/*
 * Decompiled with CFR 0.152.
 */
package pbx;

import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.rxgrpc.stub.ClientCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Flowable;
import pbx.Model;
import pbx.NodeGrpc;

public final class RxNodeGrpc {
    private static final int METHODID_MESSAGE_LOOP = 0;

    private RxNodeGrpc() {
    }

    public static RxNodeStub newRxStub(Channel channel) {
        return new RxNodeStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final NodeImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(NodeImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    return com.salesforce.rxgrpc.stub.ServerCalls.manyToMany(responseObserver, this.serviceImpl::messageLoop);
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class NodeImplBase
    implements BindableService {
        public Flowable<Model.ServerMsg> messageLoop(Flowable<Model.ClientMsg> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)NodeGrpc.getServiceDescriptor()).addMethod(NodeGrpc.getMessageLoopMethod(), ServerCalls.asyncBidiStreamingCall(new MethodHandlers(this, 0))).build();
        }
    }

    public static final class RxNodeStub
    extends AbstractStub<RxNodeStub> {
        private NodeGrpc.NodeStub delegateStub;

        private RxNodeStub(Channel channel) {
            super(channel);
            this.delegateStub = NodeGrpc.newStub(channel);
        }

        private RxNodeStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = NodeGrpc.newStub(channel).build(channel, callOptions);
        }

        protected RxNodeStub build(Channel channel, CallOptions callOptions) {
            return new RxNodeStub(channel, callOptions);
        }

        public Flowable<Model.ServerMsg> messageLoop(Flowable<Model.ClientMsg> rxRequest) {
            return ClientCalls.manyToMany(rxRequest, (Function)new Function<StreamObserver<Model.ServerMsg>, StreamObserver<Model.ClientMsg>>(){

                public StreamObserver<Model.ClientMsg> apply(StreamObserver<Model.ServerMsg> observer) {
                    return delegateStub.messageLoop(observer);
                }
            });
        }
    }
}

