/*
 * Decompiled with CFR 0.152.
 */
package pbx;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.rxgrpc.stub.ClientCalls;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Single;
import pbx.Model;
import pbx.PluginGrpc;

public final class RxPluginGrpc {
    private static final int METHODID_FIRE_HOSE = 0;
    private static final int METHODID_FIND = 1;
    private static final int METHODID_ACCOUNT = 2;
    private static final int METHODID_TOPIC = 3;
    private static final int METHODID_SUBSCRIPTION = 4;
    private static final int METHODID_MESSAGE = 5;

    private RxPluginGrpc() {
    }

    public static RxPluginStub newRxStub(Channel channel) {
        return new RxPluginStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final PluginImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(PluginImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((Model.ClientReq)request), responseObserver, (Function)new Function<Single<Model.ClientReq>, Single<Model.ServerResp>>(){

                        public Single<Model.ServerResp> apply(Single<Model.ClientReq> single) {
                            return serviceImpl.fireHose(single);
                        }
                    });
                    break;
                }
                case 1: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((Model.SearchQuery)request), responseObserver, (Function)new Function<Single<Model.SearchQuery>, Single<Model.SearchFound>>(){

                        public Single<Model.SearchFound> apply(Single<Model.SearchQuery> single) {
                            return serviceImpl.find(single);
                        }
                    });
                    break;
                }
                case 2: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((Model.AccountEvent)request), responseObserver, (Function)new Function<Single<Model.AccountEvent>, Single<Model.Unused>>(){

                        public Single<Model.Unused> apply(Single<Model.AccountEvent> single) {
                            return serviceImpl.account(single);
                        }
                    });
                    break;
                }
                case 3: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((Model.TopicEvent)request), responseObserver, (Function)new Function<Single<Model.TopicEvent>, Single<Model.Unused>>(){

                        public Single<Model.Unused> apply(Single<Model.TopicEvent> single) {
                            return serviceImpl.topic(single);
                        }
                    });
                    break;
                }
                case 4: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((Model.SubscriptionEvent)request), responseObserver, (Function)new Function<Single<Model.SubscriptionEvent>, Single<Model.Unused>>(){

                        public Single<Model.Unused> apply(Single<Model.SubscriptionEvent> single) {
                            return serviceImpl.subscription(single);
                        }
                    });
                    break;
                }
                case 5: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((Model.MessageEvent)request), responseObserver, (Function)new Function<Single<Model.MessageEvent>, Single<Model.Unused>>(){

                        public Single<Model.Unused> apply(Single<Model.MessageEvent> single) {
                            return serviceImpl.message(single);
                        }
                    });
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class PluginImplBase
    implements BindableService {
        public Single<Model.ServerResp> fireHose(Single<Model.ClientReq> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Model.SearchFound> find(Single<Model.SearchQuery> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Model.Unused> account(Single<Model.AccountEvent> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Model.Unused> topic(Single<Model.TopicEvent> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Model.Unused> subscription(Single<Model.SubscriptionEvent> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<Model.Unused> message(Single<Model.MessageEvent> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)PluginGrpc.getServiceDescriptor()).addMethod(PluginGrpc.getFireHoseMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(PluginGrpc.getFindMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(PluginGrpc.getAccountMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(PluginGrpc.getTopicMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).addMethod(PluginGrpc.getSubscriptionMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 4))).addMethod(PluginGrpc.getMessageMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 5))).build();
        }
    }

    public static final class RxPluginStub
    extends AbstractStub<RxPluginStub> {
        private PluginGrpc.PluginStub delegateStub;

        private RxPluginStub(Channel channel) {
            super(channel);
            this.delegateStub = PluginGrpc.newStub(channel);
        }

        private RxPluginStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = PluginGrpc.newStub(channel).build(channel, callOptions);
        }

        protected RxPluginStub build(Channel channel, CallOptions callOptions) {
            return new RxPluginStub(channel, callOptions);
        }

        public Single<Model.ServerResp> fireHose(Single<Model.ClientReq> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<Model.ClientReq, StreamObserver<Model.ServerResp>>(){

                public void accept(Model.ClientReq request, StreamObserver<Model.ServerResp> observer) {
                    delegateStub.fireHose(request, observer);
                }
            });
        }

        public Single<Model.SearchFound> find(Single<Model.SearchQuery> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<Model.SearchQuery, StreamObserver<Model.SearchFound>>(){

                public void accept(Model.SearchQuery request, StreamObserver<Model.SearchFound> observer) {
                    delegateStub.find(request, observer);
                }
            });
        }

        public Single<Model.Unused> account(Single<Model.AccountEvent> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<Model.AccountEvent, StreamObserver<Model.Unused>>(){

                public void accept(Model.AccountEvent request, StreamObserver<Model.Unused> observer) {
                    delegateStub.account(request, observer);
                }
            });
        }

        public Single<Model.Unused> topic(Single<Model.TopicEvent> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<Model.TopicEvent, StreamObserver<Model.Unused>>(){

                public void accept(Model.TopicEvent request, StreamObserver<Model.Unused> observer) {
                    delegateStub.topic(request, observer);
                }
            });
        }

        public Single<Model.Unused> subscription(Single<Model.SubscriptionEvent> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<Model.SubscriptionEvent, StreamObserver<Model.Unused>>(){

                public void accept(Model.SubscriptionEvent request, StreamObserver<Model.Unused> observer) {
                    delegateStub.subscription(request, observer);
                }
            });
        }

        public Single<Model.Unused> message(Single<Model.MessageEvent> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<Model.MessageEvent, StreamObserver<Model.Unused>>(){

                public void accept(Model.MessageEvent request, StreamObserver<Model.Unused> observer) {
                    delegateStub.message(request, observer);
                }
            });
        }

        public Single<Model.ServerResp> fireHose(Model.ClientReq rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<Model.ClientReq, StreamObserver<Model.ServerResp>>(){

                public void accept(Model.ClientReq request, StreamObserver<Model.ServerResp> observer) {
                    delegateStub.fireHose(request, observer);
                }
            });
        }

        public Single<Model.SearchFound> find(Model.SearchQuery rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<Model.SearchQuery, StreamObserver<Model.SearchFound>>(){

                public void accept(Model.SearchQuery request, StreamObserver<Model.SearchFound> observer) {
                    delegateStub.find(request, observer);
                }
            });
        }

        public Single<Model.Unused> account(Model.AccountEvent rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<Model.AccountEvent, StreamObserver<Model.Unused>>(){

                public void accept(Model.AccountEvent request, StreamObserver<Model.Unused> observer) {
                    delegateStub.account(request, observer);
                }
            });
        }

        public Single<Model.Unused> topic(Model.TopicEvent rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<Model.TopicEvent, StreamObserver<Model.Unused>>(){

                public void accept(Model.TopicEvent request, StreamObserver<Model.Unused> observer) {
                    delegateStub.topic(request, observer);
                }
            });
        }

        public Single<Model.Unused> subscription(Model.SubscriptionEvent rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<Model.SubscriptionEvent, StreamObserver<Model.Unused>>(){

                public void accept(Model.SubscriptionEvent request, StreamObserver<Model.Unused> observer) {
                    delegateStub.subscription(request, observer);
                }
            });
        }

        public Single<Model.Unused> message(Model.MessageEvent rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<Model.MessageEvent, StreamObserver<Model.Unused>>(){

                public void accept(Model.MessageEvent request, StreamObserver<Model.Unused> observer) {
                    delegateStub.message(request, observer);
                }
            });
        }
    }
}

