/*
 * Decompiled with CFR 0.152.
 */
package com.streamlayer.pushNotification.common;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.rxgrpc.stub.ClientCalls;
import com.streamlayer.pushNotification.common.CommonGrpc;
import com.streamlayer.pushNotification.common.OrganizationListRequest;
import com.streamlayer.pushNotification.common.OrganizationListResponse;
import com.streamlayer.pushNotification.common.SendTestRequest;
import com.streamlayer.pushNotification.common.SendTestResponse;
import com.streamlayer.pushNotification.common.UserGetRequest;
import com.streamlayer.pushNotification.common.UserGetResponse;
import com.streamlayer.pushNotification.common.UserListRequest;
import com.streamlayer.pushNotification.common.UserListResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Single;

public final class RxCommonGrpc {
    private static final int METHODID_SEND_TEST = 0;
    private static final int METHODID_ORGANIZATION_LIST = 1;
    private static final int METHODID_USER_LIST = 2;
    private static final int METHODID_USER_GET = 3;

    private RxCommonGrpc() {
    }

    public static RxCommonStub newRxStub(Channel channel) {
        return new RxCommonStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final CommonImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(CommonImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((SendTestRequest)request), responseObserver, (Function)new Function<Single<SendTestRequest>, Single<SendTestResponse>>(){

                        public Single<SendTestResponse> apply(Single<SendTestRequest> single) {
                            return serviceImpl.sendTest(single);
                        }
                    });
                    break;
                }
                case 1: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((OrganizationListRequest)request), responseObserver, (Function)new Function<Single<OrganizationListRequest>, Single<OrganizationListResponse>>(){

                        public Single<OrganizationListResponse> apply(Single<OrganizationListRequest> single) {
                            return serviceImpl.organizationList(single);
                        }
                    });
                    break;
                }
                case 2: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((UserListRequest)request), responseObserver, (Function)new Function<Single<UserListRequest>, Single<UserListResponse>>(){

                        public Single<UserListResponse> apply(Single<UserListRequest> single) {
                            return serviceImpl.userList(single);
                        }
                    });
                    break;
                }
                case 3: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((UserGetRequest)request), responseObserver, (Function)new Function<Single<UserGetRequest>, Single<UserGetResponse>>(){

                        public Single<UserGetResponse> apply(Single<UserGetRequest> single) {
                            return serviceImpl.userGet(single);
                        }
                    });
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class CommonImplBase
    implements BindableService {
        public Single<SendTestResponse> sendTest(Single<SendTestRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<OrganizationListResponse> organizationList(Single<OrganizationListRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<UserListResponse> userList(Single<UserListRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<UserGetResponse> userGet(Single<UserGetRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)CommonGrpc.getServiceDescriptor()).addMethod(CommonGrpc.getSendTestMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(CommonGrpc.getOrganizationListMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(CommonGrpc.getUserListMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(CommonGrpc.getUserGetMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).build();
        }
    }

    public static final class RxCommonStub
    extends AbstractStub<RxCommonStub> {
        private CommonGrpc.CommonStub delegateStub;

        private RxCommonStub(Channel channel) {
            super(channel);
            this.delegateStub = CommonGrpc.newStub(channel);
        }

        private RxCommonStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = CommonGrpc.newStub(channel).build(channel, callOptions);
        }

        protected RxCommonStub build(Channel channel, CallOptions callOptions) {
            return new RxCommonStub(channel, callOptions);
        }

        public Single<SendTestResponse> sendTest(Single<SendTestRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<SendTestRequest, StreamObserver<SendTestResponse>>(){

                public void accept(SendTestRequest request, StreamObserver<SendTestResponse> observer) {
                    delegateStub.sendTest(request, observer);
                }
            });
        }

        public Single<OrganizationListResponse> organizationList(Single<OrganizationListRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<OrganizationListRequest, StreamObserver<OrganizationListResponse>>(){

                public void accept(OrganizationListRequest request, StreamObserver<OrganizationListResponse> observer) {
                    delegateStub.organizationList(request, observer);
                }
            });
        }

        public Single<UserListResponse> userList(Single<UserListRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<UserListRequest, StreamObserver<UserListResponse>>(){

                public void accept(UserListRequest request, StreamObserver<UserListResponse> observer) {
                    delegateStub.userList(request, observer);
                }
            });
        }

        public Single<UserGetResponse> userGet(Single<UserGetRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<UserGetRequest, StreamObserver<UserGetResponse>>(){

                public void accept(UserGetRequest request, StreamObserver<UserGetResponse> observer) {
                    delegateStub.userGet(request, observer);
                }
            });
        }

        public Single<SendTestResponse> sendTest(SendTestRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<SendTestRequest, StreamObserver<SendTestResponse>>(){

                public void accept(SendTestRequest request, StreamObserver<SendTestResponse> observer) {
                    delegateStub.sendTest(request, observer);
                }
            });
        }

        public Single<OrganizationListResponse> organizationList(OrganizationListRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<OrganizationListRequest, StreamObserver<OrganizationListResponse>>(){

                public void accept(OrganizationListRequest request, StreamObserver<OrganizationListResponse> observer) {
                    delegateStub.organizationList(request, observer);
                }
            });
        }

        public Single<UserListResponse> userList(UserListRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<UserListRequest, StreamObserver<UserListResponse>>(){

                public void accept(UserListRequest request, StreamObserver<UserListResponse> observer) {
                    delegateStub.userList(request, observer);
                }
            });
        }

        public Single<UserGetResponse> userGet(UserGetRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<UserGetRequest, StreamObserver<UserGetResponse>>(){

                public void accept(UserGetRequest request, StreamObserver<UserGetResponse> observer) {
                    delegateStub.userGet(request, observer);
                }
            });
        }
    }
}

