/*
 * Decompiled with CFR 0.152.
 */
package com.streamlayer.organizations.invites;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.rxgrpc.stub.ClientCalls;
import com.streamlayer.organizations.invites.InviteListRequest;
import com.streamlayer.organizations.invites.InviteListResponse;
import com.streamlayer.organizations.invites.InvitesGrpc;
import com.streamlayer.organizations.invites.RevokeInviteRequest;
import com.streamlayer.organizations.invites.RevokeInviteResponse;
import com.streamlayer.organizations.invites.SendInviteRequest;
import com.streamlayer.organizations.invites.SendInviteResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Single;

public final class RxInvitesGrpc {
    private static final int METHODID_SEND_INVITE = 0;
    private static final int METHODID_REVOKE_INVITE = 1;
    private static final int METHODID_INVITE_LIST = 2;

    private RxInvitesGrpc() {
    }

    public static RxInvitesStub newRxStub(Channel channel) {
        return new RxInvitesStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final InvitesImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(InvitesImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((SendInviteRequest)request), responseObserver, (Function)new Function<Single<SendInviteRequest>, Single<SendInviteResponse>>(){

                        public Single<SendInviteResponse> apply(Single<SendInviteRequest> single) {
                            return serviceImpl.sendInvite(single);
                        }
                    });
                    break;
                }
                case 1: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((RevokeInviteRequest)request), responseObserver, (Function)new Function<Single<RevokeInviteRequest>, Single<RevokeInviteResponse>>(){

                        public Single<RevokeInviteResponse> apply(Single<RevokeInviteRequest> single) {
                            return serviceImpl.revokeInvite(single);
                        }
                    });
                    break;
                }
                case 2: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((InviteListRequest)request), responseObserver, (Function)new Function<Single<InviteListRequest>, Single<InviteListResponse>>(){

                        public Single<InviteListResponse> apply(Single<InviteListRequest> single) {
                            return serviceImpl.inviteList(single);
                        }
                    });
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class InvitesImplBase
    implements BindableService {
        public Single<SendInviteResponse> sendInvite(Single<SendInviteRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<RevokeInviteResponse> revokeInvite(Single<RevokeInviteRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<InviteListResponse> inviteList(Single<InviteListRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)InvitesGrpc.getServiceDescriptor()).addMethod(InvitesGrpc.getSendInviteMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(InvitesGrpc.getRevokeInviteMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(InvitesGrpc.getInviteListMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).build();
        }
    }

    public static final class RxInvitesStub
    extends AbstractStub<RxInvitesStub> {
        private InvitesGrpc.InvitesStub delegateStub;

        private RxInvitesStub(Channel channel) {
            super(channel);
            this.delegateStub = InvitesGrpc.newStub(channel);
        }

        private RxInvitesStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = InvitesGrpc.newStub(channel).build(channel, callOptions);
        }

        protected RxInvitesStub build(Channel channel, CallOptions callOptions) {
            return new RxInvitesStub(channel, callOptions);
        }

        public Single<SendInviteResponse> sendInvite(Single<SendInviteRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<SendInviteRequest, StreamObserver<SendInviteResponse>>(){

                public void accept(SendInviteRequest request, StreamObserver<SendInviteResponse> observer) {
                    delegateStub.sendInvite(request, observer);
                }
            });
        }

        public Single<RevokeInviteResponse> revokeInvite(Single<RevokeInviteRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<RevokeInviteRequest, StreamObserver<RevokeInviteResponse>>(){

                public void accept(RevokeInviteRequest request, StreamObserver<RevokeInviteResponse> observer) {
                    delegateStub.revokeInvite(request, observer);
                }
            });
        }

        public Single<InviteListResponse> inviteList(Single<InviteListRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<InviteListRequest, StreamObserver<InviteListResponse>>(){

                public void accept(InviteListRequest request, StreamObserver<InviteListResponse> observer) {
                    delegateStub.inviteList(request, observer);
                }
            });
        }

        public Single<SendInviteResponse> sendInvite(SendInviteRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<SendInviteRequest, StreamObserver<SendInviteResponse>>(){

                public void accept(SendInviteRequest request, StreamObserver<SendInviteResponse> observer) {
                    delegateStub.sendInvite(request, observer);
                }
            });
        }

        public Single<RevokeInviteResponse> revokeInvite(RevokeInviteRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<RevokeInviteRequest, StreamObserver<RevokeInviteResponse>>(){

                public void accept(RevokeInviteRequest request, StreamObserver<RevokeInviteResponse> observer) {
                    delegateStub.revokeInvite(request, observer);
                }
            });
        }

        public Single<InviteListResponse> inviteList(InviteListRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<InviteListRequest, StreamObserver<InviteListResponse>>(){

                public void accept(InviteListRequest request, StreamObserver<InviteListResponse> observer) {
                    delegateStub.inviteList(request, observer);
                }
            });
        }
    }
}

