/*
 * Decompiled with CFR 0.152.
 */
package com.streamlayer.social;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.rxgrpc.stub.ClientCalls;
import com.streamlayer.social.SubscriptionRequest;
import com.streamlayer.social.SubscriptionResponse;
import com.streamlayer.social.SyncRequest;
import com.streamlayer.social.SyncResponse;
import com.streamlayer.social.TwitterGrpc;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Flowable;
import io.reactivex.Single;

public final class RxTwitterGrpc {
    private static final int METHODID_SUBSCRIPTION = 0;
    private static final int METHODID_SYNC = 1;

    private RxTwitterGrpc() {
    }

    public static RxTwitterStub newRxStub(Channel channel) {
        return new RxTwitterStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final TwitterImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(TwitterImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToMany((Object)((SubscriptionRequest)request), responseObserver, (Function)new Function<Single<SubscriptionRequest>, Flowable<SubscriptionResponse>>(){

                        public Flowable<SubscriptionResponse> apply(Single<SubscriptionRequest> single) {
                            return serviceImpl.subscription(single);
                        }
                    });
                    break;
                }
                case 1: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((SyncRequest)request), responseObserver, (Function)new Function<Single<SyncRequest>, Single<SyncResponse>>(){

                        public Single<SyncResponse> apply(Single<SyncRequest> single) {
                            return serviceImpl.sync(single);
                        }
                    });
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class TwitterImplBase
    implements BindableService {
        public Flowable<SubscriptionResponse> subscription(Single<SubscriptionRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<SyncResponse> sync(Single<SyncRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)TwitterGrpc.getServiceDescriptor()).addMethod(TwitterGrpc.getSubscriptionMethod(), ServerCalls.asyncServerStreamingCall(new MethodHandlers(this, 0))).addMethod(TwitterGrpc.getSyncMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).build();
        }
    }

    public static final class RxTwitterStub
    extends AbstractStub<RxTwitterStub> {
        private TwitterGrpc.TwitterStub delegateStub;

        private RxTwitterStub(Channel channel) {
            super(channel);
            this.delegateStub = TwitterGrpc.newStub(channel);
        }

        private RxTwitterStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = TwitterGrpc.newStub(channel).build(channel, callOptions);
        }

        protected RxTwitterStub build(Channel channel, CallOptions callOptions) {
            return new RxTwitterStub(channel, callOptions);
        }

        public Flowable<SubscriptionResponse> subscription(Single<SubscriptionRequest> rxRequest) {
            return ClientCalls.oneToMany(rxRequest, (BiConsumer)new BiConsumer<SubscriptionRequest, StreamObserver<SubscriptionResponse>>(){

                public void accept(SubscriptionRequest request, StreamObserver<SubscriptionResponse> observer) {
                    delegateStub.subscription(request, observer);
                }
            });
        }

        public Single<SyncResponse> sync(Single<SyncRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<SyncRequest, StreamObserver<SyncResponse>>(){

                public void accept(SyncRequest request, StreamObserver<SyncResponse> observer) {
                    delegateStub.sync(request, observer);
                }
            });
        }

        public Flowable<SubscriptionResponse> subscription(SubscriptionRequest rxRequest) {
            return ClientCalls.oneToMany((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<SubscriptionRequest, StreamObserver<SubscriptionResponse>>(){

                public void accept(SubscriptionRequest request, StreamObserver<SubscriptionResponse> observer) {
                    delegateStub.subscription(request, observer);
                }
            });
        }

        public Single<SyncResponse> sync(SyncRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<SyncRequest, StreamObserver<SyncResponse>>(){

                public void accept(SyncRequest request, StreamObserver<SyncResponse> observer) {
                    delegateStub.sync(request, observer);
                }
            });
        }
    }
}

