/*
 * Decompiled with CFR 0.152.
 */
package com.streamlayer.organizations.members;

import com.salesforce.reactivegrpc.common.BiConsumer;
import com.salesforce.reactivegrpc.common.Function;
import com.salesforce.rxgrpc.stub.ClientCalls;
import com.streamlayer.organizations.members.AddMemberRequest;
import com.streamlayer.organizations.members.AddMemberResponse;
import com.streamlayer.organizations.members.MemberPermissionRequest;
import com.streamlayer.organizations.members.MemberPermissionResponse;
import com.streamlayer.organizations.members.MembersGrpc;
import com.streamlayer.organizations.members.MembersListRequest;
import com.streamlayer.organizations.members.MembersListResponse;
import com.streamlayer.organizations.members.RemoveMemberRequest;
import com.streamlayer.organizations.members.RemoveMemberResponse;
import io.grpc.BindableService;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.reactivex.Single;

public final class RxMembersGrpc {
    private static final int METHODID_ADD_MEMBER = 0;
    private static final int METHODID_MEMBERS_LIST = 1;
    private static final int METHODID_MEMBER_PERMISSION = 2;
    private static final int METHODID_REMOVE_MEMBER = 3;

    private RxMembersGrpc() {
    }

    public static RxMembersStub newRxStub(Channel channel) {
        return new RxMembersStub(channel);
    }

    private static final class MethodHandlers<Req, Resp>
    implements ServerCalls.UnaryMethod<Req, Resp>,
    ServerCalls.ServerStreamingMethod<Req, Resp>,
    ServerCalls.ClientStreamingMethod<Req, Resp>,
    ServerCalls.BidiStreamingMethod<Req, Resp> {
        private final MembersImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(MembersImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        public void invoke(Req request, StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                case 0: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((AddMemberRequest)request), responseObserver, (Function)new Function<Single<AddMemberRequest>, Single<AddMemberResponse>>(){

                        public Single<AddMemberResponse> apply(Single<AddMemberRequest> single) {
                            return serviceImpl.addMember(single);
                        }
                    });
                    break;
                }
                case 1: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((MembersListRequest)request), responseObserver, (Function)new Function<Single<MembersListRequest>, Single<MembersListResponse>>(){

                        public Single<MembersListResponse> apply(Single<MembersListRequest> single) {
                            return serviceImpl.membersList(single);
                        }
                    });
                    break;
                }
                case 2: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((MemberPermissionRequest)request), responseObserver, (Function)new Function<Single<MemberPermissionRequest>, Single<MemberPermissionResponse>>(){

                        public Single<MemberPermissionResponse> apply(Single<MemberPermissionRequest> single) {
                            return serviceImpl.memberPermission(single);
                        }
                    });
                    break;
                }
                case 3: {
                    com.salesforce.rxgrpc.stub.ServerCalls.oneToOne((Object)((RemoveMemberRequest)request), responseObserver, (Function)new Function<Single<RemoveMemberRequest>, Single<RemoveMemberResponse>>(){

                        public Single<RemoveMemberResponse> apply(Single<RemoveMemberRequest> single) {
                            return serviceImpl.removeMember(single);
                        }
                    });
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public StreamObserver<Req> invoke(StreamObserver<Resp> responseObserver) {
            switch (this.methodId) {
                default: 
            }
            throw new AssertionError();
        }
    }

    public static abstract class MembersImplBase
    implements BindableService {
        public Single<AddMemberResponse> addMember(Single<AddMemberRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<MembersListResponse> membersList(Single<MembersListRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<MemberPermissionResponse> memberPermission(Single<MemberPermissionRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public Single<RemoveMemberResponse> removeMember(Single<RemoveMemberRequest> request) {
            throw new StatusRuntimeException(Status.UNIMPLEMENTED);
        }

        public final ServerServiceDefinition bindService() {
            return ServerServiceDefinition.builder((ServiceDescriptor)MembersGrpc.getServiceDescriptor()).addMethod(MembersGrpc.getAddMemberMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 0))).addMethod(MembersGrpc.getMembersListMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 1))).addMethod(MembersGrpc.getMemberPermissionMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 2))).addMethod(MembersGrpc.getRemoveMemberMethod(), ServerCalls.asyncUnaryCall(new MethodHandlers(this, 3))).build();
        }
    }

    public static final class RxMembersStub
    extends AbstractStub<RxMembersStub> {
        private MembersGrpc.MembersStub delegateStub;

        private RxMembersStub(Channel channel) {
            super(channel);
            this.delegateStub = MembersGrpc.newStub(channel);
        }

        private RxMembersStub(Channel channel, CallOptions callOptions) {
            super(channel, callOptions);
            this.delegateStub = MembersGrpc.newStub(channel).build(channel, callOptions);
        }

        protected RxMembersStub build(Channel channel, CallOptions callOptions) {
            return new RxMembersStub(channel, callOptions);
        }

        public Single<AddMemberResponse> addMember(Single<AddMemberRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<AddMemberRequest, StreamObserver<AddMemberResponse>>(){

                public void accept(AddMemberRequest request, StreamObserver<AddMemberResponse> observer) {
                    delegateStub.addMember(request, observer);
                }
            });
        }

        public Single<MembersListResponse> membersList(Single<MembersListRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<MembersListRequest, StreamObserver<MembersListResponse>>(){

                public void accept(MembersListRequest request, StreamObserver<MembersListResponse> observer) {
                    delegateStub.membersList(request, observer);
                }
            });
        }

        public Single<MemberPermissionResponse> memberPermission(Single<MemberPermissionRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<MemberPermissionRequest, StreamObserver<MemberPermissionResponse>>(){

                public void accept(MemberPermissionRequest request, StreamObserver<MemberPermissionResponse> observer) {
                    delegateStub.memberPermission(request, observer);
                }
            });
        }

        public Single<RemoveMemberResponse> removeMember(Single<RemoveMemberRequest> rxRequest) {
            return ClientCalls.oneToOne(rxRequest, (BiConsumer)new BiConsumer<RemoveMemberRequest, StreamObserver<RemoveMemberResponse>>(){

                public void accept(RemoveMemberRequest request, StreamObserver<RemoveMemberResponse> observer) {
                    delegateStub.removeMember(request, observer);
                }
            });
        }

        public Single<AddMemberResponse> addMember(AddMemberRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<AddMemberRequest, StreamObserver<AddMemberResponse>>(){

                public void accept(AddMemberRequest request, StreamObserver<AddMemberResponse> observer) {
                    delegateStub.addMember(request, observer);
                }
            });
        }

        public Single<MembersListResponse> membersList(MembersListRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<MembersListRequest, StreamObserver<MembersListResponse>>(){

                public void accept(MembersListRequest request, StreamObserver<MembersListResponse> observer) {
                    delegateStub.membersList(request, observer);
                }
            });
        }

        public Single<MemberPermissionResponse> memberPermission(MemberPermissionRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<MemberPermissionRequest, StreamObserver<MemberPermissionResponse>>(){

                public void accept(MemberPermissionRequest request, StreamObserver<MemberPermissionResponse> observer) {
                    delegateStub.memberPermission(request, observer);
                }
            });
        }

        public Single<RemoveMemberResponse> removeMember(RemoveMemberRequest rxRequest) {
            return ClientCalls.oneToOne((Single)Single.just((Object)rxRequest), (BiConsumer)new BiConsumer<RemoveMemberRequest, StreamObserver<RemoveMemberResponse>>(){

                public void accept(RemoveMemberRequest request, StreamObserver<RemoveMemberResponse> observer) {
                    delegateStub.removeMember(request, observer);
                }
            });
        }
    }
}

