/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.distributedlog.io.CompressionCodec;
import org.apache.distributedlog.io.CompressionUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestCompressionCodec {
    @Test(timeout=10000L)
    public void testUnknownCompressionCodec() throws Exception {
        Assert.assertEquals((Object)CompressionCodec.Type.UNKNOWN, (Object)CompressionUtils.stringToType((String)"unknown"));
    }

    @Test(timeout=10000L)
    public void testIdentityCompressionCodec() throws Exception {
        this.testCompressionCodec(CompressionUtils.getCompressionCodec((CompressionCodec.Type)CompressionCodec.Type.NONE));
    }

    @Test(timeout=10000L)
    public void testLZ4CompressionCodec() throws Exception {
        this.testCompressionCodec(CompressionUtils.getCompressionCodec((CompressionCodec.Type)CompressionCodec.Type.LZ4));
    }

    @Test(timeout=10000L)
    public void testIdentityCompressionCodec2() throws Exception {
        this.testCompressionCodec2(CompressionUtils.getCompressionCodec((CompressionCodec.Type)CompressionCodec.Type.NONE));
    }

    @Test(timeout=10000L)
    public void testLZ4CompressionCodec2() throws Exception {
        this.testCompressionCodec2(CompressionUtils.getCompressionCodec((CompressionCodec.Type)CompressionCodec.Type.LZ4));
    }

    private void testCompressionCodec(CompressionCodec codec) throws Exception {
        byte[] data = "identity-compression-codec".getBytes(StandardCharsets.UTF_8);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])data);
        ByteBuf compressedBuf = codec.compress(buf, 0);
        ByteBuf decompressedBuf = codec.decompress(compressedBuf, data.length);
        Assert.assertEquals((String)"The length of decompressed buf should be same as the original buffer", (long)data.length, (long)decompressedBuf.readableBytes());
        byte[] decompressedData = new byte[data.length];
        decompressedBuf.readBytes(decompressedData);
        Assert.assertArrayEquals((String)"The decompressed bytes should be same as the original bytes", (byte[])data, (byte[])decompressedData);
        buf.release();
        compressedBuf.release();
        decompressedBuf.release();
    }

    private void testCompressionCodec2(CompressionCodec codec) throws Exception {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer(32, 0x400000);
        for (int i = 0; i < 100; ++i) {
            ByteBuffer record = ByteBuffer.wrap(("record-" + i).getBytes(StandardCharsets.UTF_8));
            buffer.writeInt(record.remaining());
            buffer.writeBytes(record);
        }
        byte[] uncompressedData = new byte[buffer.readableBytes()];
        buffer.slice().readBytes(uncompressedData);
        ByteBuf compressedBuf = codec.compress(buffer, 0);
        byte[] compressedData = new byte[compressedBuf.readableBytes()];
        compressedBuf.slice().readBytes(compressedData);
        ByteBuf decompressedBuf = codec.decompress(compressedBuf, uncompressedData.length);
        byte[] decompressedData = new byte[decompressedBuf.readableBytes()];
        decompressedBuf.slice().readBytes(decompressedData);
        buffer.release();
        compressedBuf.release();
        decompressedBuf.release();
    }
}

