/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar;

import com.beust.jcommander.Parameter;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import org.apache.pulsar.PulsarBrokerStarter;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.util.CmdGenerateDocs;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class PulsarBrokerStarterTest {
    private File createValidBrokerConfigFile() throws FileNotFoundException {
        File testConfigFile = new File("tmp." + System.currentTimeMillis() + ".properties");
        if (testConfigFile.exists()) {
            testConfigFile.delete();
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(testConfigFile)));
        printWriter.println("zookeeperServers=z1.example.com,z2.example.com,z3.example.com");
        printWriter.println("configurationStoreServers=gz1.example.com,gz2.example.com,gz3.example.com/foo");
        printWriter.println("brokerDeleteInactiveTopicsEnabled=false");
        printWriter.println("statusFilePath=/tmp/status.html");
        printWriter.println("managedLedgerDefaultEnsembleSize=1");
        printWriter.println("managedLedgerDefaultWriteQuorum=1");
        printWriter.println("managedLedgerDefaultAckQuorum=1");
        printWriter.println("managedLedgerMaxEntriesPerLedger=25");
        printWriter.println("managedLedgerCursorMaxEntriesPerLedger=50");
        printWriter.println("managedLedgerCursorRolloverTimeInSeconds=3000");
        printWriter.println("bookkeeperClientHealthCheckEnabled=true");
        printWriter.println("bookkeeperClientHealthCheckErrorThresholdPerInterval=5");
        printWriter.println("bookkeeperClientRackawarePolicyEnabled=true");
        printWriter.println("bookkeeperClientRegionawarePolicyEnabled=false");
        printWriter.println("bookkeeperClientMinNumRacksPerWriteQuorum=5");
        printWriter.println("bookkeeperClientEnforceMinNumRacksPerWriteQuorum=true");
        printWriter.println("bookkeeperClientReorderReadSequenceEnabled=false");
        printWriter.println("bookkeeperClientIsolationGroups=group1,group2");
        printWriter.println("backlogQuotaDefaultLimitGB=18");
        printWriter.println("clusterName=usc");
        printWriter.println("brokerClientAuthenticationPlugin=test.xyz.client.auth.plugin");
        printWriter.println("brokerClientAuthenticationParameters=role:my-role");
        printWriter.println("superUserRoles=appid1,appid2");
        printWriter.println("clientLibraryVersionCheckEnabled=true");
        printWriter.println("clientLibraryVersionCheckAllowUnversioned=true");
        printWriter.println("managedLedgerMinLedgerRolloverTimeMinutes=34");
        printWriter.println("managedLedgerMaxLedgerRolloverTimeMinutes=34");
        printWriter.println("brokerServicePort=7777");
        printWriter.println("managedLedgerDefaultMarkDeleteRateLimit=5.0");
        printWriter.println("replicationProducerQueueSize=50");
        printWriter.println("bookkeeperClientTimeoutInSeconds=12345");
        printWriter.println("bookkeeperClientSpeculativeReadTimeoutInMillis=3000");
        printWriter.println("enableRunBookieTogether=true");
        printWriter.println("bookkeeperExplicitLacIntervalInMills=5");
        printWriter.close();
        testConfigFile.deleteOnExit();
        return testConfigFile;
    }

    public void testLoadConfig() throws SecurityException, NoSuchMethodException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        File testConfigFile = this.createValidBrokerConfigFile();
        Method targetMethod = PulsarBrokerStarter.class.getDeclaredMethod("loadConfig", String.class);
        targetMethod.setAccessible(true);
        Object returnValue = targetMethod.invoke(PulsarBrokerStarter.class, testConfigFile.getAbsolutePath());
        Assert.assertTrue((boolean)(returnValue instanceof ServiceConfiguration));
        ServiceConfiguration serviceConfig = (ServiceConfiguration)returnValue;
        Assert.assertEquals((String)serviceConfig.getZookeeperServers(), (String)"z1.example.com,z2.example.com,z3.example.com");
        Assert.assertEquals((String)serviceConfig.getConfigurationStoreServers(), (String)"gz1.example.com,gz2.example.com,gz3.example.com/foo");
        Assert.assertFalse((boolean)serviceConfig.isBrokerDeleteInactiveTopicsEnabled());
        Assert.assertEquals((String)serviceConfig.getStatusFilePath(), (String)"/tmp/status.html");
        Assert.assertEquals((double)serviceConfig.getBacklogQuotaDefaultLimitGB(), (double)18.0);
        Assert.assertEquals((String)serviceConfig.getClusterName(), (String)"usc");
        Assert.assertEquals((String)serviceConfig.getBrokerClientAuthenticationPlugin(), (String)"test.xyz.client.auth.plugin");
        Assert.assertEquals((String)serviceConfig.getBrokerClientAuthenticationParameters(), (String)"role:my-role");
        Assert.assertEquals((Set)serviceConfig.getSuperUserRoles(), (Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}));
        Assert.assertEquals((int)serviceConfig.getManagedLedgerCursorRolloverTimeInSeconds(), (int)3000);
        Assert.assertEquals((int)serviceConfig.getManagedLedgerMaxEntriesPerLedger(), (int)25);
        Assert.assertEquals((int)serviceConfig.getManagedLedgerCursorMaxEntriesPerLedger(), (int)50);
        Assert.assertTrue((boolean)serviceConfig.isClientLibraryVersionCheckEnabled());
        Assert.assertEquals((int)serviceConfig.getManagedLedgerMinLedgerRolloverTimeMinutes(), (int)34);
        Assert.assertTrue((boolean)serviceConfig.isBacklogQuotaCheckEnabled());
        Assert.assertEquals((double)serviceConfig.getManagedLedgerDefaultMarkDeleteRateLimit(), (double)5.0);
        Assert.assertEquals((int)serviceConfig.getReplicationProducerQueueSize(), (int)50);
        Assert.assertFalse((boolean)serviceConfig.isReplicationMetricsEnabled());
        Assert.assertTrue((boolean)serviceConfig.isBookkeeperClientHealthCheckEnabled());
        Assert.assertEquals((long)serviceConfig.getBookkeeperClientHealthCheckErrorThresholdPerInterval(), (long)5L);
        Assert.assertTrue((boolean)serviceConfig.isBookkeeperClientRackawarePolicyEnabled());
        Assert.assertEquals((int)serviceConfig.getBookkeeperClientMinNumRacksPerWriteQuorum(), (int)5);
        Assert.assertTrue((boolean)serviceConfig.isBookkeeperClientEnforceMinNumRacksPerWriteQuorum());
        Assert.assertFalse((boolean)serviceConfig.isBookkeeperClientRegionawarePolicyEnabled());
        Assert.assertFalse((boolean)serviceConfig.isBookkeeperClientReorderReadSequenceEnabled());
        Assert.assertEquals((String)serviceConfig.getBookkeeperClientIsolationGroups(), (String)"group1,group2");
        Assert.assertEquals((int)serviceConfig.getBookkeeperClientSpeculativeReadTimeoutInMillis(), (int)3000);
        Assert.assertEquals((long)serviceConfig.getBookkeeperClientTimeoutInSeconds(), (long)12345L);
        Assert.assertEquals((int)serviceConfig.getBookkeeperExplicitLacIntervalInMills(), (int)5);
    }

    @Test
    public void testLoadConfigWithException() throws Exception {
        File testConfigFile = new File("tmp." + System.currentTimeMillis() + ".properties");
        if (testConfigFile.exists()) {
            testConfigFile.delete();
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(testConfigFile)));
        printWriter.println("brokerDeleteInactiveTopicsEnabled=false");
        printWriter.println("statusFilePath=/tmp/pulsar_broker/status.html");
        printWriter.println("managedLedgerDefaultEnsembleSize01");
        printWriter.println("managedLedgerDefaultWriteQuorum=0");
        printWriter.println("managedLedgerDefaultAckQuorum=0");
        printWriter.close();
        testConfigFile.deleteOnExit();
        try {
            Method targetMethod = PulsarBrokerStarter.class.getDeclaredMethod("loadConfig", String.class);
            targetMethod.setAccessible(true);
            targetMethod.invoke(PulsarBrokerStarter.class, testConfigFile.getAbsolutePath());
            Assert.fail((String)"Should fail w/ illegal argument exception");
        }
        catch (InvocationTargetException e) {
            Assert.assertTrue((boolean)(e.getTargetException() instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testLoadBalancerConfig() throws SecurityException, NoSuchMethodException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        File testConfigFile = new File("tmp." + System.currentTimeMillis() + ".properties");
        if (testConfigFile.exists()) {
            testConfigFile.delete();
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(testConfigFile)));
        printWriter.println("zookeeperServers=z1.example.com,z2.example.com,z3.example.com");
        printWriter.println("statusFilePath=/usr/share/pulsar_broker/status.html");
        printWriter.println("clusterName=test");
        printWriter.println("managedLedgerDefaultEnsembleSize=1");
        printWriter.println("managedLedgerDefaultWriteQuorum=1");
        printWriter.println("managedLedgerDefaultAckQuorum=1");
        printWriter.println("loadBalancerEnabled=false");
        printWriter.println("loadBalancerHostUsageCheckIntervalMinutes=4");
        printWriter.println("loadBalancerReportUpdateThresholdPercentage=15");
        printWriter.println("loadBalancerReportUpdateMaxIntervalMinutes=20");
        printWriter.println("loadBalancerBrokerOverloadedThresholdPercentage=80");
        printWriter.println("loadBalancerBrokerUnderloadedThresholdPercentage=40");
        printWriter.println("loadBalancerSheddingIntervalMinutes=8");
        printWriter.println("loadBalancerSheddingGracePeriodMinutes=29");
        printWriter.close();
        testConfigFile.deleteOnExit();
        Method targetMethod = PulsarBrokerStarter.class.getDeclaredMethod("loadConfig", String.class);
        targetMethod.setAccessible(true);
        Object returnValue = targetMethod.invoke(PulsarBrokerStarter.class, testConfigFile.getAbsolutePath());
        Assert.assertTrue((boolean)(returnValue instanceof ServiceConfiguration));
        ServiceConfiguration serviceConfig = (ServiceConfiguration)returnValue;
        Assert.assertFalse((boolean)serviceConfig.isLoadBalancerEnabled());
        Assert.assertEquals((int)serviceConfig.getLoadBalancerHostUsageCheckIntervalMinutes(), (int)4);
        Assert.assertEquals((int)serviceConfig.getLoadBalancerReportUpdateThresholdPercentage(), (int)15);
        Assert.assertEquals((int)serviceConfig.getLoadBalancerReportUpdateMaxIntervalMinutes(), (int)20);
        Assert.assertEquals((int)serviceConfig.getLoadBalancerBrokerOverloadedThresholdPercentage(), (int)80);
        Assert.assertEquals((int)serviceConfig.getLoadBalancerBrokerUnderloadedThresholdPercentage(), (int)40);
        Assert.assertEquals((int)serviceConfig.getLoadBalancerSheddingIntervalMinutes(), (int)8);
        Assert.assertEquals((long)serviceConfig.getLoadBalancerSheddingGracePeriodMinutes(), (long)29L);
    }

    @Test
    public void testGlobalZooKeeperConfig() throws SecurityException, NoSuchMethodException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        File testConfigFile = new File("tmp." + System.currentTimeMillis() + ".properties");
        if (testConfigFile.exists()) {
            testConfigFile.delete();
        }
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(testConfigFile)));
        printWriter.println("zookeeperServers=z1.example.com,z2.example.com,z3.example.com");
        printWriter.println("configurationStoreServers=");
        printWriter.println("brokerDeleteInactiveTopicsEnabled=false");
        printWriter.println("statusFilePath=/tmp/status.html");
        printWriter.println("managedLedgerDefaultEnsembleSize=1");
        printWriter.println("managedLedgerDefaultWriteQuorum=1");
        printWriter.println("managedLedgerDefaultAckQuorum=1");
        printWriter.println("managedLedgerMaxEntriesPerLedger=25");
        printWriter.println("managedLedgerCursorMaxEntriesPerLedger=50");
        printWriter.println("managedLedgerCursorRolloverTimeInSeconds=3000");
        printWriter.println("backlogQuotaDefaultLimitGB=18");
        printWriter.println("clusterName=usc");
        printWriter.println("brokerClientAuthenticationPlugin=test.xyz.client.auth.plugin");
        printWriter.println("brokerClientAuthenticationParameters=role:my-role");
        printWriter.println("superUserRoles=appid1,appid2");
        printWriter.println("pulsar.broker.enableClientVersionCheck=true");
        printWriter.println("pulsar.broker.allowUnversionedClients=true");
        printWriter.println("clientLibraryVersionCheckEnabled=true");
        printWriter.println("clientLibraryVersionCheckAllowUnversioned=true");
        printWriter.println("replicationConnectionsPerBroker=12");
        printWriter.close();
        testConfigFile.deleteOnExit();
        Method targetMethod = PulsarBrokerStarter.class.getDeclaredMethod("loadConfig", String.class);
        targetMethod.setAccessible(true);
        Object returnValue = targetMethod.invoke(PulsarBrokerStarter.class, testConfigFile.getAbsolutePath());
        Assert.assertTrue((boolean)(returnValue instanceof ServiceConfiguration));
        ServiceConfiguration serviceConfig = (ServiceConfiguration)returnValue;
        Assert.assertEquals((String)serviceConfig.getZookeeperServers(), (String)"z1.example.com,z2.example.com,z3.example.com");
        Assert.assertEquals((String)serviceConfig.getConfigurationStoreServers(), (String)"z1.example.com,z2.example.com,z3.example.com");
        Assert.assertFalse((boolean)serviceConfig.isBrokerDeleteInactiveTopicsEnabled());
        Assert.assertEquals((String)serviceConfig.getStatusFilePath(), (String)"/tmp/status.html");
        Assert.assertEquals((double)serviceConfig.getBacklogQuotaDefaultLimitGB(), (double)18.0);
        Assert.assertEquals((String)serviceConfig.getClusterName(), (String)"usc");
        Assert.assertEquals((String)serviceConfig.getBrokerClientAuthenticationPlugin(), (String)"test.xyz.client.auth.plugin");
        Assert.assertEquals((String)serviceConfig.getBrokerClientAuthenticationParameters(), (String)"role:my-role");
        Assert.assertEquals((Set)serviceConfig.getSuperUserRoles(), (Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2"}));
        Assert.assertEquals((int)serviceConfig.getManagedLedgerCursorRolloverTimeInSeconds(), (int)3000);
        Assert.assertEquals((int)serviceConfig.getManagedLedgerMaxEntriesPerLedger(), (int)25);
        Assert.assertEquals((int)serviceConfig.getManagedLedgerCursorMaxEntriesPerLedger(), (int)50);
        Assert.assertTrue((boolean)serviceConfig.isClientLibraryVersionCheckEnabled());
        Assert.assertEquals((int)serviceConfig.getReplicationConnectionsPerBroker(), (int)12);
    }

    @Test
    public void testMainWithNoArgument() throws Exception {
        try {
            PulsarBrokerStarter.main((String[])new String[0]);
            Assert.fail((String)"No argument to main should've raised FileNotFoundException for no broker config!");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testMainRunBookieAndAutoRecoveryNoConfig() throws Exception {
        try {
            File testConfigFile = this.createValidBrokerConfigFile();
            String[] args = new String[]{"-c", testConfigFile.getAbsolutePath(), "-rb", "-ra", "-bc", ""};
            PulsarBrokerStarter.main((String[])args);
            Assert.fail((String)"No Config file for bookie auto recovery should've raised IllegalArgumentException!");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            Assert.assertEquals((String)e.getMessage(), (String)"No configuration file for Bookie");
        }
    }

    @Test
    public void testMainRunBookieRecoveryNoConfig() throws Exception {
        try {
            File testConfigFile = this.createValidBrokerConfigFile();
            String[] args = new String[]{"-c", testConfigFile.getAbsolutePath(), "-ra", "-bc", ""};
            PulsarBrokerStarter.main((String[])args);
            Assert.fail((String)"No Config file for bookie auto recovery should've raised IllegalArgumentException!");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"No configuration file for Bookie");
        }
    }

    @Test
    public void testMainRunBookieNoConfig() throws Exception {
        try {
            File testConfigFile = this.createValidBrokerConfigFile();
            String[] args = new String[]{"-c", testConfigFile.getAbsolutePath(), "-rb", "-bc", ""};
            PulsarBrokerStarter.main((String[])args);
            Assert.fail((String)"No Config file for bookie should've raised IllegalArgumentException!");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"No configuration file for Bookie");
        }
    }

    @Test
    public void testMainEnableRunBookieThroughBrokerConfig() throws Exception {
        try {
            File testConfigFile = this.createValidBrokerConfigFile();
            String[] args = new String[]{"-c", testConfigFile.getAbsolutePath()};
            PulsarBrokerStarter.main((String[])args);
            Assert.fail((String)"No argument to main should've raised IllegalArgumentException for no bookie config!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainGenerateDocs() throws Exception {
        PrintStream oldStream = System.out;
        try {
            Field[] fields;
            ByteArrayOutputStream baoStream = new ByteArrayOutputStream();
            System.setOut(new PrintStream(baoStream));
            Class<?> argumentsClass = Class.forName("org.apache.pulsar.PulsarBrokerStarter$StarterArguments");
            Constructor<?> constructor = argumentsClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object obj = constructor.newInstance(new Object[0]);
            CmdGenerateDocs cmd = new CmdGenerateDocs("pulsar");
            cmd.addCommand("broker", obj);
            cmd.run(null);
            String message = baoStream.toString();
            for (Field field : fields = argumentsClass.getDeclaredFields()) {
                boolean fieldHasAnno = field.isAnnotationPresent(Parameter.class);
                if (!fieldHasAnno) continue;
                Parameter fieldAnno = field.getAnnotation(Parameter.class);
                String[] names = fieldAnno.names();
                String nameStr = Arrays.asList(names).toString();
                Assert.assertTrue((message.indexOf(nameStr = nameStr.substring(1, nameStr.length() - 1)) > 0 ? 1 : 0) != 0);
            }
        }
        finally {
            System.setOut(oldStream);
        }
    }
}

