/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.RandomUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlet;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletWithClassLoader;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServletWithPulsarService;
import org.apache.pulsar.broker.web.plugin.servlet.AdditionalServlets;
import org.apache.pulsar.common.configuration.PulsarConfiguration;
import org.eclipse.jetty.servlet.ServletHolder;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BrokerAdditionalServletTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(BrokerAdditionalServletTest.class);
    private final String BASE_PATH = "/additional/servlet";
    private final String WITH_PULSAR_SERVICE_BASE_PATH = "/additional/servlet/with/pulsar/service";
    private final String QUERY_PARAM = "param";

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        this.internalSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        this.internalCleanup();
    }

    @Override
    protected void beforePulsarStartMocks(PulsarService pulsar) throws Exception {
        this.mockAdditionalServlet(pulsar);
    }

    private void mockAdditionalServlet(PulsarService pulsar) {
        OrdinaryServlet servlet = new OrdinaryServlet();
        AdditionalServlet brokerAdditionalServlet = (AdditionalServlet)Mockito.mock(AdditionalServlet.class);
        Mockito.when((Object)brokerAdditionalServlet.getBasePath()).thenReturn((Object)"/additional/servlet");
        Mockito.when((Object)brokerAdditionalServlet.getServletHolder()).thenReturn((Object)new ServletHolder((Servlet)servlet));
        AdditionalServletWithPulsarService brokerAdditionalServletWithPulsarService = new AdditionalServletWithPulsarService(){
            private PulsarService pulsarService;

            public void setPulsarService(PulsarService pulsarService) {
                this.pulsarService = pulsarService;
            }

            public void loadConfig(PulsarConfiguration pulsarConfiguration) {
            }

            public String getBasePath() {
                return "/additional/servlet/with/pulsar/service";
            }

            public ServletHolder getServletHolder() {
                return new ServletHolder((Servlet)new WithPulsarServiceServlet(this.pulsarService));
            }

            public void close() {
            }
        };
        AdditionalServlets brokerAdditionalServlets = (AdditionalServlets)Mockito.mock(AdditionalServlets.class);
        HashMap<String, AdditionalServletWithClassLoader> map = new HashMap<String, AdditionalServletWithClassLoader>();
        map.put("broker-additional-servlet", new AdditionalServletWithClassLoader(brokerAdditionalServlet, null));
        map.put("broker-additional-servlet-with-pulsar-service", new AdditionalServletWithClassLoader((AdditionalServlet)brokerAdditionalServletWithPulsarService, null));
        Mockito.when((Object)brokerAdditionalServlets.getServlets()).thenReturn(map);
        Mockito.when((Object)pulsar.getBrokerAdditionalServlets()).thenReturn((Object)brokerAdditionalServlets);
    }

    @Test
    public void test() throws IOException {
        int httpPort = (Integer)this.pulsar.getWebService().getListenPortHTTP().get();
        log.info("pulsar webService httpPort {}", (Object)httpPort);
        String paramValue = "value - " + RandomUtils.nextInt();
        String response = this.httpGet("http://localhost:" + httpPort + "/additional/servlet" + "?" + "param" + "=" + paramValue);
        Assert.assertEquals((String)response, (String)paramValue);
        String WithPulsarServiceParamValue = PulsarService.class.getName();
        String withPulsarServiceResponse = this.httpGet("http://localhost:" + httpPort + "/additional/servlet/with/pulsar/service");
        Assert.assertEquals((String)WithPulsarServiceParamValue, (String)withPulsarServiceResponse);
    }

    String httpGet(String url) throws IOException {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().get().url(url).build();
        try (Response response = client.newCall(request).execute();){
            String string = response.body().string();
            return string;
        }
    }

    private class WithPulsarServiceServlet
    extends OrdinaryServlet {
        private final PulsarService pulsarService;

        public WithPulsarServiceServlet(PulsarService pulsar) {
            this.pulsarService = pulsar;
        }

        @Override
        public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
            log.info("[service] path: {}", (Object)((org.eclipse.jetty.server.Request)servletRequest).getOriginalURI());
            String value = this.pulsarService == null ? "null" : PulsarService.class.getName();
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            servletResponse.setContentLength(value.getBytes().length);
            servletOutputStream.write(value.getBytes());
            servletOutputStream.flush();
        }
    }

    private class OrdinaryServlet
    implements Servlet {
        private OrdinaryServlet() {
        }

        public void init(ServletConfig servletConfig) throws ServletException {
            log.info("[init]");
        }

        public ServletConfig getServletConfig() {
            log.info("[getServletConfig]");
            return null;
        }

        public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
            log.info("[service] path: {}", (Object)((org.eclipse.jetty.server.Request)servletRequest).getOriginalURI());
            String value = ((String[])servletRequest.getParameterMap().get("param"))[0];
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            servletResponse.setContentLength(value.getBytes().length);
            servletOutputStream.write(value.getBytes());
            servletOutputStream.flush();
        }

        public String getServletInfo() {
            log.info("[getServletInfo]");
            return null;
        }

        public void destroy() {
            log.info("[destroy]");
        }
    }
}

