/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.MessageDeduplication;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class BrokerMessageDeduplicationTest {
    @Test
    public void markerMessageNotDeduplicated() {
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ServiceConfiguration configuration = new ServiceConfiguration();
        ((PulsarService)Mockito.doReturn((Object)configuration).when((Object)pulsarService)).getConfiguration();
        MessageDeduplication deduplication = (MessageDeduplication)Mockito.spy((Object)new MessageDeduplication(pulsarService, (PersistentTopic)Mockito.mock(PersistentTopic.class), (ManagedLedger)Mockito.mock(ManagedLedger.class)));
        ((MessageDeduplication)Mockito.doReturn((Object)true).when((Object)deduplication)).isEnabled();
        Topic.PublishContext context = (Topic.PublishContext)Mockito.mock(Topic.PublishContext.class);
        ((Topic.PublishContext)Mockito.doReturn((Object)true).when((Object)context)).isMarkerMessage();
        MessageDeduplication.MessageDupStatus status = deduplication.isDuplicate(context, null);
        Assert.assertEquals((Object)status, (Object)MessageDeduplication.MessageDupStatus.NotDup);
    }

    @Test
    public void markerMessageNotRecordPersistent() {
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ServiceConfiguration configuration = new ServiceConfiguration();
        ((PulsarService)Mockito.doReturn((Object)configuration).when((Object)pulsarService)).getConfiguration();
        MessageDeduplication deduplication = (MessageDeduplication)Mockito.spy((Object)new MessageDeduplication(pulsarService, (PersistentTopic)Mockito.mock(PersistentTopic.class), (ManagedLedger)Mockito.mock(ManagedLedger.class)));
        ((MessageDeduplication)Mockito.doReturn((Object)true).when((Object)deduplication)).isEnabled();
        Topic.PublishContext context = (Topic.PublishContext)Mockito.mock(Topic.PublishContext.class);
        ((Topic.PublishContext)Mockito.doReturn((Object)true).when((Object)context)).isMarkerMessage();
        deduplication.recordMessagePersisted(context, null);
        ((Topic.PublishContext)Mockito.doReturn((Object)false).when((Object)context)).isMarkerMessage();
        try {
            deduplication.recordMessagePersisted(context, null);
            Assert.fail();
        }
        catch (Exception npe) {
            Assert.assertTrue((boolean)(npe instanceof NullPointerException));
        }
    }
}

