/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.SubscribeRate;

public class ConfigHelper {
    private ConfigHelper() {
    }

    public static Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlogQuotaMap(ServiceConfiguration configuration) {
        return ImmutableMap.of((Object)BacklogQuota.BacklogQuotaType.destination_storage, (Object)ConfigHelper.sizeBacklogQuota(configuration), (Object)BacklogQuota.BacklogQuotaType.message_age, (Object)ConfigHelper.timeBacklogQuota(configuration));
    }

    public static BacklogQuota sizeBacklogQuota(ServiceConfiguration configuration) {
        long backlogQuotaBytes = configuration.getBacklogQuotaDefaultLimitGB() > 0.0 ? (long)(configuration.getBacklogQuotaDefaultLimitGB() * 1.073741824E9) : configuration.getBacklogQuotaDefaultLimitBytes();
        return BacklogQuota.builder().limitSize(backlogQuotaBytes).retentionPolicy(configuration.getBacklogQuotaDefaultRetentionPolicy()).build();
    }

    public static BacklogQuota timeBacklogQuota(ServiceConfiguration configuration) {
        return BacklogQuota.builder().limitTime(configuration.getBacklogQuotaDefaultLimitSecond()).retentionPolicy(configuration.getBacklogQuotaDefaultRetentionPolicy()).build();
    }

    public static DispatchRate topicDispatchRate(ServiceConfiguration configuration) {
        return DispatchRate.builder().dispatchThrottlingRateInMsg(configuration.getDispatchThrottlingRatePerTopicInMsg()).dispatchThrottlingRateInByte(configuration.getDispatchThrottlingRatePerTopicInByte()).ratePeriodInSecond(1).build();
    }

    public static DispatchRate subscriptionDispatchRate(ServiceConfiguration configuration) {
        return DispatchRate.builder().dispatchThrottlingRateInMsg(configuration.getDispatchThrottlingRatePerSubscriptionInMsg()).dispatchThrottlingRateInByte(configuration.getDispatchThrottlingRatePerSubscriptionInByte()).ratePeriodInSecond(1).build();
    }

    public static DispatchRate replicatorDispatchRate(ServiceConfiguration configuration) {
        return DispatchRate.builder().dispatchThrottlingRateInMsg(configuration.getDispatchThrottlingRatePerReplicatorInMsg()).dispatchThrottlingRateInByte(configuration.getDispatchThrottlingRatePerReplicatorInByte()).ratePeriodInSecond(1).build();
    }

    public static SubscribeRate subscribeRate(ServiceConfiguration configuration) {
        return new SubscribeRate(configuration.getSubscribeThrottlingRatePerConsumer(), configuration.getSubscribeRatePeriodPerConsumerInSecond());
    }
}

