/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminApiClusterTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiClusterTest.class);
    private final String CLUSTER = "test";

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.resetConfig();
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testDeleteNonExistCluster() {
        String cluster = "test-non-exist-cluster-" + UUID.randomUUID();
        Assert.assertThrows(PulsarAdminException.NotFoundException.class, () -> this.admin.clusters().deleteCluster(cluster));
    }

    @Test
    public void testDeleteExistCluster() throws PulsarAdminException {
        String cluster = "test-exist-cluster-" + UUID.randomUUID();
        this.admin.clusters().createCluster(cluster, ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        Awaitility.await().untilAsserted(() -> Assert.assertNotNull((Object)this.admin.clusters().getCluster(cluster)));
        this.admin.clusters().deleteCluster(cluster);
    }

    @Test
    public void testDeleteNonExistentFailureDomain() {
        Assert.assertThrows(PulsarAdminException.NotFoundException.class, () -> this.admin.clusters().deleteFailureDomain("test", "non-existent-failure-domain"));
    }

    @Test
    public void testDeleteNonExistentFailureDomainInNonExistCluster() {
        Assert.assertThrows(PulsarAdminException.PreconditionFailedException.class, () -> this.admin.clusters().deleteFailureDomain("test" + UUID.randomUUID(), "non-existent-failure-domain"));
    }

    @Test
    public void testDeleteExistFailureDomain() throws PulsarAdminException {
        String domainName = "test-failure-domain";
        FailureDomain domain = FailureDomain.builder().brokers((Set)Sets.newHashSet((Object[])new String[]{"b1", "b2", "b3"})).build();
        this.admin.clusters().createFailureDomain("test", domainName, domain);
        Awaitility.await().untilAsserted(() -> this.admin.clusters().getFailureDomain("test", domainName));
        this.admin.clusters().deleteFailureDomain("test", domainName);
    }
}

