/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminApiDynamicConfigurationsTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiDynamicConfigurationsTest.class);

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void TestGetAllDynamicConfigurations() throws Exception {
        Map configs = this.admin.brokers().getAllDynamicConfigurations();
        org.testng.Assert.assertNotNull((Object)configs);
    }

    @Test
    public void TestDeleteDynamicConfiguration() throws Exception {
        this.admin.brokers().deleteDynamicConfiguration("dispatcherMinReadBatchSize");
    }

    @Test
    public void TestDeleteInvalidDynamicConfiguration() {
        try {
            this.admin.brokers().deleteDynamicConfiguration("errorName");
            Assert.fail((String)"exception should be thrown");
        }
        catch (Exception e) {
            if (e instanceof PulsarAdminException) {
                org.testng.Assert.assertEquals((int)((PulsarAdminException)((Object)e)).getStatusCode(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
            }
            Assert.fail((String)"PulsarAdminException should be thrown");
        }
    }
}

