/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.TopicVersion;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminApiHealthCheckTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiHealthCheckTest.class);

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.resetConfig();
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("pulsar", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("pulsar/system", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("public", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("public/default", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testHealthCheckup() throws Exception {
        int times = 30;
        CompletableFuture future = new CompletableFuture();
        this.pulsar.getExecutor().execute(() -> {
            try {
                for (int i = 0; i < 30; ++i) {
                    this.admin.brokers().healthcheck();
                }
                future.complete(null);
            }
            catch (PulsarAdminException e) {
                future.completeExceptionally(e);
            }
        });
        for (int i = 0; i < 30; ++i) {
            this.admin.brokers().healthcheck();
        }
        String testHealthCheckTopic = String.format("persistent://pulsar/test/localhost:%s/healthcheck", this.pulsar.getConfig().getWebServicePort().get());
        Awaitility.await().untilAsserted(() -> Assert.assertFalse((boolean)future.isCompletedExceptionally()));
        Awaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.admin.topics().getSubscriptions(testHealthCheckTopic).stream().filter(v -> !v.equals("__compaction")).collect(Collectors.toList()))));
    }

    @Test
    public void testHealthCheckupV1() throws Exception {
        int times = 30;
        CompletableFuture future = new CompletableFuture();
        this.pulsar.getExecutor().execute(() -> {
            try {
                for (int i = 0; i < 30; ++i) {
                    this.admin.brokers().healthcheck(TopicVersion.V1);
                }
                future.complete(null);
            }
            catch (PulsarAdminException e) {
                future.completeExceptionally(e);
            }
        });
        for (int i = 0; i < 30; ++i) {
            this.admin.brokers().healthcheck(TopicVersion.V1);
        }
        String testHealthCheckTopic = String.format("persistent://pulsar/test/localhost:%s/healthcheck", this.pulsar.getConfig().getWebServicePort().get());
        Awaitility.await().untilAsserted(() -> Assert.assertFalse((boolean)future.isCompletedExceptionally()));
        Awaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.admin.topics().getSubscriptions(testHealthCheckTopic).stream().filter(v -> !v.equals("__compaction")).collect(Collectors.toList()))));
    }

    @Test
    public void testHealthCheckupV2() throws Exception {
        int times = 30;
        CompletableFuture future = new CompletableFuture();
        this.pulsar.getExecutor().execute(() -> {
            try {
                for (int i = 0; i < 30; ++i) {
                    this.admin.brokers().healthcheck(TopicVersion.V2);
                }
                future.complete(null);
            }
            catch (PulsarAdminException e) {
                future.completeExceptionally(e);
            }
        });
        for (int i = 0; i < 30; ++i) {
            this.admin.brokers().healthcheck(TopicVersion.V2);
        }
        String testHealthCheckTopic = String.format("persistent://pulsar/localhost:%s/healthcheck", this.pulsar.getConfig().getWebServicePort().get());
        Awaitility.await().untilAsserted(() -> Assert.assertFalse((boolean)future.isCompletedExceptionally()));
        Awaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)CollectionUtils.isEmpty((Collection)this.admin.topics().getSubscriptions(testHealthCheckTopic).stream().filter(v -> !v.equals("__compaction")).collect(Collectors.toList()))));
    }
}

