/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.testng.collections.Maps;

@Test(groups={"broker"})
public class AdminApiSchemaValidationEnforced
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdminApiSchemaValidationEnforced.class);
    private static final Logger LOG = LoggerFactory.getLogger(AdminApiSchemaValidationEnforced.class);

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("schema-validation-enforced", (TenantInfo)tenantInfo);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testGetSchemaValidationEnforcedApplied() throws Exception {
        String namespace = "schema-validation-enforced/testApplied";
        this.admin.namespaces().createNamespace(namespace);
        this.conf.setSchemaValidationEnforced(true);
        Assert.assertTrue((boolean)this.admin.namespaces().getSchemaValidationEnforced(namespace, true));
        Assert.assertFalse((boolean)this.admin.namespaces().getSchemaValidationEnforced(namespace, false));
    }

    @Test
    public void testDisableSchemaValidationEnforcedNoSchema() throws Exception {
        this.admin.namespaces().createNamespace("schema-validation-enforced/default-no-schema");
        String namespace = "schema-validation-enforced/default-no-schema";
        String topicName = "persistent://schema-validation-enforced/default-no-schema/test";
        Assert.assertFalse((boolean)this.admin.namespaces().getSchemaValidationEnforced(namespace));
        this.admin.namespaces().setSchemaValidationEnforced(namespace, false);
        try {
            this.admin.schemas().getSchemaInfo(topicName);
        }
        catch (PulsarAdminException.NotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("HTTP 404 Not Found"));
        }
        try (Producer p = this.pulsarClient.newProducer().topic(topicName).create();){
            p.send((Object)"test schemaValidationEnforced".getBytes());
        }
    }

    @Test
    public void testDisableSchemaValidationEnforcedHasSchema() throws Exception {
        this.admin.namespaces().createNamespace("schema-validation-enforced/default-has-schema");
        String namespace = "schema-validation-enforced/default-has-schema";
        String topicName = "persistent://schema-validation-enforced/default-has-schema/test";
        Assert.assertFalse((boolean)this.admin.namespaces().getSchemaValidationEnforced(namespace));
        this.admin.namespaces().setSchemaValidationEnforced(namespace, false);
        try {
            this.admin.schemas().getSchemaInfo(topicName);
        }
        catch (PulsarAdminException.NotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("HTTP 404 Not Found"));
        }
        Map properties = Maps.newHashMap();
        SchemaInfo schemaInfo = SchemaInfo.builder().type(SchemaType.STRING).properties(properties).name("test").schema("".getBytes()).build();
        PostSchemaPayload postSchemaPayload = new PostSchemaPayload("STRING", "", properties);
        this.admin.schemas().createSchema(topicName, postSchemaPayload);
        try (Producer p = this.pulsarClient.newProducer().topic(topicName).create();){
            p.send((Object)"test schemaValidationEnforced".getBytes());
        }
        Assert.assertEquals((Object)this.admin.schemas().getSchemaInfo(topicName), (Object)schemaInfo);
    }

    @Test
    public void testEnableSchemaValidationEnforcedNoSchema() throws Exception {
        this.admin.namespaces().createNamespace("schema-validation-enforced/enable-no-schema");
        String namespace = "schema-validation-enforced/enable-no-schema";
        String topicName = "persistent://schema-validation-enforced/enable-no-schema/test";
        Assert.assertFalse((boolean)this.admin.namespaces().getSchemaValidationEnforced(namespace));
        this.admin.namespaces().setSchemaValidationEnforced(namespace, true);
        try {
            this.admin.schemas().getSchemaInfo(topicName);
        }
        catch (PulsarAdminException.NotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("HTTP 404 Not Found"));
        }
        try (Producer p = this.pulsarClient.newProducer().topic(topicName).create();){
            p.send((Object)"test schemaValidationEnforced".getBytes());
        }
    }

    @Test
    public void testEnableSchemaValidationEnforcedHasSchemaMismatch() throws Exception {
        this.admin.namespaces().createNamespace("schema-validation-enforced/enable-has-schema-mismatch");
        String namespace = "schema-validation-enforced/enable-has-schema-mismatch";
        String topicName = "persistent://schema-validation-enforced/enable-has-schema-mismatch/test";
        Assert.assertFalse((boolean)this.admin.namespaces().getSchemaValidationEnforced(namespace));
        this.admin.namespaces().setSchemaValidationEnforced(namespace, true);
        Assert.assertTrue((boolean)this.admin.namespaces().getSchemaValidationEnforced(namespace));
        this.admin.topics().createNonPartitionedTopic(topicName);
        this.admin.topics().getStats(topicName);
        try {
            this.admin.schemas().getSchemaInfo(topicName);
        }
        catch (PulsarAdminException.NotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("HTTP 404 Not Found"));
        }
        Map properties = Maps.newHashMap();
        properties.put("key1", "value1");
        SchemaInfo schemaInfo = SchemaInfo.builder().type(SchemaType.STRING).properties(properties).name("test").schema("".getBytes()).build();
        PostSchemaPayload postSchemaPayload = new PostSchemaPayload("STRING", "", properties);
        this.admin.schemas().createSchema(topicName, postSchemaPayload);
        try (Producer p = this.pulsarClient.newProducer().topic(topicName).create();){
            Assert.fail((String)"Client no schema, but topic has schema, should fail");
        }
        catch (PulsarClientException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("IncompatibleSchemaException"));
        }
        Assert.assertEquals((String)this.admin.schemas().getSchemaInfo(topicName).getName(), (String)schemaInfo.getName());
        Assert.assertEquals((Object)this.admin.schemas().getSchemaInfo(topicName).getType(), (Object)schemaInfo.getType());
    }

    @Test
    public void testEnableSchemaValidationEnforcedHasSchemaMatch() throws Exception {
        this.admin.namespaces().createNamespace("schema-validation-enforced/enable-has-schema-match");
        String namespace = "schema-validation-enforced/enable-has-schema-match";
        String topicName = "persistent://schema-validation-enforced/enable-has-schema-match/test";
        Assert.assertFalse((boolean)this.admin.namespaces().getSchemaValidationEnforced(namespace));
        try {
            this.admin.schemas().getSchemaInfo(topicName);
        }
        catch (PulsarAdminException.NotFoundException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("HTTP 404 Not Found"));
        }
        this.admin.namespaces().setSchemaValidationEnforced(namespace, true);
        Map properties = Maps.newHashMap();
        SchemaInfo schemaInfo = SchemaInfo.builder().type(SchemaType.STRING).properties(properties).name("test").schema("".getBytes()).build();
        PostSchemaPayload postSchemaPayload = new PostSchemaPayload("STRING", "", properties);
        this.admin.schemas().createSchema(topicName, postSchemaPayload);
        try (Producer p = this.pulsarClient.newProducer(Schema.STRING).topic(topicName).create();){
            p.send((Object)"test schemaValidationEnforced");
        }
        Assert.assertEquals((String)this.admin.schemas().getSchemaInfo(topicName).getName(), (String)schemaInfo.getName());
        Assert.assertEquals((Object)this.admin.schemas().getSchemaInfo(topicName).getType(), (Object)schemaInfo.getType());
    }
}

