/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.net.URI;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.servlet.ServletContext;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.TimeoutHandler;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.pulsar.broker.admin.MockServletContext;
import org.apache.pulsar.broker.admin.v1.BrokerStats;
import org.apache.pulsar.broker.admin.v1.Brokers;
import org.apache.pulsar.broker.admin.v1.Clusters;
import org.apache.pulsar.broker.admin.v1.Namespaces;
import org.apache.pulsar.broker.admin.v1.PersistentTopics;
import org.apache.pulsar.broker.admin.v1.Properties;
import org.apache.pulsar.broker.admin.v1.ResourceQuotas;
import org.apache.pulsar.broker.admin.v2.SchemasResource;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationDataHttps;
import org.apache.pulsar.broker.loadbalance.LeaderBroker;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.common.api.proto.CommandGetTopicsOfNamespace;
import org.apache.pulsar.common.conf.InternalConfigurationData;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.BrokerInfo;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.stats.AllocatorStats;
import org.apache.pulsar.metadata.cache.impl.MetadataCacheImpl;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.awaitility.Awaitility;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdminTest
extends MockedPulsarServiceBaseTest {
    private final String configClusterName = "use";
    private Clusters clusters;
    private Properties properties;
    private Namespaces namespaces;
    private PersistentTopics persistentTopics;
    private Brokers brokers;
    private ResourceQuotas resourceQuotas;
    private BrokerStats brokerStats;
    private SchemasResource schemasResource;
    private Field uriField;
    private final Clock mockClock = Clock.fixed(Instant.ofEpochSecond(365248800L), ZoneId.of("-05:00"));

    @Override
    protected void doInitConf() throws Exception {
        super.doInitConf();
        this.conf.setMaxTenants(10);
    }

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setClusterName("use");
        super.internalSetup();
        this.clusters = (Clusters)Mockito.spy(Clusters.class);
        this.clusters.setPulsar(this.pulsar);
        ((Clusters)Mockito.doReturn((Object)"test").when((Object)this.clusters)).clientAppId();
        ((Clusters)Mockito.doNothing().when((Object)this.clusters)).validateSuperUserAccess();
        this.properties = (Properties)Mockito.spy(Properties.class);
        this.properties.setPulsar(this.pulsar);
        ((Properties)Mockito.doReturn((Object)"test").when((Object)this.properties)).clientAppId();
        ((Properties)Mockito.doNothing().when((Object)this.properties)).validateSuperUserAccess();
        this.namespaces = (Namespaces)Mockito.spy(Namespaces.class);
        this.namespaces.setServletContext((ServletContext)new MockServletContext());
        this.namespaces.setPulsar(this.pulsar);
        ((Namespaces)Mockito.doReturn((Object)"test").when((Object)this.namespaces)).clientAppId();
        ((Namespaces)Mockito.doReturn((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"use", "usw", "usc", "global"}))).when((Object)this.namespaces)).clusters();
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateAdminAccessForTenant("my-tenant");
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateAdminAccessForTenant("other-tenant");
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateAdminAccessForTenant("new-property");
        this.brokers = (Brokers)Mockito.spy(Brokers.class);
        this.brokers.setPulsar(this.pulsar);
        ((Brokers)Mockito.doReturn((Object)"test").when((Object)this.brokers)).clientAppId();
        ((Brokers)Mockito.doNothing().when((Object)this.brokers)).validateSuperUserAccess();
        this.uriField = PulsarWebResource.class.getDeclaredField("uri");
        this.uriField.setAccessible(true);
        this.persistentTopics = (PersistentTopics)Mockito.spy(PersistentTopics.class);
        this.persistentTopics.setServletContext((ServletContext)new MockServletContext());
        this.persistentTopics.setPulsar(this.pulsar);
        ((PersistentTopics)Mockito.doReturn((Object)"test").when((Object)this.persistentTopics)).clientAppId();
        ((PersistentTopics)Mockito.doReturn((Object)"persistent").when((Object)this.persistentTopics)).domain();
        ((PersistentTopics)Mockito.doReturn((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"use", "usw", "usc"}))).when((Object)this.persistentTopics)).clusters();
        ((PersistentTopics)Mockito.doNothing().when((Object)this.persistentTopics)).validateAdminAccessForTenant("my-tenant");
        ((PersistentTopics)Mockito.doNothing().when((Object)this.persistentTopics)).validateAdminAccessForTenant("other-tenant");
        ((PersistentTopics)Mockito.doNothing().when((Object)this.persistentTopics)).validateAdminAccessForTenant("prop-xyz");
        this.resourceQuotas = (ResourceQuotas)Mockito.spy(ResourceQuotas.class);
        this.resourceQuotas.setServletContext((ServletContext)new MockServletContext());
        this.resourceQuotas.setPulsar(this.pulsar);
        this.brokerStats = (BrokerStats)Mockito.spy(BrokerStats.class);
        this.brokerStats.setServletContext((ServletContext)new MockServletContext());
        this.brokerStats.setPulsar(this.pulsar);
        ((PersistentTopics)Mockito.doReturn((Object)false).when((Object)this.persistentTopics)).isRequestHttps();
        ((PersistentTopics)Mockito.doReturn(null).when((Object)this.persistentTopics)).originalPrincipal();
        ((PersistentTopics)Mockito.doReturn((Object)"test").when((Object)this.persistentTopics)).clientAppId();
        ((PersistentTopics)Mockito.doReturn((Object)Mockito.mock(AuthenticationDataHttps.class)).when((Object)this.persistentTopics)).clientAuthData();
        this.schemasResource = (SchemasResource)Mockito.spy(SchemasResource.class);
        this.schemasResource.setServletContext((ServletContext)new MockServletContext());
        this.schemasResource.setPulsar(this.pulsar);
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
        this.conf.setClusterName("use");
    }

    @Test
    public void internalConfiguration() throws Exception {
        InternalConfigurationData expectedData = new InternalConfigurationData(this.pulsar.getConfiguration().getZookeeperServers(), this.pulsar.getConfiguration().getConfigurationStoreServers(), new ClientConfiguration().getZkLedgersRootPath(), this.pulsar.getMetadataServiceUri(), (String)this.pulsar.getWorkerConfig().map(wc -> wc.getStateStorageServiceUrl()).orElse(null));
        Assert.assertEquals((Object)this.brokers.getInternalConfigurationData(), (Object)expectedData);
    }

    @Test
    public void clusters() throws Exception {
        Assert.assertEquals((Collection)this.clusters.getClusters(), (Collection)Lists.newArrayList());
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.never())).validateSuperUserAccess();
        this.clusters.createCluster("use", ClusterDataImpl.builder().serviceUrl("http://broker.messaging.use.example.com:8080").build());
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)1))).validateSuperUserAccess();
        Assert.assertEquals((Collection)this.clusters.getClusters(), (Collection)Lists.newArrayList((Object[])new String[]{"use"}));
        try {
            this.clusters.createCluster("use", ClusterDataImpl.builder().serviceUrl("http://broker.messaging.use.example.com:8080").build());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        try {
            this.clusters.deleteCluster("usc");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        Assert.assertEquals((Object)this.clusters.getCluster("use"), (Object)ClusterDataImpl.builder().serviceUrl("http://broker.messaging.use.example.com:8080").build());
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)4))).validateSuperUserAccess();
        this.clusters.updateCluster("use", ClusterDataImpl.builder().serviceUrl("http://new-broker.messaging.use.example.com:8080").build());
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)5))).validateSuperUserAccess();
        Assert.assertEquals((Object)this.clusters.getCluster("use"), (Object)ClusterData.builder().serviceUrl("http://new-broker.messaging.use.example.com:8080").build());
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)6))).validateSuperUserAccess();
        try {
            this.clusters.getNamespaceIsolationPolicies("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)404);
        }
        HashMap<String, String> parameters1 = new HashMap<String, String>();
        parameters1.put("min_limit", "1");
        parameters1.put("usage_threshold", "90");
        NamespaceIsolationDataImpl policyData = NamespaceIsolationDataImpl.builder().namespaces(Collections.singletonList("dummy/colo/ns")).primary(Collections.singletonList("localhost:" + this.pulsar.getListenPortHTTP())).autoFailoverPolicy(AutoFailoverPolicyData.builder().policyType(AutoFailoverPolicyType.min_available).parameters(parameters1).build()).build();
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.clusters.setNamespaceIsolationPolicy(response, "use", "policy1", policyData);
        this.clusters.getNamespaceIsolationPolicies("use");
        try {
            this.clusters.deleteCluster("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)412);
        }
        this.clusters.deleteNamespaceIsolationPolicy("use", "policy1");
        Assert.assertTrue((boolean)this.clusters.getNamespaceIsolationPolicies("use").isEmpty());
        this.clusters.deleteCluster("use");
        ((Clusters)Mockito.verify((Object)this.clusters, (VerificationMode)Mockito.times((int)13))).validateSuperUserAccess();
        Assert.assertEquals((Collection)this.clusters.getClusters(), (Collection)Lists.newArrayList());
        try {
            this.clusters.getCluster("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)404);
        }
        try {
            this.clusters.updateCluster("use", ClusterDataImpl.builder().build());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)404);
        }
        try {
            this.clusters.getNamespaceIsolationPolicies("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)404);
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET_CHILDREN && path.equals("/admin/clusters"));
        MetadataCacheImpl clusterCache = (MetadataCacheImpl)this.pulsar.getPulsarResources().getClusterResources().getCache();
        MetadataCacheImpl isolationPolicyCache = (MetadataCacheImpl)this.pulsar.getPulsarResources().getNamespaceResources().getIsolationPolicies().getCache();
        AbstractMetadataStore store = (AbstractMetadataStore)clusterCache.getStore();
        clusterCache.invalidateAll();
        store.invalidateAll();
        try {
            this.clusters.getClusters();
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.CREATE && path.equals("/admin/clusters/test"));
        try {
            this.clusters.createCluster("test", ClusterDataImpl.builder().serviceUrl("http://broker.messaging.test.example.com:8080").build());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET && path.equals("/admin/clusters/test"));
        clusterCache.invalidateAll();
        store.invalidateAll();
        try {
            this.clusters.updateCluster("test", ClusterDataImpl.builder().serviceUrl("http://broker.messaging.test.example.com").build());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET && path.equals("/admin/clusters/test"));
        try {
            this.clusters.getCluster("test");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET_CHILDREN && path.equals("/admin/policies"));
        try {
            this.clusters.deleteCluster("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET && path.equals("/admin/clusters/use/namespaceIsolationPolicies"));
        clusterCache.invalidateAll();
        isolationPolicyCache.invalidateAll();
        store.invalidateAll();
        try {
            this.clusters.deleteCluster("use");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        try {
            this.clusters.createCluster("bf@", ClusterDataImpl.builder().serviceUrl("http://dummy.messaging.example.com").build());
            Assert.fail((String)"should have filed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            this.clusters.createCluster("auth", ClusterDataImpl.builder().serviceUrl("http://dummy.web.example.com").serviceUrlTls("").brokerServiceUrl("http://dummy.messaging.example.com").brokerServiceUrlTls("").authenticationPlugin("authenticationPlugin").authenticationParameters("authenticationParameters").listenerName("listenerName").build());
            ClusterData cluster = this.clusters.getCluster("auth");
            Assert.assertEquals((String)cluster.getAuthenticationPlugin(), (String)"authenticationPlugin");
            Assert.assertEquals((String)cluster.getAuthenticationParameters(), (String)"authenticationParameters");
            Assert.assertEquals((String)cluster.getListenerName(), (String)"listenerName");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    Object asynRequests(Consumer<TestAsyncResponse> function) throws Exception {
        TestAsyncResponse ctx = new TestAsyncResponse();
        function.accept(ctx);
        ctx.latch.await();
        if (ctx.e != null) {
            throw (Exception)ctx.e;
        }
        return ctx.response;
    }

    @Test
    public void properties() throws Throwable {
        Object response = this.asynRequests(ctx -> this.properties.getTenants((AsyncResponse)ctx));
        Assert.assertEquals((Object)response, (Object)Lists.newArrayList());
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)1))).validateSuperUserAccess();
        this.clusters.createCluster("use", ClusterDataImpl.builder().build());
        HashSet allowedClusters = Sets.newHashSet();
        allowedClusters.add("use");
        TenantInfoImpl tenantInfo = TenantInfoImpl.builder().adminRoles((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"})).allowedClusters((Set)allowedClusters).build();
        response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "test-property", tenantInfo));
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)2))).validateSuperUserAccess();
        response = this.asynRequests(ctx -> this.properties.getTenants((AsyncResponse)ctx));
        Assert.assertEquals((Object)response, (Object)Lists.newArrayList((Object[])new String[]{"test-property"}));
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)3))).validateSuperUserAccess();
        response = this.asynRequests(ctx -> this.properties.getTenantAdmin((AsyncResponse)ctx, "test-property"));
        Assert.assertEquals((Object)response, (Object)tenantInfo);
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)4))).validateSuperUserAccess();
        TenantInfoImpl newPropertyAdmin = TenantInfoImpl.builder().adminRoles((Set)Sets.newHashSet((Object[])new String[]{"role1", "other-role"})).allowedClusters((Set)allowedClusters).build();
        response = this.asynRequests(ctx -> this.properties.updateTenant((AsyncResponse)ctx, "test-property", newPropertyAdmin));
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)5))).validateSuperUserAccess();
        Thread.sleep(100L);
        response = this.asynRequests(ctx -> this.properties.getTenantAdmin((AsyncResponse)ctx, "test-property"));
        Assert.assertEquals((Object)response, (Object)newPropertyAdmin);
        response = this.asynRequests(ctx -> this.properties.getTenantAdmin((AsyncResponse)ctx, "test-property"));
        Assert.assertNotSame((Object)response, (Object)tenantInfo);
        ((Properties)Mockito.verify((Object)this.properties, (VerificationMode)Mockito.times((int)7))).validateSuperUserAccess();
        try {
            response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "test-property", tenantInfo));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        try {
            response = this.asynRequests(ctx -> this.properties.getTenantAdmin((AsyncResponse)ctx, "non-existing"));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            response = this.asynRequests(ctx -> this.properties.updateTenant((AsyncResponse)ctx, "xxx-non-existing", newPropertyAdmin));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            response = this.asynRequests(ctx -> this.properties.deleteTenant((AsyncResponse)ctx, "non-existing", false));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        MetadataCacheImpl cache = (MetadataCacheImpl)this.pulsar.getPulsarResources().getTenantResources().getCache();
        AbstractMetadataStore store = (AbstractMetadataStore)cache.getStore();
        cache.invalidateAll();
        store.invalidateAll();
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET_CHILDREN && path.equals("/admin/policies"));
        try {
            response = this.asynRequests(ctx -> this.properties.getTenants((AsyncResponse)ctx));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET && path.equals("/admin/policies/my-tenant"));
        try {
            response = this.asynRequests(ctx -> this.properties.getTenantAdmin((AsyncResponse)ctx, "my-tenant"));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET && path.equals("/admin/policies/my-tenant"));
        try {
            response = this.asynRequests(ctx -> this.properties.updateTenant((AsyncResponse)ctx, "my-tenant", newPropertyAdmin));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.CREATE && path.equals("/admin/policies/test"));
        try {
            response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "test", tenantInfo));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET_CHILDREN && path.equals("/admin/policies/test-property"));
        try {
            cache.invalidateAll();
            store.invalidateAll();
            response = this.asynRequests(ctx -> this.properties.deleteTenant((AsyncResponse)ctx, "test-property", false));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "error-property", tenantInfo));
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.DELETE && path.equals("/admin/policies/error-property"));
        try {
            response = this.asynRequests(ctx -> this.properties.deleteTenant((AsyncResponse)ctx, "error-property", false));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        response = this.asynRequests(ctx -> this.properties.deleteTenant((AsyncResponse)ctx, "test-property", false));
        response = this.asynRequests(ctx -> this.properties.deleteTenant((AsyncResponse)ctx, "error-property", false));
        response = Lists.newArrayList();
        response = this.asynRequests(ctx -> this.properties.getTenants((AsyncResponse)ctx));
        Assert.assertEquals((Object)response, (Object)Lists.newArrayList());
        TenantInfoImpl newPropertyAdmin2 = TenantInfoImpl.builder().adminRoles((Set)Sets.newHashSet((Object[])new String[]{"role1", "other-role"})).allowedClusters((Set)Sets.newHashSet((Object[])new String[]{"use"})).build();
        response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "my-tenant", newPropertyAdmin2));
        this.namespaces.createNamespace("my-tenant", "use", "my-namespace", BundlesData.builder().build());
        try {
            response = this.asynRequests(ctx -> this.properties.deleteTenant((AsyncResponse)ctx, "my-tenant", false));
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        try {
            response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "test&", tenantInfo));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "tenant-config-is-null", null));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        String blankCluster = "";
        HashSet blankClusters = Sets.newHashSet((Object[])new String[]{blankCluster});
        TenantInfoImpl tenantWithEmptyCluster = TenantInfoImpl.builder().adminRoles((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"})).allowedClusters((Set)blankClusters).build();
        try {
            response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "tenant-config-is-empty", tenantWithEmptyCluster));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        HashSet containBlankClusters = Sets.newHashSet((Object[])new String[]{blankCluster});
        containBlankClusters.add("use");
        TenantInfoImpl tenantContainEmptyCluster = TenantInfoImpl.builder().adminRoles((Set)Sets.newHashSet()).allowedClusters((Set)containBlankClusters).build();
        try {
            response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "tenant-config-contain-empty", tenantContainEmptyCluster));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        int maxTenants = this.pulsar.getConfiguration().getMaxTenants();
        List tenants = this.pulsar.getPulsarResources().getTenantResources().listTenants();
        for (int tenantSize = tenants.size(); tenantSize < maxTenants; ++tenantSize) {
            int tenantIndex = tenantSize;
            Response obj = (Response)this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "test-tenant-" + tenantIndex, tenantInfo));
            Assert.assertTrue((obj.getStatus() < 400 && obj.getStatus() >= 200 ? 1 : 0) != 0);
        }
        try {
            response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "test-tenant-" + maxTenants, tenantInfo));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            response = this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, "test-tenant-" + (maxTenants - 1), tenantInfo));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        AsyncResponse response2 = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response2, "my-tenant", "use", "my-namespace", false, false);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response2, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(captor.capture());
        Assert.assertEquals((int)((Response)captor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        response = this.asynRequests(ctx -> this.properties.deleteTenant((AsyncResponse)ctx, "my-tenant", false));
    }

    @Test
    public void brokers() throws Exception {
        this.clusters.createCluster("use", ClusterDataImpl.builder().serviceUrl("http://broker.messaging.use.example.com").serviceUrlTls("https://broker.messaging.use.example.com:4443").build());
        URI requestUri = new URI("http://broker.messaging.use.example.com:8080/admin/brokers/use");
        UriInfo mockUri = (UriInfo)Mockito.mock(UriInfo.class);
        ((UriInfo)Mockito.doReturn((Object)requestUri).when((Object)mockUri)).getRequestUri();
        Field uriField = PulsarWebResource.class.getDeclaredField("uri");
        uriField.setAccessible(true);
        uriField.set(this.brokers, mockUri);
        Set activeBrokers = this.brokers.getActiveBrokers("use");
        Assert.assertEquals((int)activeBrokers.size(), (int)1);
        Assert.assertEquals((Set)activeBrokers, (Set)Sets.newHashSet((Object[])new String[]{this.pulsar.getAdvertisedAddress() + ":" + this.pulsar.getListenPortHTTP().get()}));
        BrokerInfo leaderBroker = this.brokers.getLeaderBroker();
        Assert.assertEquals((String)leaderBroker.getServiceUrl(), (String)this.pulsar.getLeaderElectionService().getCurrentLeader().map(LeaderBroker::getServiceUrl).get());
    }

    @Test
    public void resourceQuotas() throws Exception {
        ResourceQuota quota = this.resourceQuotas.getDefaultResourceQuota();
        Assert.assertNotNull((Object)quota);
        Assert.assertTrue((quota.getBandwidthIn() > 0.0 ? 1 : 0) != 0);
        double defaultBandwidth = 1000.0;
        quota.setBandwidthIn(defaultBandwidth);
        quota.setBandwidthOut(defaultBandwidth);
        this.resourceQuotas.setDefaultResourceQuota(quota);
        Assert.assertEquals((double)defaultBandwidth, (double)this.resourceQuotas.getDefaultResourceQuota().getBandwidthIn());
        Assert.assertEquals((double)defaultBandwidth, (double)this.resourceQuotas.getDefaultResourceQuota().getBandwidthOut());
        String property = "prop-xyz";
        String cluster = "use";
        String namespace = "ns";
        String bundleRange = "0x00000000_0xffffffff";
        Policies policies = new Policies();
        ((ResourceQuotas)Mockito.doReturn((Object)policies).when((Object)this.resourceQuotas)).getNamespacePolicies(NamespaceName.get((String)property, (String)cluster, (String)namespace));
        ((ResourceQuotas)Mockito.doReturn((Object)"client-id").when((Object)this.resourceQuotas)).clientAppId();
        try {
            this.resourceQuotas.setNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange, quota);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.resourceQuotas.removeNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TenantInfoImpl admin = TenantInfoImpl.builder().allowedClusters(Collections.singleton(cluster)).build();
        ClusterDataImpl clusterData = ClusterDataImpl.builder().serviceUrl(cluster).build();
        this.clusters.createCluster(cluster, clusterData);
        this.asynRequests(ctx -> this.properties.createTenant((AsyncResponse)ctx, property, admin));
        double customizeBandwidth = 3000.0;
        quota.setBandwidthIn(customizeBandwidth);
        quota.setBandwidthOut(customizeBandwidth);
        this.resourceQuotas.setNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange, quota);
        ResourceQuota bundleQuota = this.resourceQuotas.getNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange);
        Assert.assertEquals((Object)quota, (Object)bundleQuota);
        this.resourceQuotas.removeNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange);
        bundleQuota = this.resourceQuotas.getNamespaceBundleResourceQuota(property, cluster, namespace, bundleRange);
        Assert.assertEquals((double)defaultBandwidth, (double)bundleQuota.getBandwidthIn());
        Assert.assertEquals((double)defaultBandwidth, (double)bundleQuota.getBandwidthOut());
    }

    @Test
    public void brokerStats() throws Exception {
        ((BrokerStats)Mockito.doReturn((Object)"client-id").when((Object)this.brokerStats)).clientAppId();
        Collection metrics = this.brokerStats.getMetrics();
        Assert.assertNotNull((Object)metrics);
        LocalBrokerData loadReport = (LocalBrokerData)this.brokerStats.getLoadReport();
        Assert.assertNotNull((Object)loadReport);
        Assert.assertNotNull((Object)loadReport.getCpu());
        Collection mBeans = this.brokerStats.getMBeans();
        Assert.assertFalse((boolean)mBeans.isEmpty());
        AllocatorStats allocatorStats = this.brokerStats.getAllocatorStats("default");
        Assert.assertNotNull((Object)allocatorStats);
        Map bookieOpsStats = this.brokerStats.getPendingBookieOpsStats();
        Assert.assertTrue((boolean)bookieOpsStats.isEmpty());
        StreamingOutput topic = this.brokerStats.getTopics2();
        Assert.assertNotNull((Object)topic);
        try {
            this.brokerStats.getBrokerResourceAvailability("prop", "use", "ns2");
            Assert.fail((String)"should have failed as ModularLoadManager doesn't support it");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    @Test
    public void persistentTopics() throws Exception {
        String property = "prop-xyz";
        String cluster = "use";
        String namespace = "ns";
        String topic = "ds1";
        Policies policies = new Policies();
        ((ResourceQuotas)Mockito.doReturn((Object)policies).when((Object)this.resourceQuotas)).getNamespacePolicies(NamespaceName.get((String)"prop-xyz", (String)"use", (String)"ns"));
        ((ResourceQuotas)Mockito.doReturn((Object)"client-id").when((Object)this.resourceQuotas)).clientAppId();
        TenantInfo admin = TenantInfo.builder().allowedClusters(Collections.singleton("use")).build();
        this.pulsar.getPulsarResources().getTenantResources().createTenant("prop-xyz", admin);
        this.pulsar.getPulsarResources().getNamespaceResources().createPolicies(NamespaceName.get((String)"prop-xyz", (String)"use", (String)"ns"), new Policies());
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.persistentTopics.getList(response, "prop-xyz", "use", "ns");
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).resume((Object)Lists.newArrayList());
        Assert.assertEquals((Collection)this.persistentTopics.getPartitionedTopicList("prop-xyz", "use", "ns"), (Collection)Lists.newArrayList());
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(Response.class);
        this.persistentTopics.createPartitionedTopic(response, "prop-xyz", "use", "ns", "ds1", 5, false);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        Assert.assertEquals((Collection)this.persistentTopics.getPartitionedTopicList("prop-xyz", "use", "ns"), (Collection)Lists.newArrayList((Object[])new String[]{String.format("persistent://%s/%s/%s/%s", "prop-xyz", "use", "ns", "ds1")}));
        TopicName topicName = TopicName.get((String)"persistent", (String)"prop-xyz", (String)"use", (String)"ns", (String)"ds1");
        Assert.assertEquals((int)this.persistentTopics.getPartitionedTopicMetadata((TopicName)topicName, (boolean)true, (boolean)false).partitions, (int)5);
        HashSet actions = Sets.newHashSet((Object[])new AuthAction[]{AuthAction.produce});
        String role = "test-role";
        this.persistentTopics.grantPermissionsOnTopic("prop-xyz", "use", "ns", "ds1", "test-role", (Set)actions);
        Map permission = this.persistentTopics.getPermissionsOnTopic("prop-xyz", "use", "ns", "ds1");
        Assert.assertEquals((Set)((Set)permission.get("test-role")), (Set)actions);
        this.persistentTopics.revokePermissionsOnTopic("prop-xyz", "use", "ns", "ds1", "test-role");
        Awaitility.await().untilAsserted(() -> {
            Map p = this.persistentTopics.getPermissionsOnTopic("prop-xyz", "use", "ns", "ds1");
            Assert.assertTrue((boolean)p.isEmpty());
        });
    }

    @Test
    public void testRestExceptionMessage() {
        String message = "my-message";
        RestException exception = new RestException(Response.Status.PRECONDITION_FAILED, message);
        Assert.assertEquals((String)exception.getMessage(), (String)message);
    }

    @Test
    public void testUpdatePartitionedTopicCoontainedInOldTopic() throws Exception {
        String property = "prop-xyz";
        String cluster = "use";
        String namespace = "ns";
        String partitionedTopicName = "old-special-topic";
        String partitionedTopicName2 = "special-topic";
        this.pulsar.getPulsarResources().getNamespaceResources().createPolicies(NamespaceName.get((String)"prop-xyz", (String)"use", (String)"ns"), new Policies());
        AsyncResponse response1 = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(Response.class);
        this.persistentTopics.createPartitionedTopic(response1, "prop-xyz", "use", "ns", "old-special-topic", 5, false);
        ((AsyncResponse)Mockito.verify((Object)response1, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        AsyncResponse response2 = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        responseCaptor = ArgumentCaptor.forClass(Response.class);
        this.persistentTopics.createPartitionedTopic(response2, "prop-xyz", "use", "ns", "special-topic", 2, false);
        ((AsyncResponse)Mockito.verify((Object)response2, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        this.persistentTopics.updatePartitionedTopic("prop-xyz", "use", "ns", "special-topic", false, false, false, 10);
    }

    @Test
    public void test500Error() throws Exception {
        String property = "prop-xyz";
        String cluster = "use";
        String namespace = "ns";
        String partitionedTopicName = "error-500-topic";
        AsyncResponse response1 = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(RestException.class);
        NamespaceName namespaceName = NamespaceName.get((String)"prop-xyz", (String)"use", (String)"ns");
        NamespaceService ns = this.pulsar.getNamespaceService();
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(new RuntimeException("500 error contains error message"));
        ((NamespaceService)Mockito.doReturn(future).when((Object)ns)).getListOfTopics(namespaceName, CommandGetTopicsOfNamespace.Mode.ALL);
        this.persistentTopics.createPartitionedTopic(response1, "prop-xyz", "use", "ns", "error-500-topic", 5, false);
        ((AsyncResponse)Mockito.verify((Object)response1, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)responseCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)responseCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        Assert.assertTrue((boolean)((ErrorData)((RestException)((Object)responseCaptor.getValue())).getResponse().getEntity()).reason.contains("500 error contains error message"));
    }

    static class TestAsyncResponse
    implements AsyncResponse {
        Object response;
        Throwable e;
        CountDownLatch latch = new CountDownLatch(1);

        TestAsyncResponse() {
        }

        public boolean resume(Object response) {
            this.response = response;
            this.latch.countDown();
            return true;
        }

        public boolean resume(Throwable response) {
            this.e = response;
            this.latch.countDown();
            return true;
        }

        public boolean cancel() {
            return false;
        }

        public boolean cancel(int retryAfter) {
            return false;
        }

        public boolean cancel(Date retryAfter) {
            return false;
        }

        public boolean isSuspended() {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return false;
        }

        public boolean setTimeout(long time, TimeUnit unit) {
            return false;
        }

        public void setTimeoutHandler(TimeoutHandler handler) {
        }

        public Collection<Class<?>> register(Class<?> callback) {
            return null;
        }

        public Map<Class<?>, Collection<Class<?>>> register(Class<?> callback, Class<?> ... callbacks) {
            return null;
        }

        public Collection<Class<?>> register(Object callback) {
            return null;
        }

        public Map<Class<?>, Collection<Class<?>>> register(Object callback, Object ... callbacks) {
            return null;
        }
    }
}

