/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.mledger.LedgerOffloader;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.broker.admin.MockServletContext;
import org.apache.pulsar.broker.admin.v1.Namespaces;
import org.apache.pulsar.broker.admin.v1.PersistentTopics;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.namespace.LookupOptions;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.namespace.OwnershipCache;
import org.apache.pulsar.broker.web.PulsarWebResource;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.OffloadedReadPriority;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.metadata.cache.impl.MetadataCacheImpl;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.awaitility.Awaitility;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class NamespacesTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(NamespacesTest.class);
    private Namespaces namespaces;
    private List<NamespaceName> testLocalNamespaces;
    private List<NamespaceName> testGlobalNamespaces;
    private final String testTenant = "my-tenant";
    private final String testOtherTenant = "other-tenant";
    private final String testLocalCluster = "use";
    private final String testOtherCluster = "usc";
    public static final long THREE_MINUTE_MILLIS = 180000L;
    protected NamespaceService nsSvc;
    protected Field uriField;
    protected UriInfo uriInfo;

    @BeforeClass
    public void initNamespace() throws Exception {
        this.testLocalNamespaces = Lists.newArrayList();
        this.testGlobalNamespaces = Lists.newArrayList();
        this.testLocalNamespaces.add(NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)"test-namespace-1"));
        this.testLocalNamespaces.add(NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)"test-namespace-2"));
        this.testLocalNamespaces.add(NamespaceName.get((String)this.testTenant, (String)this.testOtherCluster, (String)"test-other-namespace-1"));
        this.testLocalNamespaces.add(NamespaceName.get((String)this.testOtherTenant, (String)this.testLocalCluster, (String)"test-namespace-1"));
        this.testGlobalNamespaces.add(NamespaceName.get((String)this.testTenant, (String)"global", (String)"test-global-ns1"));
        this.uriField = PulsarWebResource.class.getDeclaredField("uri");
        this.uriField.setAccessible(true);
        this.uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
    }

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.resetConfig();
        this.conf.setClusterName("use");
        super.internalSetup();
        this.namespaces = (Namespaces)Mockito.spy(Namespaces.class);
        this.namespaces.setServletContext((ServletContext)new MockServletContext());
        this.namespaces.setPulsar(this.pulsar);
        ((Namespaces)Mockito.doReturn((Object)false).when((Object)this.namespaces)).isRequestHttps();
        ((Namespaces)Mockito.doReturn((Object)"test").when((Object)this.namespaces)).clientAppId();
        ((Namespaces)Mockito.doReturn(null).when((Object)this.namespaces)).originalPrincipal();
        ((Namespaces)Mockito.doReturn(null).when((Object)this.namespaces)).clientAuthData();
        ((Namespaces)Mockito.doReturn((Object)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"use", "usw", "usc", "global"}))).when((Object)this.namespaces)).clusters();
        this.admin.clusters().createCluster("use", ClusterData.builder().serviceUrl("http://broker-use.com:8080").build());
        this.admin.clusters().createCluster("usw", ClusterData.builder().serviceUrl("http://broker-usw.com:8080").build());
        this.admin.clusters().createCluster("usc", ClusterData.builder().serviceUrl("http://broker-usc.com:8080").build());
        this.admin.tenants().createTenant(this.testTenant, (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use", "usc", "usw"})));
        this.admin.tenants().createTenant(this.testOtherTenant, (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role3", "role4"}), (Set)Sets.newHashSet((Object[])new String[]{"use", "usc", "usw"})));
        this.createTestNamespaces(this.testLocalNamespaces, BundlesData.builder().build());
        this.createGlobalTestNamespaces(this.testTenant, this.testGlobalNamespaces.get(0).getLocalName(), BundlesData.builder().build());
        ((Namespaces)Mockito.doThrow((Throwable[])new Throwable[]{new RestException(Response.Status.UNAUTHORIZED, "unauthorized")}).when((Object)this.namespaces)).validateTenantOperation(this.testOtherTenant, null);
        ((Namespaces)Mockito.doThrow((Throwable[])new Throwable[]{new RestException(Response.Status.UNAUTHORIZED, "unauthorized")}).when((Object)this.namespaces)).validateNamespacePolicyOperation(NamespaceName.get((String)"other-tenant/use/test-namespace-1"), PolicyName.PERSISTENCE, PolicyOperation.WRITE);
        ((Namespaces)Mockito.doThrow((Throwable[])new Throwable[]{new RestException(Response.Status.UNAUTHORIZED, "unauthorized")}).when((Object)this.namespaces)).validateNamespacePolicyOperation(NamespaceName.get((String)"other-tenant/use/test-namespace-1"), PolicyName.RETENTION, PolicyOperation.WRITE);
        this.nsSvc = this.pulsar.getNamespaceService();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
        this.conf.setClusterName("use");
    }

    @Test
    public void testCreateNamespaces() throws Exception {
        try {
            this.namespaces.createNamespace(this.testTenant, "other-colo", "my-namespace", BundlesData.builder().build());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        ArrayList nsnames = Lists.newArrayList();
        nsnames.add(NamespaceName.get((String)this.testTenant, (String)"use", (String)"create-namespace-1"));
        nsnames.add(NamespaceName.get((String)this.testTenant, (String)"use", (String)"create-namespace-2"));
        nsnames.add(NamespaceName.get((String)this.testTenant, (String)"usc", (String)"create-other-namespace-1"));
        this.createTestNamespaces(nsnames, BundlesData.builder().build());
        try {
            this.namespaces.createNamespace(this.testTenant, "use", "create-namespace-1", BundlesData.builder().build());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        try {
            this.namespaces.createNamespace("non-existing-tenant", "use", "create-namespace-1", BundlesData.builder().build());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        try {
            this.namespaces.createNamespace(this.testTenant, "use", "create-namespace-#", BundlesData.builder().build());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.CREATE && path.equals("/admin/policies/my-tenant/use/my-namespace-3"));
        try {
            this.namespaces.createNamespace(this.testTenant, "use", "my-namespace-3", BundlesData.builder().build());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    @Test
    public void testGetNamespaces() throws Exception {
        ArrayList expectedList = Lists.newArrayList((Object[])new String[]{this.testLocalNamespaces.get(0).toString(), this.testLocalNamespaces.get(1).toString()});
        expectedList.sort(null);
        Assert.assertEquals((Collection)this.namespaces.getNamespacesForCluster(this.testTenant, this.testLocalCluster), (Collection)expectedList);
        expectedList = Lists.newArrayList((Object[])new String[]{this.testLocalNamespaces.get(0).toString(), this.testLocalNamespaces.get(1).toString(), this.testLocalNamespaces.get(2).toString(), this.testGlobalNamespaces.get(0).toString()});
        expectedList.sort(null);
        Assert.assertEquals((Collection)this.namespaces.getTenantNamespaces(this.testTenant), (Collection)expectedList);
        try {
            this.namespaces.getTenantNamespaces(this.testTenant + "/default");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            this.namespaces.getTenantNamespaces("non-existing-tenant");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            // empty catch block
        }
        try {
            this.namespaces.getNamespacesForCluster(this.testTenant, "other-cluster");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            // empty catch block
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET_CHILDREN && path.equals("/admin/policies/my-tenant"));
        MetadataCacheImpl tenantCache = (MetadataCacheImpl)this.pulsar.getPulsarResources().getTenantResources().getCache();
        AbstractMetadataStore store = (AbstractMetadataStore)tenantCache.getStore();
        tenantCache.invalidateAll();
        store.invalidateAll();
        try {
            this.namespaces.getTenantNamespaces(this.testTenant);
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET_CHILDREN && path.equals("/admin/policies/my-tenant/use"));
        try {
            this.namespaces.getNamespacesForCluster(this.testTenant, this.testLocalCluster);
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    @Test(enabled=false)
    public void testGrantAndRevokePermissions() throws Exception {
        Policies expectedPolicies = new Policies();
        Assert.assertEquals((Object)this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies);
        Assert.assertEquals((Map)this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Map)expectedPolicies.auth_policies.getNamespaceAuthentication());
        this.namespaces.grantPermissionOnNamespace(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName(), "my-role", EnumSet.of(AuthAction.produce));
        expectedPolicies.auth_policies.getNamespaceAuthentication().put("my-role", EnumSet.of(AuthAction.produce));
        Assert.assertEquals((Object)this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies);
        Assert.assertEquals((Map)this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Map)expectedPolicies.auth_policies.getNamespaceAuthentication());
        this.namespaces.grantPermissionOnNamespace(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName(), "other-role", EnumSet.of(AuthAction.consume));
        expectedPolicies.auth_policies.getNamespaceAuthentication().put("other-role", EnumSet.of(AuthAction.consume));
        Assert.assertEquals((Object)this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies);
        Assert.assertEquals((Map)this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Map)expectedPolicies.auth_policies.getNamespaceAuthentication());
        this.namespaces.revokePermissionsOnNamespace(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName(), "my-role");
        expectedPolicies.auth_policies.getNamespaceAuthentication().remove("my-role");
        Assert.assertEquals((Object)this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Object)expectedPolicies);
        Assert.assertEquals((Map)this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName()), (Map)expectedPolicies.auth_policies.getNamespaceAuthentication());
        try {
            this.namespaces.getPolicies(this.testTenant, this.testLocalCluster, "non-existing-namespace-1");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.namespaces.getPermissions(this.testTenant, this.testLocalCluster, "non-existing-namespace-1");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.namespaces.grantPermissionOnNamespace(this.testTenant, this.testLocalCluster, "non-existing-namespace-1", "my-role", EnumSet.of(AuthAction.produce));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.namespaces.revokePermissionsOnNamespace(this.testTenant, this.testLocalCluster, "non-existing-namespace-1", "my-role");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        NamespaceName testNs = this.testLocalNamespaces.get(1);
        this.mockZooKeeper.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> {
            log.info("Condition1: {} {}", op, path);
            return true;
        });
        try {
            this.namespaces.getPolicies(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.mockZooKeeper.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> {
            log.info("Condition2: {} {}", op, path);
            return true;
        });
        try {
            this.namespaces.getPermissions(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName());
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.mockZooKeeper.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> {
            log.info("Condition3: {} {}", op, path);
            return true;
        });
        try {
            this.namespaces.grantPermissionOnNamespace(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), "other-role", EnumSet.of(AuthAction.consume));
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
        this.mockZooKeeper.failConditional(KeeperException.Code.BADVERSION, (op, path) -> {
            log.info("Condition4: {} {}", op, path);
            return true;
        });
        try {
            this.namespaces.grantPermissionOnNamespace(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), "other-role", EnumSet.of(AuthAction.consume));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        this.mockZooKeeper.failConditional(KeeperException.Code.BADVERSION, (op, path) -> {
            log.info("Condition5: {} {}", op, path);
            return true;
        });
        try {
            this.namespaces.revokePermissionsOnNamespace(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), "other-role");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        }
        this.mockZooKeeper.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> {
            log.info("Condition6: {} {}", op, path);
            return true;
        });
        try {
            this.namespaces.revokePermissionsOnNamespace(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), "other-role");
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    @Test
    public void testGlobalNamespaceReplicationConfiguration() throws Exception {
        Assert.assertEquals((Set)this.namespaces.getNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName()), (Set)Sets.newHashSet());
        this.namespaces.setNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "usw"}));
        Assert.assertEquals((Collection)this.namespaces.getNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName()), (Collection)Lists.newArrayList((Object[])new String[]{"use", "usw"}));
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "invalid-cluster"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.FORBIDDEN.getStatusCode());
        }
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).getTenant(), this.testGlobalNamespaces.get(0).getCluster(), this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "global"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "invalid-cluster"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.FORBIDDEN.getStatusCode());
        }
        this.admin.tenants().updateTenant("my-tenant", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use", "usc"})));
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use", "usw"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.FORBIDDEN.getStatusCode());
        }
        this.mockZooKeeperGlobal.setAlwaysFail(KeeperException.Code.SESSIONEXPIRED);
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        finally {
            this.mockZooKeeperGlobal.unsetAlwaysFail();
        }
        MetadataCacheImpl policiesCache = (MetadataCacheImpl)this.pulsar.getPulsarResources().getNamespaceResources().getCache();
        AbstractMetadataStore store = (AbstractMetadataStore)policiesCache.getStore();
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.SET && path.equals("/admin/policies/my-tenant/global/test-global-ns1"));
        policiesCache.invalidateAll();
        store.invalidateAll();
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)500);
        }
        try {
            this.namespaces.getNamespaceReplicationClusters(this.testTenant, "global", "non-existing-ns");
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, "global", "non-existing-ns", (List)Lists.newArrayList((Object[])new String[]{"use"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        }
        this.mockZooKeeperGlobal.failConditional(KeeperException.Code.SESSIONEXPIRED, (op, path) -> op == MockZooKeeper.Op.GET && path.equals("/admin/policies/my-tenant/global/test-global-ns1"));
        policiesCache.invalidateAll();
        store.invalidateAll();
        try {
            this.namespaces.getNamespaceReplicationClusters(this.testTenant, "global", this.testGlobalNamespaces.get(0).getLocalName());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)500);
        }
        try {
            this.namespaces.getNamespaceReplicationClusters(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName());
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        try {
            this.namespaces.setNamespaceReplicationClusters(this.testTenant, this.testLocalCluster, this.testLocalNamespaces.get(0).getLocalName(), (List)Lists.newArrayList((Object[])new String[]{"use"}));
            Assert.fail((String)"should have failed");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    public void testGetBundles() throws Exception {
        ArrayList boundaries = Lists.newArrayList((Object[])new String[]{"0x00000000", "0x80000000", "0xffffffff"});
        BundlesData bundle = BundlesData.builder().boundaries((List)boundaries).numBundles(boundaries.size() - 1).build();
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, "test-bundled-namespace-1", bundle);
        BundlesData responseData = this.namespaces.getBundlesData("my-tenant", this.testLocalCluster, "test-bundled-namespace-1");
        Assert.assertEquals((Object)responseData, (Object)bundle);
    }

    @Test
    public void testNamespacesApiRedirects() throws Exception {
        this.uriField.set(this.namespaces, this.uriInfo);
        ((Namespaces)Mockito.doReturn((Object)false).when((Object)this.namespaces)).isLeaderBroker();
        URI uri = URI.create(this.pulsar.getWebServiceAddress() + "/admin/namespace/" + this.testLocalNamespaces.get(2).toString());
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)this.uriInfo)).getRequestUri();
        this.conf.setAuthorizationEnabled(true);
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, this.testTenant, this.testOtherCluster, this.testLocalNamespaces.get(2).getLocalName(), false, false);
        ArgumentCaptor captor = ArgumentCaptor.forClass(WebApplicationException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)captor.capture());
        Assert.assertEquals((int)((WebApplicationException)((Object)captor.getValue())).getResponse().getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode());
        Assert.assertEquals((String)((WebApplicationException)((Object)captor.getValue())).getResponse().getLocation().toString(), (String)UriBuilder.fromUri((URI)uri).host("broker-usc.com").port(8080).toString());
        uri = URI.create(this.pulsar.getWebServiceAddress() + "/admin/namespace/" + this.testLocalNamespaces.get(2).toString() + "/unload");
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)this.uriInfo)).getRequestUri();
        try {
            this.namespaces.unloadNamespaceBundle(response, this.testTenant, this.testOtherCluster, this.testLocalNamespaces.get(2).getLocalName(), "0x00000000_0xffffffff", false);
            Assert.fail((String)"Should have raised exception to redirect request");
        }
        catch (WebApplicationException wae) {
            Assert.assertEquals((int)wae.getResponse().getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode());
            Assert.assertEquals((String)wae.getResponse().getLocation().toString(), (String)UriBuilder.fromUri((URI)uri).host("broker-usc.com").port(8080).toString());
        }
        uri = URI.create(this.pulsar.getWebServiceAddress() + "/admin/namespace/" + this.testGlobalNamespaces.get(0).toString() + "/configversion");
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)this.uriInfo)).getRequestUri();
        ((NamespaceService)Mockito.doReturn(Optional.of(new URL("http://otherhost:8080"))).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<NamespaceName>(){

            public boolean matches(NamespaceName nsname) {
                return nsname.equals(NamespacesTest.this.testGlobalNamespaces.get(0));
            }
        }), (LookupOptions)Mockito.any());
        this.admin.namespaces().setNamespaceReplicationClusters(this.testGlobalNamespaces.get(0).toString(), (Set)Sets.newHashSet((Object[])new String[]{"usw"}));
        uri = URI.create(this.pulsar.getWebServiceAddress() + "/admin/namespace/" + this.testLocalNamespaces.get(2).toString() + "?authoritative=false");
        ((UriInfo)Mockito.doReturn((Object)uri).when((Object)this.uriInfo)).getRequestUri();
        ((Namespaces)Mockito.doReturn((Object)true).when((Object)this.namespaces)).isLeaderBroker();
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, this.testLocalNamespaces.get(2).getTenant(), this.testLocalNamespaces.get(2).getCluster(), this.testLocalNamespaces.get(2).getLocalName(), false, false);
        captor = ArgumentCaptor.forClass(WebApplicationException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)captor.capture());
        Assert.assertEquals((int)((WebApplicationException)((Object)captor.getValue())).getResponse().getStatus(), (int)Response.Status.TEMPORARY_REDIRECT.getStatusCode());
        Assert.assertEquals((String)((WebApplicationException)((Object)captor.getValue())).getResponse().getLocation().toString(), (String)UriBuilder.fromUri((URI)uri).host("broker-usc.com").port(8080).toString());
    }

    @Test
    public void testDeleteNamespaces() throws Exception {
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, this.testTenant, this.testLocalCluster, "non-existing-namespace-1", false, false);
        ArgumentCaptor errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)errorCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.NOT_FOUND.getStatusCode());
        NamespaceName testNs = this.testLocalNamespaces.get(1);
        TopicName topicName = TopicName.get((String)testNs.getPersistentTopicName("my-topic"));
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.mockZooKeeper, (String)("/managed-ledgers/" + topicName.getPersistenceNamingEncoding()), (byte[])new byte[0], null, null);
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        LookupOptions options = LookupOptions.builder().authoritative(false).readOnly(false).requestHttps(false).build();
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)testNs, options);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testNs);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false, false);
        errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)errorCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        this.mockZooKeeper.delete("/managed-ledgers/" + topicName.getPersistenceNamingEncoding(), -1);
        ZkUtils.createFullPathOptimistic((ZooKeeper)this.mockZooKeeperGlobal, (String)("/admin/partitioned-topics/" + topicName.getPersistenceNamingEncoding()), (byte[])new byte[0], null, null);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false, false);
        errorCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)errorCaptor.capture());
        Assert.assertEquals((int)((RestException)((Object)errorCaptor.getValue())).getResponse().getStatus(), (int)Response.Status.CONFLICT.getStatusCode());
        this.mockZooKeeperGlobal.delete("/admin/partitioned-topics/" + topicName.getPersistenceNamingEncoding(), -1);
        testNs = this.testGlobalNamespaces.get(0);
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)testNs, options);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testNs);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false, false);
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        testNs = this.testLocalNamespaces.get(0);
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)testNs, options);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testNs);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false, false);
        responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
        ArrayList nsList = Lists.newArrayList((Object[])new String[]{this.testLocalNamespaces.get(1).toString(), this.testLocalNamespaces.get(2).toString()});
        nsList.sort(null);
        Assert.assertEquals((Collection)this.namespaces.getTenantNamespaces(this.testTenant), (Collection)nsList);
        testNs = this.testLocalNamespaces.get(1);
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)testNs, options);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testNs);
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), false, false);
        responseCaptor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(responseCaptor.capture());
        Assert.assertEquals((int)((Response)responseCaptor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
    }

    @Test
    public void testDeleteNamespaceWithBundles() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-delete-namespace-with-bundles";
        ArrayList boundaries = Lists.newArrayList((Object[])new String[]{"0x00000000", "0x80000000", "0xffffffff"});
        BundlesData bundleData = BundlesData.builder().boundaries((List)boundaries).numBundles(boundaries.size() - 1).build();
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        final NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        org.apache.pulsar.client.admin.Namespaces namespacesAdmin = (org.apache.pulsar.client.admin.Namespaces)Mockito.mock(org.apache.pulsar.client.admin.Namespaces.class);
        ((PulsarAdmin)Mockito.doReturn((Object)namespacesAdmin).when((Object)this.admin)).namespaces();
        ((NamespaceService)Mockito.doReturn(null).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<NamespaceBundle>(){

            public boolean matches(NamespaceBundle bundle) {
                return bundle.getNamespaceObject().equals((Object)testNs);
            }
        }), (LookupOptions)Mockito.any());
        ((NamespaceService)Mockito.doReturn((Object)false).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<NamespaceBundle>(){

            public boolean matches(NamespaceBundle bundle) {
                return bundle.getNamespaceObject().equals((Object)testNs);
            }
        }));
        ((NamespaceService)Mockito.doReturn(CompletableFuture.completedFuture(Optional.of(Mockito.mock(NamespaceEphemeralData.class)))).when((Object)this.nsSvc)).getOwnerAsync((NamespaceBundle)Mockito.argThat((ArgumentMatcher)new ArgumentMatcher<NamespaceBundle>(){

            public boolean matches(NamespaceBundle bundle) {
                return bundle.getNamespaceObject().equals((Object)testNs);
            }
        }));
        CompletableFuture preconditionFailed = new CompletableFuture();
        ClientErrorException cee = new ClientErrorException(Response.Status.PRECONDITION_FAILED);
        int statusCode = cee.getResponse().getStatus();
        String httpError = BaseResource.getReasonFromServer((WebApplicationException)cee);
        preconditionFailed.completeExceptionally(new PulsarAdminException.PreconditionFailedException((Throwable)cee, httpError, statusCode));
        ((org.apache.pulsar.client.admin.Namespaces)Mockito.doReturn(preconditionFailed).when((Object)namespacesAdmin)).deleteNamespaceBundleAsync(Mockito.anyString(), Mockito.anyString());
        try {
            this.namespaces.deleteNamespaceBundle("my-tenant", "use", bundledNsLocal, "0x00000000_0x80000000", false, false);
            Assert.fail((String)"Should have failed");
        }
        catch (RestException re) {
            Assert.assertEquals((int)re.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        NamespaceBundles nsBundles = this.nsSvc.getNamespaceBundleFactory().getBundles(testNs, bundleData);
        ((NamespaceService)Mockito.doReturn(Optional.empty()).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)ArgumentMatchers.any(NamespaceBundle.class), (LookupOptions)ArgumentMatchers.any(LookupOptions.class));
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.deleteNamespace(response, "my-tenant", "use", bundledNsLocal, false, false);
        ArgumentCaptor captor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)captor.capture());
        Assert.assertEquals((int)((RestException)((Object)captor.getValue())).getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        LookupOptions optionsHttps = LookupOptions.builder().authoritative(false).requestHttps(true).readOnly(false).build();
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)nsBundles.getBundles().get(0), optionsHttps);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)nsBundles.getBundles().get(0));
        ((org.apache.pulsar.client.admin.Namespaces)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)namespacesAdmin)).deleteNamespaceBundleAsync("my-tenant/use/" + bundledNsLocal, "0x00000000_0x80000000");
        try {
            this.namespaces.deleteNamespaceBundle("my-tenant", "use", bundledNsLocal, "0x80000000_0xffffffff", false, false);
            Assert.fail((String)"Should have failed");
        }
        catch (RestException re) {
            Assert.assertEquals((int)re.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
        response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)ArgumentMatchers.any(NamespaceBundle.class), (LookupOptions)ArgumentMatchers.any(LookupOptions.class));
        for (NamespaceBundle bundle : nsBundles.getBundles()) {
            ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)bundle);
        }
        this.namespaces.deleteNamespace(response, "my-tenant", "use", bundledNsLocal, false, false);
        ArgumentCaptor captor2 = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(captor2.capture());
        Assert.assertEquals((int)((Response)captor2.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
    }

    @Test
    public void testUnloadNamespaces() throws Exception {
        NamespaceName testNs = this.testLocalNamespaces.get(1);
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)Mockito.argThat(ns -> ns.equals(testNs)), (LookupOptions)Mockito.any());
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)Mockito.argThat(ns -> ns.equals(testNs)));
        NamespaceBundle bundle = this.nsSvc.getNamespaceBundleFactory().getFullBundle(testNs);
        ((Namespaces)Mockito.doNothing().when((Object)this.namespaces)).validateBundleOwnership(bundle, false, true);
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.unloadNamespace(response, testNs.getTenant(), testNs.getCluster(), testNs.getLocalName());
        ArgumentCaptor captor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(captor.capture());
        Assert.assertEquals((int)((Response)captor.getValue()).getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode());
    }

    @Test
    public void testSplitBundles() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-bundled-namespace-1";
        ArrayList boundaries = Lists.newArrayList((Object[])new String[]{"0x00000000", "0xffffffff"});
        BundlesData bundleData = BundlesData.builder().boundaries((List)boundaries).numBundles(boundaries.size() - 1).build();
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        this.mockWebUrl(localWebServiceUrl, testNs);
        try {
            AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
            this.namespaces.splitNamespaceBundle(response, "my-tenant", "use", bundledNsLocal, "0x00000000_0xffffffff", false, true);
            ArgumentCaptor captor = ArgumentCaptor.forClass(Response.class);
            ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume(captor.capture());
            BundlesData bundlesData = this.namespaces.getBundlesData("my-tenant", "use", bundledNsLocal);
            Assert.assertNotNull((Object)bundlesData);
            Assert.assertEquals((int)bundlesData.getBoundaries().size(), (int)3);
            Assert.assertEquals((String)((String)bundlesData.getBoundaries().get(0)), (String)"0x00000000");
            Assert.assertEquals((String)((String)bundlesData.getBoundaries().get(1)), (String)"0x7fffffff");
            Assert.assertEquals((String)((String)bundlesData.getBoundaries().get(2)), (String)"0xffffffff");
        }
        catch (RestException re) {
            Assert.assertEquals((int)re.getResponse().getStatus(), (int)Response.Status.PRECONDITION_FAILED.getStatusCode());
        }
    }

    @Test
    public void testSplitBundleWithUnDividedRange() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-bundled-namespace-1";
        ArrayList boundaries = Lists.newArrayList((Object[])new String[]{"0x00000000", "0x08375b1a", "0x08375b1b", "0xffffffff"});
        BundlesData bundleData = BundlesData.builder().boundaries((List)boundaries).numBundles(boundaries.size() - 1).build();
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        this.mockWebUrl(localWebServiceUrl, testNs);
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.splitNamespaceBundle(response, "my-tenant", "use", bundledNsLocal, "0x08375b1a_0x08375b1b", false, false);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Response.class);
        ((AsyncResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.timeout((long)5000L).times(1))).resume((Throwable)ArgumentMatchers.any(RestException.class));
    }

    @Test
    public void testUnloadNamespaceWithBundles() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-bundled-namespace-1";
        ArrayList boundaries = Lists.newArrayList((Object[])new String[]{"0x00000000", "0x80000000", "0xffffffff"});
        BundlesData bundleData = BundlesData.builder().boundaries((List)boundaries).numBundles(boundaries.size() - 1).build();
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        ((NamespaceService)Mockito.doReturn(CompletableFuture.completedFuture(Optional.of(localWebServiceUrl))).when((Object)this.nsSvc)).getWebServiceUrlAsync((ServiceUnitId)Mockito.argThat(bundle -> bundle.getNamespaceObject().equals((Object)testNs)), (LookupOptions)Mockito.any());
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)Mockito.argThat(bundle -> bundle.getNamespaceObject().equals((Object)testNs)));
        NamespaceBundles nsBundles = this.nsSvc.getNamespaceBundleFactory().getBundles(testNs, bundleData);
        NamespaceBundle testBundle = (NamespaceBundle)nsBundles.getBundles().get(0);
        LookupOptions optionsHttps = LookupOptions.builder().authoritative(false).requestHttps(true).readOnly(false).build();
        ((NamespaceService)Mockito.doReturn(CompletableFuture.completedFuture(Optional.of(localWebServiceUrl))).when((Object)this.nsSvc)).getWebServiceUrlAsync((ServiceUnitId)testBundle, optionsHttps);
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)testBundle);
        ((NamespaceService)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)this.nsSvc)).unloadNamespaceBundle(testBundle);
        AsyncResponse response = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.namespaces.unloadNamespaceBundle(response, "my-tenant", "use", bundledNsLocal, "0x00000000_0x80000000", false);
        ((NamespaceService)Mockito.verify((Object)this.nsSvc, (VerificationMode)Mockito.times((int)1))).unloadNamespaceBundle(testBundle);
        try {
            this.namespaces.unloadNamespaceBundle(response, "my-tenant", "use", bundledNsLocal, "0x00000000_0x88000000", false);
            Assert.fail((String)"should have failed");
        }
        catch (RestException restException) {
            // empty catch block
        }
    }

    private void createBundledTestNamespaces(String property, String cluster, String namespace, BundlesData bundle) throws Exception {
        this.namespaces.createNamespace(property, cluster, namespace, bundle);
    }

    private void createGlobalTestNamespaces(String property, String namespace, BundlesData bundle) throws Exception {
        this.namespaces.createNamespace(property, "global", namespace, bundle);
    }

    private void createTestNamespaces(List<NamespaceName> nsnames, BundlesData bundle) throws Exception {
        for (NamespaceName nsName : nsnames) {
            this.namespaces.createNamespace(nsName.getTenant(), nsName.getCluster(), nsName.getLocalName(), bundle);
        }
    }

    @Test
    public void testValidateAdminAccessOnTenant() throws Exception {
        try {
            String tenant = "prop";
            this.pulsar.getConfiguration().setAuthenticationEnabled(true);
            this.pulsar.getConfiguration().setAuthorizationEnabled(true);
            this.pulsar.getPulsarResources().getTenantResources().createTenant("prop", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{this.namespaces.clientAppId()}), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
            this.namespaces.validateTenantOperation("prop", null);
        }
        finally {
            this.pulsar.getConfiguration().setAuthenticationEnabled(false);
            this.pulsar.getConfiguration().setAuthorizationEnabled(false);
        }
    }

    @Test
    public void testRetention() throws Exception {
        try {
            URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
            String bundledNsLocal = "test-bundled-namespace-1";
            ArrayList boundaries = Lists.newArrayList((Object[])new String[]{"0x00000000", "0xffffffff"});
            BundlesData bundleData = BundlesData.builder().boundaries((List)boundaries).numBundles(boundaries.size() - 1).build();
            this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
            NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
            this.mockWebUrl(localWebServiceUrl, testNs);
            OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
            ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
            Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
            ownership.setAccessible(true);
            ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
            RetentionPolicies retention = new RetentionPolicies(10, 10);
            this.namespaces.setRetention(this.testTenant, this.testLocalCluster, bundledNsLocal, retention);
            RetentionPolicies retention2 = this.namespaces.getRetention(this.testTenant, this.testLocalCluster, bundledNsLocal);
            Assert.assertEquals((Object)retention, (Object)retention2);
        }
        catch (RestException e) {
            Assert.fail((String)"ValidateNamespaceOwnershipWithBundles failed");
        }
    }

    @Test
    public void testRetentionUnauthorized() throws Exception {
        try {
            NamespaceName testNs = this.testLocalNamespaces.get(3);
            RetentionPolicies retention = new RetentionPolicies(10, 10);
            this.namespaces.setRetention(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), retention);
            Assert.fail((String)"Should fail");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode());
        }
    }

    @Test
    public void testPersistence() throws Exception {
        NamespaceName testNs = this.testLocalNamespaces.get(0);
        PersistencePolicies persistence1 = new PersistencePolicies(3, 2, 1, 0.0);
        this.namespaces.setPersistence(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), persistence1);
        PersistencePolicies persistence2 = this.namespaces.getPersistence(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName());
        Assert.assertEquals((Object)persistence2, (Object)persistence1);
    }

    @Test
    public void testPersistenceUnauthorized() throws Exception {
        try {
            NamespaceName testNs = this.testLocalNamespaces.get(3);
            PersistencePolicies persistence = new PersistencePolicies(3, 2, 1, 0.0);
            this.namespaces.setPersistence(testNs.getTenant(), testNs.getCluster(), testNs.getLocalName(), persistence);
            Assert.fail((String)"Should fail");
        }
        catch (RestException e) {
            Assert.assertEquals((int)e.getResponse().getStatus(), (int)Response.Status.UNAUTHORIZED.getStatusCode());
        }
    }

    @Test
    public void testValidateTopicOwnership() throws Exception {
        URL localWebServiceUrl = new URL(this.pulsar.getSafeWebServiceAddress());
        String bundledNsLocal = "test-bundled-namespace-1";
        ArrayList boundaries = Lists.newArrayList((Object[])new String[]{"0x00000000", "0xffffffff"});
        BundlesData bundleData = BundlesData.builder().boundaries((List)boundaries).numBundles(boundaries.size() - 1).build();
        this.createBundledTestNamespaces(this.testTenant, this.testLocalCluster, bundledNsLocal, bundleData);
        NamespaceName testNs = NamespaceName.get((String)this.testTenant, (String)this.testLocalCluster, (String)bundledNsLocal);
        OwnershipCache MockOwnershipCache = (OwnershipCache)Mockito.spy((Object)this.pulsar.getNamespaceService().getOwnershipCache());
        ((OwnershipCache)Mockito.doReturn(CompletableFuture.completedFuture(null)).when((Object)MockOwnershipCache)).disableOwnership((NamespaceBundle)ArgumentMatchers.any(NamespaceBundle.class));
        Field ownership = NamespaceService.class.getDeclaredField("ownershipCache");
        ownership.setAccessible(true);
        ownership.set(this.pulsar.getNamespaceService(), MockOwnershipCache);
        TopicName topicName = TopicName.get((String)testNs.getPersistentTopicName("my-topic"));
        PersistentTopics topics = (PersistentTopics)Mockito.spy(PersistentTopics.class);
        topics.setServletContext((ServletContext)new MockServletContext());
        topics.setPulsar(this.pulsar);
        ((PersistentTopics)Mockito.doReturn((Object)false).when((Object)topics)).isRequestHttps();
        ((PersistentTopics)Mockito.doReturn((Object)"test").when((Object)topics)).clientAppId();
        ((PersistentTopics)Mockito.doReturn(null).when((Object)topics)).originalPrincipal();
        ((PersistentTopics)Mockito.doReturn(null).when((Object)topics)).clientAuthData();
        this.mockWebUrl(localWebServiceUrl, testNs);
        ((PersistentTopics)Mockito.doReturn((Object)"persistent").when((Object)topics)).domain();
        topics.validateTopicName(topicName.getTenant(), topicName.getCluster(), topicName.getNamespacePortion(), topicName.getEncodedLocalName());
        topics.validateAdminOperationOnTopic(false);
    }

    @Test
    public void testIsLeader() throws Exception {
        Assert.assertTrue((boolean)this.namespaces.isLeaderBroker());
    }

    @Test
    public void testDeleteNamespace() throws Exception {
        String namespace = this.testTenant + "/use/deleteNs";
        this.admin.namespaces().createNamespace(namespace, 100);
        Assert.assertEquals((int)this.admin.namespaces().getPolicies((String)namespace).bundles.getNumBundles(), (int)100);
        String topicName = "persistent://" + namespace + "/my-topic";
        TopicName topic = TopicName.get((String)topicName);
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        producer.close();
        NamespaceBundle bundle1 = this.pulsar.getNamespaceService().getBundle(topic);
        this.admin.topics().delete(topicName);
        this.admin.namespaces().deleteNamespace(namespace);
        NamespaceBundle bundle2 = this.pulsar.getNamespaceService().getBundle(topic);
        Assert.assertNotEquals((Object)bundle1.getBundleRange(), (Object)bundle2.getBundleRange());
        Assert.assertEquals((String)"0x00000000_0xffffffff", (String)bundle2.getBundleRange());
    }

    @Test
    public void testForceDeleteNamespace() throws Exception {
        this.pulsar.getConfiguration().setForceDeleteNamespaceAllowed(true);
        String namespace = BrokerTestUtil.newUniqueName(this.testTenant + "/namespace");
        String topic = namespace + "/topic";
        String non_persistent_topic = "non-persistent://" + topic;
        this.admin.namespaces().createNamespace(namespace, 100);
        this.admin.topics().createPartitionedTopic(topic, 10);
        this.admin.topics().createNonPartitionedTopic(non_persistent_topic);
        List topicList = this.admin.topics().getList(namespace);
        Assert.assertFalse((boolean)topicList.isEmpty());
        try {
            this.admin.namespaces().deleteNamespace(namespace, false);
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
        this.admin.namespaces().deleteNamespace(namespace, true);
        this.admin.namespaces().createNamespace(namespace, 100);
        topicList = this.admin.topics().getList(namespace);
        Assert.assertTrue((boolean)topicList.isEmpty());
        this.pulsar.getConfiguration().setForceDeleteNamespaceAllowed(false);
    }

    @Test
    public void testForceDeleteNamespaceNotAllowed() throws Exception {
        Assert.assertFalse((boolean)this.pulsar.getConfiguration().isForceDeleteNamespaceAllowed());
        String namespace = BrokerTestUtil.newUniqueName(this.testTenant + "/namespace");
        String topic = namespace + "/topic";
        String non_persistent_topic = "non-persistent://" + topic;
        this.admin.namespaces().createNamespace(namespace, 100);
        this.admin.topics().createPartitionedTopic(topic, 10);
        this.admin.topics().createNonPartitionedTopic(non_persistent_topic);
        List topicList = this.admin.topics().getList(namespace);
        Assert.assertFalse((boolean)topicList.isEmpty());
        try {
            this.admin.namespaces().deleteNamespace(namespace, false);
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
        try {
            this.admin.namespaces().deleteNamespace(namespace, true);
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.admin.namespaces().getNamespaces(this.testTenant).contains(namespace));
    }

    @Test
    public void testSubscribeRate() throws Exception {
        SubscribeRate subscribeRate = new SubscribeRate(1, 5);
        String namespace = "my-tenants/my-namespace";
        this.admin.tenants().createTenant("my-tenants", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{"use"})));
        this.admin.namespaces().createNamespace(namespace, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.namespaces().setSubscribeRate(namespace, subscribeRate);
        Assert.assertEquals((Object)subscribeRate, (Object)this.admin.namespaces().getSubscribeRate(namespace));
        String topicName = "persistent://" + namespace + "/subscribe-rate";
        this.admin.topics().createPartitionedTopic(topicName, 2);
        this.pulsar.getConfiguration().setAuthorizationEnabled(false);
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionType(SubscriptionType.Shared).subscriptionName("subscribe-rate").subscribe();
        Assert.assertTrue((boolean)consumer.isConnected());
        this.pulsarClient.updateServiceUrl(this.lookupUrl.toString());
        Awaitility.await().untilAsserted(() -> Assert.assertFalse((boolean)consumer.isConnected()));
        this.pulsarClient.updateServiceUrl(this.lookupUrl.toString());
        Awaitility.await().pollDelay(Duration.ofSeconds(6L)).untilAsserted(() -> Assert.assertTrue((boolean)consumer.isConnected()));
        subscribeRate = new SubscribeRate(0, 10);
        this.admin.namespaces().setSubscribeRate(namespace, subscribeRate);
        this.pulsarClient.updateServiceUrl(this.lookupUrl.toString());
        Awaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)consumer.isConnected()));
        this.pulsar.getConfiguration().setAuthorizationEnabled(true);
        this.admin.topics().deletePartitionedTopic(topicName, true);
        this.admin.namespaces().deleteNamespace(namespace);
        this.admin.tenants().deleteTenant("my-tenants");
    }

    @Test
    public void testSetOffloadThreshold() throws Exception {
        TopicName topicName = TopicName.get((String)"persistent", (String)this.testTenant, (String)"offload", (String)"offload-topic");
        String namespace = topicName.getNamespaceObject().toString();
        System.out.println(namespace);
        this.pulsar.getConfiguration().setManagedLedgerOffloadAutoTriggerSizeThresholdBytes(1L);
        this.admin.namespaces().createNamespace(namespace, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.topics().createNonPartitionedTopic(topicName.toString());
        Assert.assertEquals((long)-1L, (long)this.admin.namespaces().getOffloadThreshold(namespace));
        ManagedLedgerConfig ledgerConf = (ManagedLedgerConfig)this.pulsar.getBrokerService().getManagedLedgerConfig(topicName).get();
        MockLedgerOffloader offloader = new MockLedgerOffloader(OffloadPoliciesImpl.create((String)"S3", (String)"", (String)"", (String)"", null, null, null, null, (Integer)0x4000000, (Integer)0x100000, (Long)this.admin.namespaces().getOffloadThreshold(namespace), (Long)this.pulsar.getConfiguration().getManagedLedgerOffloadDeletionLagMs(), (OffloadedReadPriority)OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY));
        ledgerConf.setLedgerOffloader((LedgerOffloader)offloader);
        Assert.assertEquals((Object)ledgerConf.getLedgerOffloader().getOffloadPolicies().getManagedLedgerOffloadThresholdInBytes(), (Object)new Long(-1L));
        this.admin.namespaces().setOffloadThreshold(namespace, 100L);
        Assert.assertEquals((long)100L, (long)this.admin.namespaces().getOffloadThreshold(namespace));
        ledgerConf = (ManagedLedgerConfig)this.pulsar.getBrokerService().getManagedLedgerConfig(topicName).get();
        this.admin.namespaces().getOffloadPolicies(namespace);
        offloader = new MockLedgerOffloader(OffloadPoliciesImpl.create((String)"S3", (String)"", (String)"", (String)"", null, null, null, null, (Integer)0x4000000, (Integer)0x100000, (Long)this.admin.namespaces().getOffloadThreshold(namespace), (Long)this.pulsar.getConfiguration().getManagedLedgerOffloadDeletionLagMs(), (OffloadedReadPriority)OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY));
        ledgerConf.setLedgerOffloader((LedgerOffloader)offloader);
        Assert.assertEquals((Object)ledgerConf.getLedgerOffloader().getOffloadPolicies().getManagedLedgerOffloadThresholdInBytes(), (Object)new Long(100L));
        this.admin.namespaces().setOffloadThreshold(namespace, -2L);
        Assert.assertEquals((long)-2L, (long)this.admin.namespaces().getOffloadThreshold(namespace));
        ledgerConf = (ManagedLedgerConfig)this.pulsar.getBrokerService().getManagedLedgerConfig(topicName).get();
        offloader = new MockLedgerOffloader(OffloadPoliciesImpl.create((String)"S3", (String)"", (String)"", (String)"", null, null, null, null, (Integer)0x4000000, (Integer)0x100000, (Long)this.admin.namespaces().getOffloadThreshold(namespace), (Long)this.pulsar.getConfiguration().getManagedLedgerOffloadDeletionLagMs(), (OffloadedReadPriority)OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY));
        ledgerConf.setLedgerOffloader((LedgerOffloader)offloader);
        Assert.assertEquals((Object)ledgerConf.getLedgerOffloader().getOffloadPolicies().getManagedLedgerOffloadThresholdInBytes(), (Object)new Long(-2L));
        this.admin.namespaces().setOffloadThreshold(namespace, -1L);
        Assert.assertEquals((long)-1L, (long)this.admin.namespaces().getOffloadThreshold(namespace));
        ledgerConf = (ManagedLedgerConfig)this.pulsar.getBrokerService().getManagedLedgerConfig(topicName).get();
        offloader = new MockLedgerOffloader(OffloadPoliciesImpl.create((String)"S3", (String)"", (String)"", (String)"", null, null, null, null, (Integer)0x4000000, (Integer)0x100000, (Long)this.admin.namespaces().getOffloadThreshold(namespace), (Long)this.pulsar.getConfiguration().getManagedLedgerOffloadDeletionLagMs(), (OffloadedReadPriority)OffloadPoliciesImpl.DEFAULT_OFFLOADED_READ_PRIORITY));
        ledgerConf.setLedgerOffloader((LedgerOffloader)offloader);
        Assert.assertEquals((Object)ledgerConf.getLedgerOffloader().getOffloadPolicies().getManagedLedgerOffloadThresholdInBytes(), (Object)new Long(-1L));
        this.admin.topics().delete(topicName.toString(), true);
        this.admin.namespaces().deleteNamespace(namespace);
    }

    private void mockWebUrl(URL localWebServiceUrl, NamespaceName namespace) throws Exception {
        ((NamespaceService)Mockito.doReturn(Optional.of(localWebServiceUrl)).when((Object)this.nsSvc)).getWebServiceUrl((ServiceUnitId)Mockito.argThat(bundle -> bundle.getNamespaceObject().equals((Object)namespace)), (LookupOptions)Mockito.any());
        ((NamespaceService)Mockito.doReturn((Object)true).when((Object)this.nsSvc)).isServiceUnitOwned((ServiceUnitId)Mockito.argThat(bundle -> bundle.getNamespaceObject().equals((Object)namespace)));
    }

    @Test
    public void testDeleteNonPartitionedTopicMultipleTimes() throws Exception {
        String namespace = BrokerTestUtil.newUniqueName(this.testTenant + "/namespace");
        String topic = namespace + "/topic";
        this.admin.namespaces().createNamespace(namespace, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.topics().createNonPartitionedTopic(topic);
        this.admin.topics().delete(topic);
        try {
            this.admin.topics().delete(topic);
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        this.admin.namespaces().deleteNamespace(namespace);
        try {
            this.admin.topics().delete(topic);
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDeletePartitionedTopicMultipleTimes() throws Exception {
        String namespace = BrokerTestUtil.newUniqueName(this.testTenant + "/namespace");
        String topic = namespace + "/topic";
        this.admin.namespaces().createNamespace(namespace, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.topics().createPartitionedTopic(topic, 3);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)topic).partitions, (int)3);
        this.admin.topics().deletePartitionedTopic(topic);
        try {
            this.admin.topics().deletePartitionedTopic(topic);
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        this.admin.namespaces().deleteNamespace(namespace);
        try {
            this.admin.topics().deletePartitionedTopic(topic);
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRetentionPolicyValidation() throws Exception {
        String namespace = BrokerTestUtil.newUniqueName(this.testTenant + "/namespace");
        this.admin.namespaces().createNamespace(namespace, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.namespaces().setRetention(namespace, new RetentionPolicies());
        this.admin.namespaces().setRetention(namespace, new RetentionPolicies(-1, -1));
        this.admin.namespaces().setRetention(namespace, new RetentionPolicies(1, 1));
        this.assertInvalidRetentionPolicy(namespace, 1, 0);
        this.assertInvalidRetentionPolicy(namespace, 0, 1);
        this.assertInvalidRetentionPolicy(namespace, -1, 0);
        this.assertInvalidRetentionPolicy(namespace, 0, -1);
        this.assertInvalidRetentionPolicy(namespace, -2, 1);
        this.assertInvalidRetentionPolicy(namespace, 1, -2);
        this.admin.namespaces().deleteNamespace(namespace);
    }

    @Test(timeOut=180000L)
    public void testMaxTopicsPerNamespace() throws Exception {
        this.cleanup();
        this.conf.setMaxTopicsPerNamespace(15);
        super.internalSetup();
        String namespace = "testTenant/ns1";
        this.admin.clusters().createCluster("use", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace(namespace, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        Assert.assertEquals((int)0, (int)this.admin.namespaces().getMaxTopicsPerNamespace(namespace));
        this.admin.namespaces().setMaxTopicsPerNamespace(namespace, 10);
        Assert.assertEquals((int)10, (int)this.admin.namespaces().getMaxTopicsPerNamespace(namespace));
        String topic = "persistent://testTenant/ns1/test_create_topic_v";
        this.admin.topics().createPartitionedTopic(topic + "1", 2);
        this.admin.topics().createPartitionedTopic(topic + "2", 3);
        this.admin.topics().createPartitionedTopic(topic + "3", 4);
        this.admin.topics().createNonPartitionedTopic(topic + "4");
        try {
            this.admin.topics().createPartitionedTopic(topic + "5", 2);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
            Assert.assertEquals((String)e.getHttpError(), (String)"Exceed maximum number of topics in namespace.");
        }
        this.admin.namespaces().removeMaxTopicsPerNamespace(namespace);
        this.admin.topics().createPartitionedTopic(topic + "6", 4);
        try {
            this.admin.topics().createPartitionedTopic(topic + "7", 3);
            Assert.fail();
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)412);
            Assert.assertEquals((String)e.getHttpError(), (String)"Exceed maximum number of topics in namespace.");
        }
        this.admin.namespaces().setMaxTopicsPerNamespace(namespace, 0);
        for (int i = 0; i < 10; ++i) {
            this.admin.topics().createPartitionedTopic(topic + "_v" + i, 2);
            this.admin.topics().createNonPartitionedTopic(topic + "_vn" + i);
        }
        this.cleanup();
        this.conf.setMaxTopicsPerNamespace(0);
        this.conf.setDefaultNumPartitions(3);
        this.conf.setAllowAutoTopicCreationType("partitioned");
        super.internalSetup();
        this.admin.clusters().createCluster("use", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace(namespace, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.namespaces().setMaxTopicsPerNamespace(namespace, 10);
        this.pulsarClient.newProducer().topic(topic + "1").create().close();
        this.pulsarClient.newProducer().topic(topic + "2").create().close();
        this.pulsarClient.newConsumer().topic(new String[]{topic + "3"}).subscriptionName("test_sub").subscribe().close();
        try {
            this.pulsarClient.newConsumer().topic(new String[]{topic + "4"}).subscriptionName("test_sub").subscribe().close();
            Assert.fail();
        }
        catch (PulsarClientException e) {
            log.info("Exception: ", (Throwable)e);
        }
        this.admin.namespaces().removeMaxTopicsPerNamespace(namespace);
        for (int i = 0; i < 10; ++i) {
            this.pulsarClient.newProducer().topic(topic + "_p" + i).create().close();
            this.pulsarClient.newConsumer().topic(new String[]{topic + "_c" + i}).subscriptionName("test_sub").subscribe().close();
        }
        this.cleanup();
        this.conf.setMaxTopicsPerNamespace(0);
        this.conf.setDefaultNumPartitions(1);
        this.conf.setAllowAutoTopicCreationType("non-partitioned");
        super.internalSetup();
        this.admin.clusters().createCluster("use", ClusterData.builder().serviceUrl(this.brokerUrl.toString()).build());
        this.admin.tenants().createTenant("testTenant", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace(namespace, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.namespaces().setMaxTopicsPerNamespace(namespace, 3);
        this.pulsarClient.newProducer().topic(topic + "1").create().close();
        this.pulsarClient.newProducer().topic(topic + "2").create().close();
        this.pulsarClient.newConsumer().topic(new String[]{topic + "3"}).subscriptionName("test_sub").subscribe().close();
        try {
            this.pulsarClient.newConsumer().topic(new String[]{topic + "4"}).subscriptionName("test_sub").subscribe().close();
            Assert.fail();
        }
        catch (PulsarClientException e) {
            log.info("Exception: ", (Throwable)e);
        }
        this.admin.namespaces().setMaxTopicsPerNamespace(namespace, 5);
        this.pulsarClient.newProducer().topic(topic + "4").create().close();
        this.pulsarClient.newProducer().topic(topic + "5").create().close();
        try {
            this.pulsarClient.newConsumer().topic(new String[]{topic + "6"}).subscriptionName("test_sub").subscribe().close();
            Assert.fail();
        }
        catch (PulsarClientException e) {
            log.info("Exception: ", (Throwable)e);
        }
        this.admin.namespaces().removeMaxTopicsPerNamespace(namespace);
        for (int i = 0; i < 10; ++i) {
            this.pulsarClient.newProducer().topic(topic + "_p" + i).create().close();
            this.pulsarClient.newConsumer().topic(new String[]{topic + "_c" + i}).subscriptionName("test_sub").subscribe().close();
        }
        this.conf.setMaxTopicsPerNamespace(0);
        this.conf.setDefaultNumPartitions(1);
        this.conf.setAllowAutoTopicCreationType("non-partitioned");
    }

    private void assertInvalidRetentionPolicy(String namespace, int retentionTimeInMinutes, int retentionSizeInMB) {
        try {
            RetentionPolicies retention = new RetentionPolicies(retentionTimeInMinutes, retentionSizeInMB);
            this.admin.namespaces().setRetention(namespace, retention);
            Assert.fail((String)("Validation should have failed for " + retention));
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof BadRequestException));
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid retention policy"));
        }
    }

    @Test
    public void testRetentionPolicyValidationAsPartOfAllPolicies() throws Exception {
        Policies policies = new Policies();
        policies.replication_clusters = Sets.newHashSet((Object[])new String[]{"use"});
        this.assertValidRetentionPolicyAsPartOfAllPolicies(policies, 0, 0);
        this.assertValidRetentionPolicyAsPartOfAllPolicies(policies, -1, -1);
        this.assertValidRetentionPolicyAsPartOfAllPolicies(policies, 1, 1);
        this.assertInvalidRetentionPolicyAsPartOfAllPolicies(policies, 1, 0);
        this.assertInvalidRetentionPolicyAsPartOfAllPolicies(policies, 0, 1);
        this.assertInvalidRetentionPolicyAsPartOfAllPolicies(policies, -1, 0);
        this.assertInvalidRetentionPolicyAsPartOfAllPolicies(policies, 0, -1);
        this.assertInvalidRetentionPolicyAsPartOfAllPolicies(policies, -2, 1);
        this.assertInvalidRetentionPolicyAsPartOfAllPolicies(policies, 1, -2);
    }

    @Test
    public void testSubscriptionTypesEnabled() throws PulsarAdminException, PulsarClientException {
        this.pulsar.getConfiguration().setAuthorizationEnabled(false);
        this.pulsar.getConfiguration().setTopicLevelPoliciesEnabled(false);
        String namespace = BrokerTestUtil.newUniqueName(this.testTenant + "/namespace");
        String topic = namespace + "/test-subscription-enabled";
        this.admin.namespaces().createNamespace(namespace);
        Set<SubscriptionType> subscriptionTypes = new HashSet<SubscriptionType>();
        subscriptionTypes.add(SubscriptionType.Shared);
        subscriptionTypes.add(SubscriptionType.Exclusive);
        subscriptionTypes.add(SubscriptionType.Failover);
        subscriptionTypes.add(SubscriptionType.Key_Shared);
        this.admin.namespaces().setSubscriptionTypesEnabled(namespace, subscriptionTypes);
        ConsumerBuilder consumerBuilder = this.pulsarClient.newConsumer().topic(new String[]{topic}).subscriptionType(SubscriptionType.Shared).subscriptionName("share");
        consumerBuilder.subscribe().close();
        subscriptionTypes = this.admin.namespaces().getSubscriptionTypesEnabled(namespace);
        Assert.assertEquals((int)SubscriptionType.values().length, (int)subscriptionTypes.size());
        for (SubscriptionType value : SubscriptionType.values()) {
            Assert.assertTrue((boolean)subscriptionTypes.contains(value));
        }
        subscriptionTypes.remove(SubscriptionType.Shared);
        this.admin.namespaces().setSubscriptionTypesEnabled(namespace, subscriptionTypes);
        Assert.assertFalse((boolean)this.admin.namespaces().getSubscriptionTypesEnabled(namespace).contains(SubscriptionType.Shared));
        try {
            consumerBuilder.subscribe().close();
            Assert.fail();
        }
        catch (PulsarClientException pulsarClientException) {
            Assert.assertTrue((boolean)(pulsarClientException instanceof PulsarClientException.NotAllowedException));
        }
        subscriptionTypes.add(SubscriptionType.Shared);
        this.admin.namespaces().setSubscriptionTypesEnabled(namespace, subscriptionTypes);
        consumerBuilder.subscribe().close();
        subscriptionTypes.remove(SubscriptionType.Failover);
        this.admin.namespaces().setSubscriptionTypesEnabled(namespace, subscriptionTypes);
        consumerBuilder.subscriptionType(SubscriptionType.Failover);
        try {
            consumerBuilder.subscribe().close();
            Assert.fail();
        }
        catch (PulsarClientException pulsarClientException) {
            Assert.assertTrue((boolean)(pulsarClientException instanceof PulsarClientException.NotAllowedException));
        }
        subscriptionTypes.clear();
        this.admin.namespaces().setSubscriptionTypesEnabled(namespace, subscriptionTypes);
        consumerBuilder.subscriptionType(SubscriptionType.Shared);
        HashSet<String> subscriptions = new HashSet<String>();
        subscriptions.add("Failover");
        this.conf.setSubscriptionTypesEnabled(subscriptions);
        try {
            consumerBuilder.subscribe().close();
            Assert.fail();
        }
        catch (PulsarClientException pulsarClientException) {
            Assert.assertTrue((boolean)(pulsarClientException instanceof PulsarClientException.NotAllowedException));
        }
        subscriptions.add("Shared");
        this.conf.setSubscriptionTypesEnabled(subscriptions);
        consumerBuilder.subscribe().close();
    }

    private void assertValidRetentionPolicyAsPartOfAllPolicies(Policies policies, int retentionTimeInMinutes, int retentionSizeInMB) throws PulsarAdminException {
        String namespace = BrokerTestUtil.newUniqueName(this.testTenant + "/namespace");
        policies.retention_policies = new RetentionPolicies(retentionTimeInMinutes, retentionSizeInMB);
        this.admin.namespaces().createNamespace(namespace, policies);
        this.admin.namespaces().deleteNamespace(namespace);
    }

    private void assertInvalidRetentionPolicyAsPartOfAllPolicies(Policies policies, int retentionTimeInMinutes, int retentionSizeInMB) {
        String namespace = BrokerTestUtil.newUniqueName(this.testTenant + "/namespace");
        try {
            RetentionPolicies retention;
            policies.retention_policies = retention = new RetentionPolicies(retentionTimeInMinutes, retentionSizeInMB);
            this.admin.namespaces().createNamespace(namespace, policies);
            Assert.fail((String)("Validation should have failed for " + retention));
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof BadRequestException));
            Assert.assertTrue((boolean)e.getMessage().startsWith("Invalid retention policy"));
        }
    }

    @Test
    public void testSplitBundleForMultiTimes() throws Exception {
        String namespace = BrokerTestUtil.newUniqueName(this.testTenant + "/namespace");
        BundlesData data = BundlesData.builder().numBundles(4).build();
        this.admin.namespaces().createNamespace(namespace, data);
        for (int i = 0; i < 10; ++i) {
            BundlesData bundles = this.admin.namespaces().getBundles(namespace);
            String bundle = (String)bundles.getBoundaries().get(0) + "_" + (String)bundles.getBoundaries().get(1);
            this.admin.namespaces().splitNamespaceBundle(namespace, bundle, true, null);
        }
        BundlesData bundles = this.admin.namespaces().getBundles(namespace);
        Assert.assertEquals((int)bundles.getNumBundles(), (int)14);
    }

    public static class MockLedgerOffloader
    implements LedgerOffloader {
        ConcurrentHashMap<Long, UUID> offloads = new ConcurrentHashMap();
        ConcurrentHashMap<Long, UUID> deletes = new ConcurrentHashMap();
        OffloadPoliciesImpl offloadPolicies;

        Set<Long> offloadedLedgers() {
            return this.offloads.keySet();
        }

        Set<Long> deletedOffloads() {
            return this.deletes.keySet();
        }

        public MockLedgerOffloader(OffloadPoliciesImpl offloadPolicies) {
            this.offloadPolicies = offloadPolicies;
        }

        public String getOffloadDriverName() {
            return "mock";
        }

        public CompletableFuture<Void> offload(ReadHandle ledger, UUID uuid, Map<String, String> extraMetadata) {
            CompletableFuture<Void> promise = new CompletableFuture<Void>();
            if (this.offloads.putIfAbsent(ledger.getId(), uuid) == null) {
                promise.complete(null);
            } else {
                promise.completeExceptionally(new Exception("Already exists exception"));
            }
            return promise;
        }

        public CompletableFuture<ReadHandle> readOffloaded(long ledgerId, UUID uuid, Map<String, String> offloadDriverMetadata) {
            CompletableFuture<ReadHandle> promise = new CompletableFuture<ReadHandle>();
            promise.completeExceptionally(new UnsupportedOperationException());
            return promise;
        }

        public CompletableFuture<Void> deleteOffloaded(long ledgerId, UUID uuid, Map<String, String> offloadDriverMetadata) {
            CompletableFuture<Void> promise = new CompletableFuture<Void>();
            if (this.offloads.remove(ledgerId, uuid)) {
                this.deletes.put(ledgerId, uuid);
                promise.complete(null);
            } else {
                promise.completeExceptionally(new Exception("Not found"));
            }
            return promise;
        }

        public OffloadPoliciesImpl getOffloadPolicies() {
            return this.offloadPolicies;
        }

        public void close() {
        }
    }
}

