/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Sets;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationProviderToken;
import org.apache.pulsar.broker.authentication.utils.AuthTokenUtils;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminBuilder;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.client.impl.schema.StringSchema;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.websocket.data.ProducerMessage;
import org.apache.pulsar.websocket.data.ProducerMessages;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TopicsAuthTest
extends MockedPulsarServiceBaseTest {
    private final String testLocalCluster = "test";
    private final String testTenant = "my-tenant";
    private final String testNamespace = "my-namespace";
    private final String testTopicName = "my-topic";
    private static final SecretKey SECRET_KEY = AuthTokenUtils.createSecretKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
    private static final String ADMIN_TOKEN = Jwts.builder().setSubject("admin").signWith((Key)SECRET_KEY).compact();
    private static final String PRODUCE_TOKEN = Jwts.builder().setSubject("producer").signWith((Key)SECRET_KEY).compact();
    private static final String CONSUME_TOKEN = Jwts.builder().setSubject("consumer").signWith((Key)SECRET_KEY).compact();

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setAuthenticationEnabled(true);
        this.conf.setAuthorizationEnabled(true);
        this.conf.getProperties().setProperty("tokenSecretKey", "data:;base64," + Base64.getEncoder().encodeToString(SECRET_KEY.getEncoded()));
        HashSet<String> superUserRoles = new HashSet<String>();
        superUserRoles.add("admin");
        this.conf.setSuperUserRoles(superUserRoles);
        HashSet<String> providers = new HashSet<String>();
        providers.add(AuthenticationProviderToken.class.getName());
        this.conf.setAuthenticationProviders(providers);
        super.internalSetup();
        PulsarAdminBuilder pulsarAdminBuilder = PulsarAdmin.builder().serviceHttpUrl(this.brokerUrl != null ? this.brokerUrl.toString() : this.brokerUrlTls.toString()).authentication(AuthenticationToken.class.getName(), ADMIN_TOKEN);
        this.admin = (PulsarAdmin)Mockito.spy((Object)pulsarAdminBuilder.build());
        this.admin.clusters().createCluster("test", (ClusterData)new ClusterDataImpl());
        this.admin.tenants().createTenant("my-tenant", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace("my-tenant/my-namespace", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.namespaces().grantPermissionOnNamespace("my-tenant/my-namespace", "producer", EnumSet.of(AuthAction.produce));
        this.admin.namespaces().grantPermissionOnNamespace("my-tenant/my-namespace", "consumer", EnumSet.of(AuthAction.consume));
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="variations")
    public static Object[][] variations() {
        return new Object[][]{{CONSUME_TOKEN, 401}, {PRODUCE_TOKEN, 200}};
    }

    @Test(dataProvider="variations")
    public void testProduceToNonPartitionedTopic(String token, int status) throws Exception {
        this.innerTestProduce("my-topic", true, false, token, status);
    }

    @Test(dataProvider="variations")
    public void testProduceToPartitionedTopic(String token, int status) throws Exception {
        this.innerTestProduce("my-topic", true, true, token, status);
    }

    @Test(dataProvider="variations")
    public void testProduceOnNonPersistentNonPartitionedTopic(String token, int status) throws Exception {
        this.innerTestProduce("my-topic", false, false, token, status);
    }

    @Test(dataProvider="variations")
    public void testProduceOnNonPersistentPartitionedTopic(String token, int status) throws Exception {
        this.innerTestProduce("my-topic", false, true, token, status);
    }

    private void innerTestProduce(String createTopicName, boolean isPersistent, boolean isPartition, String token, int status) throws Exception {
        String topicPrefix = null;
        topicPrefix = isPersistent ? "persistent" : "non-persistent";
        if (isPartition) {
            this.admin.topics().createPartitionedTopic(topicPrefix + "://" + "my-tenant" + "/" + "my-namespace" + "/" + createTopicName, 5);
        } else {
            this.admin.topics().createNonPartitionedTopic(topicPrefix + "://" + "my-tenant" + "/" + "my-namespace" + "/" + createTopicName);
        }
        StringSchema schema = StringSchema.utf8();
        ProducerMessages producerMessages = new ProducerMessages();
        producerMessages.setKeySchema(ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)schema.getSchemaInfo()));
        producerMessages.setValueSchema(ObjectMapperFactory.getThreadLocal().writeValueAsString((Object)schema.getSchemaInfo()));
        String message = "[{\"key\":\"my-key\",\"payload\":\"RestProducer:1\",\"eventTime\":1603045262772,\"sequenceId\":1},{\"key\":\"my-key\",\"payload\":\"RestProducer:2\",\"eventTime\":1603045262772,\"sequenceId\":2}]";
        producerMessages.setMessages((List)ObjectMapperFactory.getThreadLocal().readValue(message, (TypeReference)new TypeReference<List<ProducerMessage>>(){}));
        WebTarget root = this.buildWebClient();
        String requestPath = null;
        requestPath = isPartition ? "/topics/" + topicPrefix + "/" + "my-tenant" + "/" + "my-namespace" + "/" + createTopicName + "/partitions/2" : "/topics/" + topicPrefix + "/" + "my-tenant" + "/" + "my-namespace" + "/" + createTopicName;
        Response response = root.path(requestPath).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).post(Entity.json((Object)producerMessages));
        Assert.assertEquals((int)response.getStatus(), (int)status);
    }

    WebTarget buildWebClient() throws Exception {
        ClientConfig httpConfig = new ClientConfig();
        httpConfig.property("jersey.config.client.followRedirects", (Object)true);
        httpConfig.property("jersey.config.client.async.threadPoolSize", (Object)8);
        httpConfig.register(MultiPartFeature.class);
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig((Configuration)httpConfig);
        Client client = clientBuilder.build();
        return client.target(this.brokerUrl.toString());
    }
}

