/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v1;

import com.google.common.collect.BoundType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.internal.LookupImpl;
import org.apache.pulsar.client.admin.internal.TenantsImpl;
import org.apache.pulsar.client.admin.internal.TopicsImpl;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.ConsumerBuilder;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BrokerAssignment;
import org.apache.pulsar.common.policies.data.BrokerNamespaceIsolationData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.NamespaceIsolationDataImpl;
import org.apache.pulsar.common.policies.data.NamespaceOwnershipStatus;
import org.apache.pulsar.common.policies.data.PartitionedTopicStats;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.Policies;
import org.apache.pulsar.common.policies.data.PoliciesUtil;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.compaction.Compactor;
import org.apache.pulsar.metadata.cache.impl.MetadataCacheImpl;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class V1_AdminApiTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(V1_AdminApiTest.class);
    private static final Logger LOG = LoggerFactory.getLogger(V1_AdminApiTest.class);
    private final String TLS_SERVER_CERT_FILE_PATH = "./src/test/resources/certificate/server.crt";
    private final String TLS_SERVER_KEY_FILE_PATH = "./src/test/resources/certificate/server.key";
    private MockedPulsarService mockPulsarSetup;
    private PulsarService otherPulsar;
    private PulsarAdmin adminTls;
    private PulsarAdmin otheradmin;
    private NamespaceBundleFactory bundleFactory;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.conf.setLoadBalancerEnabled(true);
        this.conf.setBrokerServicePortTls(Optional.of(0));
        this.conf.setWebServicePortTls(Optional.of(0));
        this.conf.setTlsCertificateFilePath("./src/test/resources/certificate/server.crt");
        this.conf.setTlsKeyFilePath("./src/test/resources/certificate/server.key");
        this.conf.setNumExecutorThreadPoolSize(5);
        super.internalSetup();
        this.bundleFactory = new NamespaceBundleFactory(this.pulsar, Hashing.crc32());
        this.adminTls = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().tlsTrustCertsFilePath("./src/test/resources/certificate/server.crt").serviceHttpUrl(this.brokerUrlTls.toString()).build());
        this.mockPulsarSetup = new MockedPulsarService(this.conf);
        this.mockPulsarSetup.setup();
        this.otherPulsar = this.mockPulsarSetup.getPulsar();
        this.otheradmin = this.mockPulsarSetup.getAdmin();
        this.admin.clusters().createCluster("use", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.tenants().createTenant("prop-xyz", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/use/ns1");
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        this.adminTls.close();
        super.internalCleanup();
        this.mockPulsarSetup.cleanup();
    }

    @DataProvider(name="numBundles")
    public static Object[][] numBundles() {
        return new Object[][]{{1}, {4}};
    }

    @DataProvider(name="bundling")
    public static Object[][] bundling() {
        return new Object[][]{{0}, {4}};
    }

    @DataProvider(name="topicName")
    public Object[][] topicNamesProvider() {
        return new Object[][]{{"topic_+&*%{}() \\/$@#^%"}, {"simple-topicName"}};
    }

    @DataProvider(name="topicType")
    public Object[][] topicTypeProvider() {
        return new Object[][]{{TopicDomain.persistent.value()}, {TopicDomain.non_persistent.value()}};
    }

    @Test
    public void clusters() throws Exception {
        this.admin.clusters().createCluster("usw", ClusterData.builder().serviceUrl("http://broker.messaging.use.example.com:8080").build());
        Assert.assertEquals((Collection)this.admin.clusters().getClusters(), (Collection)Lists.newArrayList((Object[])new String[]{"use", "usw"}));
        Assert.assertEquals((Object)this.admin.clusters().getCluster("use"), (Object)ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        this.admin.clusters().updateCluster("usw", ClusterData.builder().serviceUrl("http://new-broker.messaging.use.example.com:8080").build());
        Assert.assertEquals((Collection)this.admin.clusters().getClusters(), (Collection)Lists.newArrayList((Object[])new String[]{"use", "usw"}));
        Assert.assertEquals((Object)this.admin.clusters().getCluster("usw"), (Object)ClusterData.builder().serviceUrl("http://new-broker.messaging.use.example.com:8080").build());
        this.admin.clusters().updateCluster("usw", ClusterData.builder().serviceUrl("http://new-broker.messaging.usw.example.com:8080").serviceUrlTls("https://new-broker.messaging.usw.example.com:4443").build());
        Assert.assertEquals((Collection)this.admin.clusters().getClusters(), (Collection)Lists.newArrayList((Object[])new String[]{"use", "usw"}));
        Assert.assertEquals((Object)this.admin.clusters().getCluster("usw"), (Object)ClusterData.builder().serviceUrl("http://new-broker.messaging.usw.example.com:8080").serviceUrlTls("https://new-broker.messaging.usw.example.com:4443").build());
        this.admin.clusters().deleteCluster("usw");
        Thread.sleep(300L);
        Assert.assertEquals((Collection)this.admin.clusters().getClusters(), (Collection)Lists.newArrayList((Object[])new String[]{"use"}));
        this.admin.namespaces().deleteNamespace("prop-xyz/use/ns1");
        this.admin.clusters().deleteCluster("use");
        Assert.assertEquals((Collection)this.admin.clusters().getClusters(), (Collection)Lists.newArrayList());
        try {
            this.admin.clusters().createCluster("bf!", ClusterData.builder().serviceUrl("http://dummy.messaging.example.com").build());
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
    }

    @Test
    public void clusterNamespaceIsolationPolicies() throws PulsarAdminException {
        try {
            String policyName1 = "policy-1";
            HashMap<String, String> parameters1 = new HashMap<String, String>();
            parameters1.put("min_limit", "1");
            parameters1.put("usage_threshold", "100");
            NamespaceIsolationData nsPolicyData1 = NamespaceIsolationData.builder().namespaces((List)Lists.newArrayList((Object[])new String[]{"other/use/other.*"})).primary((List)Lists.newArrayList((Object[])new String[]{".*"})).secondary((List)Lists.newArrayList((Object[])new String[]{"prod1-broker.*.messaging.use.example.com"})).autoFailoverPolicy(AutoFailoverPolicyData.builder().policyType(AutoFailoverPolicyType.min_available).parameters(parameters1).build()).build();
            this.admin.clusters().createNamespaceIsolationPolicy("use", policyName1, nsPolicyData1);
            String policyName2 = "policy-2";
            HashMap<String, String> parameters2 = new HashMap<String, String>();
            parameters2.put("min_limit", "1");
            parameters2.put("usage_threshold", "100");
            NamespaceIsolationData nsPolicyData2 = NamespaceIsolationData.builder().namespaces((List)Lists.newArrayList((Object[])new String[]{"other/use/other.*"})).primary((List)Lists.newArrayList((Object[])new String[]{"prod1-broker[4-6].messaging.use.example.com"})).secondary((List)Lists.newArrayList((Object[])new String[]{"prod1-broker.*.messaging.use.example.com"})).autoFailoverPolicy(AutoFailoverPolicyData.builder().policyType(AutoFailoverPolicyType.min_available).parameters(parameters1).build()).build();
            this.admin.clusters().createNamespaceIsolationPolicy("use", policyName2, nsPolicyData2);
            Map policiesMap = this.admin.clusters().getNamespaceIsolationPolicies("use");
            Assert.assertEquals(policiesMap.get(policyName1), (Object)nsPolicyData1);
            Assert.assertEquals(policiesMap.get(policyName2), (Object)nsPolicyData2);
            List isoList = this.admin.clusters().getBrokersWithNamespaceIsolationPolicy("use");
            Assert.assertEquals((int)isoList.size(), (int)1);
            Assert.assertTrue((boolean)((BrokerNamespaceIsolationData)isoList.get(0)).isPrimary());
            nsPolicyData1.getPrimary().remove(0);
            nsPolicyData1.getPrimary().add("prod1-broker[1-2].messaging.use.example.com");
            this.admin.clusters().updateNamespaceIsolationPolicy("use", policyName1, nsPolicyData1);
            policiesMap = this.admin.clusters().getNamespaceIsolationPolicies("use");
            Assert.assertEquals(policiesMap.get(policyName1), (Object)nsPolicyData1);
            nsPolicyData1.getSecondary().remove(0);
            nsPolicyData1.getSecondary().add("prod1-broker[3-4].messaging.use.example.com");
            this.admin.clusters().updateNamespaceIsolationPolicy("use", policyName1, nsPolicyData1);
            policiesMap = this.admin.clusters().getNamespaceIsolationPolicies("use");
            Assert.assertEquals(policiesMap.get(policyName1), (Object)nsPolicyData1);
            nsPolicyData1.getAutoFailoverPolicy().getParameters().put("min_limit", "10");
            this.admin.clusters().updateNamespaceIsolationPolicy("use", policyName1, nsPolicyData1);
            policiesMap = this.admin.clusters().getNamespaceIsolationPolicies("use");
            Assert.assertEquals(policiesMap.get(policyName1), (Object)nsPolicyData1);
            nsPolicyData1.getAutoFailoverPolicy().getParameters().put("usage_threshold", "80");
            this.admin.clusters().updateNamespaceIsolationPolicy("use", policyName1, nsPolicyData1);
            policiesMap = this.admin.clusters().getNamespaceIsolationPolicies("use");
            Assert.assertEquals(policiesMap.get(policyName1), (Object)nsPolicyData1);
            NamespaceIsolationDataImpl policy1Data = (NamespaceIsolationDataImpl)this.admin.clusters().getNamespaceIsolationPolicy("use", policyName1);
            Assert.assertEquals((Object)policy1Data, (Object)nsPolicyData1);
            this.admin.clusters().createNamespaceIsolationPolicy("use", policyName2, nsPolicyData1);
            try {
                this.admin.clusters().getNamespaceIsolationPolicy("use", "no-such-policy");
                Assert.fail((String)"should have raised exception");
            }
            catch (PulsarAdminException e) {
                Assert.assertTrue((boolean)(e instanceof PulsarAdminException.NotFoundException));
            }
            try {
                this.admin.clusters().deleteCluster("use");
                Assert.fail((String)"should have raised exception");
            }
            catch (PulsarAdminException e) {
                Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
            }
            this.admin.clusters().deleteNamespaceIsolationPolicy("use", policyName1);
            this.admin.clusters().deleteNamespaceIsolationPolicy("use", policyName2);
            try {
                this.admin.clusters().getNamespaceIsolationPolicy("use", policyName1);
                Assert.fail((String)"should have raised exception");
            }
            catch (PulsarAdminException e) {
                Assert.assertTrue((boolean)(e instanceof PulsarAdminException.NotFoundException));
            }
            try {
                this.admin.clusters().getNamespaceIsolationPolicy("use", policyName2);
                Assert.fail((String)"should have raised exception");
            }
            catch (PulsarAdminException e) {
                Assert.assertTrue((boolean)(e instanceof PulsarAdminException.NotFoundException));
            }
            try {
                this.admin.clusters().getNamespaceIsolationPolicies("usc");
                Assert.fail((String)"should have raised exception");
            }
            catch (PulsarAdminException e) {
                Assert.assertTrue((boolean)(e instanceof PulsarAdminException.NotFoundException));
            }
            try {
                this.admin.clusters().getNamespaceIsolationPolicy("usc", "no-such-cluster");
                Assert.fail((String)"should have raised exception");
            }
            catch (PulsarAdminException e) {
                Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
            }
            try {
                this.admin.clusters().createNamespaceIsolationPolicy("usc", "no-such-cluster", nsPolicyData1);
                Assert.fail((String)"should have raised exception");
            }
            catch (PulsarAdminException e) {
                Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
            }
            try {
                this.admin.clusters().updateNamespaceIsolationPolicy("usc", "no-such-cluster", (NamespaceIsolationData)policy1Data);
                Assert.fail((String)"should have raised exception");
            }
            catch (PulsarAdminException e) {
                Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
            }
        }
        catch (PulsarAdminException e) {
            LOG.warn("TEST FAILED [{}]", (Object)e.getMessage());
            throw e;
        }
    }

    @Test
    public void brokers() throws Exception {
        List list = this.admin.brokers().getActiveBrokers("use");
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((int)list.size(), (int)1);
        List list2 = this.otheradmin.brokers().getActiveBrokers("test");
        Assert.assertNotNull((Object)list2);
        Assert.assertEquals((int)list2.size(), (int)1);
        Map nsMap = this.admin.brokers().getOwnedNamespaces("use", (String)list.get(0));
        Assert.assertEquals((int)nsMap.size(), (int)2);
        for (String ns : nsMap.keySet()) {
            NamespaceOwnershipStatus nsStatus = (NamespaceOwnershipStatus)nsMap.get(ns);
            if (!ns.equals(NamespaceService.getHeartbeatNamespace((String)this.pulsar.getAdvertisedAddress(), (ServiceConfiguration)this.pulsar.getConfiguration()) + "/0x00000000_0xffffffff")) continue;
            Assert.assertEquals((Object)nsStatus.broker_assignment, (Object)BrokerAssignment.shared);
            Assert.assertFalse((boolean)nsStatus.is_controlled);
            Assert.assertTrue((boolean)nsStatus.is_active);
        }
        String[] parts = ((String)list.get(0)).split(":");
        Assert.assertEquals((int)parts.length, (int)2);
        Map nsMap2 = this.adminTls.brokers().getOwnedNamespaces("use", String.format("%s:%d", parts[0], this.pulsar.getListenPortHTTPS().get()));
        Assert.assertEquals((int)nsMap2.size(), (int)2);
        this.admin.namespaces().deleteNamespace("prop-xyz/use/ns1");
        this.admin.clusters().deleteCluster("use");
        Assert.assertEquals((Collection)this.admin.clusters().getClusters(), (Collection)Lists.newArrayList());
    }

    @Test
    public void testUpdateDynamicConfigurationWithZkWatch() throws Exception {
        int i;
        int initValue = 30000;
        this.pulsar.getConfiguration().setBrokerShutdownTimeoutMs(30000L);
        long shutdownTime = 10L;
        this.admin.brokers().updateDynamicConfiguration("brokerShutdownTimeoutMs", Long.toString(10L));
        for (i = 0; i < 5; ++i) {
            if (this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs() == 30000L) continue;
            Thread.sleep(50 + i * 10);
        }
        for (i = 0; i < 5 && this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs() != 10L; ++i) {
            Thread.sleep(100 + i * 10);
        }
        Assert.assertEquals((long)this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs(), (long)10L);
        try {
            this.admin.brokers().updateDynamicConfiguration("zookeeperServers", "test-zk:1234");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
        try {
            this.admin.brokers().updateDynamicConfiguration("test", Long.toString(10L));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
    }

    @Test
    public void testInvalidDynamicConfigContentInZK() throws Exception {
        int newValue = 10;
        this.pulsar.getLocalMetadataStore().put("/admin/configuration", "$".getBytes(), Optional.empty()).join();
        this.stopBroker();
        this.startBroker();
        Assert.assertNotEquals((Object)this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs(), (Object)10);
        HashMap configMap = Maps.newHashMap();
        configMap.put("brokerShutdownTimeoutMs", Integer.toString(10));
        this.pulsar.getLocalMetadataStore().put("/admin/configuration", ObjectMapperFactory.getThreadLocal().writeValueAsBytes((Object)configMap), Optional.empty()).join();
        for (int i = 0; i < 5 && this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs() != 10L; ++i) {
            Thread.sleep(100 + i * 10);
        }
        Assert.assertEquals((long)this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs(), (long)10L);
    }

    @Test
    public void testUpdateDynamicLocalConfiguration() throws Exception {
        long initValue = 30000L;
        long shutdownTime = 10L;
        this.pulsar.getConfiguration().setBrokerShutdownTimeoutMs(30000L);
        this.admin.brokers().updateDynamicConfiguration("brokerShutdownTimeoutMs", Long.toString(10L));
        for (int i = 0; i < 5; ++i) {
            if (this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs() != 30000L) continue;
            Thread.sleep(50 + i * 10);
        }
        Assert.assertEquals((long)this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs(), (long)10L);
    }

    @Test
    public void testUpdatableConfigurationName() throws Exception {
        String configName = "brokerShutdownTimeoutMs";
        Assert.assertTrue((boolean)this.admin.brokers().getDynamicConfigurationNames().contains("brokerShutdownTimeoutMs"));
    }

    @Test
    public void testGetDynamicLocalConfiguration() throws Exception {
        String configName = "brokerShutdownTimeoutMs";
        long shutdownTime = 10L;
        this.pulsar.getConfiguration().setBrokerShutdownTimeoutMs(30000L);
        Map configs = this.admin.brokers().getAllDynamicConfigurations();
        Assert.assertTrue((boolean)configs.isEmpty());
        Assert.assertNotEquals((Object)this.pulsar.getConfiguration().getBrokerShutdownTimeoutMs(), (Object)10L);
        this.admin.brokers().updateDynamicConfiguration("brokerShutdownTimeoutMs", Long.toString(10L));
        Assert.assertEquals((long)Long.parseLong((String)this.admin.brokers().getAllDynamicConfigurations().get("brokerShutdownTimeoutMs")), (long)10L);
    }

    @Test
    public void properties() throws PulsarAdminException {
        HashSet allowedClusters = Sets.newHashSet((Object[])new String[]{"use"});
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)allowedClusters);
        this.admin.tenants().updateTenant("prop-xyz", (TenantInfo)tenantInfo);
        Assert.assertEquals((Collection)this.admin.tenants().getTenants(), (Collection)Lists.newArrayList((Object[])new String[]{"prop-xyz"}));
        Assert.assertEquals((Object)this.admin.tenants().getTenantInfo("prop-xyz"), (Object)tenantInfo);
        TenantInfoImpl newPropertyAdmin = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role3", "role4"}), (Set)allowedClusters);
        this.admin.tenants().updateTenant("prop-xyz", (TenantInfo)newPropertyAdmin);
        Assert.assertEquals((Object)this.admin.tenants().getTenantInfo("prop-xyz"), (Object)newPropertyAdmin);
        this.admin.namespaces().deleteNamespace("prop-xyz/use/ns1");
        this.admin.tenants().deleteTenant("prop-xyz");
        Assert.assertEquals((Collection)this.admin.tenants().getTenants(), (Collection)Lists.newArrayList());
        try {
            this.admin.tenants().createTenant("prop-xyz&", (TenantInfo)tenantInfo);
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
    }

    @Test
    public void namespaces() throws Exception {
        Optional data1;
        int i;
        this.admin.clusters().createCluster("usw", ClusterData.builder().build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use", "usw"}));
        this.admin.tenants().updateTenant("prop-xyz", (TenantInfo)tenantInfo);
        Assert.assertEquals((Object)this.admin.namespaces().getPolicies((String)"prop-xyz/use/ns1").bundles, (Object)PoliciesUtil.defaultBundle());
        this.admin.namespaces().createNamespace("prop-xyz/use/ns2");
        this.admin.namespaces().createNamespace("prop-xyz/use/ns3", 4);
        Assert.assertEquals((int)this.admin.namespaces().getPolicies((String)"prop-xyz/use/ns3").bundles.getNumBundles(), (int)4);
        Assert.assertEquals((int)this.admin.namespaces().getPolicies((String)"prop-xyz/use/ns3").bundles.getBoundaries().size(), (int)5);
        this.admin.namespaces().deleteNamespace("prop-xyz/use/ns3");
        try {
            this.admin.namespaces().createNamespace("non-existing/usw/ns1");
            Assert.fail((String)"Should not have passed");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        Assert.assertEquals((Collection)this.admin.namespaces().getNamespaces("prop-xyz"), (Collection)Lists.newArrayList((Object[])new String[]{"prop-xyz/use/ns1", "prop-xyz/use/ns2"}));
        Assert.assertEquals((Collection)this.admin.namespaces().getNamespaces("prop-xyz", "use"), (Collection)Lists.newArrayList((Object[])new String[]{"prop-xyz/use/ns1", "prop-xyz/use/ns2"}));
        try {
            this.admin.namespaces().createNamespace("prop-xyz/usc/ns1");
            Assert.fail((String)"Should not have passed");
        }
        catch (PulsarAdminException.NotAuthorizedException notAuthorizedException) {
            // empty catch block
        }
        this.clearCache();
        this.admin.namespaces().grantPermissionOnNamespace("prop-xyz/use/ns1", "my-role", EnumSet.allOf(AuthAction.class));
        Policies policies = new Policies();
        policies.bundles = PoliciesUtil.defaultBundle();
        policies.auth_policies.getNamespaceAuthentication().put("my-role", EnumSet.allOf(AuthAction.class));
        policies.is_allow_auto_update_schema = this.conf.isAllowAutoUpdateSchemaEnabled();
        Assert.assertEquals((Object)this.admin.namespaces().getPolicies("prop-xyz/use/ns1"), (Object)policies);
        Assert.assertEquals((Map)this.admin.namespaces().getPermissions("prop-xyz/use/ns1"), (Map)policies.auth_policies.getNamespaceAuthentication());
        Assert.assertEquals((Collection)this.admin.namespaces().getTopics("prop-xyz/use/ns1"), (Collection)Lists.newArrayList());
        this.admin.namespaces().revokePermissionsOnNamespace("prop-xyz/use/ns1", "my-role");
        policies.auth_policies.getNamespaceAuthentication().remove("my-role");
        policies.is_allow_auto_update_schema = this.conf.isAllowAutoUpdateSchemaEnabled();
        Assert.assertEquals((Object)this.admin.namespaces().getPolicies("prop-xyz/use/ns1"), (Object)policies);
        Assert.assertNull((Object)this.admin.namespaces().getPersistence("prop-xyz/use/ns1"));
        this.admin.namespaces().setPersistence("prop-xyz/use/ns1", new PersistencePolicies(3, 2, 1, 10.0));
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/use/ns1"), (Object)new PersistencePolicies(3, 2, 1, 10.0));
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://prop-xyz/use/ns1/my-topic").create();
        producer.close();
        this.admin.topics().delete("persistent://prop-xyz/use/ns1/my-topic");
        this.admin.namespaces().unloadNamespaceBundle("prop-xyz/use/ns1", "0x00000000_0xffffffff");
        NamespaceName ns = NamespaceName.get((String)"prop-xyz/use/ns1");
        NamespaceBundle defaultBundle = this.bundleFactory.getFullBundle(ns);
        for (i = 0; i < 10 && (data1 = (Optional)this.pulsar.getNamespaceService().getOwnershipCache().getOwnerAsync(defaultBundle).get()).isPresent(); ++i) {
            LOG.info("Waiting for unload namespace {} to complete. Current service unit isDisabled: {}", (Object)defaultBundle, (Object)((NamespaceEphemeralData)data1.get()).isDisabled());
            Thread.sleep(1000L);
        }
        Assert.assertTrue((i < 10 ? 1 : 0) != 0);
        this.admin.namespaces().deleteNamespace("prop-xyz/use/ns1");
        Assert.assertEquals((Collection)this.admin.namespaces().getNamespaces("prop-xyz", "use"), (Collection)Lists.newArrayList((Object[])new String[]{"prop-xyz/use/ns2"}));
        try {
            this.admin.namespaces().unload("prop-xyz/use/ns1");
            Assert.fail((String)"should have raised exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://prop-xyz/use/ns2/my-topic").create();
        producer.close();
        this.admin.topics().delete("persistent://prop-xyz/use/ns2/my-topic");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="topicName")
    public void persistentTopics(String topicName) throws Exception {
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList());
        String persistentTopicName = "persistent://prop-xyz/use/ns1/" + topicName;
        this.publishMessagesOnPersistentTopic("persistent://prop-xyz/use/ns1/" + topicName, 0);
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList((Object[])new String[]{"persistent://prop-xyz/use/ns1/" + topicName}));
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).statsInterval(0L, TimeUnit.SECONDS).build();
        try {
            String expectedMessage;
            int i;
            Consumer consumer = client.newConsumer().topic(new String[]{persistentTopicName}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Exclusive).subscribe();
            Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(persistentTopicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
            this.publishMessagesOnPersistentTopic("persistent://prop-xyz/use/ns1/" + topicName, 10);
            TopicStats topicStats = this.admin.topics().getStats(persistentTopicName);
            Assert.assertEquals(topicStats.getSubscriptions().keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"my-sub"})));
            Assert.assertEquals((int)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getConsumers().size(), (int)1);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getMsgBacklog(), (long)10L);
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)0);
            PersistentTopicInternalStats internalStats = this.admin.topics().getInternalStats(persistentTopicName, false);
            Assert.assertEquals(internalStats.cursors.keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"my-sub"})));
            List messages = this.admin.topics().peekMessages(persistentTopicName, "my-sub", 3);
            Assert.assertEquals((int)messages.size(), (int)3);
            for (i = 0; i < 3; ++i) {
                expectedMessage = "message-" + i;
                Assert.assertEquals((byte[])((Message)messages.get(i)).getData(), (byte[])expectedMessage.getBytes());
            }
            messages = this.admin.topics().peekMessages(persistentTopicName, "my-sub", 15);
            Assert.assertEquals((int)messages.size(), (int)10);
            for (i = 0; i < 10; ++i) {
                expectedMessage = "message-" + i;
                Assert.assertEquals((byte[])((Message)messages.get(i)).getData(), (byte[])expectedMessage.getBytes());
            }
            this.admin.topics().skipMessages(persistentTopicName, "my-sub", 5L);
            topicStats = this.admin.topics().getStats(persistentTopicName);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getMsgBacklog(), (long)5L);
            this.admin.topics().skipAllMessages(persistentTopicName, "my-sub");
            topicStats = this.admin.topics().getStats(persistentTopicName);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getMsgBacklog(), (long)0L);
            consumer.close();
            client.close();
            this.admin.topics().deleteSubscription(persistentTopicName, "my-sub");
            Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(persistentTopicName), (Collection)Lists.newArrayList());
            topicStats = this.admin.topics().getStats(persistentTopicName);
            Assert.assertEquals(topicStats.getSubscriptions().keySet(), (Set)Sets.newTreeSet());
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)0);
            try {
                this.admin.topics().skipAllMessages(persistentTopicName, "my-sub");
            }
            catch (PulsarAdminException.NotFoundException notFoundException) {
                // empty catch block
            }
            this.admin.topics().delete(persistentTopicName);
            try {
                this.admin.topics().delete(persistentTopicName);
                Assert.fail((String)"Should have received 404");
            }
            catch (PulsarAdminException.NotFoundException notFoundException) {
                // empty catch block
            }
            Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList());
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dataProvider="topicName")
    public void partitionedTopics(String topicName) throws Exception {
        Assert.assertEquals((Collection)this.admin.topics().getPartitionedTopicList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList());
        String partitionedTopicName = "persistent://prop-xyz/use/ns1/" + topicName;
        this.admin.topics().createPartitionedTopic(partitionedTopicName, 4);
        Assert.assertEquals((Collection)this.admin.topics().getPartitionedTopicList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList((Object[])new String[]{partitionedTopicName}));
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)partitionedTopicName).partitions, (int)4);
        List topics = this.admin.topics().getList("prop-xyz/use/ns1");
        Assert.assertEquals((int)topics.size(), (int)4);
        try {
            this.admin.topics().getPartitionedTopicMetadata("persistent://prop-xyz/use/ns1/ds2");
            Assert.fail((String)"getPartitionedTopicMetadata of persistent://prop-xyz/use/ns1/ds2 should not succeed");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).statsInterval(0L, TimeUnit.SECONDS).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{partitionedTopicName}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Exclusive).subscribe();
            Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(partitionedTopicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
            try {
                this.admin.topics().deleteSubscription(partitionedTopicName, "my-sub");
                Assert.fail((String)"should have failed");
            }
            catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
            List subscriptions = this.admin.topics().getSubscriptions(partitionedTopicName);
            Assert.assertEquals((int)subscriptions.size(), (int)1);
            Consumer consumer1 = client.newConsumer().topic(new String[]{partitionedTopicName}).subscriptionName("my-sub-1").subscribe();
            Assert.assertEquals((Set)Sets.newHashSet((Iterable)this.admin.topics().getSubscriptions(partitionedTopicName)), (Set)Sets.newHashSet((Object[])new String[]{"my-sub", "my-sub-1"}));
            consumer1.close();
            this.admin.topics().deleteSubscription(partitionedTopicName, "my-sub-1");
            Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(partitionedTopicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
            Producer producer = client.newProducer(Schema.BYTES).topic(partitionedTopicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.RoundRobinPartition).create();
            for (int i = 0; i < 10; ++i) {
                String message = "message-" + i;
                producer.send((Object)message.getBytes());
            }
            Assert.assertEquals((Set)Sets.newHashSet((Iterable)this.admin.topics().getList("prop-xyz/use/ns1")), (Set)Sets.newHashSet((Object[])new String[]{partitionedTopicName + "-partition-0", partitionedTopicName + "-partition-1", partitionedTopicName + "-partition-2", partitionedTopicName + "-partition-3"}));
            PartitionedTopicStats topicStats = this.admin.topics().getPartitionedStats(partitionedTopicName, false);
            Assert.assertEquals(topicStats.getSubscriptions().keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"my-sub"})));
            Assert.assertEquals((int)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getConsumers().size(), (int)1);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getMsgBacklog(), (long)10L);
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)1);
            Assert.assertEquals((Map)topicStats.getPartitions(), (Map)Maps.newHashMap());
            topicStats = this.admin.topics().getPartitionedStats(partitionedTopicName, true);
            Assert.assertEquals((int)topicStats.getMetadata().partitions, (int)4);
            Assert.assertEquals(topicStats.getPartitions().keySet(), (Set)Sets.newHashSet((Object[])new String[]{partitionedTopicName + "-partition-0", partitionedTopicName + "-partition-1", partitionedTopicName + "-partition-2", partitionedTopicName + "-partition-3"}));
            TopicStats partitionStats = (TopicStats)topicStats.getPartitions().get(partitionedTopicName + "-partition-0");
            Assert.assertEquals((int)partitionStats.getPublishers().size(), (int)1);
            Assert.assertEquals((int)((SubscriptionStats)partitionStats.getSubscriptions().get("my-sub")).getConsumers().size(), (int)1);
            Assert.assertEquals((float)((SubscriptionStats)partitionStats.getSubscriptions().get("my-sub")).getMsgBacklog(), (float)3.0f, (float)1.0f);
            try {
                this.admin.topics().skipMessages(partitionedTopicName, "my-sub", 5L);
                Assert.fail((String)"skip messages for partitioned topics should fail");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.admin.topics().skipAllMessages(partitionedTopicName, "my-sub");
            topicStats = this.admin.topics().getPartitionedStats(partitionedTopicName, false);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getMsgBacklog(), (long)0L);
            producer.close();
            consumer.close();
            this.admin.topics().deleteSubscription(partitionedTopicName, "my-sub");
            Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(partitionedTopicName), (Collection)Lists.newArrayList());
            try {
                this.admin.topics().createPartitionedTopic(partitionedTopicName, 32);
                Assert.fail((String)"Should have failed as the partitioned topic exists with its partition created");
            }
            catch (PulsarAdminException.ConflictException conflictException) {
                // empty catch block
            }
            producer = client.newProducer(Schema.BYTES).topic(partitionedTopicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
            topics = this.admin.topics().getList("prop-xyz/use/ns1");
            Assert.assertEquals((int)topics.size(), (int)4);
            try {
                this.admin.topics().deletePartitionedTopic(partitionedTopicName);
                Assert.fail((String)"The topic is busy");
            }
            catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
                // empty catch block
            }
            producer.close();
            client.close();
            this.admin.topics().deletePartitionedTopic(partitionedTopicName);
            try {
                this.admin.topics().getPartitionedTopicMetadata(partitionedTopicName);
                Assert.fail((String)("getPartitionedTopicMetadata of " + partitionedTopicName + " should not succeed"));
            }
            catch (PulsarAdminException.NotFoundException notFoundException) {
                // empty catch block
            }
            this.admin.topics().createPartitionedTopic(partitionedTopicName, 32);
            Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)partitionedTopicName).partitions, (int)32);
            try {
                this.admin.topics().deletePartitionedTopic("persistent://prop-xyz/use/ns1/ds2");
                Assert.fail((String)"Should have failed as the partitioned topic was not created");
            }
            catch (PulsarAdminException.NotFoundException notFoundException) {
                // empty catch block
            }
            this.admin.topics().deletePartitionedTopic(partitionedTopicName);
            this.admin.topics().createPartitionedTopic(partitionedTopicName, 4);
            this.admin.topics().deletePartitionedTopic(partitionedTopicName);
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test(dataProvider="numBundles")
    public void testDeleteNamespaceBundle(Integer numBundles) throws Exception {
        this.admin.namespaces().deleteNamespace("prop-xyz/use/ns1");
        this.admin.namespaces().createNamespace("prop-xyz/use/ns1-bundles", numBundles.intValue());
        this.admin.lookups().lookupTopic("persistent://prop-xyz/use/ns1-bundles/ds1");
        this.admin.lookups().lookupTopic("persistent://prop-xyz/use/ns1-bundles/ds2");
        this.admin.lookups().lookupTopic("persistent://prop-xyz/use/ns1-bundles/ds3");
        this.admin.lookups().lookupTopic("persistent://prop-xyz/use/ns1-bundles/ds4");
        Assert.assertEquals((Collection)this.admin.namespaces().getTopics("prop-xyz/use/ns1-bundles"), (Collection)Lists.newArrayList());
        this.admin.namespaces().deleteNamespace("prop-xyz/use/ns1-bundles");
        Assert.assertEquals((Collection)this.admin.namespaces().getNamespaces("prop-xyz", "use"), (Collection)Lists.newArrayList());
    }

    @Test
    public void testNamespaceSplitBundle() throws Exception {
        String namespace = "prop-xyz/use/ns1";
        String topicName = "persistent://prop-xyz/use/ns1/ds2";
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://prop-xyz/use/ns1/ds2").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        producer.send((Object)"message".getBytes());
        this.publishMessagesOnPersistentTopic("persistent://prop-xyz/use/ns1/ds2", 0);
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList((Object[])new String[]{"persistent://prop-xyz/use/ns1/ds2"}));
        try {
            this.admin.namespaces().splitNamespaceBundle("prop-xyz/use/ns1", "0x00000000_0xffffffff", true, null);
        }
        catch (Exception e) {
            Assert.fail((String)"split bundle shouldn't have thrown exception");
        }
        NamespaceBundles bundles = this.bundleFactory.getBundles(NamespaceName.get((String)"prop-xyz/use/ns1"));
        String[] splitRange = new String[]{"prop-xyz/use/ns1/0x00000000_0x7fffffff", "prop-xyz/use/ns1/0x7fffffff_0xffffffff"};
        for (int i = 0; i < bundles.getBundles().size(); ++i) {
            Assert.assertEquals((String)((NamespaceBundle)bundles.getBundles().get(i)).toString(), (String)splitRange[i]);
        }
        producer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamespaceSplitBundleConcurrent() throws Exception {
        String namespace = "prop-xyz/use/ns1";
        String topicName = "persistent://prop-xyz/use/ns1/ds2";
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://prop-xyz/use/ns1/ds2").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        producer.send((Object)"message".getBytes());
        this.publishMessagesOnPersistentTopic("persistent://prop-xyz/use/ns1/ds2", 0);
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList((Object[])new String[]{"persistent://prop-xyz/use/ns1/ds2"}));
        try {
            this.admin.namespaces().splitNamespaceBundle("prop-xyz/use/ns1", "0x00000000_0xffffffff", false, null);
        }
        catch (Exception e) {
            Assert.fail((String)"split bundle shouldn't have thrown exception");
        }
        NamespaceBundles bundles = this.bundleFactory.getBundles(NamespaceName.get((String)"prop-xyz/use/ns1"));
        String[] splitRange = new String[]{"prop-xyz/use/ns1/0x00000000_0x7fffffff", "prop-xyz/use/ns1/0x7fffffff_0xffffffff"};
        for (int i = 0; i < bundles.getBundles().size(); ++i) {
            Assert.assertEquals((String)((NamespaceBundle)bundles.getBundles().get(i)).toString(), (String)splitRange[i]);
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            try {
                executorService.invokeAll(Arrays.asList(() -> {
                    log.info("split 2 bundles at the same time. spilt: 0x00000000_0x7fffffff ");
                    this.admin.namespaces().splitNamespaceBundle("prop-xyz/use/ns1", "0x00000000_0x7fffffff", false, null);
                    return null;
                }, () -> {
                    log.info("split 2 bundles at the same time. spilt: 0x7fffffff_0xffffffff ");
                    this.admin.namespaces().splitNamespaceBundle("prop-xyz/use/ns1", "0x7fffffff_0xffffffff", false, null);
                    return null;
                }));
            }
            catch (Exception e) {
                Assert.fail((String)"split bundle shouldn't have thrown exception");
            }
            String[] splitRange4 = new String[]{"prop-xyz/use/ns1/0x00000000_0x3fffffff", "prop-xyz/use/ns1/0x3fffffff_0x7fffffff", "prop-xyz/use/ns1/0x7fffffff_0xbfffffff", "prop-xyz/use/ns1/0xbfffffff_0xffffffff"};
            bundles = this.bundleFactory.getBundles(NamespaceName.get((String)"prop-xyz/use/ns1"));
            Assert.assertEquals((int)bundles.getBundles().size(), (int)4);
            for (int i = 0; i < bundles.getBundles().size(); ++i) {
                Assert.assertEquals((String)((NamespaceBundle)bundles.getBundles().get(i)).toString(), (String)splitRange4[i]);
            }
            try {
                executorService.invokeAll(Arrays.asList(() -> {
                    log.info("split 4 bundles at the same time. spilt: 0x00000000_0x3fffffff ");
                    this.admin.namespaces().splitNamespaceBundle("prop-xyz/use/ns1", "0x00000000_0x3fffffff", false, null);
                    return null;
                }, () -> {
                    log.info("split 4 bundles at the same time. spilt: 0x3fffffff_0x7fffffff ");
                    this.admin.namespaces().splitNamespaceBundle("prop-xyz/use/ns1", "0x3fffffff_0x7fffffff", false, null);
                    return null;
                }, () -> {
                    log.info("split 4 bundles at the same time. spilt: 0x7fffffff_0xbfffffff ");
                    this.admin.namespaces().splitNamespaceBundle("prop-xyz/use/ns1", "0x7fffffff_0xbfffffff", false, null);
                    return null;
                }, () -> {
                    log.info("split 4 bundles at the same time. spilt: 0xbfffffff_0xffffffff ");
                    this.admin.namespaces().splitNamespaceBundle("prop-xyz/use/ns1", "0xbfffffff_0xffffffff", false, null);
                    return null;
                }));
            }
            catch (Exception e) {
                Assert.fail((String)"split bundle shouldn't have thrown exception");
            }
            String[] splitRange8 = new String[]{"prop-xyz/use/ns1/0x00000000_0x1fffffff", "prop-xyz/use/ns1/0x1fffffff_0x3fffffff", "prop-xyz/use/ns1/0x3fffffff_0x5fffffff", "prop-xyz/use/ns1/0x5fffffff_0x7fffffff", "prop-xyz/use/ns1/0x7fffffff_0x9fffffff", "prop-xyz/use/ns1/0x9fffffff_0xbfffffff", "prop-xyz/use/ns1/0xbfffffff_0xdfffffff", "prop-xyz/use/ns1/0xdfffffff_0xffffffff"};
            bundles = this.bundleFactory.getBundles(NamespaceName.get((String)"prop-xyz/use/ns1"));
            Assert.assertEquals((int)bundles.getBundles().size(), (int)8);
            for (int i = 0; i < bundles.getBundles().size(); ++i) {
                Assert.assertEquals((String)((NamespaceBundle)bundles.getBundles().get(i)).toString(), (String)splitRange8[i]);
            }
            producer.close();
        }
        finally {
            if (Collections.singletonList(executorService).get(0) != null) {
                executorService.shutdownNow();
            }
        }
    }

    @Test
    public void testNamespaceUnloadBundle() throws Exception {
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList());
        this.publishMessagesOnPersistentTopic("persistent://prop-xyz/use/ns1/ds2", 0);
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList((Object[])new String[]{"persistent://prop-xyz/use/ns1/ds2"}));
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1/ds2"}).subscriptionName("my-sub").subscribe();
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions("persistent://prop-xyz/use/ns1/ds2"), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://prop-xyz/use/ns1/ds2").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = 0; i < 10; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        consumer.close();
        producer.close();
        try {
            this.admin.namespaces().unloadNamespaceBundle("prop-xyz/use/ns1", "0x00000000_0xffffffff");
        }
        catch (Exception e) {
            Assert.fail((String)"Unload shouldn't have throw exception");
        }
        NamespaceBundle bundle = this.bundleFactory.getBundle(NamespaceName.get((String)"prop-xyz/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0xFFFFFFFFL), (BoundType)BoundType.CLOSED));
        Assert.assertFalse((boolean)this.pulsar.getNamespaceService().isServiceUnitOwned((ServiceUnitId)bundle));
        Assert.assertFalse((boolean)this.otherPulsar.getNamespaceService().isServiceUnitOwned((ServiceUnitId)bundle));
        this.pulsarClient.shutdown();
        LOG.info("--- RELOAD ---");
        for (int i = 0; i < 30; ++i) {
            try {
                this.admin.topics().getStats("persistent://prop-xyz/use/ns1/ds2");
                break;
            }
            catch (PulsarAdminException e) {
                LOG.warn("Failed to get topic stats.. {}", (Object)e.getMessage());
                Thread.sleep(1000L);
                continue;
            }
        }
        this.admin.topics().deleteSubscription("persistent://prop-xyz/use/ns1/ds2", "my-sub");
        this.admin.topics().delete("persistent://prop-xyz/use/ns1/ds2");
    }

    @Test(dataProvider="numBundles")
    public void testNamespaceBundleUnload(Integer numBundles) throws Exception {
        this.admin.namespaces().createNamespace("prop-xyz/use/ns1-bundles", numBundles.intValue());
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1-bundles"), (Collection)Lists.newArrayList());
        this.publishMessagesOnPersistentTopic("persistent://prop-xyz/use/ns1-bundles/ds2", 0);
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1-bundles"), (Collection)Lists.newArrayList((Object[])new String[]{"persistent://prop-xyz/use/ns1-bundles/ds2"}));
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds2"}).subscriptionName("my-sub").subscribe();
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions("persistent://prop-xyz/use/ns1-bundles/ds2"), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://prop-xyz/use/ns1-bundles/ds2").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = 0; i < 10; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        NamespaceBundle bundle = this.pulsar.getNamespaceService().getBundle(TopicName.get((String)"persistent://prop-xyz/use/ns1-bundles/ds2"));
        consumer.close();
        producer.close();
        this.admin.namespaces().unloadNamespaceBundle("prop-xyz/use/ns1-bundles", bundle.getBundleRange());
        Assert.assertFalse((boolean)this.pulsar.getNamespaceService().isServiceUnitOwned((ServiceUnitId)bundle));
        Assert.assertFalse((boolean)this.otherPulsar.getNamespaceService().isServiceUnitOwned((ServiceUnitId)bundle));
        LOG.info("--- RELOAD ---");
        for (int i = 0; i < 30; ++i) {
            try {
                this.admin.topics().getStats("persistent://prop-xyz/use/ns1-bundles/ds2");
                break;
            }
            catch (PulsarAdminException e) {
                LOG.warn("Failed to get topic stats.. {}", (Object)e.getMessage());
                Thread.sleep(1000L);
                continue;
            }
        }
        this.admin.topics().deleteSubscription("persistent://prop-xyz/use/ns1-bundles/ds2", "my-sub");
        this.admin.topics().delete("persistent://prop-xyz/use/ns1-bundles/ds2");
    }

    @Test(dataProvider="bundling")
    public void testClearBacklogOnNamespace(Integer numBundles) throws Exception {
        this.admin.namespaces().createNamespace("prop-xyz/use/ns1-bundles", numBundles.intValue());
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds2"}).subscriptionName("my-sub").subscribe();
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds2"}).subscriptionName("my-sub-1").subscribe();
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds2"}).subscriptionName("my-sub-2").subscribe();
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds1"}).subscriptionName("my-sub").subscribe();
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds1"}).subscriptionName("my-sub-1").subscribe();
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://prop-xyz/use/ns1-bundles/ds2").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = 0; i < 10; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        producer.close();
        Producer producer1 = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://prop-xyz/use/ns1-bundles/ds1").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = 0; i < 10; ++i) {
            String message = "message-" + i;
            producer1.send((Object)message.getBytes());
        }
        producer1.close();
        this.admin.namespaces().clearNamespaceBacklogForSubscription("prop-xyz/use/ns1-bundles", "my-sub");
        long backlog = ((SubscriptionStats)this.admin.topics().getStats("persistent://prop-xyz/use/ns1-bundles/ds2").getSubscriptions().get("my-sub")).getMsgBacklog();
        Assert.assertEquals((long)backlog, (long)0L);
        backlog = ((SubscriptionStats)this.admin.topics().getStats("persistent://prop-xyz/use/ns1-bundles/ds1").getSubscriptions().get("my-sub")).getMsgBacklog();
        Assert.assertEquals((long)backlog, (long)0L);
        backlog = ((SubscriptionStats)this.admin.topics().getStats("persistent://prop-xyz/use/ns1-bundles/ds1").getSubscriptions().get("my-sub-1")).getMsgBacklog();
        Assert.assertEquals((long)backlog, (long)10L);
        this.admin.namespaces().clearNamespaceBacklog("prop-xyz/use/ns1-bundles");
        backlog = ((SubscriptionStats)this.admin.topics().getStats("persistent://prop-xyz/use/ns1-bundles/ds1").getSubscriptions().get("my-sub-1")).getMsgBacklog();
        Assert.assertEquals((long)backlog, (long)0L);
        backlog = ((SubscriptionStats)this.admin.topics().getStats("persistent://prop-xyz/use/ns1-bundles/ds2").getSubscriptions().get("my-sub-1")).getMsgBacklog();
        Assert.assertEquals((long)backlog, (long)0L);
        backlog = ((SubscriptionStats)this.admin.topics().getStats("persistent://prop-xyz/use/ns1-bundles/ds2").getSubscriptions().get("my-sub-2")).getMsgBacklog();
        Assert.assertEquals((long)backlog, (long)0L);
    }

    @Test(dataProvider="bundling")
    public void testUnsubscribeOnNamespace(Integer numBundles) throws Exception {
        this.admin.namespaces().createNamespace("prop-xyz/use/ns1-bundles", numBundles.intValue());
        Consumer consumer1 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds2"}).subscriptionName("my-sub").subscribe();
        Consumer consumer2 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds2"}).subscriptionName("my-sub-1").subscribe();
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds2"}).subscriptionName("my-sub-2").subscribe();
        Consumer consumer4 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds1"}).subscriptionName("my-sub").subscribe();
        Consumer consumer5 = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1-bundles/ds1"}).subscriptionName("my-sub-1").subscribe();
        try {
            this.admin.namespaces().unsubscribeNamespace("prop-xyz/use/ns1-bundles", "my-sub");
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
        consumer1.close();
        try {
            this.admin.namespaces().unsubscribeNamespace("prop-xyz/use/ns1-bundles", "my-sub");
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
        consumer4.close();
        this.admin.namespaces().unsubscribeNamespace("prop-xyz/use/ns1-bundles", "my-sub");
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions("persistent://prop-xyz/use/ns1-bundles/ds2"), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub-1", "my-sub-2"}));
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions("persistent://prop-xyz/use/ns1-bundles/ds1"), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub-1"}));
        consumer2.close();
        consumer5.close();
        this.admin.namespaces().unsubscribeNamespace("prop-xyz/use/ns1-bundles", "my-sub-1");
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions("persistent://prop-xyz/use/ns1-bundles/ds2"), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub-2"}));
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions("persistent://prop-xyz/use/ns1-bundles/ds1"), (Collection)Lists.newArrayList());
    }

    private void publishMessagesOnPersistentTopic(String topicName, int messages) throws Exception {
        this.publishMessagesOnPersistentTopic(topicName, messages, 0);
    }

    private void publishMessagesOnPersistentTopic(String topicName, int messages, int startIdx) throws Exception {
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = startIdx; i < messages + startIdx; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        producer.close();
    }

    @Test
    public void backlogQuotas() throws Exception {
        Assert.assertEquals((Map)this.admin.namespaces().getBacklogQuotaMap("prop-xyz/use/ns1"), (Map)Maps.newHashMap());
        Map quotaMap = this.admin.namespaces().getBacklogQuotaMap("prop-xyz/use/ns1");
        Assert.assertEquals((int)quotaMap.size(), (int)0);
        Assert.assertNull(quotaMap.get(BacklogQuota.BacklogQuotaType.destination_storage));
        this.admin.namespaces().setBacklogQuota("prop-xyz/use/ns1", BacklogQuota.builder().limitSize(0x100000L).retentionPolicy(BacklogQuota.RetentionPolicy.producer_exception).build());
        quotaMap = this.admin.namespaces().getBacklogQuotaMap("prop-xyz/use/ns1");
        Assert.assertEquals((int)quotaMap.size(), (int)1);
        Assert.assertEquals(quotaMap.get(BacklogQuota.BacklogQuotaType.destination_storage), (Object)BacklogQuota.builder().limitSize(0x100000L).retentionPolicy(BacklogQuota.RetentionPolicy.producer_exception).build());
        this.admin.namespaces().removeBacklogQuota("prop-xyz/use/ns1");
        quotaMap = this.admin.namespaces().getBacklogQuotaMap("prop-xyz/use/ns1");
        Assert.assertEquals((int)quotaMap.size(), (int)0);
        Assert.assertNull(quotaMap.get(BacklogQuota.BacklogQuotaType.destination_storage));
    }

    @Test
    public void statsOnNonExistingTopics() throws Exception {
        try {
            this.admin.topics().getStats("persistent://prop-xyz/use/ns1/ghostTopic");
            Assert.fail((String)"The topic doesn't exist");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteFailedReturnCode() throws Exception {
        String topicName = "persistent://prop-xyz/use/ns1/my-topic";
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        try {
            this.admin.topics().delete(topicName);
            Assert.fail((String)"The topic is busy");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
        producer.close();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("sub").subscribe();
        try {
            this.admin.topics().delete(topicName);
            Assert.fail((String)"The topic is busy");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
        try {
            this.admin.topics().deleteSubscription(topicName, "sub");
            Assert.fail((String)"The topic is busy");
        }
        catch (PulsarAdminException.PreconditionFailedException preconditionFailedException) {
            // empty catch block
        }
        consumer.close();
        this.admin.topics().delete(topicName);
    }

    @Test
    public void testJacksonWithTypeDifferencies() throws Exception {
        String expectedJson = "{\"adminRoles\":[\"role1\",\"role2\"],\"allowedClusters\":[\"usw\",\"use\"]}";
        IncompatiblePropertyAdmin r1 = (IncompatiblePropertyAdmin)ObjectMapperFactory.getThreadLocal().readerFor(IncompatiblePropertyAdmin.class).readValue(expectedJson);
        Assert.assertEquals(r1.allowedClusters, (Set)Sets.newHashSet((Object[])new String[]{"use", "usw"}));
        Assert.assertEquals((int)r1.someNewIntField, (int)0);
        Assert.assertNull((Object)r1.someNewString);
    }

    @Test
    public void testBackwardCompatiblity() throws Exception {
        Assert.assertEquals((Collection)this.admin.tenants().getTenants(), (Collection)Lists.newArrayList((Object[])new String[]{"prop-xyz"}));
        Assert.assertEquals((Collection)this.admin.tenants().getTenantInfo("prop-xyz").getAdminRoles(), (Collection)Lists.newArrayList((Object[])new String[]{"role1", "role2"}));
        Assert.assertEquals((Set)this.admin.tenants().getTenantInfo("prop-xyz").getAllowedClusters(), (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        TenantsImpl properties = (TenantsImpl)this.admin.tenants();
        IncompatiblePropertyAdmin result = (IncompatiblePropertyAdmin)properties.request(properties.getWebTarget().path("prop-xyz")).get(IncompatiblePropertyAdmin.class);
        Assert.assertEquals(result.allowedClusters, (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        Assert.assertEquals((int)result.someNewIntField, (int)0);
        Assert.assertNull((Object)result.someNewString);
        this.admin.namespaces().deleteNamespace("prop-xyz/use/ns1");
        this.admin.tenants().deleteTenant("prop-xyz");
        Assert.assertEquals((Collection)this.admin.tenants().getTenants(), (Collection)Lists.newArrayList());
    }

    @Test(dataProvider="topicName")
    public void persistentTopicsCursorReset(String topicName) throws Exception {
        this.admin.namespaces().setRetention("prop-xyz/use/ns1", new RetentionPolicies(10, 10));
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList());
        topicName = "persistent://prop-xyz/use/ns1/" + topicName;
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").startMessageIdInclusive().subscriptionType(SubscriptionType.Exclusive).acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
        this.publishMessagesOnPersistentTopic(topicName, 5, 0);
        Thread.sleep(1L);
        long messageTimestamp = System.currentTimeMillis();
        this.publishMessagesOnPersistentTopic(topicName, 5, 5);
        List messages = this.admin.topics().peekMessages(topicName, "my-sub", 10);
        Assert.assertEquals((int)messages.size(), (int)10);
        for (int i = 0; i < 10; ++i) {
            Message message = consumer.receive();
            consumer.acknowledge(message);
        }
        this.admin.topics().resetCursor(topicName, "my-sub", messageTimestamp);
        int receivedAfterReset = 0;
        for (int i = 5; i < 10; ++i) {
            Message message = consumer.receive();
            consumer.acknowledge(message);
            ++receivedAfterReset;
            String expected = "message-" + i;
            Assert.assertEquals((byte[])message.getData(), (byte[])expected.getBytes());
        }
        Assert.assertEquals((int)receivedAfterReset, (int)5);
        consumer.close();
        this.admin.topics().deleteSubscription(topicName, "my-sub");
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList());
        this.admin.topics().delete(topicName);
    }

    @Test(dataProvider="topicName")
    public void persistentTopicsCursorResetAfterReset(String topicName) throws Exception {
        String expected;
        Message message2;
        int i;
        this.admin.namespaces().setRetention("prop-xyz/use/ns1", new RetentionPolicies(10, 10));
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList());
        topicName = "persistent://prop-xyz/use/ns1/" + topicName;
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").startMessageIdInclusive().subscriptionType(SubscriptionType.Exclusive).acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
        this.publishMessagesOnPersistentTopic(topicName, 5, 0);
        Thread.sleep(1L);
        long firstTimestamp = System.currentTimeMillis();
        this.publishMessagesOnPersistentTopic(topicName, 3, 5);
        Thread.sleep(1L);
        long secondTimestamp = System.currentTimeMillis();
        this.publishMessagesOnPersistentTopic(topicName, 2, 8);
        List messages = this.admin.topics().peekMessages(topicName, "my-sub", 10);
        Assert.assertEquals((int)messages.size(), (int)10);
        messages.forEach(message -> LOG.info("Peeked message: {}", (Object)new String(message.getData())));
        for (int i2 = 0; i2 < 10; ++i2) {
            Message message3 = consumer.receive();
            consumer.acknowledge(message3);
        }
        this.admin.topics().resetCursor(topicName, "my-sub", firstTimestamp);
        int receivedAfterReset = 0;
        for (i = 5; i < 10; ++i) {
            message2 = consumer.receive();
            consumer.acknowledge(message2);
            ++receivedAfterReset;
            expected = "message-" + i;
            Assert.assertEquals((String)new String(message2.getData()), (String)expected);
        }
        Assert.assertEquals((int)receivedAfterReset, (int)5);
        receivedAfterReset = 0;
        this.admin.topics().resetCursor(topicName, "my-sub", secondTimestamp);
        for (i = 8; i < 10; ++i) {
            message2 = consumer.receive();
            consumer.acknowledge(message2);
            ++receivedAfterReset;
            expected = "message-" + i;
            Assert.assertEquals((String)new String(message2.getData()), (String)expected);
        }
        Assert.assertEquals((int)receivedAfterReset, (int)2);
        consumer.close();
        this.admin.topics().deleteSubscription(topicName, "my-sub");
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList());
        this.admin.topics().delete(topicName);
    }

    @Test(dataProvider="topicName")
    public void partitionedTopicsCursorReset(String topicName) throws Exception {
        this.admin.namespaces().setRetention("prop-xyz/use/ns1", new RetentionPolicies(10, 10));
        topicName = "persistent://prop-xyz/use/ns1/" + topicName;
        this.admin.topics().createPartitionedTopic(topicName, 4);
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").startMessageIdInclusive().subscriptionType(SubscriptionType.Exclusive).acknowledgmentGroupTime(0L, TimeUnit.SECONDS).subscribe();
        List topics = this.admin.topics().getList("prop-xyz/use/ns1");
        Assert.assertEquals((int)topics.size(), (int)4);
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
        this.publishMessagesOnPersistentTopic(topicName, 5, 0);
        Thread.sleep(1L);
        long timestamp = System.currentTimeMillis();
        this.publishMessagesOnPersistentTopic(topicName, 5, 5);
        for (int i = 0; i < 10; ++i) {
            Message message = consumer.receive();
            consumer.acknowledge(message);
        }
        this.admin.topics().resetCursor(topicName, "my-sub", timestamp);
        HashSet expectedMessages = Sets.newHashSet();
        HashSet receivedMessages = Sets.newHashSet();
        for (int i = 5; i < 10; ++i) {
            Message message = consumer.receive();
            consumer.acknowledge(message);
            expectedMessages.add("message-" + i);
            receivedMessages.add(new String(message.getData()));
        }
        receivedMessages.removeAll(expectedMessages);
        Assert.assertEquals((int)receivedMessages.size(), (int)0);
        consumer.close();
        this.admin.topics().deleteSubscription(topicName, "my-sub");
        this.admin.topics().deletePartitionedTopic(topicName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void persistentTopicsInvalidCursorReset() throws Exception {
        this.admin.namespaces().setRetention("prop-xyz/use/ns1", new RetentionPolicies(10, 10));
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList());
        String topicName = "persistent://prop-xyz/use/ns1/invalidcursorreset";
        this.publishMessagesOnPersistentTopic(topicName, 0);
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList((Object[])new String[]{topicName}));
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).statsInterval(0L, TimeUnit.SECONDS).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Exclusive).subscribe();
            Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
            this.publishMessagesOnPersistentTopic(topicName, 10);
            List messages = this.admin.topics().peekMessages(topicName, "my-sub", 10);
            Assert.assertEquals((int)messages.size(), (int)10);
            for (int i = 0; i < 10; ++i) {
                Message message = consumer.receive();
                consumer.acknowledge(message);
            }
            this.admin.topics().resetCursor(topicName, "my-sub", System.currentTimeMillis() - 190000L);
            this.admin.topics().resetCursor(topicName, "my-sub", System.currentTimeMillis() + 90000L);
            consumer = client.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").subscribe();
            consumer.close();
            client.close();
            this.admin.topics().deleteSubscription(topicName, "my-sub");
            Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList());
            this.admin.topics().delete(topicName);
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test
    public void testObjectWithUnknownProperties() {
        TenantInfo pa = TenantInfo.builder().adminRoles((Set)Sets.newHashSet((Object[])new String[]{"test_appid1", "test_appid2"})).allowedClusters((Set)Sets.newHashSet((Object[])new String[]{"use"})).build();
        CustomTenantAdmin cpa = CustomTenantAdmin.builder().adminRoles(pa.getAdminRoles()).allowedClusters(pa.getAllowedClusters()).newTenant(100).build();
        try {
            this.admin.tenants().createTenant("test-property", (TenantInfo)cpa);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not happen : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistentTopicsExpireMessages() throws Exception {
        this.publishMessagesOnPersistentTopic("persistent://prop-xyz/use/ns1/ds2", 0);
        Assert.assertEquals((Collection)this.admin.topics().getList("prop-xyz/use/ns1"), (Collection)Lists.newArrayList((Object[])new String[]{"persistent://prop-xyz/use/ns1/ds2"}));
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).statsInterval(0L, TimeUnit.SECONDS).build();
        try {
            ConsumerBuilder consumerBuilder = client.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1/ds2"}).subscriptionType(SubscriptionType.Shared);
            Consumer consumer1 = consumerBuilder.clone().subscriptionName("my-sub1").subscribe();
            Consumer consumer2 = consumerBuilder.clone().subscriptionName("my-sub2").subscribe();
            Consumer consumer3 = consumerBuilder.clone().subscriptionName("my-sub3").subscribe();
            Assert.assertEquals((int)this.admin.topics().getSubscriptions("persistent://prop-xyz/use/ns1/ds2").size(), (int)3);
            this.publishMessagesOnPersistentTopic("persistent://prop-xyz/use/ns1/ds2", 10);
            TopicStats topicStats = this.admin.topics().getStats("persistent://prop-xyz/use/ns1/ds2");
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub1")).getMsgBacklog(), (long)10L);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub2")).getMsgBacklog(), (long)10L);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub3")).getMsgBacklog(), (long)10L);
            Thread.sleep(1000L);
            this.admin.topics().expireMessages("persistent://prop-xyz/use/ns1/ds2", "my-sub1", 1L);
            Thread.sleep(1000L);
            topicStats = this.admin.topics().getStats("persistent://prop-xyz/use/ns1/ds2");
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub1")).getMsgBacklog(), (long)0L);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub2")).getMsgBacklog(), (long)10L);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub3")).getMsgBacklog(), (long)10L);
            try {
                this.admin.topics().expireMessagesForAllSubscriptions("persistent://prop-xyz/use/ns1/ds2", 1L);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)e.getMessage().startsWith("Expire message by timestamp not issued on topic"));
            }
            Thread.sleep(1000L);
            topicStats = this.admin.topics().getStats("persistent://prop-xyz/use/ns1/ds2");
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub1")).getMsgBacklog(), (long)0L);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub2")).getMsgBacklog(), (long)0L);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub3")).getMsgBacklog(), (long)0L);
            consumer1.close();
            consumer2.close();
            consumer3.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPersistentTopicExpireMessageOnPartitionTopic() throws Exception {
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/use/ns1/ds1", 4);
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).statsInterval(0L, TimeUnit.SECONDS).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1/ds1"}).subscriptionName("my-sub").subscribe();
            Producer producer = client.newProducer(Schema.BYTES).topic("persistent://prop-xyz/use/ns1/ds1").enableBatching(false).messageRoutingMode(MessageRoutingMode.RoundRobinPartition).create();
            for (int i = 0; i < 10; ++i) {
                String message = "message-" + i;
                producer.send((Object)message.getBytes());
            }
            PartitionedTopicStats topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/use/ns1/ds1", true);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getMsgBacklog(), (long)10L);
            TopicStats partitionStatsPartition0 = (TopicStats)topicStats.getPartitions().get("persistent://prop-xyz/use/ns1/ds1-partition-0");
            TopicStats partitionStatsPartition1 = (TopicStats)topicStats.getPartitions().get("persistent://prop-xyz/use/ns1/ds1-partition-1");
            Assert.assertEquals((float)((SubscriptionStats)partitionStatsPartition0.getSubscriptions().get("my-sub")).getMsgBacklog(), (float)3.0f, (float)1.0f);
            Assert.assertEquals((float)((SubscriptionStats)partitionStatsPartition1.getSubscriptions().get("my-sub")).getMsgBacklog(), (float)3.0f, (float)1.0f);
            Thread.sleep(1000L);
            this.admin.topics().expireMessagesForAllSubscriptions("persistent://prop-xyz/use/ns1/ds1", 1L);
            Thread.sleep(1000L);
            topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/use/ns1/ds1", true);
            partitionStatsPartition0 = (TopicStats)topicStats.getPartitions().get("persistent://prop-xyz/use/ns1/ds1-partition-0");
            partitionStatsPartition1 = (TopicStats)topicStats.getPartitions().get("persistent://prop-xyz/use/ns1/ds1-partition-1");
            Assert.assertEquals((long)((SubscriptionStats)partitionStatsPartition0.getSubscriptions().get("my-sub")).getMsgBacklog(), (long)0L);
            Assert.assertEquals((long)((SubscriptionStats)partitionStatsPartition1.getSubscriptions().get("my-sub")).getMsgBacklog(), (long)0L);
            producer.close();
            consumer.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test(dataProvider="topicName")
    public void testPulsarAdminForUriAndUrlEncoding(String topicName) throws Exception {
        String ns1 = "prop-xyz/use/ns1";
        String topic1 = "persistent://prop-xyz/use/ns1/" + topicName;
        String urlEncodedTopic = Codec.encode((String)topicName);
        String uriEncodedTopic = urlEncodedTopic.replaceAll("\\+", "%20");
        int numOfPartitions = 4;
        this.admin.topics().createPartitionedTopic(topic1, 4);
        this.pulsarClient.newConsumer().topic(new String[]{topic1}).subscriptionName("my-subscriber-name").subscribe();
        TopicsImpl persistent = (TopicsImpl)this.admin.topics();
        Field field = TopicsImpl.class.getDeclaredField("adminTopics");
        field.setAccessible(true);
        WebTarget persistentTopics = ((WebTarget)field.get(persistent)).path("persistent");
        final CompletableFuture urlEncodedPartitionedMetadata = new CompletableFuture();
        persistent.asyncGetRequest(persistentTopics.path("prop-xyz/use/ns1").path(urlEncodedTopic).path("partitions"), (InvocationCallback)new InvocationCallback<PartitionedTopicMetadata>(){

            public void completed(PartitionedTopicMetadata response) {
                urlEncodedPartitionedMetadata.complete(response);
            }

            public void failed(Throwable e) {
                urlEncodedPartitionedMetadata.completeExceptionally(e);
            }
        });
        final CompletableFuture uriEncodedPartitionedMetadata = new CompletableFuture();
        persistent.asyncGetRequest(persistentTopics.path("prop-xyz/use/ns1").path(uriEncodedTopic).path("partitions"), (InvocationCallback)new InvocationCallback<PartitionedTopicMetadata>(){

            public void completed(PartitionedTopicMetadata response) {
                uriEncodedPartitionedMetadata.complete(response);
            }

            public void failed(Throwable e) {
                uriEncodedPartitionedMetadata.completeExceptionally(e);
            }
        });
        Assert.assertEquals((int)((PartitionedTopicMetadata)urlEncodedPartitionedMetadata.get()).partitions, (int)4);
        Assert.assertEquals((int)((PartitionedTopicMetadata)urlEncodedPartitionedMetadata.get()).partitions, (int)((PartitionedTopicMetadata)uriEncodedPartitionedMetadata.get()).partitions);
        LookupImpl lookup = (LookupImpl)this.admin.lookups();
        Field field2 = LookupImpl.class.getDeclaredField("v2lookup");
        field2.setAccessible(true);
        WebTarget target2 = (WebTarget)field2.get(lookup);
        LookupData urlEncodedLookupData = (LookupData)lookup.request(target2.path("/destination/persistent").path("prop-xyz/use/ns1/" + urlEncodedTopic)).get(LookupData.class);
        LookupData uriEncodedLookupData = (LookupData)lookup.request(target2.path("/destination/persistent").path("prop-xyz/use/ns1/" + uriEncodedTopic)).get(LookupData.class);
        Assert.assertNotNull((Object)urlEncodedLookupData.getBrokerUrl());
        Assert.assertEquals((String)urlEncodedLookupData.getBrokerUrl(), (String)uriEncodedLookupData.getBrokerUrl());
        final CompletableFuture urlStats = new CompletableFuture();
        persistent.asyncGetRequest(persistentTopics.path("prop-xyz/use/ns1").path(urlEncodedTopic + "-partition-1").path("stats"), (InvocationCallback)new InvocationCallback<TopicStats>(){

            public void completed(TopicStats response) {
                urlStats.complete(response);
            }

            public void failed(Throwable e) {
                urlStats.completeExceptionally(e);
            }
        });
        final CompletableFuture uriStats = new CompletableFuture();
        persistent.asyncGetRequest(persistentTopics.path("prop-xyz/use/ns1").path(uriEncodedTopic + "-partition-1").path("stats"), (InvocationCallback)new InvocationCallback<TopicStats>(){

            public void completed(TopicStats response) {
                uriStats.complete(response);
            }

            public void failed(Throwable e) {
                uriStats.completeExceptionally(e);
            }
        });
        Assert.assertEquals((int)((TopicStats)urlStats.get()).getSubscriptions().size(), (int)1);
        Assert.assertEquals((int)((TopicStats)uriStats.get()).getSubscriptions().size(), (int)1);
    }

    @Test
    public void testTopicBundleRangeLookup() throws Exception {
        this.admin.clusters().createCluster("usw", ClusterData.builder().build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use", "usw"}));
        this.admin.tenants().updateTenant("prop-xyz", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/use/getBundleNs", 100);
        Assert.assertEquals((int)this.admin.namespaces().getPolicies((String)"prop-xyz/use/getBundleNs").bundles.getNumBundles(), (int)100);
        String topicName = "persistent://prop-xyz/use/getBundleNs/topic1";
        String bundleRange = this.admin.lookups().getBundleRange("persistent://prop-xyz/use/getBundleNs/topic1");
        Assert.assertEquals((String)bundleRange, (String)this.pulsar.getNamespaceService().getBundle(TopicName.get((String)"persistent://prop-xyz/use/getBundleNs/topic1")).getBundleRange());
    }

    @Test
    public void testTriggerCompaction() throws Exception {
        String topicName = "persistent://prop-xyz/use/ns1/topic1";
        this.pulsarClient.newProducer(Schema.BYTES).topic(topicName).create().close();
        Assert.assertNotNull((Object)this.pulsar.getBrokerService().getTopicReference(topicName));
        CompletableFuture<Long> promise = new CompletableFuture<Long>();
        Compactor compactor = this.pulsar.getCompactor();
        ((Compactor)Mockito.doReturn(promise).when((Object)compactor)).compact(topicName);
        this.admin.topics().triggerCompaction(topicName);
        ((Compactor)Mockito.verify((Object)compactor)).compact(topicName);
        try {
            this.admin.topics().triggerCompaction(topicName);
            Assert.fail((String)"Shouldn't be able to run while already running");
        }
        catch (PulsarAdminException.ConflictException conflictException) {
            // empty catch block
        }
        ((Compactor)Mockito.verify((Object)compactor)).compact(topicName);
        promise.complete(1L);
        this.admin.topics().triggerCompaction(topicName);
        ((Compactor)Mockito.verify((Object)compactor, (VerificationMode)Mockito.times((int)2))).compact(topicName);
    }

    @Test
    public void testCompactionStatus() throws Exception {
        String topicName = "persistent://prop-xyz/use/ns1/topic1";
        this.pulsarClient.newProducer(Schema.BYTES).topic(topicName).create().close();
        Assert.assertNotNull((Object)this.pulsar.getBrokerService().getTopicReference(topicName));
        Assert.assertEquals((Object)this.admin.topics().compactionStatus((String)topicName).status, (Object)LongRunningProcessStatus.Status.NOT_RUN);
        CompletableFuture<Long> promise = new CompletableFuture<Long>();
        Compactor compactor = this.pulsar.getCompactor();
        ((Compactor)Mockito.doReturn(promise).when((Object)compactor)).compact(topicName);
        this.admin.topics().triggerCompaction(topicName);
        Assert.assertEquals((Object)this.admin.topics().compactionStatus((String)topicName).status, (Object)LongRunningProcessStatus.Status.RUNNING);
        promise.complete(1L);
        Assert.assertEquals((Object)this.admin.topics().compactionStatus((String)topicName).status, (Object)LongRunningProcessStatus.Status.SUCCESS);
        CompletableFuture errorPromise = new CompletableFuture();
        ((Compactor)Mockito.doReturn(errorPromise).when((Object)compactor)).compact(topicName);
        this.admin.topics().triggerCompaction(topicName);
        errorPromise.completeExceptionally(new Exception("Failed at something"));
        Assert.assertEquals((Object)this.admin.topics().compactionStatus((String)topicName).status, (Object)LongRunningProcessStatus.Status.ERROR);
        Assert.assertTrue((boolean)this.admin.topics().compactionStatus((String)topicName).lastError.contains("Failed at something"));
    }

    private void clearCache() {
        ((MetadataCacheImpl)this.pulsar.getPulsarResources().getNamespaceResources().getCache()).invalidateAll();
    }

    static class MockedPulsarService
    extends MockedPulsarServiceBaseTest {
        private final ServiceConfiguration conf;

        public MockedPulsarService(ServiceConfiguration conf) {
            this.conf = conf;
        }

        @Override
        protected void setup() throws Exception {
            ((MockedPulsarServiceBaseTest)this).conf.setLoadManagerClassName(this.conf.getLoadManagerClassName());
            super.internalSetup();
        }

        @Override
        protected void cleanup() throws Exception {
            super.internalCleanup();
        }

        @Override
        public PulsarService getPulsar() {
            return this.pulsar;
        }

        public PulsarAdmin getAdmin() {
            return this.admin;
        }
    }

    static final class CustomTenantAdmin
    implements TenantInfo {
        private final int newTenant;
        private final Set<String> adminRoles;
        private final Set<String> allowedClusters;

        CustomTenantAdmin(int newTenant, Set<String> adminRoles, Set<String> allowedClusters) {
            this.newTenant = newTenant;
            this.adminRoles = adminRoles;
            this.allowedClusters = allowedClusters;
        }

        public static CustomTenantAdminBuilder builder() {
            return new CustomTenantAdminBuilder();
        }

        public int getNewTenant() {
            return this.newTenant;
        }

        public Set<String> getAdminRoles() {
            return this.adminRoles;
        }

        public Set<String> getAllowedClusters() {
            return this.allowedClusters;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomTenantAdmin)) {
                return false;
            }
            CustomTenantAdmin other = (CustomTenantAdmin)o;
            if (this.getNewTenant() != other.getNewTenant()) {
                return false;
            }
            Set<String> this$adminRoles = this.getAdminRoles();
            Set<String> other$adminRoles = other.getAdminRoles();
            if (this$adminRoles == null ? other$adminRoles != null : !((Object)this$adminRoles).equals(other$adminRoles)) {
                return false;
            }
            Set<String> this$allowedClusters = this.getAllowedClusters();
            Set<String> other$allowedClusters = other.getAllowedClusters();
            return !(this$allowedClusters == null ? other$allowedClusters != null : !((Object)this$allowedClusters).equals(other$allowedClusters));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNewTenant();
            Set<String> $adminRoles = this.getAdminRoles();
            result = result * 59 + ($adminRoles == null ? 43 : ((Object)$adminRoles).hashCode());
            Set<String> $allowedClusters = this.getAllowedClusters();
            result = result * 59 + ($allowedClusters == null ? 43 : ((Object)$allowedClusters).hashCode());
            return result;
        }

        public String toString() {
            return "V1_AdminApiTest.CustomTenantAdmin(newTenant=" + this.getNewTenant() + ", adminRoles=" + this.getAdminRoles() + ", allowedClusters=" + this.getAllowedClusters() + ")";
        }

        public static class CustomTenantAdminBuilder {
            private int newTenant;
            private Set<String> adminRoles;
            private Set<String> allowedClusters;

            CustomTenantAdminBuilder() {
            }

            public CustomTenantAdminBuilder newTenant(int newTenant) {
                this.newTenant = newTenant;
                return this;
            }

            public CustomTenantAdminBuilder adminRoles(Set<String> adminRoles) {
                this.adminRoles = adminRoles;
                return this;
            }

            public CustomTenantAdminBuilder allowedClusters(Set<String> allowedClusters) {
                this.allowedClusters = allowedClusters;
                return this;
            }

            public CustomTenantAdmin build() {
                return new CustomTenantAdmin(this.newTenant, this.adminRoles, this.allowedClusters);
            }

            public String toString() {
                return "V1_AdminApiTest.CustomTenantAdmin.CustomTenantAdminBuilder(newTenant=" + this.newTenant + ", adminRoles=" + this.adminRoles + ", allowedClusters=" + this.allowedClusters + ")";
            }
        }
    }

    private static class IncompatiblePropertyAdmin {
        public Set<String> allowedClusters;
        public int someNewIntField;
        public String someNewString;

        private IncompatiblePropertyAdmin() {
        }
    }
}

