/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v1;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.admin.v1.V1_AdminApiTest;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.loadbalance.impl.ModularLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.common.policies.data.FailureDomain;
import org.apache.pulsar.common.policies.data.NonPersistentSubscriptionStats;
import org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import org.apache.pulsar.common.policies.data.PartitionedTopicStats;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class V1_AdminApiTest2
extends MockedPulsarServiceBaseTest {
    private V1_AdminApiTest.MockedPulsarService mockPulsarSetup;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        this.resetConfig();
        this.conf.setLoadBalancerEnabled(true);
        super.internalSetup();
        this.mockPulsarSetup = new V1_AdminApiTest.MockedPulsarService(this.conf);
        this.mockPulsarSetup.setup();
        this.admin.clusters().createCluster("use", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.tenants().createTenant("prop-xyz", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop-xyz/use/ns1");
    }

    @Override
    @AfterMethod(alwaysRun=true)
    public void cleanup() throws Exception {
        super.internalCleanup();
        this.mockPulsarSetup.cleanup();
    }

    @DataProvider(name="topicType")
    public Object[][] topicTypeProvider() {
        return new Object[][]{{TopicDomain.persistent.value()}, {TopicDomain.non_persistent.value()}};
    }

    @DataProvider(name="namespaceNames")
    public Object[][] namespaceNameProvider() {
        return new Object[][]{{"ns1"}, {"global"}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIncrementPartitionsOfTopic() throws Exception {
        String topicName = "increment-partitionedTopic";
        String subName1 = "increment-partitionedTopic-my-sub-1";
        String subName2 = "increment-partitionedTopic-my-sub-2";
        int startPartitions = 4;
        int newPartitions = 8;
        String partitionedTopicName = "persistent://prop-xyz/use/ns1/increment-partitionedTopic";
        URL pulsarUrl = new URL(this.pulsar.getWebServiceAddress());
        this.admin.topics().createPartitionedTopic("persistent://prop-xyz/use/ns1/increment-partitionedTopic", 4);
        Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/increment-partitionedTopic").partitions, (int)4);
        PulsarClient client = PulsarClient.builder().serviceUrl(pulsarUrl.toString()).build();
        try {
            int i;
            Consumer consumer1 = client.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1/increment-partitionedTopic"}).subscriptionName("increment-partitionedTopic-my-sub-1").subscriptionType(SubscriptionType.Shared).subscribe();
            Assert.assertEquals((Collection)this.admin.topics().getSubscriptions("persistent://prop-xyz/use/ns1/increment-partitionedTopic"), (Collection)Lists.newArrayList((Object[])new String[]{"increment-partitionedTopic-my-sub-1"}));
            Consumer consumer2 = client.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1/increment-partitionedTopic"}).subscriptionName("increment-partitionedTopic-my-sub-2").subscriptionType(SubscriptionType.Shared).subscribe();
            Assert.assertEquals((Set)Sets.newHashSet((Iterable)this.admin.topics().getSubscriptions("persistent://prop-xyz/use/ns1/increment-partitionedTopic")), (Set)Sets.newHashSet((Object[])new String[]{"increment-partitionedTopic-my-sub-1", "increment-partitionedTopic-my-sub-2"}));
            this.admin.topics().updatePartitionedTopic("persistent://prop-xyz/use/ns1/increment-partitionedTopic", 8);
            Assert.assertEquals((int)this.admin.topics().getPartitionedTopicMetadata((String)"persistent://prop-xyz/use/ns1/increment-partitionedTopic").partitions, (int)8);
            String newPartitionTopicName = TopicName.get((String)"persistent://prop-xyz/use/ns1/increment-partitionedTopic").getPartition(5).toString();
            Producer producer = client.newProducer().topic("persistent://prop-xyz/use/ns1/increment-partitionedTopic").enableBatching(false).messageRoutingMode(MessageRoutingMode.RoundRobinPartition).create();
            int totalMessages = 16;
            for (int i2 = 0; i2 < 16; ++i2) {
                String message = "message-" + i2;
                producer.send((Object)message.getBytes());
            }
            consumer2.close();
            consumer2 = client.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1/increment-partitionedTopic"}).subscriptionName("increment-partitionedTopic-my-sub-2").subscriptionType(SubscriptionType.Shared).subscribe();
            Assert.assertEquals((Set)Sets.newHashSet((Iterable)this.admin.topics().getSubscriptions(newPartitionTopicName)), (Set)Sets.newHashSet((Object[])new String[]{"increment-partitionedTopic-my-sub-1", "increment-partitionedTopic-my-sub-2"}));
            Assert.assertEquals((int)Sets.newHashSet((Iterable)this.admin.topics().getList("prop-xyz/use/ns1")).size(), (int)8);
            PartitionedTopicStats topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/use/ns1/increment-partitionedTopic", false);
            Assert.assertEquals(topicStats.getSubscriptions().keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"increment-partitionedTopic-my-sub-1", "increment-partitionedTopic-my-sub-2"})));
            Assert.assertEquals((int)((SubscriptionStats)topicStats.getSubscriptions().get("increment-partitionedTopic-my-sub-2")).getConsumers().size(), (int)1);
            Assert.assertEquals((long)((SubscriptionStats)topicStats.getSubscriptions().get("increment-partitionedTopic-my-sub-2")).getMsgBacklog(), (long)16L);
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)1);
            Assert.assertEquals((Map)topicStats.getPartitions(), (Map)Maps.newHashMap());
            topicStats = this.admin.topics().getPartitionedStats("persistent://prop-xyz/use/ns1/increment-partitionedTopic", true);
            Assert.assertEquals((int)topicStats.getMetadata().partitions, (int)8);
            HashSet partitionSet = Sets.newHashSet();
            for (i = 0; i < 8; ++i) {
                partitionSet.add("persistent://prop-xyz/use/ns1/increment-partitionedTopic-partition-" + i);
            }
            Assert.assertEquals(topicStats.getPartitions().keySet(), (Set)partitionSet);
            for (i = 0; i < 8; ++i) {
                TopicStats partitionStats = (TopicStats)topicStats.getPartitions().get(TopicName.get((String)"persistent://prop-xyz/use/ns1/increment-partitionedTopic").getPartition(i).toString());
                Assert.assertEquals((int)partitionStats.getPublishers().size(), (int)1);
                Assert.assertEquals((int)((SubscriptionStats)partitionStats.getSubscriptions().get("increment-partitionedTopic-my-sub-2")).getConsumers().size(), (int)1);
                Assert.assertEquals((float)((SubscriptionStats)partitionStats.getSubscriptions().get("increment-partitionedTopic-my-sub-2")).getMsgBacklog(), (float)2.0f, (float)1.0f);
            }
            producer.close();
            consumer1.close();
            consumer2.close();
            consumer2.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void nonPersistentTopics() throws Exception {
        String topicName = "nonPersistentTopic";
        String persistentTopicName = "non-persistent://prop-xyz/use/ns1/nonPersistentTopic";
        this.publishMessagesOnTopic("non-persistent://prop-xyz/use/ns1/nonPersistentTopic", 0, 0);
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).statsInterval(0L, TimeUnit.SECONDS).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"non-persistent://prop-xyz/use/ns1/nonPersistentTopic"}).subscriptionName("my-sub").subscribe();
            this.publishMessagesOnTopic("non-persistent://prop-xyz/use/ns1/nonPersistentTopic", 10, 0);
            NonPersistentTopicStats topicStats = this.admin.nonPersistentTopics().getStats("non-persistent://prop-xyz/use/ns1/nonPersistentTopic");
            Assert.assertEquals(topicStats.getSubscriptions().keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"my-sub"})));
            Assert.assertEquals((int)((NonPersistentSubscriptionStats)topicStats.getSubscriptions().get("my-sub")).getConsumers().size(), (int)1);
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)0);
            PersistentTopicInternalStats internalStats = this.admin.nonPersistentTopics().getInternalStats("non-persistent://prop-xyz/use/ns1/nonPersistentTopic");
            Assert.assertEquals(internalStats.cursors.keySet(), (Set)Sets.newTreeSet((Iterable)Lists.newArrayList((Object[])new String[]{"my-sub"})));
            consumer.close();
            client.close();
            topicStats = this.admin.nonPersistentTopics().getStats("non-persistent://prop-xyz/use/ns1/nonPersistentTopic");
            Assert.assertTrue((boolean)topicStats.getSubscriptions().keySet().contains("my-sub"));
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)0);
            String partitionedTopicName = "non-persistent://prop-xyz/use/ns1/paritioned";
            Assert.assertEquals((int)this.admin.nonPersistentTopics().getPartitionedTopicMetadata((String)"non-persistent://prop-xyz/use/ns1/paritioned").partitions, (int)0);
            this.admin.nonPersistentTopics().createPartitionedTopic("non-persistent://prop-xyz/use/ns1/paritioned", 5);
            Assert.assertEquals((int)this.admin.nonPersistentTopics().getPartitionedTopicMetadata((String)"non-persistent://prop-xyz/use/ns1/paritioned").partitions, (int)5);
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    private void publishMessagesOnTopic(String topicName, int messages, int startIdx) throws Exception {
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = startIdx; i < messages + startIdx; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        producer.close();
    }

    @Test
    public void testSetPersistencepolicies() throws Exception {
        String namespace = "prop-xyz/use/ns2";
        this.admin.namespaces().createNamespace("prop-xyz/use/ns2");
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/use/ns2"), null);
        this.admin.namespaces().setPersistence("prop-xyz/use/ns2", new PersistencePolicies(3, 3, 3, 10.0));
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/use/ns2"), (Object)new PersistencePolicies(3, 3, 3, 10.0));
        try {
            this.admin.namespaces().setPersistence("prop-xyz/use/ns2", new PersistencePolicies(3, 4, 3, 10.0));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)400);
        }
        try {
            this.admin.namespaces().setPersistence("prop-xyz/use/ns2", new PersistencePolicies(3, 3, 4, 10.0));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)400);
        }
        try {
            this.admin.namespaces().setPersistence("prop-xyz/use/ns2", new PersistencePolicies(6, 3, 1, 10.0));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertEquals((int)e.getStatusCode(), (int)400);
        }
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/use/ns2"), (Object)new PersistencePolicies(3, 3, 3, 10.0));
    }

    @Test
    public void testUpdatePersistencePolicyUpdateManagedCursor() throws Exception {
        String namespace = "prop-xyz/use/ns2";
        String topicName = "persistent://prop-xyz/use/ns2/topic1";
        this.admin.namespaces().createNamespace("prop-xyz/use/ns2");
        this.admin.namespaces().setPersistence("prop-xyz/use/ns2", new PersistencePolicies(3, 3, 3, 50.0));
        Assert.assertEquals((Object)this.admin.namespaces().getPersistence("prop-xyz/use/ns2"), (Object)new PersistencePolicies(3, 3, 3, 50.0));
        Producer producer = this.pulsarClient.newProducer().topic("persistent://prop-xyz/use/ns2/topic1").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns2/topic1"}).subscriptionName("my-sub").subscribe();
        PersistentTopic topic = (PersistentTopic)this.pulsar.getBrokerService().getOrCreateTopic("persistent://prop-xyz/use/ns2/topic1").get();
        ManagedLedgerImpl managedLedger = (ManagedLedgerImpl)topic.getManagedLedger();
        ManagedCursorImpl cursor = (ManagedCursorImpl)managedLedger.getCursors().iterator().next();
        double newThrottleRate = 100.0;
        int newEnsembleSize = 5;
        this.admin.namespaces().setPersistence("prop-xyz/use/ns2", new PersistencePolicies(5, 3, 3, 100.0));
        V1_AdminApiTest2.retryStrategically(test -> managedLedger.getConfig().getEnsembleSize() == 5 && cursor.getThrottleMarkDelete() != 100.0, 5, 200L);
        Assert.assertEquals((double)cursor.getThrottleMarkDelete(), (double)100.0);
        producer.close();
        consumer.close();
    }

    @Test(dataProvider="topicType")
    public void testUnloadTopic(String topicType) throws Exception {
        String namespace = "prop-xyz/use/ns2";
        String topicName = topicType + "://" + "prop-xyz/use/ns2" + "/topic1";
        this.admin.namespaces().createNamespace("prop-xyz/use/ns2");
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        producer.close();
        Topic topic = (Topic)((Optional)this.pulsar.getBrokerService().getTopicIfExists(topicName).join()).get();
        boolean isPersistentTopic = topic instanceof PersistentTopic;
        this.unloadTopic(topicName, isPersistentTopic);
        Assert.assertFalse((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        producer = this.pulsarClient.newProducer().topic(topicName).create();
        topic = (Topic)this.pulsar.getBrokerService().getTopicReference(topicName).get();
        Assert.assertNotNull((Object)topic);
        this.unloadTopic(topicName, isPersistentTopic);
        Awaitility.await().until(() -> this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        topic = (Topic)this.pulsar.getBrokerService().getTopicReference(topicName).get();
        Assert.assertNotNull((Object)topic);
    }

    private void unloadTopic(String topicName, boolean isPersistentTopic) throws Exception {
        if (isPersistentTopic) {
            this.admin.topics().unload(topicName);
        } else {
            this.admin.nonPersistentTopics().unload(topicName);
        }
    }

    @Test(dataProvider="namespaceNames", timeOut=10000L)
    public void testResetCursorOnPosition(String namespaceName) throws Exception {
        String topicName = "persistent://prop-xyz/use/" + namespaceName + "/resetPosition";
        int totalProducedMessages = 50;
        this.admin.namespaces().setRetention("prop-xyz/use/ns1", new RetentionPolicies(10, 10));
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        Assert.assertEquals((Collection)this.admin.topics().getSubscriptions(topicName), (Collection)Lists.newArrayList((Object[])new String[]{"my-sub"}));
        this.publishMessagesOnPersistentTopic(topicName, 50, 0);
        List messages = this.admin.topics().peekMessages(topicName, "my-sub", 10);
        Assert.assertEquals((int)messages.size(), (int)10);
        Message message = null;
        MessageIdImpl resetMessageId = null;
        int resetPositionId = 10;
        for (int i = 0; i < 20; ++i) {
            message = consumer.receive(1, TimeUnit.SECONDS);
            consumer.acknowledge(message);
            if (i != resetPositionId) continue;
            resetMessageId = (MessageIdImpl)message.getMessageId();
        }
        consumer.close();
        MessageIdImpl messageId = new MessageIdImpl(resetMessageId.getLedgerId(), resetMessageId.getEntryId(), -1);
        this.admin.topics().resetCursor(topicName, "my-sub", (MessageId)messageId);
        consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").subscriptionType(SubscriptionType.Shared).subscribe();
        MessageIdImpl msgId2 = (MessageIdImpl)consumer.receive(1, TimeUnit.SECONDS).getMessageId();
        Assert.assertEquals((Object)resetMessageId, (Object)msgId2);
        int receivedAfterReset = 1;
        for (int i = 0; i < 50 && (message = consumer.receive(500, TimeUnit.MILLISECONDS)) != null; ++i) {
            consumer.acknowledge(message);
            ++receivedAfterReset;
        }
        Assert.assertEquals((int)receivedAfterReset, (int)(50 - resetPositionId));
        try {
            this.admin.topics().resetCursor(topicName + "invalid", "my-sub", (MessageId)messageId);
            Assert.fail((String)"It should have failed due to invalid topic name");
        }
        catch (PulsarAdminException.NotFoundException i) {
            // empty catch block
        }
        try {
            this.admin.topics().resetCursor(topicName, "invalid-sub", (MessageId)messageId);
            Assert.fail((String)"It should have failed due to invalid subscription name");
        }
        catch (PulsarAdminException.NotFoundException i) {
            // empty catch block
        }
        try {
            messageId = new MessageIdImpl(0L, 0L, -1);
            this.admin.topics().resetCursor(topicName, "my-sub", (MessageId)messageId);
        }
        catch (PulsarAdminException.PreconditionFailedException e) {
            Assert.fail((String)"It shouldn't fail for a invalid position");
        }
        consumer.close();
    }

    private void publishMessagesOnPersistentTopic(String topicName, int messages, int startIdx) throws Exception {
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        for (int i = startIdx; i < messages + startIdx; ++i) {
            String message = "message-" + i;
            producer.send((Object)message.getBytes());
        }
        producer.close();
    }

    @Test
    public void testLoadReportApi() throws Exception {
        this.conf.setLoadManagerClassName(SimpleLoadManagerImpl.class.getName());
        V1_AdminApiTest.MockedPulsarService mockPulsarSetup1 = new V1_AdminApiTest.MockedPulsarService(this.conf);
        mockPulsarSetup1.setup();
        PulsarAdmin simpleLoadManagerAdmin = mockPulsarSetup1.getAdmin();
        Assert.assertNotNull((Object)simpleLoadManagerAdmin.brokerStats().getLoadReport());
        this.conf.setLoadManagerClassName(ModularLoadManagerImpl.class.getName());
        V1_AdminApiTest.MockedPulsarService mockPulsarSetup2 = new V1_AdminApiTest.MockedPulsarService(this.conf);
        mockPulsarSetup2.setup();
        PulsarAdmin modularLoadManagerAdmin = mockPulsarSetup2.getAdmin();
        Assert.assertNotNull((Object)modularLoadManagerAdmin.brokerStats().getLoadReport());
        mockPulsarSetup1.cleanup();
        mockPulsarSetup2.cleanup();
    }

    @Test
    public void testPeerCluster() throws Exception {
        this.admin.clusters().createCluster("us-west1", ClusterData.builder().serviceUrl("http://broker.messaging.west1.example.com:8080").build());
        this.admin.clusters().createCluster("us-west2", ClusterData.builder().serviceUrl("http://broker.messaging.west2.example.com:8080").build());
        this.admin.clusters().createCluster("us-east1", ClusterData.builder().serviceUrl("http://broker.messaging.east1.example.com:8080").build());
        this.admin.clusters().createCluster("us-east2", ClusterData.builder().serviceUrl("http://broker.messaging.east2.example.com:8080").build());
        this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west2"})));
        Assert.assertEquals((Collection)this.admin.clusters().getCluster("us-west1").getPeerClusterNames(), (Collection)Lists.newArrayList((Object[])new String[]{"us-west2"}));
        Assert.assertNull((Object)this.admin.clusters().getCluster("us-west2").getPeerClusterNames());
        this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west2", "us-east1", "us-west2", "us-east1", "us-west2", "us-east1"})));
        Assert.assertEquals((Collection)this.admin.clusters().getCluster("us-west1").getPeerClusterNames(), (Collection)Lists.newArrayList((Object[])new String[]{"us-west2", "us-east1"}));
        this.admin.clusters().updatePeerClusterNames("us-west1", null);
        Assert.assertNull((Object)this.admin.clusters().getCluster("us-west1").getPeerClusterNames());
        try {
            this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"invalid-cluster"})));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
        try {
            this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west1"})));
            Assert.fail((String)"should have failed");
        }
        catch (PulsarAdminException e) {
            Assert.assertTrue((boolean)(e instanceof PulsarAdminException.PreconditionFailedException));
        }
    }

    @Test
    public void testReplicationPeerCluster() throws Exception {
        this.admin.clusters().createCluster("us-west1", ClusterData.builder().serviceUrl("http://broker.messaging.west1.example.com:8080").build());
        this.admin.clusters().createCluster("us-west2", ClusterData.builder().serviceUrl("http://broker.messaging.west2.example.com:8080").build());
        this.admin.clusters().createCluster("us-west3", ClusterData.builder().serviceUrl("http://broker.messaging.west2.example.com:8080").build());
        this.admin.clusters().createCluster("us-west4", ClusterData.builder().serviceUrl("http://broker.messaging.west2.example.com:8080").build());
        this.admin.clusters().createCluster("us-east1", ClusterData.builder().serviceUrl("http://broker.messaging.east1.example.com:8080").build());
        this.admin.clusters().createCluster("us-east2", ClusterData.builder().serviceUrl("http://broker.messaging.east2.example.com:8080").build());
        this.admin.clusters().createCluster("global", ClusterData.builder().build());
        String property = "peer-prop";
        HashSet allowedClusters = Sets.newHashSet((Object[])new String[]{"us-west1", "us-west2", "us-west3", "us-west4", "us-east1", "us-east2"});
        TenantInfoImpl propConfig = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"test"}), (Set)allowedClusters);
        this.admin.tenants().createTenant("peer-prop", (TenantInfo)propConfig);
        String namespace = "peer-prop/global/conflictPeer";
        this.admin.namespaces().createNamespace("peer-prop/global/conflictPeer");
        this.admin.clusters().updatePeerClusterNames("us-west1", Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])new String[]{"us-west2", "us-west3"})));
        Assert.assertEquals((Collection)this.admin.clusters().getCluster("us-west1").getPeerClusterNames(), (Collection)Lists.newArrayList((Object[])new String[]{"us-west2", "us-west3"}));
        HashSet clusterIds = Sets.newHashSet((Object[])new String[]{"us-east1", "us-east2"});
        this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
        clusterIds = Sets.newHashSet((Object[])new String[]{"us-west2", "us-west3", "us-west1"});
        try {
            this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
            Assert.fail((String)"Peer-cluster can't coexist in replication cluster list");
        }
        catch (PulsarAdminException.ConflictException conflictException) {
            // empty catch block
        }
        clusterIds = Sets.newHashSet((Object[])new String[]{"us-west2", "us-west3"});
        this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
        clusterIds = Sets.newHashSet((Object[])new String[]{"us-west1", "us-west4"});
        this.admin.namespaces().setNamespaceReplicationClusters("peer-prop/global/conflictPeer", (Set)clusterIds);
    }

    @Test
    public void clusterFailureDomain() throws PulsarAdminException {
        String cluster = this.pulsar.getConfiguration().getClusterName();
        this.admin.clusters().createCluster(cluster, ClusterData.builder().serviceUrl(this.pulsar.getSafeWebServiceAddress()).serviceUrlTls(this.pulsar.getWebServiceAddressTls()).build());
        FailureDomain domain = FailureDomain.builder().brokers((Set)Sets.newHashSet((Object[])new String[]{"b1", "b2", "b3"})).build();
        this.admin.clusters().createFailureDomain(cluster, "domain-1", domain);
        this.admin.clusters().updateFailureDomain(cluster, "domain-1", domain);
        Assert.assertEquals((Object)this.admin.clusters().getFailureDomain(cluster, "domain-1"), (Object)domain);
        Map domains = this.admin.clusters().getFailureDomains(cluster);
        Assert.assertEquals((int)domains.size(), (int)1);
        Assert.assertTrue((boolean)domains.containsKey("domain-1"));
        try {
            this.admin.clusters().createFailureDomain(cluster, "domain-2", domain);
            Assert.fail((String)"should have failed because of brokers are already registered");
        }
        catch (PulsarAdminException.ConflictException conflictException) {
            // empty catch block
        }
        this.admin.clusters().deleteFailureDomain(cluster, "domain-1");
        Assert.assertTrue((boolean)this.admin.clusters().getFailureDomains(cluster).isEmpty());
        this.admin.clusters().createFailureDomain(cluster, "domain-2", domain);
        domains = this.admin.clusters().getFailureDomains(cluster);
        Assert.assertEquals((int)domains.size(), (int)1);
        Assert.assertTrue((boolean)domains.containsKey("domain-2"));
    }

    @Test
    public void namespaceAntiAffinity() throws PulsarAdminException {
        String namespace = "prop-xyz/use/ns1";
        String antiAffinityGroup = "group";
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)this.admin.namespaces().getNamespaceAntiAffinityGroup("prop-xyz/use/ns1")));
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/use/ns1", "group");
        Assert.assertEquals((String)this.admin.namespaces().getNamespaceAntiAffinityGroup("prop-xyz/use/ns1"), (String)"group");
        this.admin.namespaces().deleteNamespaceAntiAffinityGroup("prop-xyz/use/ns1");
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)this.admin.namespaces().getNamespaceAntiAffinityGroup("prop-xyz/use/ns1")));
        String ns1 = "prop-xyz/use/antiAG1";
        String ns2 = "prop-xyz/use/antiAG2";
        String ns3 = "prop-xyz/use/antiAG3";
        this.admin.namespaces().createNamespace("prop-xyz/use/antiAG1");
        this.admin.namespaces().createNamespace("prop-xyz/use/antiAG2");
        this.admin.namespaces().createNamespace("prop-xyz/use/antiAG3");
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/use/antiAG1", "group");
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/use/antiAG2", "group");
        this.admin.namespaces().setNamespaceAntiAffinityGroup("prop-xyz/use/antiAG3", "group");
        HashSet namespaces = new HashSet(this.admin.namespaces().getAntiAffinityNamespaces("prop-xyz", "use", "group"));
        Assert.assertEquals((int)namespaces.size(), (int)3);
        Assert.assertTrue((boolean)namespaces.contains("prop-xyz/use/antiAG1"));
        Assert.assertTrue((boolean)namespaces.contains("prop-xyz/use/antiAG2"));
        Assert.assertTrue((boolean)namespaces.contains("prop-xyz/use/antiAG3"));
        List namespaces2 = this.admin.namespaces().getAntiAffinityNamespaces("prop-xyz", "use", "invalid-group");
        Assert.assertEquals((int)namespaces2.size(), (int)0);
    }

    @Test
    public void testNonPersistentTopics() throws Exception {
        int i;
        String namespace = "prop-xyz/use/ns2";
        String topicName = "non-persistent://prop-xyz/use/ns2/topic";
        this.admin.namespaces().createNamespace("prop-xyz/use/ns2", 20);
        int totalTopics = 100;
        HashSet topicNames = Sets.newHashSet();
        for (i = 0; i < totalTopics; ++i) {
            topicNames.add("non-persistent://prop-xyz/use/ns2/topic" + i);
            Producer producer = this.pulsarClient.newProducer().topic("non-persistent://prop-xyz/use/ns2/topic" + i).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
            producer.close();
        }
        for (i = 0; i < totalTopics; ++i) {
            Topic topic = (Topic)this.pulsar.getBrokerService().getTopicReference("non-persistent://prop-xyz/use/ns2/topic" + i).get();
            Assert.assertNotNull((Object)topic);
        }
        HashSet topicsInNs = Sets.newHashSet((Iterable)this.admin.nonPersistentTopics().getList("prop-xyz/use/ns2"));
        Assert.assertEquals((int)topicsInNs.size(), (int)totalTopics);
        topicsInNs.removeAll(topicNames);
        Assert.assertEquals((int)topicsInNs.size(), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishConsumerStats() throws Exception {
        String topicName = "statTopic";
        String subscriberName = "statTopic-my-sub-1";
        String topic = "persistent://prop-xyz/use/ns1/statTopic";
        String producerName = "myProducer";
        PulsarClient client = PulsarClient.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build();
        try {
            Consumer consumer = client.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns1/statTopic"}).subscriptionName("statTopic-my-sub-1").subscriptionType(SubscriptionType.Shared).subscribe();
            Producer producer = client.newProducer().topic("persistent://prop-xyz/use/ns1/statTopic").producerName("myProducer").enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
            V1_AdminApiTest2.retryStrategically(test -> {
                try {
                    TopicStats stats = this.admin.topics().getStats("persistent://prop-xyz/use/ns1/statTopic");
                    return stats.getPublishers().size() > 0 && stats.getSubscriptions().get("statTopic-my-sub-1") != null && ((SubscriptionStats)stats.getSubscriptions().get("statTopic-my-sub-1")).getConsumers().size() > 0;
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 5, 200L);
            TopicStats topicStats = this.admin.topics().getStats("persistent://prop-xyz/use/ns1/statTopic");
            Assert.assertEquals((int)topicStats.getPublishers().size(), (int)1);
            Assert.assertNotNull((Object)((PublisherStats)topicStats.getPublishers().get(0)).getAddress());
            Assert.assertNotNull((Object)((PublisherStats)topicStats.getPublishers().get(0)).getClientVersion());
            Assert.assertNotNull((Object)((PublisherStats)topicStats.getPublishers().get(0)).getConnectedSince());
            Assert.assertNotNull((Object)((PublisherStats)topicStats.getPublishers().get(0)).getProducerName());
            Assert.assertEquals((String)((PublisherStats)topicStats.getPublishers().get(0)).getProducerName(), (String)"myProducer");
            SubscriptionStats subscriber = (SubscriptionStats)topicStats.getSubscriptions().get("statTopic-my-sub-1");
            Assert.assertNotNull((Object)subscriber);
            Assert.assertEquals((int)subscriber.getConsumers().size(), (int)1);
            ConsumerStats consumerStats = (ConsumerStats)subscriber.getConsumers().get(0);
            Assert.assertNotNull((Object)consumerStats.getAddress());
            Assert.assertNotNull((Object)consumerStats.getClientVersion());
            Assert.assertNotNull((Object)consumerStats.getConnectedSince());
            producer.close();
            consumer.close();
        }
        finally {
            if (Collections.singletonList(client).get(0) != null) {
                client.close();
            }
        }
    }

    @Test
    public void testTenantNameWithUnderscore() throws Exception {
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        this.admin.tenants().createTenant("prop_xyz", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("prop_xyz/use/my-namespace");
        String topic = "persistent://prop_xyz/use/my-namespace/my-topic";
        Producer producer = this.pulsarClient.newProducer().topic(topic).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        TopicStats stats = this.admin.topics().getStats(topic);
        Assert.assertEquals((int)stats.getPublishers().size(), (int)1);
        producer.close();
    }

    @Test
    public void testTenantNameWithInvalidCharacters() throws Exception {
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"use"}));
        try {
            this.admin.tenants().createTenant("prop xyz", (TenantInfo)tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
        try {
            this.admin.tenants().createTenant("prop&xyz", (TenantInfo)tenantInfo);
            Assert.fail((String)"Should have failed");
        }
        catch (PulsarAdminException pulsarAdminException) {
            // empty catch block
        }
    }
}

