/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v3;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker-admin"})
public class AdminApiTransactionMultiBrokerTest
extends TransactionTestBase {
    private static final Logger log = LoggerFactory.getLogger(AdminApiTransactionMultiBrokerTest.class);
    private static final int NUM_BROKERS = 16;
    private static final int NUM_PARTITIONS = 3;

    @BeforeMethod
    protected void setup() throws Exception {
        this.setUpBase(16, 3, "tnx/ns1/test", 0);
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testRedirectOfGetCoordinatorInternalStats() throws Exception {
        Map map = this.admin.lookups().lookupPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString());
        while (map.containsValue(this.getPulsarServiceList().get(0).getBrokerServiceUrl())) {
            this.admin.topics().deletePartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString());
            this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), 3);
            map = this.admin.lookups().lookupPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString());
        }
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.getPulsarServiceList().get(0).getBrokerServiceUrl()).statsInterval(0L, TimeUnit.SECONDS).enableTransaction(true).build();
        for (int i = 0; i < 3; ++i) {
            this.admin.transactions().getCoordinatorInternalStats(i, false);
        }
    }
}

