/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.v3;

import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.transaction.TransactionImpl;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorInternalStats;
import org.apache.pulsar.common.policies.data.TransactionCoordinatorStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInPendingAckStats;
import org.apache.pulsar.common.policies.data.TransactionMetadata;
import org.apache.pulsar.common.policies.data.TransactionPendingAckInternalStats;
import org.apache.pulsar.common.policies.data.TransactionPendingAckStats;
import org.apache.pulsar.packages.management.core.MockedPackagesStorageProvider;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker-admin"})
public class AdminApiTransactionTest
extends MockedPulsarServiceBaseTest {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        this.conf.setEnablePackagesManagement(true);
        this.conf.setPackagesManagementStorageProvider(MockedPackagesStorageProvider.class.getName());
        this.conf.setTransactionCoordinatorEnabled(true);
        this.conf.setSystemTopicEnabled(true);
        this.conf.setTransactionBufferSnapshotMaxTransactionCount(1);
        super.internalSetup();
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        TenantInfoImpl tenantInfo = new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"role1", "role2"}), (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("pulsar", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("pulsar/system", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
        this.admin.tenants().createTenant("public", (TenantInfo)tenantInfo);
        this.admin.namespaces().createNamespace("public/default", (Set)Sets.newHashSet((Object[])new String[]{"test"}));
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test(timeOut=20000L)
    public void testGetTransactionCoordinatorStats() throws Exception {
        this.initTransaction(2);
        this.getTransaction().commit().get();
        this.getTransaction().abort().get();
        TransactionCoordinatorStats transactionCoordinatorstats = (TransactionCoordinatorStats)this.admin.transactions().getCoordinatorStatsByIdAsync(1).get();
        AdminApiTransactionTest.verifyCoordinatorStats(transactionCoordinatorstats.state, transactionCoordinatorstats.leastSigBits, transactionCoordinatorstats.lowWaterMark);
        transactionCoordinatorstats = (TransactionCoordinatorStats)this.admin.transactions().getCoordinatorStatsByIdAsync(0).get();
        AdminApiTransactionTest.verifyCoordinatorStats(transactionCoordinatorstats.state, transactionCoordinatorstats.leastSigBits, transactionCoordinatorstats.lowWaterMark);
        Map stats = (Map)this.admin.transactions().getCoordinatorStatsAsync().get();
        Assert.assertEquals((int)stats.size(), (int)2);
        transactionCoordinatorstats = (TransactionCoordinatorStats)stats.get(0);
        AdminApiTransactionTest.verifyCoordinatorStats(transactionCoordinatorstats.state, transactionCoordinatorstats.leastSigBits, transactionCoordinatorstats.lowWaterMark);
        transactionCoordinatorstats = (TransactionCoordinatorStats)stats.get(1);
        AdminApiTransactionTest.verifyCoordinatorStats(transactionCoordinatorstats.state, transactionCoordinatorstats.leastSigBits, transactionCoordinatorstats.lowWaterMark);
    }

    @Test(timeOut=20000L)
    public void testGetTransactionInBufferStats() throws Exception {
        PulsarAdminException.NotFoundException cause;
        this.initTransaction(2);
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        String topic = "persistent://public/default/testGetTransactionInBufferStats";
        try {
            this.admin.transactions().getTransactionInBufferStatsAsync(new TxnID(1L, 1L), "persistent://public/default/testGetTransactionInBufferStats").get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        try {
            this.pulsar.getBrokerService().getTopic("persistent://public/default/testGetTransactionInBufferStats", false);
            this.admin.transactions().getTransactionInBufferStatsAsync(new TxnID(1L, 1L), "persistent://public/default/testGetTransactionInBufferStats").get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetTransactionInBufferStats");
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://public/default/testGetTransactionInBufferStats").sendTimeout(0, TimeUnit.SECONDS).create();
        MessageId messageId = producer.newMessage((Transaction)transaction).value((Object)"Hello pulsar!".getBytes()).send();
        TransactionInBufferStats transactionInBufferStats = (TransactionInBufferStats)this.admin.transactions().getTransactionInBufferStatsAsync(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits()), "persistent://public/default/testGetTransactionInBufferStats").get();
        PositionImpl position = PositionImpl.get((long)((MessageIdImpl)messageId).getLedgerId(), (long)((MessageIdImpl)messageId).getEntryId());
        Assert.assertEquals((String)transactionInBufferStats.startPosition, (String)position.toString());
        Assert.assertFalse((boolean)transactionInBufferStats.aborted);
        transaction.abort().get();
        transactionInBufferStats = (TransactionInBufferStats)this.admin.transactions().getTransactionInBufferStatsAsync(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits()), "persistent://public/default/testGetTransactionInBufferStats").get();
        Assert.assertNull((Object)transactionInBufferStats.startPosition);
        Assert.assertTrue((boolean)transactionInBufferStats.aborted);
    }

    @Test(timeOut=20000L)
    public void testGetTransactionPendingAckStats() throws Exception {
        PulsarAdminException.NotFoundException cause;
        this.initTransaction(2);
        String topic = "persistent://public/default/testGetTransactionInBufferStats";
        String subName = "test";
        try {
            this.admin.transactions().getTransactionInPendingAckStatsAsync(new TxnID(1L, 2L), "persistent://public/default/testGetTransactionInBufferStats", "test").get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        try {
            this.pulsar.getBrokerService().getTopic("persistent://public/default/testGetTransactionInBufferStats", false);
            this.admin.transactions().getTransactionInPendingAckStatsAsync(new TxnID(1L, 2L), "persistent://public/default/testGetTransactionInBufferStats", "test").get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetTransactionInBufferStats");
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://public/default/testGetTransactionInBufferStats").create();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionInBufferStats"}).subscriptionName("test").subscribe();
        producer.sendAsync((Object)"Hello pulsar!".getBytes());
        producer.sendAsync((Object)"Hello pulsar!".getBytes());
        producer.sendAsync((Object)"Hello pulsar!".getBytes());
        producer.sendAsync((Object)"Hello pulsar!".getBytes());
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        TransactionInPendingAckStats transactionInPendingAckStats = (TransactionInPendingAckStats)this.admin.transactions().getTransactionInPendingAckStatsAsync(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits()), "persistent://public/default/testGetTransactionInBufferStats", "test").get();
        Assert.assertNull((Object)transactionInPendingAckStats.cumulativeAckPosition);
        consumer.receive();
        consumer.receive();
        Message message = consumer.receive();
        BatchMessageIdImpl batchMessageId = (BatchMessageIdImpl)message.getMessageId();
        consumer.acknowledgeCumulativeAsync((MessageId)batchMessageId, (Transaction)transaction).get();
        transactionInPendingAckStats = (TransactionInPendingAckStats)this.admin.transactions().getTransactionInPendingAckStatsAsync(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits()), "persistent://public/default/testGetTransactionInBufferStats", "test").get();
        Assert.assertEquals((String)transactionInPendingAckStats.cumulativeAckPosition, (String)(String.valueOf(batchMessageId.getLedgerId()) + ':' + batchMessageId.getEntryId() + ':' + batchMessageId.getBatchIndex()));
    }

    @Test(timeOut=20000L)
    public void testGetTransactionMetadata() throws Exception {
        this.initTransaction(2);
        long currentTime = System.currentTimeMillis();
        String topic1 = "persistent://public/default/testGetTransactionMetadata-1";
        String subName1 = "test1";
        String topic2 = "persistent://public/default/testGetTransactionMetadata-2";
        String subName2 = "test2";
        String subName3 = "test3";
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetTransactionMetadata-1");
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetTransactionMetadata-2");
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        Producer producer1 = this.pulsarClient.newProducer(Schema.BYTES).sendTimeout(0, TimeUnit.SECONDS).topic("persistent://public/default/testGetTransactionMetadata-1").create();
        Producer producer2 = this.pulsarClient.newProducer(Schema.BYTES).sendTimeout(0, TimeUnit.SECONDS).topic("persistent://public/default/testGetTransactionMetadata-2").create();
        Consumer consumer1 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionMetadata-1"}).subscriptionName("test1").subscribe();
        Consumer consumer2 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionMetadata-2"}).subscriptionName("test2").subscribe();
        Consumer consumer3 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionMetadata-2"}).subscriptionName("test3").subscribe();
        MessageId messageId1 = producer1.send((Object)"Hello pulsar!".getBytes());
        MessageId messageId2 = producer2.send((Object)"Hello pulsar!".getBytes());
        MessageId messageId3 = producer1.newMessage((Transaction)transaction).value((Object)"Hello pulsar!".getBytes()).send();
        MessageId messageId4 = producer2.newMessage((Transaction)transaction).value((Object)"Hello pulsar!".getBytes()).send();
        consumer1.acknowledgeCumulativeAsync(messageId1, (Transaction)transaction).get();
        consumer2.acknowledgeCumulativeAsync(messageId2, (Transaction)transaction).get();
        consumer3.acknowledgeCumulativeAsync(messageId2, (Transaction)transaction).get();
        TxnID txnID = new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits());
        TransactionMetadata transactionMetadata = (TransactionMetadata)this.admin.transactions().getTransactionMetadataAsync(new TxnID(transaction.getTxnIdMostBits(), transaction.getTxnIdLeastBits())).get();
        Assert.assertEquals((String)transactionMetadata.txnId, (String)txnID.toString());
        Assert.assertTrue((transactionMetadata.openTimestamp > currentTime ? 1 : 0) != 0);
        Assert.assertEquals((long)transactionMetadata.timeoutAt, (long)5000L);
        Assert.assertEquals((String)transactionMetadata.status, (String)"OPEN");
        Map producedPartitions = transactionMetadata.producedPartitions;
        Map ackedPartitions = transactionMetadata.ackedPartitions;
        PositionImpl position1 = AdminApiTransactionTest.getPositionByMessageId(messageId1);
        PositionImpl position2 = AdminApiTransactionTest.getPositionByMessageId(messageId2);
        PositionImpl position3 = AdminApiTransactionTest.getPositionByMessageId(messageId3);
        PositionImpl position4 = AdminApiTransactionTest.getPositionByMessageId(messageId4);
        Assert.assertFalse((boolean)((TransactionInBufferStats)producedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-1")).aborted);
        Assert.assertFalse((boolean)((TransactionInBufferStats)producedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-2")).aborted);
        Assert.assertEquals((String)((TransactionInBufferStats)producedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-1")).startPosition, (String)position3.toString());
        Assert.assertEquals((String)((TransactionInBufferStats)producedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-2")).startPosition, (String)position4.toString());
        Assert.assertEquals((int)((Map)ackedPartitions.get("persistent://public/default/testGetTransactionMetadata-1")).size(), (int)1);
        Assert.assertEquals((int)((Map)ackedPartitions.get("persistent://public/default/testGetTransactionMetadata-2")).size(), (int)2);
        Assert.assertEquals((String)((TransactionInPendingAckStats)((Map)ackedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-1")).get((Object)"test1")).cumulativeAckPosition, (String)position1.toString());
        Assert.assertEquals((String)((TransactionInPendingAckStats)((Map)ackedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-2")).get((Object)"test2")).cumulativeAckPosition, (String)position2.toString());
        Assert.assertEquals((String)((TransactionInPendingAckStats)((Map)ackedPartitions.get((Object)"persistent://public/default/testGetTransactionMetadata-2")).get((Object)"test3")).cumulativeAckPosition, (String)position2.toString());
    }

    @Test(timeOut=20000L)
    public void testGetTransactionBufferStats() throws Exception {
        PulsarAdminException.NotFoundException cause;
        this.initTransaction(2);
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        String topic = "persistent://public/default/testGetTransactionBufferStats";
        String subName1 = "test1";
        String subName2 = "test2";
        try {
            this.admin.transactions().getTransactionBufferStatsAsync("persistent://public/default/testGetTransactionBufferStats").get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        try {
            this.pulsar.getBrokerService().getTopic("persistent://public/default/testGetTransactionBufferStats", false);
            this.admin.transactions().getTransactionBufferStatsAsync("persistent://public/default/testGetTransactionBufferStats").get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetTransactionBufferStats");
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).sendTimeout(0, TimeUnit.SECONDS).topic("persistent://public/default/testGetTransactionBufferStats").create();
        Consumer consumer1 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionBufferStats"}).subscriptionName("test1").subscribe();
        Consumer consumer2 = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetTransactionBufferStats"}).subscriptionName("test2").subscribe();
        long currentTime = System.currentTimeMillis();
        MessageId messageId = producer.newMessage((Transaction)transaction).value((Object)"Hello pulsar!".getBytes()).send();
        transaction.commit().get();
        transaction = (TransactionImpl)this.getTransaction();
        consumer1.acknowledgeAsync(messageId, (Transaction)transaction).get();
        consumer2.acknowledgeAsync(messageId, (Transaction)transaction).get();
        TransactionBufferStats transactionBufferStats = (TransactionBufferStats)this.admin.transactions().getTransactionBufferStatsAsync("persistent://public/default/testGetTransactionBufferStats").get();
        Assert.assertEquals((String)transactionBufferStats.state, (String)"Ready");
        Assert.assertEquals((String)transactionBufferStats.maxReadPosition, (String)PositionImpl.get((long)((MessageIdImpl)messageId).getLedgerId(), (long)(((MessageIdImpl)messageId).getEntryId() + 1L)).toString());
        Assert.assertTrue((transactionBufferStats.lastSnapshotTimestamps > currentTime ? 1 : 0) != 0);
    }

    @DataProvider(name="ackType")
    public static Object[] ackType() {
        return new Object[]{"cumulative", "individual"};
    }

    @Test(timeOut=20000L, dataProvider="ackType")
    public void testGetPendingAckStats(String ackType) throws Exception {
        PulsarAdminException.NotFoundException cause;
        this.initTransaction(2);
        String topic = "persistent://public/default/testGetPendingAckStats";
        String subName = "test1";
        try {
            this.admin.transactions().getPendingAckStatsAsync("persistent://public/default/testGetPendingAckStats", "test1").get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        try {
            this.pulsar.getBrokerService().getTopic("persistent://public/default/testGetPendingAckStats", false);
            this.admin.transactions().getPendingAckStatsAsync("persistent://public/default/testGetPendingAckStats", "test1").get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetPendingAckStats");
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).sendTimeout(0, TimeUnit.SECONDS).topic("persistent://public/default/testGetPendingAckStats").create();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetPendingAckStats"}).subscriptionName("test1").subscribe();
        TransactionPendingAckStats transactionPendingAckStats = (TransactionPendingAckStats)this.admin.transactions().getPendingAckStatsAsync("persistent://public/default/testGetPendingAckStats", "test1").get();
        Assert.assertEquals((String)transactionPendingAckStats.state, (String)"None");
        producer.newMessage().value((Object)"Hello pulsar!".getBytes()).send();
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        if (ackType.equals("individual")) {
            consumer.acknowledgeAsync(consumer.receive().getMessageId(), (Transaction)transaction);
        } else {
            consumer.acknowledgeCumulativeAsync(consumer.receive().getMessageId(), (Transaction)transaction);
        }
        transaction.commit().get();
        transactionPendingAckStats = (TransactionPendingAckStats)this.admin.transactions().getPendingAckStatsAsync("persistent://public/default/testGetPendingAckStats", "test1").get();
        Assert.assertEquals((String)transactionPendingAckStats.state, (String)"Ready");
    }

    @Test(timeOut=20000L)
    public void testGetSlowTransactions() throws Exception {
        this.initTransaction(2);
        TransactionImpl transaction1 = (TransactionImpl)this.pulsarClient.newTransaction().withTransactionTimeout(60L, TimeUnit.SECONDS).build().get();
        TransactionImpl transaction2 = (TransactionImpl)this.pulsarClient.newTransaction().withTransactionTimeout(60L, TimeUnit.SECONDS).build().get();
        this.pulsarClient.newTransaction().withTransactionTimeout(20L, TimeUnit.SECONDS).build();
        this.pulsarClient.newTransaction().withTransactionTimeout(20L, TimeUnit.SECONDS).build();
        Map transactionMetadataMap = (Map)this.admin.transactions().getSlowTransactionsAsync(30L, TimeUnit.SECONDS).get();
        Assert.assertEquals((int)transactionMetadataMap.size(), (int)2);
        TxnID txnID1 = new TxnID(transaction1.getTxnIdMostBits(), transaction1.getTxnIdLeastBits());
        TxnID txnID2 = new TxnID(transaction2.getTxnIdMostBits(), transaction2.getTxnIdLeastBits());
        TransactionMetadata transactionMetadata = (TransactionMetadata)transactionMetadataMap.get(txnID1.toString());
        Assert.assertNotNull((Object)transactionMetadata);
        Assert.assertEquals((long)transactionMetadata.timeoutAt, (long)60000L);
        transactionMetadata = (TransactionMetadata)transactionMetadataMap.get(txnID2.toString());
        Assert.assertNotNull((Object)transactionMetadata);
        Assert.assertEquals((long)transactionMetadata.timeoutAt, (long)60000L);
    }

    private static PositionImpl getPositionByMessageId(MessageId messageId) {
        return PositionImpl.get((long)((MessageIdImpl)messageId).getLedgerId(), (long)((MessageIdImpl)messageId).getEntryId());
    }

    @Test(timeOut=20000L)
    public void testGetCoordinatorInternalStats() throws Exception {
        this.initTransaction(1);
        Transaction transaction = (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(60L, TimeUnit.SECONDS).build().get();
        TransactionCoordinatorInternalStats stats = (TransactionCoordinatorInternalStats)this.admin.transactions().getCoordinatorInternalStatsAsync(0, true).get();
        AdminApiTransactionTest.verifyManagedLegerInternalStats(stats.transactionLogStats.managedLedgerInternalStats, 26L);
        Assert.assertEquals((String)TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)"__transaction_log_0").getPersistenceNamingEncoding(), (String)stats.transactionLogStats.managedLedgerName);
        transaction.commit().get();
        stats = (TransactionCoordinatorInternalStats)this.admin.transactions().getCoordinatorInternalStatsAsync(0, false).get();
        Assert.assertNull((Object)((ManagedLedgerInternalStats.LedgerInfo)stats.transactionLogStats.managedLedgerInternalStats.ledgers.get((int)0)).metadata);
        Assert.assertEquals((String)TopicName.get((String)TopicDomain.persistent.toString(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)"__transaction_log_0").getPersistenceNamingEncoding(), (String)stats.transactionLogStats.managedLedgerName);
    }

    @Test(timeOut=20000L)
    public void testGetPendingAckInternalStats() throws Exception {
        PulsarAdminException.NotFoundException cause;
        this.initTransaction(1);
        TransactionImpl transaction = (TransactionImpl)this.getTransaction();
        String topic = "persistent://public/default/testGetPendingAckInternalStats";
        String subName = "test";
        try {
            this.admin.transactions().getPendingAckInternalStatsAsync("persistent://public/default/testGetPendingAckInternalStats", "test", true).get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        try {
            this.pulsar.getBrokerService().getTopic("persistent://public/default/testGetPendingAckInternalStats", false);
            this.admin.transactions().getPendingAckInternalStatsAsync("persistent://public/default/testGetPendingAckInternalStats", "test", true).get();
            Assert.fail((String)"Should failed here");
        }
        catch (ExecutionException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof PulsarAdminException.NotFoundException));
            cause = (PulsarAdminException.NotFoundException)ex.getCause();
            Assert.assertEquals((String)cause.getMessage(), (String)"Topic not found");
        }
        this.admin.topics().createNonPartitionedTopic("persistent://public/default/testGetPendingAckInternalStats");
        Producer producer = this.pulsarClient.newProducer(Schema.BYTES).topic("persistent://public/default/testGetPendingAckInternalStats").create();
        Consumer consumer = this.pulsarClient.newConsumer(Schema.BYTES).topic(new String[]{"persistent://public/default/testGetPendingAckInternalStats"}).subscriptionName("test").subscribe();
        MessageId messageId = producer.send((Object)"Hello pulsar!".getBytes());
        consumer.acknowledgeAsync(messageId, (Transaction)transaction).get();
        TransactionPendingAckInternalStats stats = (TransactionPendingAckInternalStats)this.admin.transactions().getPendingAckInternalStatsAsync("persistent://public/default/testGetPendingAckInternalStats", "test", true).get();
        ManagedLedgerInternalStats managedLedgerInternalStats = stats.pendingAckLogStats.managedLedgerInternalStats;
        Assert.assertEquals((String)TopicName.get((String)TopicDomain.persistent.toString(), (String)"public", (String)"default", (String)"testGetPendingAckInternalStats-test__transaction_pending_ack").getPersistenceNamingEncoding(), (String)stats.pendingAckLogStats.managedLedgerName);
        AdminApiTransactionTest.verifyManagedLegerInternalStats(managedLedgerInternalStats, 16L);
        ManagedLedgerInternalStats finalManagedLedgerInternalStats = managedLedgerInternalStats;
        managedLedgerInternalStats.cursors.forEach((s, cursorStats) -> {
            Assert.assertEquals((String)s, (String)"__pending_ack_state");
            Assert.assertEquals((String)cursorStats.readPosition, (String)finalManagedLedgerInternalStats.lastConfirmedEntry);
        });
        stats = (TransactionPendingAckInternalStats)this.admin.transactions().getPendingAckInternalStatsAsync("persistent://public/default/testGetPendingAckInternalStats", "test", false).get();
        managedLedgerInternalStats = stats.pendingAckLogStats.managedLedgerInternalStats;
        Assert.assertEquals((String)TopicName.get((String)TopicDomain.persistent.toString(), (String)"public", (String)"default", (String)"testGetPendingAckInternalStats-test__transaction_pending_ack").getPersistenceNamingEncoding(), (String)stats.pendingAckLogStats.managedLedgerName);
        Assert.assertNull((Object)((ManagedLedgerInternalStats.LedgerInfo)managedLedgerInternalStats.ledgers.get((int)0)).metadata);
    }

    @Test(timeOut=20000L)
    public void testTransactionNotEnabled() throws Exception {
        this.stopBroker();
        this.conf.setTransactionCoordinatorEnabled(false);
        super.internalSetup();
        try {
            this.admin.transactions().getCoordinatorInternalStats(1, false);
        }
        catch (PulsarAdminException ex) {
            Assert.assertEquals((int)ex.getStatusCode(), (int)503);
        }
    }

    private static void verifyCoordinatorStats(String state, long sequenceId, long lowWaterMark) {
        Assert.assertEquals((String)state, (String)"Ready");
        Assert.assertEquals((long)sequenceId, (long)0L);
        Assert.assertEquals((long)lowWaterMark, (long)0L);
    }

    private void initTransaction(int coordinatorSize) throws Exception {
        this.admin.topics().createPartitionedTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString(), coordinatorSize);
        this.admin.lookups().lookupTopic(TopicName.TRANSACTION_COORDINATOR_ASSIGN.toString());
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.lookupUrl.toString()).enableTransaction(true).build();
        this.pulsarClient.close();
        Awaitility.await().until(() -> this.pulsar.getTransactionMetadataStoreService().getStores().size() == coordinatorSize);
        this.pulsarClient = PulsarClient.builder().serviceUrl(this.lookupUrl.toString()).enableTransaction(true).build();
    }

    private Transaction getTransaction() throws Exception {
        return (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(5L, TimeUnit.SECONDS).build().get();
    }

    private static void verifyManagedLegerInternalStats(ManagedLedgerInternalStats managedLedgerInternalStats, long totalSize) {
        Assert.assertEquals((long)managedLedgerInternalStats.entriesAddedCounter, (long)1L);
        Assert.assertEquals((long)managedLedgerInternalStats.numberOfEntries, (long)1L);
        Assert.assertEquals((long)managedLedgerInternalStats.totalSize, (long)totalSize);
        Assert.assertEquals((long)managedLedgerInternalStats.currentLedgerEntries, (long)1L);
        Assert.assertEquals((long)managedLedgerInternalStats.currentLedgerSize, (long)totalSize);
        Assert.assertNull((Object)managedLedgerInternalStats.lastLedgerCreationFailureTimestamp);
        Assert.assertEquals((int)managedLedgerInternalStats.waitingCursorsCount, (int)0);
        Assert.assertEquals((int)managedLedgerInternalStats.pendingAddEntriesCount, (int)0);
        Assert.assertNotNull((Object)managedLedgerInternalStats.lastConfirmedEntry);
        Assert.assertEquals((int)managedLedgerInternalStats.ledgers.size(), (int)1);
        Assert.assertNotNull((Object)((ManagedLedgerInternalStats.LedgerInfo)managedLedgerInternalStats.ledgers.get((int)0)).metadata);
        Assert.assertEquals((int)managedLedgerInternalStats.cursors.size(), (int)1);
    }
}

