/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.auth;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwarder
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PortForwarder.class);
    private final SocketAddress targetAddress;
    private final Channel serverChannel;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;

    public PortForwarder(SocketAddress listenAddress, SocketAddress targetAddress) {
        this.targetAddress = targetAddress;
        this.bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            this.serverChannel = ((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(PortForwarder.class, LogLevel.DEBUG))).childHandler((ChannelHandler)new Initializer()).childOption(ChannelOption.AUTO_READ, (Object)false).bind(listenAddress).sync().channel();
            LOG.info("Started port forwarding service on {}, target: {}", (Object)listenAddress, (Object)targetAddress);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("failed to bind to %s: %s", listenAddress, e.getMessage()), e);
        }
    }

    @Override
    public void close() throws Exception {
        this.serverChannel.close().sync();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    private static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private class BackendHandler
    extends ChannelInboundHandlerAdapter {
        private final Channel inboundChannel;

        public BackendHandler(Channel inboundChannel) {
            this.inboundChannel = inboundChannel;
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.read();
        }

        public void channelRead(final ChannelHandlerContext ctx, Object msg) {
            this.inboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        ctx.channel().read();
                    } else {
                        future.channel().close();
                    }
                }
            });
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            PortForwarder.closeOnFlush(this.inboundChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.error("backend exception", cause);
            PortForwarder.closeOnFlush(ctx.channel());
        }
    }

    private class FrontendHandler
    extends ChannelInboundHandlerAdapter {
        private volatile Channel outboundChannel;

        private FrontendHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) {
            final Channel inboundChannel = ctx.channel();
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)inboundChannel.eventLoop())).channel(ctx.channel().getClass())).handler((ChannelHandler)new BackendHandler(inboundChannel))).option(ChannelOption.AUTO_READ, (Object)false);
            ChannelFuture f = b.connect(PortForwarder.this.targetAddress);
            this.outboundChannel = f.channel();
            f.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        inboundChannel.read();
                    } else {
                        inboundChannel.close();
                    }
                }
            });
        }

        public void channelRead(final ChannelHandlerContext ctx, Object msg) {
            if (this.outboundChannel.isActive()) {
                this.outboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            ctx.channel().read();
                        } else {
                            future.channel().close();
                        }
                    }
                });
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            if (this.outboundChannel != null) {
                PortForwarder.closeOnFlush(this.outboundChannel);
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.error("frontend exception", cause);
            PortForwarder.closeOnFlush(ctx.channel());
        }
    }

    private class Initializer
    extends ChannelInitializer<SocketChannel> {
        private Initializer() {
        }

        public void initChannel(SocketChannel ch) {
            ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(PortForwarder.class, LogLevel.DEBUG), new FrontendHandler()});
        }
    }
}

