/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.cache;

import com.google.common.collect.Range;
import com.google.common.hash.Hashing;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.cache.BundlesQuotas;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreFactory;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BundlesQuotasTest {
    private MetadataStore store;
    private NamespaceBundleFactory bundleFactory;

    @BeforeMethod
    public void setup() throws Exception {
        this.store = MetadataStoreFactory.create((String)"memory://local", (MetadataStoreConfig)MetadataStoreConfig.builder().build());
        PulsarService pulsar = (PulsarService)Mockito.mock(PulsarService.class);
        Mockito.when((Object)pulsar.getLocalMetadataStore()).thenReturn(Mockito.mock(MetadataStoreExtended.class));
        Mockito.when((Object)pulsar.getConfigurationMetadataStore()).thenReturn(Mockito.mock(MetadataStoreExtended.class));
        this.bundleFactory = new NamespaceBundleFactory(pulsar, Hashing.crc32());
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws Exception {
        this.store.close();
    }

    @Test
    public void testGetSetDefaultQuota() throws Exception {
        BundlesQuotas bundlesQuotas = new BundlesQuotas(this.store);
        ResourceQuota quota2 = new ResourceQuota();
        quota2.setMsgRateIn(10.0);
        quota2.setMsgRateOut(20.0);
        quota2.setBandwidthIn(10000.0);
        quota2.setBandwidthOut(20000.0);
        quota2.setMemory(100.0);
        quota2.setDynamic(false);
        Assert.assertEquals(bundlesQuotas.getDefaultResourceQuota().join(), (Object)BundlesQuotas.INITIAL_QUOTA);
        bundlesQuotas.setDefaultResourceQuota(quota2).join();
        Assert.assertEquals(bundlesQuotas.getDefaultResourceQuota().join(), (Object)quota2);
    }

    @Test
    public void testGetSetBundleQuota() throws Exception {
        BundlesQuotas bundlesQuotas = new BundlesQuotas(this.store);
        NamespaceBundle testBundle = new NamespaceBundle(NamespaceName.get((String)"pulsar/test/ns-2"), Range.closedOpen((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(Integer.MAX_VALUE)), this.bundleFactory);
        ResourceQuota quota2 = new ResourceQuota();
        quota2.setMsgRateIn(10.0);
        quota2.setMsgRateOut(20.0);
        quota2.setBandwidthIn(10000.0);
        quota2.setBandwidthOut(20000.0);
        quota2.setMemory(100.0);
        quota2.setDynamic(false);
        Assert.assertEquals(bundlesQuotas.getResourceQuota(testBundle).join(), (Object)BundlesQuotas.INITIAL_QUOTA);
        bundlesQuotas.setResourceQuota(testBundle, quota2).join();
        Assert.assertEquals(bundlesQuotas.getResourceQuota(testBundle).join(), (Object)quota2);
        bundlesQuotas.resetResourceQuota(testBundle).join();
        Assert.assertEquals(bundlesQuotas.getResourceQuota(testBundle).join(), (Object)BundlesQuotas.INITIAL_QUOTA);
    }
}

