/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.intercept.BrokerInterceptorDefinition;
import org.apache.pulsar.broker.intercept.BrokerInterceptorMetadata;
import org.apache.pulsar.broker.intercept.BrokerInterceptorUtils;
import org.apache.pulsar.broker.intercept.BrokerInterceptorWithClassLoader;
import org.apache.pulsar.broker.intercept.MockBrokerInterceptor;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.testng.PowerMockObjectFactory;
import org.testng.AssertJUnit;
import org.testng.IObjectFactory;
import org.testng.annotations.ObjectFactory;
import org.testng.annotations.Test;

@PrepareForTest(value={BrokerInterceptorUtils.class, NarClassLoader.class})
@PowerMockIgnore(value={"org.apache.logging.log4j.*"})
@Test(groups={"broker"})
public class BrokerInterceptorUtilsTest {
    @ObjectFactory
    public IObjectFactory getObjectFactory() {
        return new PowerMockObjectFactory();
    }

    @Test
    public void testLoadBrokerEventListener() throws Exception {
        BrokerInterceptorDefinition def = new BrokerInterceptorDefinition();
        def.setInterceptorClass(MockBrokerInterceptor.class.getName());
        def.setDescription("test-broker-listener");
        String archivePath = "/path/to/broker/listener/nar";
        BrokerInterceptorMetadata metadata = new BrokerInterceptorMetadata();
        metadata.setDefinition(def);
        metadata.setArchivePath(Paths.get(archivePath, new String[0]));
        NarClassLoader mockLoader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        Mockito.when((Object)mockLoader.getServiceDefinition((String)ArgumentMatchers.eq((Object)"broker_interceptor.yml"))).thenReturn((Object)ObjectMapperFactory.getThreadLocalYaml().writeValueAsString((Object)def));
        Class<MockBrokerInterceptor> listenerClass = MockBrokerInterceptor.class;
        Mockito.when((Object)mockLoader.loadClass((String)ArgumentMatchers.eq((Object)MockBrokerInterceptor.class.getName()))).thenReturn(listenerClass);
        PowerMockito.mockStatic(NarClassLoader.class, (Class[])new Class[0]);
        PowerMockito.when((Object)NarClassLoader.getFromArchive((File)((File)ArgumentMatchers.any(File.class)), (Set)((Set)ArgumentMatchers.any(Set.class)), (ClassLoader)((ClassLoader)ArgumentMatchers.any(ClassLoader.class)), (String)((String)ArgumentMatchers.any(String.class)))).thenReturn((Object)mockLoader);
        BrokerInterceptorWithClassLoader returnedPhWithCL = BrokerInterceptorUtils.load((BrokerInterceptorMetadata)metadata, (String)"");
        BrokerInterceptor returnedPh = returnedPhWithCL.getInterceptor();
        AssertJUnit.assertSame((Object)mockLoader, (Object)returnedPhWithCL.getClassLoader());
        AssertJUnit.assertTrue((boolean)(returnedPh instanceof MockBrokerInterceptor));
    }

    @Test(expectedExceptions={IOException.class})
    public void testLoadBrokerEventListenerWithBlankListerClass() throws Exception {
        BrokerInterceptorDefinition def = new BrokerInterceptorDefinition();
        def.setDescription("test-broker-listener");
        String archivePath = "/path/to/broker/listener/nar";
        BrokerInterceptorMetadata metadata = new BrokerInterceptorMetadata();
        metadata.setDefinition(def);
        metadata.setArchivePath(Paths.get(archivePath, new String[0]));
        NarClassLoader mockLoader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        Mockito.when((Object)mockLoader.getServiceDefinition((String)ArgumentMatchers.eq((Object)"broker_interceptor.yml"))).thenReturn((Object)ObjectMapperFactory.getThreadLocalYaml().writeValueAsString((Object)def));
        Class<MockBrokerInterceptor> listenerClass = MockBrokerInterceptor.class;
        Mockito.when((Object)mockLoader.loadClass((String)ArgumentMatchers.eq((Object)MockBrokerInterceptor.class.getName()))).thenReturn(listenerClass);
        PowerMockito.mockStatic(NarClassLoader.class, (Class[])new Class[0]);
        PowerMockito.when((Object)NarClassLoader.getFromArchive((File)((File)ArgumentMatchers.any(File.class)), (Set)((Set)ArgumentMatchers.any(Set.class)), (ClassLoader)((ClassLoader)ArgumentMatchers.any(ClassLoader.class)), (String)((String)ArgumentMatchers.any(String.class)))).thenReturn((Object)mockLoader);
        BrokerInterceptorUtils.load((BrokerInterceptorMetadata)metadata, (String)"");
    }

    @Test(expectedExceptions={IOException.class})
    public void testLoadBrokerEventListenerWithWrongListerClass() throws Exception {
        BrokerInterceptorDefinition def = new BrokerInterceptorDefinition();
        def.setInterceptorClass(Runnable.class.getName());
        def.setDescription("test-broker-listener");
        String archivePath = "/path/to/broker/listener/nar";
        BrokerInterceptorMetadata metadata = new BrokerInterceptorMetadata();
        metadata.setDefinition(def);
        metadata.setArchivePath(Paths.get(archivePath, new String[0]));
        NarClassLoader mockLoader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        Mockito.when((Object)mockLoader.getServiceDefinition((String)ArgumentMatchers.eq((Object)"broker_interceptor.yml"))).thenReturn((Object)ObjectMapperFactory.getThreadLocalYaml().writeValueAsString((Object)def));
        Class<Runnable> listenerClass = Runnable.class;
        Mockito.when((Object)mockLoader.loadClass((String)ArgumentMatchers.eq((Object)Runnable.class.getName()))).thenReturn(listenerClass);
        PowerMockito.mockStatic(NarClassLoader.class, (Class[])new Class[0]);
        PowerMockito.when((Object)NarClassLoader.getFromArchive((File)((File)ArgumentMatchers.any(File.class)), (Set)((Set)ArgumentMatchers.any(Set.class)), (ClassLoader)((ClassLoader)ArgumentMatchers.any(ClassLoader.class)), (String)((String)ArgumentMatchers.any(String.class)))).thenReturn((Object)mockLoader);
        BrokerInterceptorUtils.load((BrokerInterceptorMetadata)metadata, (String)"");
    }
}

