/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.intercept;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.intercept.BrokerInterceptorWithClassLoader;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.common.api.proto.BaseCommand;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.intercept.InterceptException;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BrokerInterceptorWithClassLoaderTest {
    @Test
    public void testWrapper() throws Exception {
        BrokerInterceptor h = (BrokerInterceptor)Mockito.mock(BrokerInterceptor.class);
        NarClassLoader loader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        BrokerInterceptorWithClassLoader wrapper = new BrokerInterceptorWithClassLoader(h, loader);
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        wrapper.initialize(pulsarService);
        ((BrokerInterceptor)Mockito.verify((Object)h, (VerificationMode)Mockito.times((int)1))).initialize((PulsarService)ArgumentMatchers.same((Object)pulsarService));
    }

    @Test
    public void testClassLoaderSwitcher() throws Exception {
        final NarClassLoader narLoader = (NarClassLoader)Mockito.mock(NarClassLoader.class);
        BrokerInterceptor interceptor = new BrokerInterceptor(){

            public void beforeSendMessage(Subscription subscription, Entry entry, long[] ackSet, MessageMetadata msgMetadata) {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }

            public void onPulsarCommand(BaseCommand command, ServerCnx cnx) throws InterceptException {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }

            public void onConnectionClosed(ServerCnx cnx) {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }

            public void onWebserviceRequest(ServletRequest request) {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }

            public void onWebserviceResponse(ServletRequest request, ServletResponse response) {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }

            public void onFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }

            public void initialize(PulsarService pulsarService) throws Exception {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }

            public void close() {
                Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)narLoader);
            }
        };
        BrokerInterceptorWithClassLoader brokerInterceptorWithClassLoader = new BrokerInterceptorWithClassLoader(interceptor, narLoader);
        ClassLoader curClassLoader = Thread.currentThread().getContextClassLoader();
        Assert.assertEquals((Object)brokerInterceptorWithClassLoader.getClassLoader(), (Object)narLoader);
        brokerInterceptorWithClassLoader.initialize((PulsarService)Mockito.mock(PulsarService.class));
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        brokerInterceptorWithClassLoader.onFilter((ServletRequest)Mockito.mock(ServletRequest.class), (ServletResponse)Mockito.mock(ServletResponse.class), (FilterChain)Mockito.mock(FilterChain.class));
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        brokerInterceptorWithClassLoader.onWebserviceResponse((ServletRequest)Mockito.mock(ServletRequest.class), (ServletResponse)Mockito.mock(ServletResponse.class));
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        brokerInterceptorWithClassLoader.onWebserviceRequest((ServletRequest)Mockito.mock(ServletRequest.class));
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        brokerInterceptorWithClassLoader.onConnectionClosed((ServerCnx)Mockito.mock(ServerCnx.class));
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        brokerInterceptorWithClassLoader.onPulsarCommand(null, (ServerCnx)Mockito.mock(ServerCnx.class));
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        brokerInterceptorWithClassLoader.beforeSendMessage((Subscription)Mockito.mock(Subscription.class), (Entry)Mockito.mock(Entry.class), null, null);
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
        brokerInterceptorWithClassLoader.close();
        Assert.assertEquals((Object)Thread.currentThread().getContextClassLoader(), (Object)curClassLoader);
    }
}

