/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import org.apache.bookkeeper.util.PortManager;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.pulsar.broker.MultiBrokerBaseTest;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdvertisedListenersTest
extends MultiBrokerBaseTest {
    private static final Logger log = LoggerFactory.getLogger(AdvertisedListenersTest.class);

    @Override
    protected int numberOfAdditionalBrokers() {
        return 1;
    }

    @Override
    protected void doInitConf() throws Exception {
        super.doInitConf();
        this.updateConfig(this.conf, "BROKER-X");
    }

    @Override
    protected ServiceConfiguration createConfForAdditionalBroker(int additionalBrokerIndex) {
        ServiceConfiguration conf = super.createConfForAdditionalBroker(additionalBrokerIndex);
        this.updateConfig(conf, "BROKER-" + additionalBrokerIndex);
        return conf;
    }

    private void updateConfig(ServiceConfiguration conf, String advertisedAddress) {
        int pulsarPort = PortManager.nextFreePort();
        int httpPort = PortManager.nextFreePort();
        int httpsPort = PortManager.nextFreePort();
        conf.setAdvertisedAddress(advertisedAddress);
        conf.setAdvertisedListeners("public:pulsar://localhost:" + pulsarPort + ",public_http:http://localhost:" + httpPort + ",public_https:https://localhost:" + httpsPort);
        conf.setBrokerServicePort(Optional.of(pulsarPort));
        conf.setWebServicePort(Optional.of(httpPort));
        conf.setWebServicePortTls(Optional.of(httpsPort));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLookup() throws Exception {
        HttpGet request = new HttpGet(this.pulsar.getWebServiceAddress() + "/lookup/v2/topic/persistent/public/default/my-topic");
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Accept", "application/json");
        String topic = "my-topic";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
            try {
                HttpEntity entity = response.getEntity();
                LookupData ld = (LookupData)ObjectMapperFactory.getThreadLocal().readValue(EntityUtils.toString((HttpEntity)entity), LookupData.class);
                System.err.println("Lookup data: " + ld);
                Assert.assertEquals((String)new URI(ld.getBrokerUrl()).getHost(), (String)"localhost");
                Assert.assertEquals((String)new URI(ld.getHttpUrl()).getHost(), (String)"localhost");
                Assert.assertEquals((String)new URI(ld.getHttpUrlTls()).getHost(), (String)"localhost");
                Producer p = this.pulsarClient.newProducer(Schema.STRING).topic("my-topic").create();
                try {
                    p.send((Object)"hello");
                    for (PulsarAdmin a : this.getAllAdmins()) {
                        TopicStats s = a.topics().getStats("my-topic");
                        Assert.assertNotNull((Object)a.lookups().lookupTopic("my-topic"));
                        Assert.assertEquals((int)s.getPublishers().size(), (int)1);
                    }
                }
                finally {
                    if (Collections.singletonList(p).get(0) != null) {
                        p.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(response).get(0) != null) {
                    response.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(httpClient).get(0) != null) {
                httpClient.close();
            }
        }
    }
}

