/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.SystemUtils;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LoadBalancerTestingUtils;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.LoadReport;
import org.apache.pulsar.broker.loadbalance.LoadResourceQuotaUpdaterTask;
import org.apache.pulsar.broker.loadbalance.LoadSheddingTask;
import org.apache.pulsar.broker.loadbalance.ResourceDescription;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.GenericBrokerHostUsageImpl;
import org.apache.pulsar.broker.loadbalance.impl.LinuxBrokerHostUsageImpl;
import org.apache.pulsar.broker.loadbalance.impl.PulsarLoadReportImpl;
import org.apache.pulsar.broker.loadbalance.impl.PulsarResourceDescription;
import org.apache.pulsar.broker.loadbalance.impl.ResourceAvailabilityRanker;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadCalculatorImpl;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceUnit;
import org.apache.pulsar.client.admin.BrokerStats;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyData;
import org.apache.pulsar.common.policies.data.AutoFailoverPolicyType;
import org.apache.pulsar.common.policies.data.NamespaceIsolationData;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.common.policies.impl.NamespaceIsolationPolicies;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.policies.data.loadbalancer.BrokerUsage;
import org.apache.pulsar.policies.data.loadbalancer.JvmUsage;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUnitRanking;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class SimpleLoadManagerImplTest {
    private static final Logger log = LoggerFactory.getLogger(SimpleLoadManagerImplTest.class);
    LocalBookkeeperEnsemble bkEnsemble;
    URL url1;
    PulsarService pulsar1;
    PulsarAdmin admin1;
    URL url2;
    PulsarService pulsar2;
    PulsarAdmin admin2;
    BrokerStats brokerStatsClient1;
    BrokerStats brokerStatsClient2;
    String primaryHost;
    String secondaryHost;
    ExecutorService executor = new ThreadPoolExecutor(5, 20, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    @BeforeMethod
    void setup() throws Exception {
        this.bkEnsemble = new LocalBookkeeperEnsemble(3, 0, () -> 0);
        this.bkEnsemble.start();
        ServiceConfiguration config1 = (ServiceConfiguration)Mockito.spy(ServiceConfiguration.class);
        config1.setClusterName("use");
        config1.setWebServicePort(Optional.of(0));
        config1.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
        config1.setBrokerShutdownTimeoutMs(0L);
        config1.setBrokerServicePort(Optional.of(0));
        config1.setLoadManagerClassName(SimpleLoadManagerImpl.class.getName());
        config1.setBrokerServicePortTls(Optional.of(0));
        config1.setWebServicePortTls(Optional.of(0));
        config1.setAdvertisedAddress("localhost");
        this.pulsar1 = new PulsarService(config1);
        this.pulsar1.start();
        this.url1 = new URL(this.pulsar1.getWebServiceAddress());
        this.admin1 = PulsarAdmin.builder().serviceHttpUrl(this.url1.toString()).build();
        this.brokerStatsClient1 = this.admin1.brokerStats();
        this.primaryHost = this.pulsar1.getWebServiceAddress();
        ServiceConfiguration config2 = new ServiceConfiguration();
        config2.setClusterName("use");
        config2.setWebServicePort(Optional.of(0));
        config2.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
        config2.setBrokerShutdownTimeoutMs(0L);
        config2.setBrokerServicePort(Optional.of(0));
        config2.setLoadManagerClassName(SimpleLoadManagerImpl.class.getName());
        config2.setBrokerServicePortTls(Optional.of(0));
        config2.setWebServicePortTls(Optional.of(0));
        config2.setAdvertisedAddress("localhost");
        this.pulsar2 = new PulsarService(config2);
        this.pulsar2.start();
        this.url2 = new URL(this.pulsar2.getWebServiceAddress());
        this.admin2 = PulsarAdmin.builder().serviceHttpUrl(this.url2.toString()).build();
        this.brokerStatsClient2 = this.admin2.brokerStats();
        this.secondaryHost = this.pulsar2.getWebServiceAddress();
        Thread.sleep(100L);
    }

    @AfterMethod(alwaysRun=true)
    void shutdown() throws Exception {
        log.info("--- Shutting down ---");
        this.executor.shutdownNow();
        this.admin1.close();
        this.admin2.close();
        this.pulsar2.close();
        this.pulsar1.close();
        this.bkEnsemble.stop();
    }

    private void createNamespacePolicies(PulsarService pulsar) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("min_limit", "1");
        parameters.put("usage_threshold", "100");
        NamespaceIsolationPolicies policies = new NamespaceIsolationPolicies();
        NamespaceIsolationData policyData = NamespaceIsolationData.builder().namespaces(Collections.singletonList("pulsar/use/primary-ns.*")).primary(Collections.singletonList(this.pulsar1.getAdvertisedAddress() + "*")).secondary(Collections.singletonList("prod2-broker([78]).messaging.usw.example.co.*")).autoFailoverPolicy(AutoFailoverPolicyData.builder().policyType(AutoFailoverPolicyType.min_available).parameters(parameters).build()).build();
        policies.setPolicy("primaryBrokerPolicy", policyData);
        try {
            pulsar.getPulsarResources().getNamespaceResources().getIsolationPolicies().createIsolationData("use", policies.getPolicies());
        }
        catch (MetadataStoreException.BadVersionException e) {
            pulsar.getPulsarResources().getNamespaceResources().getIsolationPolicies().setIsolationData("use", data -> policies.getPolicies());
        }
    }

    @Test
    public void testBasicBrokerSelection() throws Exception {
        SimpleLoadManagerImpl loadManager = new SimpleLoadManagerImpl(this.pulsar1);
        PulsarResourceDescription rd = new PulsarResourceDescription();
        rd.put("memory", new ResourceUsage(1024.0, 4096.0));
        rd.put("cpu", new ResourceUsage(10.0, 100.0));
        rd.put("bandwidthIn", new ResourceUsage(256000.0, 1048576.0));
        rd.put("bandwidthOut", new ResourceUsage(563200.0, 1048576.0));
        SimpleResourceUnit ru1 = new SimpleResourceUnit("http://prod2-broker7.messaging.usw.example.com:8080", (ResourceDescription)rd);
        HashSet<SimpleResourceUnit> rus = new HashSet<SimpleResourceUnit>();
        rus.add(ru1);
        ResourceAvailabilityRanker lr = new ResourceAvailabilityRanker();
        AtomicReference<TreeMap> sortedRankingsInstance = new AtomicReference<TreeMap>(Maps.newTreeMap());
        ((Map)sortedRankingsInstance.get()).put(lr.getRank((ResourceDescription)rd), rus);
        Field sortedRankings = SimpleLoadManagerImpl.class.getDeclaredField("sortedRankings");
        sortedRankings.setAccessible(true);
        sortedRankings.set(loadManager, sortedRankingsInstance);
        Optional res = loadManager.getLeastLoaded((ServiceUnitId)NamespaceName.get((String)"pulsar/use/primary-ns.10"));
        Assert.assertEquals((Object)res, Optional.empty(), (String)"found a broker when expected none to be found");
    }

    private void setObjectField(Class<?> objClass, Object objInstance, String fieldName, Object newValue) throws Exception {
        Field field = objClass.getDeclaredField(fieldName);
        field.setAccessible(true);
        field.set(objInstance, newValue);
    }

    @Test
    public void testPrimary() throws Exception {
        this.createNamespacePolicies(this.pulsar1);
        SimpleLoadManagerImpl loadManager = new SimpleLoadManagerImpl(this.pulsar1);
        PulsarResourceDescription rd = new PulsarResourceDescription();
        rd.put("memory", new ResourceUsage(1024.0, 4096.0));
        rd.put("cpu", new ResourceUsage(10.0, 100.0));
        rd.put("bandwidthIn", new ResourceUsage(256000.0, 1048576.0));
        rd.put("bandwidthOut", new ResourceUsage(563200.0, 1048576.0));
        SimpleResourceUnit ru1 = new SimpleResourceUnit("http://" + this.pulsar1.getAdvertisedAddress() + ":" + this.pulsar1.getConfiguration().getWebServicePort().get(), (ResourceDescription)rd);
        HashSet<SimpleResourceUnit> rus = new HashSet<SimpleResourceUnit>();
        rus.add(ru1);
        ResourceAvailabilityRanker lr = new ResourceAvailabilityRanker();
        HashMap<SimpleResourceUnit, org.apache.pulsar.policies.data.loadbalancer.LoadReport> loadReports = new HashMap<SimpleResourceUnit, org.apache.pulsar.policies.data.loadbalancer.LoadReport>();
        org.apache.pulsar.policies.data.loadbalancer.LoadReport loadReport = new org.apache.pulsar.policies.data.loadbalancer.LoadReport();
        loadReport.setSystemResourceUsage(new SystemResourceUsage());
        loadReports.put(ru1, loadReport);
        this.setObjectField(SimpleLoadManagerImpl.class, loadManager, "currentLoadReports", loadReports);
        ResourceUnitRanking ranking = new ResourceUnitRanking(loadReport.getSystemResourceUsage(), new HashSet(), new ResourceQuota(), new HashSet(), new ResourceQuota());
        HashMap<SimpleResourceUnit, ResourceUnitRanking> rankings = new HashMap<SimpleResourceUnit, ResourceUnitRanking>();
        rankings.put(ru1, ranking);
        this.setObjectField(SimpleLoadManagerImpl.class, loadManager, "resourceUnitRankings", rankings);
        AtomicReference<TreeMap> sortedRankingsInstance = new AtomicReference<TreeMap>(Maps.newTreeMap());
        ((Map)sortedRankingsInstance.get()).put(lr.getRank((ResourceDescription)rd), rus);
        this.setObjectField(SimpleLoadManagerImpl.class, loadManager, "sortedRankings", sortedRankingsInstance);
        ResourceUnit found = (ResourceUnit)loadManager.getLeastLoaded((ServiceUnitId)NamespaceName.get((String)"pulsar/use/primary-ns.10")).get();
        Assert.assertNotEquals((Object)found, null, (String)"did not find a broker when expected one to be found");
    }

    @Test(enabled=false)
    public void testPrimarySecondary() throws Exception {
        this.createNamespacePolicies(this.pulsar1);
        SimpleLoadManagerImpl loadManager = new SimpleLoadManagerImpl(this.pulsar1);
        PulsarResourceDescription rd = new PulsarResourceDescription();
        rd.put("memory", new ResourceUsage(1024.0, 4096.0));
        rd.put("cpu", new ResourceUsage(10.0, 100.0));
        rd.put("bandwidthIn", new ResourceUsage(256000.0, 1048576.0));
        rd.put("bandwidthOut", new ResourceUsage(563200.0, 1048576.0));
        SimpleResourceUnit ru1 = new SimpleResourceUnit("http://prod2-broker7.messaging.usw.example.com:8080", (ResourceDescription)rd);
        HashSet<SimpleResourceUnit> rus = new HashSet<SimpleResourceUnit>();
        rus.add(ru1);
        ResourceAvailabilityRanker lr = new ResourceAvailabilityRanker();
        AtomicReference<TreeMap> sortedRankingsInstance = new AtomicReference<TreeMap>(Maps.newTreeMap());
        ((Map)sortedRankingsInstance.get()).put(lr.getRank((ResourceDescription)rd), rus);
        Field sortedRankings = SimpleLoadManagerImpl.class.getDeclaredField("sortedRankings");
        sortedRankings.setAccessible(true);
        sortedRankings.set(loadManager, sortedRankingsInstance);
        ResourceUnit found = (ResourceUnit)loadManager.getLeastLoaded((ServiceUnitId)NamespaceName.get((String)"pulsar/use/primary-ns.10")).get();
        Assert.assertEquals((String)found.getResourceId(), (String)ru1.getResourceId());
    }

    @Test
    public void testResourceDescription() {
        PulsarResourceDescription rd = new PulsarResourceDescription();
        rd.put("memory", new ResourceUsage(1024.0, 4096.0));
        rd.put("cpu", new ResourceUsage(10.0, 100.0));
        rd.put("bandwidthIn", new ResourceUsage(256000.0, 1048576.0));
        rd.put("bandwidthOut", new ResourceUsage(563200.0, 1048576.0));
        PulsarResourceDescription rd1 = new PulsarResourceDescription();
        rd1.put("memory", new ResourceUsage(2048.0, 4096.0));
        rd1.put("cpu", new ResourceUsage(50.0, 100.0));
        rd1.put("bandwidthIn", new ResourceUsage(563200.0, 1048576.0));
        rd1.put("bandwidthOut", new ResourceUsage(870400.0, 1048576.0));
        Assert.assertEquals((int)rd.compareTo((ResourceDescription)rd1), (int)1);
        Assert.assertTrue((rd1.calculateRank() > rd.calculateRank() ? 1 : 0) != 0);
        SimpleLoadCalculatorImpl calc = new SimpleLoadCalculatorImpl();
        calc.recalibrateResourceUsagePerServiceUnit(null);
        Assert.assertNull((Object)calc.getResourceDescription(null));
    }

    @Test
    public void testLoadReportParsing() throws Exception {
        ObjectMapper mapper = ObjectMapperFactory.create();
        org.apache.pulsar.policies.data.loadbalancer.LoadReport reportData = new org.apache.pulsar.policies.data.loadbalancer.LoadReport();
        reportData.setName("b1");
        SystemResourceUsage resource = new SystemResourceUsage();
        ResourceUsage resourceUsage = new ResourceUsage();
        resource.setBandwidthIn(resourceUsage);
        resource.setBandwidthOut(resourceUsage);
        resource.setMemory(resourceUsage);
        resource.setCpu(resourceUsage);
        reportData.setSystemResourceUsage(resource);
        String loadReportJson = mapper.writeValueAsString((Object)reportData);
        LoadReport loadReport = PulsarLoadReportImpl.parse((String)loadReportJson);
        Assert.assertEquals((int)((ResourceUsage)loadReport.getResourceUnitDescription().getResourceUsage().get("bandwidthIn")).compareTo(resourceUsage), (int)0);
    }

    @Test(enabled=true)
    public void testDoLoadShedding() throws Exception {
        SimpleLoadManagerImpl loadManager = BrokerTestUtil.spyWithClassAndConstructorArgs(SimpleLoadManagerImpl.class, this.pulsar1);
        PulsarResourceDescription rd = new PulsarResourceDescription();
        rd.put("memory", new ResourceUsage(1024.0, 4096.0));
        rd.put("cpu", new ResourceUsage(10.0, 100.0));
        rd.put("bandwidthIn", new ResourceUsage(256000.0, 1048576.0));
        rd.put("bandwidthOut", new ResourceUsage(563200.0, 1048576.0));
        SimpleResourceUnit ru1 = new SimpleResourceUnit("http://pulsar-broker1.com:8080", (ResourceDescription)rd);
        SimpleResourceUnit ru2 = new SimpleResourceUnit("http://pulsar-broker2.com:8080", (ResourceDescription)rd);
        HashSet<SimpleResourceUnit> rus = new HashSet<SimpleResourceUnit>();
        rus.add(ru1);
        rus.add(ru2);
        ResourceAvailabilityRanker lr = new ResourceAvailabilityRanker();
        AtomicReference<TreeMap> sortedRankingsInstance = new AtomicReference<TreeMap>(Maps.newTreeMap());
        ((Map)sortedRankingsInstance.get()).put(lr.getRank((ResourceDescription)rd), rus);
        Field sortedRankings = SimpleLoadManagerImpl.class.getDeclaredField("sortedRankings");
        sortedRankings.setAccessible(true);
        sortedRankings.set(loadManager, sortedRankingsInstance);
        SystemResourceUsage systemResource = new SystemResourceUsage();
        systemResource.setBandwidthIn(new ResourceUsage(90.0, 100.0));
        HashMap stats = Maps.newHashMap();
        NamespaceBundleStats nsb1 = new NamespaceBundleStats();
        nsb1.msgRateOut = 10000.0;
        NamespaceBundleStats nsb2 = new NamespaceBundleStats();
        nsb2.msgRateOut = 10000.0;
        stats.put("property/cluster/namespace1/0x00000000_0xFFFFFFFF", nsb1);
        stats.put("property/cluster/namespace2/0x00000000_0xFFFFFFFF", nsb2);
        HashMap<SimpleResourceUnit, org.apache.pulsar.policies.data.loadbalancer.LoadReport> loadReports = new HashMap<SimpleResourceUnit, org.apache.pulsar.policies.data.loadbalancer.LoadReport>();
        org.apache.pulsar.policies.data.loadbalancer.LoadReport loadReport1 = new org.apache.pulsar.policies.data.loadbalancer.LoadReport();
        loadReport1.setSystemResourceUsage(systemResource);
        loadReport1.setBundleStats((Map)stats);
        org.apache.pulsar.policies.data.loadbalancer.LoadReport loadReport2 = new org.apache.pulsar.policies.data.loadbalancer.LoadReport();
        loadReport2.setSystemResourceUsage(new SystemResourceUsage());
        loadReport2.setBundleStats((Map)stats);
        loadReports.put(ru1, loadReport1);
        loadReports.put(ru2, loadReport2);
        this.setObjectField(SimpleLoadManagerImpl.class, loadManager, "currentLoadReports", loadReports);
        loadManager.doLoadShedding();
        ((SimpleLoadManagerImpl)Mockito.verify((Object)loadManager, (VerificationMode)Mockito.atLeastOnce())).doLoadShedding();
    }

    @Test
    public void testEvenBundleDistribution() throws Exception {
        NamespaceBundle[] bundles = LoadBalancerTestingUtils.makeBundles(this.pulsar1.getNamespaceService().getNamespaceBundleFactory(), "pulsar", "use", "test", 16);
        ResourceQuota quota = new ResourceQuota();
        this.pulsar1.getBrokerService().getBundlesQuotas().setResourceQuota(bundles[0], quota).join();
        int numAssignedToPrimary = 0;
        int numAssignedToSecondary = 0;
        this.pulsar1.getConfiguration().setLoadBalancerPlacementStrategy("leastLoadedServer");
        SimpleLoadManagerImpl loadManager = (SimpleLoadManagerImpl)this.pulsar1.getLoadManager().get();
        for (NamespaceBundle bundle : bundles) {
            if (((ResourceUnit)loadManager.getLeastLoaded((ServiceUnitId)bundle).get()).getResourceId().equals(this.primaryHost)) {
                ++numAssignedToPrimary;
            } else {
                ++numAssignedToSecondary;
            }
            if ((numAssignedToPrimary + numAssignedToSecondary) % 2 == 0) assert (numAssignedToPrimary == numAssignedToSecondary);
        }
    }

    @Test
    public void testNamespaceBundleStats() {
        NamespaceBundleStats nsb1 = new NamespaceBundleStats();
        nsb1.msgRateOut = 10000.0;
        nsb1.producerCount = 1;
        nsb1.consumerCount = 1;
        nsb1.cacheSize = 4L;
        nsb1.msgRateIn = 500.0;
        nsb1.msgThroughputIn = 30.0;
        nsb1.msgThroughputOut = 30.0;
        NamespaceBundleStats nsb2 = new NamespaceBundleStats();
        nsb2.msgRateOut = 20000.0;
        nsb2.producerCount = 300;
        nsb2.consumerCount = 300;
        nsb2.cacheSize = 110000L;
        nsb2.msgRateIn = 5000.0;
        nsb2.msgThroughputIn = 110000.0;
        nsb2.msgThroughputOut = 110000.0;
        Assert.assertEquals((int)-1, (int)nsb1.compareTo(nsb2));
        Assert.assertEquals((int)-1, (int)nsb1.compareByMsgRate(nsb2));
        Assert.assertEquals((int)-1, (int)nsb1.compareByTopicConnections(nsb2));
        Assert.assertEquals((int)-1, (int)nsb1.compareByCacheSize(nsb2));
        Assert.assertEquals((int)-1, (int)nsb1.compareByBandwidthOut(nsb2));
        Assert.assertEquals((int)-1, (int)nsb1.compareByBandwidthIn(nsb2));
    }

    @Test
    public void testBrokerHostUsage() {
        Object brokerUsage = SystemUtils.IS_OS_LINUX ? new LinuxBrokerHostUsageImpl(this.pulsar1) : new GenericBrokerHostUsageImpl(this.pulsar1);
        brokerUsage.getBrokerHostUsage();
    }

    @Test
    public void testTask() throws Exception {
        LoadManager loadManager = (LoadManager)Mockito.mock(LoadManager.class);
        AtomicReference<LoadManager> atomicLoadManager = new AtomicReference<LoadManager>(loadManager);
        LoadResourceQuotaUpdaterTask task1 = new LoadResourceQuotaUpdaterTask(atomicLoadManager);
        task1.run();
        ((LoadManager)Mockito.verify((Object)loadManager, (VerificationMode)Mockito.times((int)1))).writeResourceQuotasToZooKeeper();
        LoadSheddingTask task2 = new LoadSheddingTask(atomicLoadManager);
        task2.run();
        ((LoadManager)Mockito.verify((Object)loadManager, (VerificationMode)Mockito.times((int)1))).doLoadShedding();
    }

    @Test
    public void testUsage() {
        HashMap metrics = Maps.newHashMap();
        metrics.put("brk_conn_cnt", 1L);
        metrics.put("brk_repl_conn_cnt", 1L);
        metrics.put("jvm_thread_cnt", 1L);
        BrokerUsage brokerUsage = BrokerUsage.populateFrom((Map)metrics);
        Assert.assertEquals((long)brokerUsage.getConnectionCount(), (long)1L);
        Assert.assertEquals((long)brokerUsage.getReplicationConnectionCount(), (long)1L);
        JvmUsage jvmUsage = JvmUsage.populateFrom((Map)metrics);
        Assert.assertEquals((long)jvmUsage.getThreadCount(), (long)1L);
        SystemResourceUsage usage = new SystemResourceUsage();
        double usageLimit = 10.0;
        usage.setBandwidthIn(new ResourceUsage(usageLimit, usageLimit));
        Assert.assertEquals((double)usage.getBandwidthIn().usage, (double)usageLimit);
        usage.reset();
        Assert.assertNotEquals((Object)usage.getBandwidthIn().usage, (Object)usageLimit);
    }
}

