/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.pulsar.broker.BrokerData;
import org.apache.pulsar.broker.BundleData;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.TimeAverageMessageData;
import org.apache.pulsar.broker.loadbalance.LoadData;
import org.apache.pulsar.broker.loadbalance.impl.OverloadShedder;
import org.apache.pulsar.policies.data.loadbalancer.LocalBrokerData;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class OverloadShedderTest {
    private final OverloadShedder os = new OverloadShedder();
    private final ServiceConfiguration conf = new ServiceConfiguration();

    public OverloadShedderTest() {
        this.conf.setLoadBalancerBrokerOverloadedThresholdPercentage(85);
    }

    @Test
    public void testNoBrokers() {
        LoadData loadData = new LoadData();
        Assert.assertTrue((boolean)this.os.findBundlesForUnloading(loadData, this.conf).isEmpty());
    }

    @Test
    public void testBrokersWithNoBundles() {
        LoadData loadData = new LoadData();
        LocalBrokerData broker1 = new LocalBrokerData();
        broker1.setBandwidthIn(new ResourceUsage(999.0, 1000.0));
        broker1.setBandwidthOut(new ResourceUsage(999.0, 1000.0));
        loadData.getBrokerData().put("broker-1", new BrokerData(broker1));
        Assert.assertTrue((boolean)this.os.findBundlesForUnloading(loadData, this.conf).isEmpty());
    }

    @Test
    public void testBrokerNotOverloaded() {
        LoadData loadData = new LoadData();
        LocalBrokerData broker1 = new LocalBrokerData();
        broker1.setBandwidthIn(new ResourceUsage(500.0, 1000.0));
        broker1.setBandwidthOut(new ResourceUsage(500.0, 1000.0));
        broker1.setBundles((Set)Sets.newHashSet((Object[])new String[]{"bundle-1"}));
        BundleData bundle1 = new BundleData();
        TimeAverageMessageData db1 = new TimeAverageMessageData();
        db1.setMsgThroughputIn(1000.0);
        db1.setMsgThroughputOut(1000.0);
        bundle1.setShortTermData(db1);
        loadData.getBundleData().put("bundle-1", bundle1);
        loadData.getBrokerData().put("broker-1", new BrokerData(broker1));
        Assert.assertTrue((boolean)this.os.findBundlesForUnloading(loadData, this.conf).isEmpty());
    }

    @Test
    public void testBrokerWithSingleBundle() {
        LoadData loadData = new LoadData();
        LocalBrokerData broker1 = new LocalBrokerData();
        broker1.setBandwidthIn(new ResourceUsage(999.0, 1000.0));
        broker1.setBandwidthOut(new ResourceUsage(999.0, 1000.0));
        broker1.setBundles((Set)Sets.newHashSet((Object[])new String[]{"bundle-1"}));
        BundleData bundle1 = new BundleData();
        TimeAverageMessageData db1 = new TimeAverageMessageData();
        db1.setMsgThroughputIn(1000.0);
        db1.setMsgThroughputOut(1000.0);
        bundle1.setShortTermData(db1);
        loadData.getBundleData().put("bundle-1", bundle1);
        loadData.getBrokerData().put("broker-1", new BrokerData(broker1));
        Assert.assertTrue((boolean)this.os.findBundlesForUnloading(loadData, this.conf).isEmpty());
    }

    @Test
    public void testBrokerWithMultipleBundles() {
        int numBundles = 10;
        LoadData loadData = new LoadData();
        LocalBrokerData broker1 = new LocalBrokerData();
        broker1.setBandwidthIn(new ResourceUsage(999.0, 1000.0));
        broker1.setBandwidthOut(new ResourceUsage(999.0, 1000.0));
        LocalBrokerData anotherBroker = new LocalBrokerData();
        String anotherBrokerName = "another-broker";
        double brokerThroghput = 0.0;
        for (int i = 1; i <= numBundles; ++i) {
            broker1.getBundles().add("bundle-" + i);
            BundleData bundle = new BundleData();
            TimeAverageMessageData db = new TimeAverageMessageData();
            double throughput = i * 1024 * 1024;
            db.setMsgThroughputIn(throughput);
            db.setMsgThroughputOut(throughput);
            bundle.setShortTermData(db);
            loadData.getBundleData().put("bundle-" + i, bundle);
            String anotherBundleName = anotherBrokerName + "-bundle-" + (numBundles + i);
            loadData.getBundleData().put(anotherBundleName, bundle);
            anotherBroker.getBundles().add(anotherBundleName);
            brokerThroghput += throughput;
        }
        broker1.setMsgThroughputIn(brokerThroghput);
        broker1.setMsgThroughputOut(brokerThroghput);
        loadData.getBrokerData().put("broker-1", new BrokerData(broker1));
        loadData.getBrokerData().put(anotherBrokerName, new BrokerData(anotherBroker));
        Multimap bundlesToUnload = this.os.findBundlesForUnloading(loadData, this.conf);
        Assert.assertFalse((boolean)bundlesToUnload.isEmpty());
        Assert.assertEquals((Collection)bundlesToUnload.get((Object)"broker-1"), (Collection)Lists.newArrayList((Object[])new String[]{"bundle-10", "bundle-9"}));
    }

    @Test
    public void testFilterRecentlyUnloaded() {
        int numBundles = 10;
        LoadData loadData = new LoadData();
        LocalBrokerData broker1 = new LocalBrokerData();
        broker1.setBandwidthIn(new ResourceUsage(999.0, 1000.0));
        broker1.setBandwidthOut(new ResourceUsage(999.0, 1000.0));
        double brokerThroghput = 0.0;
        for (int i = 1; i <= numBundles; ++i) {
            broker1.getBundles().add("bundle-" + i);
            BundleData bundle = new BundleData();
            TimeAverageMessageData db = new TimeAverageMessageData();
            double throughput = i * 1024 * 1024;
            db.setMsgThroughputIn(throughput);
            db.setMsgThroughputOut(throughput);
            bundle.setShortTermData(db);
            loadData.getBundleData().put("bundle-" + i, bundle);
            brokerThroghput += throughput;
        }
        broker1.setMsgThroughputIn(brokerThroghput);
        broker1.setMsgThroughputOut(brokerThroghput);
        loadData.getBrokerData().put("broker-1", new BrokerData(broker1));
        loadData.getRecentlyUnloadedBundles().put("bundle-10", 1L);
        loadData.getRecentlyUnloadedBundles().put("bundle-9", 1L);
        Multimap bundlesToUnload = this.os.findBundlesForUnloading(loadData, this.conf);
        Assert.assertFalse((boolean)bundlesToUnload.isEmpty());
        Assert.assertEquals((Collection)bundlesToUnload.get((Object)"broker-1"), (Collection)Lists.newArrayList((Object[])new String[]{"bundle-8", "bundle-7"}));
    }

    @Test
    public void testPrintResourceUsage() {
        LocalBrokerData data = new LocalBrokerData();
        data.setCpu(new ResourceUsage(10.0, 100.0));
        data.setMemory(new ResourceUsage(50.0, 100.0));
        data.setDirectMemory(new ResourceUsage(90.0, 100.0));
        data.setBandwidthIn(new ResourceUsage(30.0, 100.0));
        data.setBandwidthOut(new ResourceUsage(20.0, 100.0));
        Assert.assertEquals((String)data.printResourceUsage(), (String)"cpu: 10.00%, memory: 50.00%, directMemory: 90.00%, bandwidthIn: 30.00%, bandwidthOut: 20.00%");
    }
}

