/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.lookup.http.v2;

import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.apache.pulsar.broker.lookup.v2.TopicLookup;
import org.apache.pulsar.broker.web.PulsarWebResourceTest;
import org.apache.pulsar.common.lookup.data.LookupData;
import org.apache.pulsar.common.naming.TopicName;
import org.glassfish.jersey.server.ResourceConfig;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TopicLookupTest
extends PulsarWebResourceTest {
    private static final String TOPIC_PATH = "/v2/topic/persistent/public/testns/testtopic";
    private TestableTopicLookup resource;

    @Override
    protected ResourceConfig configure() {
        this.resource = (TestableTopicLookup)((Object)Mockito.spy(TestableTopicLookup.class));
        return new ResourceConfig().register((Object)this.resource);
    }

    @Test
    public void testListenerName() {
        Response response = this.target(TOPIC_PATH).queryParam("listenerName", new Object[]{"query"}).request().get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((String)this.resource.actualListenerName, (String)"query");
        response = this.target(TOPIC_PATH).request().header("X-Pulsar-ListenerName", (Object)"header").get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((String)this.resource.actualListenerName, (String)"header");
        response = this.target(TOPIC_PATH).queryParam("listenerName", new Object[]{"query"}).request().header("X-Pulsar-ListenerName", (Object)"header").get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        Assert.assertEquals((String)this.resource.actualListenerName, (String)"query");
    }

    public static class TestableTopicLookup
    extends TopicLookup {
        private String actualListenerName;

        protected void internalLookupTopicAsync(TopicName topicName, boolean authoritative, AsyncResponse asyncResponse, String listenerName) {
            this.actualListenerName = listenerName;
            asyncResponse.resume((Object)new LookupData());
        }
    }
}

