/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.namespace.OwnerShipForCurrentServerTestBase;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class OwnerShipCacheForCurrentServerTest
extends OwnerShipForCurrentServerTestBase {
    private static final Logger log = LoggerFactory.getLogger(OwnerShipCacheForCurrentServerTest.class);
    private static final String TENANT = "ownership";
    private static final String NAMESPACE = "ownership/ns1";
    private static final Random RANDOM = new Random();

    @BeforeMethod
    protected void setup() throws Exception {
        this.internalSetup();
        String[] brokerServiceUrlArr = this.getPulsarServiceList().get(0).getBrokerServiceUrl().split(":");
        String webServicePort = brokerServiceUrlArr[brokerServiceUrlArr.length - 1];
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl("http://localhost:" + webServicePort).build());
        this.admin.tenants().createTenant(TENANT, (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NAMESPACE);
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() {
        super.internalCleanup();
    }

    @Test
    public void testOwnershipForCurrentServer() throws Exception {
        for (int i = 0; i < this.getPulsarServiceList().size(); ++i) {
            String topicName = this.newTopicName();
            this.admin.topics().createNonPartitionedTopic(topicName);
            NamespaceService namespaceService = this.getPulsarServiceList().get(i).getNamespaceService();
            NamespaceBundle bundle = namespaceService.getBundle(TopicName.get((String)topicName));
            Assert.assertEquals((String)((NamespaceEphemeralData)((Optional)namespaceService.getOwnerAsync(bundle).get()).get()).getNativeUrl(), (String)((NamespaceEphemeralData)((Optional)namespaceService.getOwnerAsync(bundle).get()).get()).getNativeUrl());
        }
    }

    @Test(timeOut=30000L)
    public void testCreateTopicWithNotTopicNsOwnedBroker() {
        String topicName = this.newTopicName();
        int verifiedBrokerNum = 0;
        for (PulsarService pulsarService : this.getPulsarServiceList()) {
            BrokerService bs = pulsarService.getBrokerService();
            if (bs.isTopicNsOwnedByBroker(TopicName.get((String)topicName))) continue;
            ++verifiedBrokerNum;
            try {
                bs.getOrCreateTopic(topicName).get();
            }
            catch (Exception ex) {
                AssertJUnit.assertTrue((boolean)(ex.getCause() instanceof BrokerServiceException.ServiceUnitNotReadyException));
            }
        }
        AssertJUnit.assertTrue((verifiedBrokerNum > 0 ? 1 : 0) != 0);
    }

    protected String newTopicName() {
        return "persistent://ownership/ns1/topic-" + Long.toHexString(RANDOM.nextLong());
    }
}

