/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import org.apache.pulsar.broker.service.AbstractSubscription;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AbstractSubscriptionTest {
    private Consumer consumer;
    private AbstractSubscription subscription;

    @BeforeMethod
    public void beforeMethod() {
        Dispatcher dispatcher = (Dispatcher)Mockito.mock(Dispatcher.class);
        this.consumer = (Consumer)Mockito.mock(Consumer.class);
        this.subscription = (AbstractSubscription)Mockito.spy(AbstractSubscription.class);
        Mockito.when((Object)this.subscription.getDispatcher()).thenReturn((Object)dispatcher);
        Mockito.when((Object)dispatcher.getConsumers()).thenReturn(Collections.singletonList(this.consumer));
    }

    @Test
    public void testGetMsgOutCounter() {
        this.subscription.msgOutFromRemovedConsumer.add(1L);
        Mockito.when((Object)this.consumer.getMsgOutCounter()).thenReturn((Object)2L);
        Assert.assertEquals((long)this.subscription.getMsgOutCounter(), (long)3L);
    }

    @Test
    public void testGetBytesOutCounter() {
        this.subscription.bytesOutFromRemovedConsumers.add(1L);
        Mockito.when((Object)this.consumer.getBytesOutCounter()).thenReturn((Object)2L);
        Assert.assertEquals((long)this.subscription.getBytesOutCounter(), (long)3L);
    }
}

