/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.AbstractSubscription;
import org.apache.pulsar.broker.service.AbstractTopic;
import org.apache.pulsar.broker.service.BacklogQuotaManager;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AbstractTopicTest {
    private AbstractSubscription subscription;
    private AbstractTopic topic;

    @BeforeMethod
    public void beforeMethod() {
        BrokerService brokerService = (BrokerService)Mockito.mock(BrokerService.class);
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ServiceConfiguration serviceConfiguration = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        BacklogQuotaManager backlogQuotaManager = (BacklogQuotaManager)Mockito.mock(BacklogQuotaManager.class);
        this.subscription = (AbstractSubscription)Mockito.mock(AbstractSubscription.class);
        Mockito.when((Object)brokerService.pulsar()).thenReturn((Object)pulsarService);
        Mockito.when((Object)pulsarService.getConfiguration()).thenReturn((Object)serviceConfiguration);
        Mockito.when((Object)brokerService.getBacklogQuotaManager()).thenReturn((Object)backlogQuotaManager);
        this.topic = (AbstractTopic)Mockito.mock(AbstractTopic.class, (MockSettings)Mockito.withSettings().useConstructor(new Object[]{"topic", brokerService}).defaultAnswer(Mockito.CALLS_REAL_METHODS));
        ConcurrentOpenHashMap subscriptions = ConcurrentOpenHashMap.newBuilder().expectedItems(16).concurrencyLevel(1).build();
        subscriptions.put((Object)"subscription", (Object)this.subscription);
        Mockito.when((Object)this.topic.getSubscriptions()).thenAnswer(invocation -> subscriptions);
    }

    @Test
    public void testGetMsgOutCounter() {
        this.topic.msgOutFromRemovedSubscriptions.add(1L);
        Mockito.when((Object)this.subscription.getMsgOutCounter()).thenReturn((Object)2L);
        Assert.assertEquals((long)this.topic.getMsgOutCounter(), (long)3L);
    }

    @Test
    public void testGetBytesOutCounter() {
        this.topic.bytesOutFromRemovedSubscriptions.add(1L);
        Mockito.when((Object)this.subscription.getBytesOutCounter()).thenReturn((Object)2L);
        Assert.assertEquals((long)this.topic.getBytesOutCounter(), (long)3L);
    }
}

