/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.apache.zookeeper.data.Stat;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class AdvertisedAddressTest {
    LocalBookkeeperEnsemble bkEnsemble;
    PulsarService pulsar;
    private final String advertisedAddress = "pulsar-usc.example.com";

    @BeforeMethod
    public void setup() throws Exception {
        this.bkEnsemble = new LocalBookkeeperEnsemble(1, 0, () -> 0);
        this.bkEnsemble.start();
        ServiceConfiguration config = new ServiceConfiguration();
        config.setBrokerShutdownTimeoutMs(0L);
        config.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
        config.setWebServicePort(Optional.ofNullable(0));
        config.setClusterName("usc");
        config.setAdvertisedAddress("localhost");
        config.setBrokerServicePort(Optional.ofNullable(0));
        config.setAdvertisedAddress("pulsar-usc.example.com");
        config.setManagedLedgerDefaultEnsembleSize(1);
        config.setManagedLedgerDefaultWriteQuorum(1);
        config.setManagedLedgerDefaultAckQuorum(1);
        config.setManagedLedgerMaxEntriesPerLedger(5);
        config.setManagedLedgerMinLedgerRolloverTimeMinutes(0);
        this.pulsar = new PulsarService(config);
        this.pulsar.start();
    }

    @AfterMethod(alwaysRun=true)
    public void shutdown() throws Exception {
        this.pulsar.close();
        this.bkEnsemble.stop();
    }

    @Test
    public void testAdvertisedAddress() throws Exception {
        Assert.assertEquals((String)this.pulsar.getAdvertisedAddress(), (String)"pulsar-usc.example.com");
        Assert.assertEquals((String)this.pulsar.getBrokerServiceUrl(), (String)String.format("pulsar://%s:%d", "pulsar-usc.example.com", this.pulsar.getBrokerListenPort().get()));
        Assert.assertEquals((String)this.pulsar.getSafeWebServiceAddress(), (String)String.format("http://%s:%d", "pulsar-usc.example.com", this.pulsar.getListenPortHTTP().get()));
        String brokerZkPath = String.format("/loadbalance/brokers/%s:%d", this.pulsar.getAdvertisedAddress(), this.pulsar.getListenPortHTTP().get());
        String bkBrokerData = new String(this.bkEnsemble.getZkClient().getData(brokerZkPath, false, new Stat()), StandardCharsets.UTF_8);
        JsonObject jsonBkBrokerData = (JsonObject)new Gson().fromJson(bkBrokerData, JsonObject.class);
        Assert.assertEquals((String)jsonBkBrokerData.get("pulsarServiceUrl").getAsString(), (String)this.pulsar.getBrokerServiceUrl());
        Assert.assertEquals((String)jsonBkBrokerData.get("webServiceUrl").getAsString(), (String)this.pulsar.getSafeWebServiceAddress());
    }
}

