/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.cache.ConfigurationCacheService;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.broker.service.BacklogQuotaManager;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BacklogQuotaManagerConfigurationTest {
    private ServiceConfiguration serviceConfiguration;
    private PulsarService pulsarService;

    @BeforeMethod
    public void setup() {
        this.serviceConfiguration = new ServiceConfiguration();
        this.initializeServiceConfiguration();
        this.pulsarService = this.getPulsarService();
    }

    @Test
    public void testBacklogQuotaDefaultLimitGBConversion() {
        this.serviceConfiguration.setBacklogQuotaDefaultLimitGB(1.6);
        BacklogQuotaManager backlogQuotaManager = new BacklogQuotaManager(this.pulsarService);
        Assert.assertEquals((long)backlogQuotaManager.getDefaultQuota().getLimitSize(), (long)0x66666666L);
    }

    @Test
    public void testBacklogQuotaDefaultLimitPrecedence() {
        this.serviceConfiguration.setBacklogQuotaDefaultLimitGB(1.6);
        this.serviceConfiguration.setBacklogQuotaDefaultLimitBytes(123L);
        BacklogQuotaManager backlogQuotaManager = new BacklogQuotaManager(this.pulsarService);
        Assert.assertEquals((long)backlogQuotaManager.getDefaultQuota().getLimitSize(), (long)0x66666666L);
    }

    @Test
    public void testBacklogQuotaDefaultLimitBytes() {
        this.serviceConfiguration.setBacklogQuotaDefaultLimitGB(0.0);
        this.serviceConfiguration.setBacklogQuotaDefaultLimitBytes(123L);
        BacklogQuotaManager backlogQuotaManager = new BacklogQuotaManager(this.pulsarService);
        Assert.assertEquals((long)backlogQuotaManager.getDefaultQuota().getLimitSize(), (long)123L);
    }

    private void initializeServiceConfiguration() {
        this.serviceConfiguration.setClusterName("test");
        this.serviceConfiguration.setZookeeperServers("localhost:2181");
    }

    private PulsarService getPulsarService() {
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ConfigurationCacheService configurationCacheService = (ConfigurationCacheService)Mockito.mock(ConfigurationCacheService.class);
        Mockito.when((Object)pulsarService.getConfiguration()).thenReturn((Object)this.serviceConfiguration);
        Mockito.when((Object)pulsarService.getPulsarResources()).thenReturn(Mockito.mock(PulsarResources.class));
        return pulsarService;
    }
}

