/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.tests.TestRetrySupport;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class BkEnsemblesTestBase
extends TestRetrySupport {
    private static final Logger log = LoggerFactory.getLogger(BkEnsemblesTestBase.class);
    protected PulsarService pulsar;
    protected ServiceConfiguration config;
    protected PulsarAdmin admin;
    protected LocalBookkeeperEnsemble bkEnsemble;
    private final int numberOfBookies;

    public BkEnsemblesTestBase() {
        this(3);
    }

    public BkEnsemblesTestBase(int numberOfBookies) {
        this.numberOfBookies = numberOfBookies;
    }

    protected void configurePulsar(ServiceConfiguration config) throws Exception {
    }

    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        this.incrementSetupNumber();
        try {
            this.bkEnsemble = new LocalBookkeeperEnsemble(this.numberOfBookies, 0, () -> 0);
            this.bkEnsemble.start();
            this.config = new ServiceConfiguration();
            this.config.setZookeeperServers("127.0.0.1:" + this.bkEnsemble.getZookeeperPort());
            this.config.setAdvertisedAddress("localhost");
            this.config.setWebServicePort(Optional.of(0));
            this.config.setClusterName("usc");
            this.config.setBrokerShutdownTimeoutMs(0L);
            this.config.setBrokerServicePort(Optional.of(0));
            this.config.setAuthorizationEnabled(false);
            this.config.setAuthenticationEnabled(false);
            this.config.setManagedLedgerMaxEntriesPerLedger(5);
            this.config.setManagedLedgerMinLedgerRolloverTimeMinutes(0);
            this.config.setAdvertisedAddress("127.0.0.1");
            this.config.setAllowAutoTopicCreationType("non-partitioned");
            this.config.setZooKeeperOperationTimeoutSeconds(10);
            this.config.setNumIOThreads(1);
            Properties properties = new Properties();
            properties.put("bookkeeper_numWorkerThreads", "1");
            this.config.setProperties(properties);
            this.configurePulsar(this.config);
            this.pulsar = new PulsarService(this.config);
            this.pulsar.start();
            this.admin = PulsarAdmin.builder().serviceHttpUrl(this.pulsar.getWebServiceAddress()).build();
            this.admin.clusters().createCluster("usc", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
            this.admin.tenants().createTenant("prop", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1"}), (Set)Sets.newHashSet((Object[])new String[]{"usc"})));
        }
        catch (Throwable t) {
            log.error("Error setting up broker test", t);
            Assert.fail((String)"Broker test setup failed");
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        this.markCurrentSetupNumberCleaned();
        this.admin.close();
        this.pulsar.close();
        this.bkEnsemble.stop();
    }
}

