/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Optional;
import java.util.Properties;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.admin.internal.PulsarAdminImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ClusterDataImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BrokerInternalClientConfigurationOverrideTest
extends BrokerTestBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testPulsarServiceAdminClientConfiguration() throws PulsarServerException {
        Properties config = this.pulsar.getConfiguration().getProperties();
        config.setProperty("brokerClient_operationTimeoutMs", "60000");
        config.setProperty("brokerClient_statsIntervalSeconds", "10");
        ClientConfigurationData clientConf = ((PulsarAdminImpl)this.pulsar.getAdminClient()).getClientConfigData();
        Assert.assertEquals((long)clientConf.getOperationTimeoutMs(), (long)60000L);
        Assert.assertEquals((long)clientConf.getStatsIntervalSeconds(), (long)10L);
    }

    @Test
    public void testPulsarServicePulsarClientConfiguration() throws PulsarServerException {
        Properties config = this.pulsar.getConfiguration().getProperties();
        config.setProperty("brokerClient_operationTimeoutMs", "60000");
        config.setProperty("brokerClient_statsIntervalSeconds", "10");
        this.pulsar.getConfiguration().setBrokerClientAuthenticationParameters("sensitive");
        ClientConfigurationData clientConf = ((PulsarClientImpl)this.pulsar.getClient()).getConfiguration();
        Assert.assertEquals((long)clientConf.getOperationTimeoutMs(), (long)60000L);
        Assert.assertEquals((long)clientConf.getStatsIntervalSeconds(), (long)10L);
        Assert.assertEquals((String)clientConf.getAuthParams(), (String)"sensitive");
    }

    @Test
    public void testBrokerServicePulsarClientConfiguration() {
        ClusterData data = ClusterData.builder().serviceUrl("http://localhost:8080").build();
        Properties config = this.pulsar.getConfiguration().getProperties();
        config.setProperty("brokerClient_operationTimeoutMs", "60000");
        config.setProperty("brokerClient_statsIntervalSeconds", "10");
        config.setProperty("memoryLimitBytes", "10");
        config.setProperty("brokerClient_memoryLimitBytes", "100000");
        PulsarClientImpl client = (PulsarClientImpl)this.pulsar.getBrokerService().getReplicationClient("an_arbitrary_name", Optional.of(data));
        ClientConfigurationData clientConf = client.getConfiguration();
        Assert.assertEquals((long)clientConf.getOperationTimeoutMs(), (long)60000L);
        Assert.assertEquals((long)clientConf.getStatsIntervalSeconds(), (long)10L);
        Assert.assertEquals((long)clientConf.getMemoryLimitBytes(), (long)100000L);
    }

    @Test
    public void testNamespaceServicePulsarClientConfiguration() {
        ClusterDataImpl data = (ClusterDataImpl)ClusterData.builder().serviceUrl("http://localhost:8080").build();
        Properties config = this.pulsar.getConfiguration().getProperties();
        config.setProperty("brokerClient_operationTimeoutMs", "60000");
        config.setProperty("brokerClient_statsIntervalSeconds", "10");
        config.setProperty("memoryLimitBytes", "10");
        config.setProperty("brokerClient_memoryLimitBytes", "100000");
        PulsarClientImpl client = this.pulsar.getNamespaceService().getNamespaceClient(data);
        ClientConfigurationData clientConf = client.getConfiguration();
        Assert.assertEquals((long)clientConf.getOperationTimeoutMs(), (long)60000L);
        Assert.assertEquals((long)clientConf.getStatsIntervalSeconds(), (long)10L);
        Assert.assertEquals((long)clientConf.getMemoryLimitBytes(), (long)100000L);
    }
}

