/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AutoTopicCreationOverride;
import org.apache.pulsar.common.policies.data.TopicType;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BrokerServiceAutoTopicCreationTest
extends BrokerTestBase {
    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanupTest() throws Exception {
        this.pulsar.getAdminClient().namespaces().removeAutoTopicCreation("prop/ns-abc");
    }

    @Test
    public void testAutoNonPartitionedTopicCreation() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("non-partitioned");
        String topicString = "persistent://prop/ns-abc/non-partitioned-topic";
        String subscriptionName = "non-partitioned-topic-sub";
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/non-partitioned-topic"}).subscriptionName("non-partitioned-topic-sub").subscribe();
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/non-partitioned-topic"));
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/non-partitioned-topic"));
    }

    @Test
    public void testAutoNonPartitionedTopicCreationOnProduce() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("non-partitioned");
        String topicString = "persistent://prop/ns-abc/non-partitioned-topic-2";
        this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/non-partitioned-topic-2").create();
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/non-partitioned-topic-2"));
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/non-partitioned-topic-2"));
    }

    @Test
    public void testAutoPartitionedTopicCreation() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(3);
        String topicString = "persistent://prop/ns-abc/partitioned-topic";
        String subscriptionName = "partitioned-topic-sub";
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/partitioned-topic"}).subscriptionName("partitioned-topic-sub").subscribe();
        Assert.assertTrue((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-topic"));
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-topic-partition-" + i));
        }
    }

    @Test
    public void testAutoPartitionedTopicCreationOnProduce() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(3);
        String topicString = "persistent://prop/ns-abc/partitioned-topic-1";
        this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/partitioned-topic-1").create();
        Assert.assertTrue((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-topic-1"));
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-topic-1-partition-" + i));
        }
    }

    @Test
    public void testAutoTopicCreationDisable() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        String topicString = "persistent://prop/ns-abc/test-topic";
        String subscriptionName = "test-topic-sub";
        try {
            this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/test-topic"}).subscriptionName("test-topic-sub").subscribe();
            Assert.fail((String)"Subscribe operation should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarClientException));
        }
        Assert.assertFalse((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic"));
    }

    @Test
    public void testAutoTopicCreationDisableIfNonPartitionedTopicAlreadyExist() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(3);
        String topicString = "persistent://prop/ns-abc/test-topic-2";
        String subscriptionName = "partitioned-topic-sub";
        this.admin.topics().createNonPartitionedTopic("persistent://prop/ns-abc/test-topic-2");
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/test-topic-2"}).subscriptionName("partitioned-topic-sub").subscribe();
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-2"));
        for (int i = 0; i < 3; ++i) {
            Assert.assertFalse((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-2-partition-" + i));
        }
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-2"));
    }

    @Test
    public void testGetPartitionedMetadataWithoutCheckAllowAutoCreation() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(3);
        String topicString = "persistent://prop/ns-abc/test-topic-3";
        try {
            this.admin.topics().getPartitionedTopicMetadata("persistent://prop/ns-abc/test-topic-3");
        }
        catch (PulsarAdminException.NotFoundException notFoundException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-3"));
    }

    @Test
    public void testAutoCreationNamespaceAllowOverridesBroker() throws Exception {
        String topicString = "persistent://prop/ns-abc/test-topic-4";
        String subscriptionName = "test-topic-sub-4";
        TopicName topicName = TopicName.get((String)"persistent://prop/ns-abc/test-topic-4");
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        AutoTopicCreationOverride autoTopicCreationOverride = AutoTopicCreationOverride.builder().allowAutoTopicCreation(true).topicType(TopicType.NON_PARTITIONED.toString()).build();
        this.pulsar.getAdminClient().namespaces().setAutoTopicCreation(topicName.getNamespace(), autoTopicCreationOverride);
        Assert.assertEquals((Object)this.pulsar.getAdminClient().namespaces().getAutoTopicCreation(topicName.getNamespace()), (Object)autoTopicCreationOverride);
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/test-topic-4"}).subscriptionName("test-topic-sub-4").subscribe();
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-4"));
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-4"));
    }

    @Test
    public void testAutoCreationNamespaceDisallowOverridesBroker() throws Exception {
        String topicString = "persistent://prop/ns-abc/test-topic-5";
        String subscriptionName = "test-topic-sub-5";
        TopicName topicName = TopicName.get((String)"persistent://prop/ns-abc/test-topic-5");
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        AutoTopicCreationOverride autoTopicCreationOverride = AutoTopicCreationOverride.builder().allowAutoTopicCreation(false).build();
        this.pulsar.getAdminClient().namespaces().setAutoTopicCreation(topicName.getNamespace(), autoTopicCreationOverride);
        Assert.assertEquals((Object)this.pulsar.getAdminClient().namespaces().getAutoTopicCreation(topicName.getNamespace()), (Object)autoTopicCreationOverride);
        try {
            this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/test-topic-5"}).subscriptionName("test-topic-sub-5").subscribe();
            Assert.fail((String)"Subscribe operation should have failed");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarClientException));
        }
        Assert.assertFalse((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-5"));
    }

    @Test
    public void testAutoCreationNamespaceOverrideAllowsPartitionedTopics() throws Exception {
        String topicString = "persistent://prop/ns-abc/partitioned-test-topic-6";
        TopicName topicName = TopicName.get((String)"persistent://prop/ns-abc/partitioned-test-topic-6");
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        AutoTopicCreationOverride autoTopicCreationOverride = AutoTopicCreationOverride.builder().allowAutoTopicCreation(true).topicType(TopicType.PARTITIONED.toString()).defaultNumPartitions(Integer.valueOf(4)).build();
        this.pulsar.getAdminClient().namespaces().setAutoTopicCreation(topicName.getNamespace(), autoTopicCreationOverride);
        Assert.assertEquals((Object)this.pulsar.getAdminClient().namespaces().getAutoTopicCreation(topicName.getNamespace()), (Object)autoTopicCreationOverride);
        String subscriptionName = "test-topic-sub-6";
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/partitioned-test-topic-6"}).subscriptionName("test-topic-sub-6").subscribe();
        Assert.assertTrue((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-test-topic-6"));
        for (int i = 0; i < 4; ++i) {
            Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-test-topic-6-partition-" + i));
        }
    }

    @Test
    public void testAutoCreationNamespaceOverridesTopicTypePartitioned() throws Exception {
        String topicString = "persistent://prop/ns-abc/partitioned-test-topic-7";
        TopicName topicName = TopicName.get((String)"persistent://prop/ns-abc/partitioned-test-topic-7");
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("non-partitioned");
        this.pulsar.getAdminClient().namespaces().setAutoTopicCreation(topicName.getNamespace(), AutoTopicCreationOverride.builder().allowAutoTopicCreation(true).topicType(TopicType.PARTITIONED.toString()).defaultNumPartitions(Integer.valueOf(3)).build());
        String subscriptionName = "test-topic-sub-7";
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/partitioned-test-topic-7"}).subscriptionName("test-topic-sub-7").subscribe();
        Assert.assertTrue((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-test-topic-7"));
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-test-topic-7-partition-" + i));
        }
    }

    @Test
    public void testAutoCreationNamespaceOverridesTopicTypeNonPartitioned() throws Exception {
        String topicString = "persistent://prop/ns-abc/partitioned-test-topic-8";
        TopicName topicName = TopicName.get((String)"persistent://prop/ns-abc/partitioned-test-topic-8");
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(2);
        this.pulsar.getAdminClient().namespaces().setAutoTopicCreation(topicName.getNamespace(), AutoTopicCreationOverride.builder().allowAutoTopicCreation(true).topicType(TopicType.NON_PARTITIONED.toString()).build());
        String subscriptionName = "test-topic-sub-8";
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/partitioned-test-topic-8"}).subscriptionName("test-topic-sub-8").subscribe();
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-test-topic-8"));
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-test-topic-8"));
    }

    @Test
    public void testAutoCreationNamespaceOverridesDefaultNumPartitions() throws Exception {
        String topicString = "persistent://prop/ns-abc/partitioned-test-topic-9";
        TopicName topicName = TopicName.get((String)"persistent://prop/ns-abc/partitioned-test-topic-9");
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(2);
        this.pulsar.getAdminClient().namespaces().setAutoTopicCreation(topicName.getNamespace(), AutoTopicCreationOverride.builder().allowAutoTopicCreation(true).topicType(TopicType.PARTITIONED.toString()).defaultNumPartitions(Integer.valueOf(4)).build());
        String subscriptionName = "test-topic-sub-9";
        this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/partitioned-test-topic-9"}).subscriptionName("test-topic-sub-9").subscribe();
        Assert.assertTrue((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-test-topic-9"));
        for (int i = 0; i < 4; ++i) {
            Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/partitioned-test-topic-9-partition-" + i));
        }
    }

    @Test
    public void testAutoCreationNamespaceAllowOverridesBrokerOnProduce() throws Exception {
        String topicString = "persistent://prop/ns-abc/test-topic-10";
        TopicName topicName = TopicName.get((String)"persistent://prop/ns-abc/test-topic-10");
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        this.pulsar.getAdminClient().namespaces().setAutoTopicCreation(topicName.getNamespace(), AutoTopicCreationOverride.builder().allowAutoTopicCreation(true).topicType(TopicType.NON_PARTITIONED.toString()).build());
        this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/test-topic-10").create();
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-10"));
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/test-topic-10"));
    }

    @Test
    public void testNotAllowSubscriptionTopicCreation() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        String topicName = "persistent://prop/ns-abc/non-partitioned-topic" + System.currentTimeMillis();
        String subscriptionName = "non-partitioned-topic-sub";
        try {
            this.admin.topics().createSubscription(topicName, subscriptionName, MessageId.earliest);
            Assert.fail((String)"should fail to create subscription once not allowAutoTopicCreation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.admin.topics().createSubscription(topicName + "-partition-0", subscriptionName, MessageId.earliest);
            Assert.fail((String)"should fail to create subscription once not allowAutoTopicCreation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains(topicName));
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains(topicName));
        try {
            this.admin.topics().createNonPartitionedTopic(topicName);
            this.admin.topics().createSubscription(topicName, subscriptionName, MessageId.earliest);
        }
        catch (Exception e) {
            Assert.fail((String)"should success to create subscription once topic created");
        }
        try {
            String partitionTopic = "persistent://prop/ns-abc/partitioned-topic" + System.currentTimeMillis();
            this.admin.topics().createPartitionedTopic(partitionTopic, 1);
            this.admin.topics().createSubscription(partitionTopic + "-partition-0", subscriptionName, MessageId.earliest);
        }
        catch (Exception e) {
            Assert.fail((String)"should success to create subscription once topic created");
        }
    }

    @Test
    public void testAutoCreationNamespaceOverridesSubscriptionTopicCreation() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        String topicString = "persistent://prop/ns-abc/non-partitioned-topic" + System.currentTimeMillis();
        String subscriptionName = "non-partitioned-topic-sub";
        TopicName topicName = TopicName.get((String)topicString);
        this.pulsar.getAdminClient().namespaces().setAutoTopicCreation(topicName.getNamespace(), AutoTopicCreationOverride.builder().allowAutoTopicCreation(true).topicType(TopicType.NON_PARTITIONED.toString()).build());
        this.admin.topics().createSubscription(topicString, subscriptionName, MessageId.earliest);
    }

    @Test
    public void testMaxNumPartitionsPerPartitionedTopicTopicCreation() {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(true);
        this.pulsar.getConfiguration().setAllowAutoTopicCreationType("partitioned");
        this.pulsar.getConfiguration().setDefaultNumPartitions(3);
        this.pulsar.getConfiguration().setMaxNumPartitionsPerPartitionedTopic(2);
        String topicString = "persistent://prop/ns-abc/partitioned-test-topic-11";
        String subscriptionName = "test-topic-sub-11";
        try {
            this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop/ns-abc/partitioned-test-topic-11"}).subscriptionName("test-topic-sub-11").subscribe();
            Assert.fail((String)"should throw exception when number of partitions exceed than max partitions");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof PulsarClientException));
        }
    }

    @Test
    public void testAutoCreationOfSystemTopicTransactionBufferSnapshot() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        this.pulsar.getConfiguration().setSystemTopicEnabled(true);
        String topicString = "persistent://prop/ns-abc/__transaction_buffer_snapshot";
        this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/__transaction_buffer_snapshot").create();
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/__transaction_buffer_snapshot"));
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/__transaction_buffer_snapshot"));
    }

    @Test
    public void testAutoCreationOfSystemTopicNamespaceEvents() throws Exception {
        this.pulsar.getConfiguration().setAllowAutoTopicCreation(false);
        this.pulsar.getConfiguration().setSystemTopicEnabled(true);
        String topicString = "persistent://prop/ns-abc/__change_events";
        this.pulsarClient.newProducer().topic("persistent://prop/ns-abc/__change_events").create();
        Assert.assertTrue((boolean)this.admin.namespaces().getTopics("prop/ns-abc").contains("persistent://prop/ns-abc/__change_events"));
        Assert.assertFalse((boolean)this.admin.topics().getPartitionedTopicList("prop/ns-abc").contains("persistent://prop/ns-abc/__change_events"));
    }
}

