/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BrokerServiceBundlesCacheInvalidationTest
extends BrokerTestBase {
    private static final Logger log = LoggerFactory.getLogger(BrokerServiceBundlesCacheInvalidationTest.class);

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testRecreateNamespace() throws Exception {
        String namespace = "prop/test-" + System.nanoTime();
        String topic = namespace + "/my-topic";
        this.admin.namespaces().createNamespace(namespace, 20);
        Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic(topic).create();
        producer.send((Object)"Hello");
        producer.close();
        this.admin.topics().delete(topic);
        this.admin.namespaces().deleteNamespace(namespace, false);
        this.admin.namespaces().createNamespace(namespace, 32);
        BundlesData bundlesData = this.admin.namespaces().getBundles(namespace);
        log.info("BUNDLES: {}", (Object)this.admin.namespaces().getBundles(namespace));
        Assert.assertEquals((int)bundlesData.getNumBundles(), (int)32);
    }
}

