/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.net.SocketAddress;
import java.util.Collections;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.KeySharedMeta;
import org.apache.pulsar.common.api.proto.KeySharedMode;
import org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ConsumerTest {
    private Consumer consumer;
    private final ConsumerStatsImpl stats = new ConsumerStatsImpl();

    @BeforeMethod
    public void beforeMethod() {
        Subscription subscription = (Subscription)Mockito.mock(Subscription.class);
        ServerCnx cnx = (ServerCnx)Mockito.mock(ServerCnx.class);
        SocketAddress address = (SocketAddress)Mockito.mock(SocketAddress.class);
        Topic topic = (Topic)Mockito.mock(Topic.class);
        BrokerService brokerService = (BrokerService)Mockito.mock(BrokerService.class);
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ServiceConfiguration serviceConfiguration = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        Mockito.when((Object)cnx.clientAddress()).thenReturn((Object)address);
        Mockito.when((Object)subscription.getTopic()).thenReturn((Object)topic);
        Mockito.when((Object)topic.getBrokerService()).thenReturn((Object)brokerService);
        Mockito.when((Object)brokerService.getPulsar()).thenReturn((Object)pulsarService);
        Mockito.when((Object)pulsarService.getConfiguration()).thenReturn((Object)serviceConfiguration);
        this.consumer = new Consumer(subscription, CommandSubscribe.SubType.Exclusive, "topic", 1L, 0, "Cons1", 1, (TransportCnx)cnx, "myrole-1", Collections.emptyMap(), false, CommandSubscribe.InitialPosition.Earliest, new KeySharedMeta().setKeySharedMode(KeySharedMode.AUTO_SPLIT), MessageId.latest);
    }

    @Test
    public void testGetMsgOutCounter() {
        this.stats.msgOutCounter = 1L;
        this.consumer.updateStats(this.stats);
        Assert.assertEquals((long)this.consumer.getMsgOutCounter(), (long)1L);
    }

    @Test
    public void testGetBytesOutCounter() {
        this.stats.bytesOutCounter = 1L;
        this.consumer.updateStats(this.stats);
        Assert.assertEquals((long)this.consumer.getBytesOutCounter(), (long)1L);
    }
}

