/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.HashRangeAutoSplitStickyKeyConsumerSelector;
import org.apache.pulsar.client.api.Range;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class HashRangeAutoSplitStickyKeyConsumerSelectorTest {
    @Test
    public void testGetConsumerKeyHashRanges() throws BrokerServiceException.ConsumerAssignException {
        HashRangeAutoSplitStickyKeyConsumerSelector selector = new HashRangeAutoSplitStickyKeyConsumerSelector(64);
        List<String> consumerName = Arrays.asList("consumer1", "consumer2", "consumer3", "consumer4");
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        for (String s : consumerName) {
            Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
            Mockito.when((Object)consumer.consumerName()).thenReturn((Object)s);
            selector.addConsumer(consumer);
            consumers.add(consumer);
        }
        HashMap expectedResult = new HashMap();
        expectedResult.put(consumers.get(0), Collections.singletonList(Range.of((int)49, (int)64)));
        expectedResult.put(consumers.get(3), Collections.singletonList(Range.of((int)33, (int)48)));
        expectedResult.put(consumers.get(1), Collections.singletonList(Range.of((int)17, (int)32)));
        expectedResult.put(consumers.get(2), Collections.singletonList(Range.of((int)0, (int)16)));
        for (Map.Entry entry : selector.getConsumerKeyHashRanges().entrySet()) {
            Assert.assertEquals((Collection)((Collection)entry.getValue()), (Collection)((Collection)expectedResult.get(entry.getKey())));
            expectedResult.remove(entry.getKey());
        }
        Assert.assertEquals((int)expectedResult.size(), (int)0);
    }

    @Test
    public void testGetConsumerKeyHashRangesWithSameConsumerName() throws Exception {
        HashRangeAutoSplitStickyKeyConsumerSelector selector = new HashRangeAutoSplitStickyKeyConsumerSelector(64);
        String consumerName = "My-consumer";
        ArrayList<Consumer> consumers = new ArrayList<Consumer>();
        for (int i = 0; i < 3; ++i) {
            Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
            Mockito.when((Object)consumer.consumerName()).thenReturn((Object)"My-consumer");
            selector.addConsumer(consumer);
            consumers.add(consumer);
        }
        List prev = null;
        for (Consumer consumer : consumers) {
            List ranges = (List)selector.getConsumerKeyHashRanges().get(consumer);
            Assert.assertEquals((int)ranges.size(), (int)1);
            if (prev != null) {
                Assert.assertNotEquals((Object)prev, (Object)ranges);
            }
            prev = ranges;
        }
    }
}

