/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.RegexSubscriptionMode;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NonPersistentTopicE2ETest
extends BrokerTestBase {
    @Override
    @BeforeMethod(alwaysRun=true)
    protected void setup() throws Exception {
        this.conf.setBrokerDeleteInactivePartitionedTopicMetadataEnabled(true);
        this.conf.setBrokerDeleteInactiveTopicsFrequencySeconds(1);
        super.baseSetup();
    }

    @Override
    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    private Optional<Topic> getTopic(String topicName) {
        return this.pulsar.getBrokerService().getTopicReference(topicName);
    }

    private boolean topicHasSchema(String topicName) {
        String base = TopicName.get((String)topicName).getPartitionedTopicName();
        String schemaName = TopicName.get((String)base).getSchemaName();
        SchemaRegistry.SchemaAndMetadata result = (SchemaRegistry.SchemaAndMetadata)this.pulsar.getSchemaRegistryService().getSchema(schemaName).join();
        return result != null && !result.schema.isDeleted();
    }

    @Test(groups={"broker"})
    public void testGCWillDeleteSchema() throws Exception {
        String topicName = "non-persistent://prop/ns-abc/topic-1";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        producer.close();
        Optional<Topic> topic = this.getTopic(topicName);
        Assert.assertTrue((boolean)topic.isPresent());
        byte[] data = JSONSchema.of((SchemaDefinition)SchemaDefinition.builder().withPojo(Foo.class).build()).getSchemaInfo().getSchema();
        SchemaData schemaData = SchemaData.builder().data(data).type(SchemaType.BYTES).user("foo").build();
        topic.get().addSchema(schemaData).join();
        Assert.assertTrue((boolean)this.topicHasSchema(topicName));
        this.runGC();
        topic = this.getTopic(topicName);
        Assert.assertFalse((boolean)topic.isPresent());
        Assert.assertFalse((boolean)this.topicHasSchema(topicName));
        topicName = "non-persistent://prop/ns-abc/topic-1a";
        String subName = "sub1";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subName).subscribe();
        topic = this.getTopic(topicName);
        Assert.assertTrue((boolean)topic.isPresent());
        topic.get().addSchema(schemaData).join();
        Assert.assertTrue((boolean)this.topicHasSchema(topicName));
        this.admin.topics().deleteSubscription(topicName, subName);
        consumer.close();
        this.runGC();
        topic = this.getTopic(topicName);
        Assert.assertFalse((boolean)topic.isPresent());
        Assert.assertFalse((boolean)this.topicHasSchema(topicName));
        topicName = "non-persistent://prop/ns-abc/topic-2";
        subName = "sub1";
        consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subName).subscribe();
        topic = this.getTopic(topicName);
        Assert.assertTrue((boolean)topic.isPresent());
        topic.get().addSchema(schemaData).join();
        Assert.assertTrue((boolean)this.topicHasSchema(topicName));
        this.runGC();
        topic = this.getTopic(topicName);
        Assert.assertTrue((boolean)topic.isPresent());
        Assert.assertTrue((boolean)this.topicHasSchema(topicName));
        consumer.close();
        this.runGC();
        topic = this.getTopic(topicName);
        Assert.assertTrue((boolean)topic.isPresent());
        Assert.assertTrue((boolean)this.topicHasSchema(topicName));
        this.admin.topics().deleteSubscription(topicName, subName);
        this.runGC();
        topic = this.getTopic(topicName);
        Assert.assertFalse((boolean)topic.isPresent());
        Assert.assertFalse((boolean)this.topicHasSchema(topicName));
    }

    @Test(groups={"broker"})
    public void testPatternTopic() throws PulsarClientException, InterruptedException {
        int i;
        String topic1 = "non-persistent://prop/ns-abc/testPatternTopic1-" + UUID.randomUUID().toString();
        String topic2 = "non-persistent://prop/ns-abc/testPatternTopic2-" + UUID.randomUUID().toString();
        Pattern pattern = Pattern.compile("prop/ns-abc/test.*");
        Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topicsPattern(pattern).subscriptionName("my-sub").patternAutoDiscoveryPeriod(1, TimeUnit.SECONDS).subscriptionTopicsMode(RegexSubscriptionMode.AllTopics).subscribe();
        Producer producer1 = this.pulsarClient.newProducer(Schema.STRING).topic(topic1).create();
        Producer producer2 = this.pulsarClient.newProducer(Schema.STRING).topic(topic2).create();
        Thread.sleep(2000L);
        int messages = 10;
        for (i = 0; i < 10; ++i) {
            producer1.send((Object)("Message sent by producer-1 -> " + i));
            producer2.send((Object)("Message sent by producer-2 -> " + i));
        }
        for (i = 0; i < 20; ++i) {
            Message received = consumer.receive(3, TimeUnit.SECONDS);
            Assert.assertNotNull((Object)received);
        }
        consumer.close();
        producer1.close();
        producer2.close();
    }

    @Test(groups={"broker"})
    public void testGC() throws Exception {
        String topicName = "non-persistent://prop/ns-abc/topic-10";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        producer.close();
        Assert.assertTrue((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        this.runGC();
        Assert.assertFalse((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        String subName = "sub1";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subName).subscribe();
        this.runGC();
        Assert.assertTrue((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        consumer.close();
        this.runGC();
        Assert.assertTrue((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        this.admin.topics().deleteSubscription(topicName, subName);
        this.runGC();
        Assert.assertFalse((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        this.admin.lookups().lookupTopic(topicName);
        Optional topic = (Optional)this.pulsar.getBrokerService().getTopicIfExists(topicName).join();
        Assert.assertFalse((boolean)topic.isPresent());
        Assert.assertFalse((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        Producer producer2 = this.pulsarClient.newProducer().topic(topicName).create();
        producer2.close();
        Assert.assertTrue((boolean)this.pulsar.getBrokerService().getTopicReference(topicName).isPresent());
        String topicGc = "non-persistent://prop/ns-abc/topic-gc";
        int partitions = 5;
        this.admin.topics().createPartitionedTopic(topicGc, partitions);
        Producer producer3 = this.pulsarClient.newProducer().topic(topicGc).create();
        producer3.close();
        Assert.assertTrue((((PartitionedTopicMetadata)this.pulsar.getBrokerService().fetchPartitionedTopicMetadataAsync((TopicName)TopicName.get((String)topicGc)).join()).partitions == partitions ? 1 : 0) != 0);
        this.runGC();
        Assert.assertTrue((((PartitionedTopicMetadata)this.pulsar.getBrokerService().fetchPartitionedTopicMetadataAsync((TopicName)TopicName.get((String)topicGc)).join()).partitions == 0 ? 1 : 0) != 0);
    }

    private static class Foo {
        private String field1;
        private String field2;
        private int field3;

        public String getField1() {
            return this.field1;
        }

        public String getField2() {
            return this.field2;
        }

        public int getField3() {
            return this.field3;
        }

        public void setField1(String field1) {
            this.field1 = field1;
        }

        public void setField2(String field2) {
            this.field2 = field2;
        }

        public void setField3(int field3) {
            this.field3 = field3;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Foo)) {
                return false;
            }
            Foo other = (Foo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getField3() != other.getField3()) {
                return false;
            }
            String this$field1 = this.getField1();
            String other$field1 = other.getField1();
            if (this$field1 == null ? other$field1 != null : !this$field1.equals(other$field1)) {
                return false;
            }
            String this$field2 = this.getField2();
            String other$field2 = other.getField2();
            return !(this$field2 == null ? other$field2 != null : !this$field2.equals(other$field2));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Foo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getField3();
            String $field1 = this.getField1();
            result = result * 59 + ($field1 == null ? 43 : $field1.hashCode());
            String $field2 = this.getField2();
            result = result * 59 + ($field2 == null ? 43 : $field2.hashCode());
            return result;
        }

        public String toString() {
            return "NonPersistentTopicE2ETest.Foo(field1=" + this.getField1() + ", field2=" + this.getField2() + ", field3=" + this.getField3() + ")";
        }
    }
}

