/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Lists;
import io.netty.channel.nio.NioEventLoopGroup;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerConfig;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerFactoryImpl;
import org.apache.bookkeeper.test.MockedBookKeeperTestCase;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.PersistentTopicTest;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.TransportCnx;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.InactiveTopicDeleteMode;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class PersistentTopicConcurrentTest
extends MockedBookKeeperTestCase {
    private BrokerService brokerService;
    private ManagedLedgerFactory mlFactoryMock;
    private ServerCnx serverCnx;
    private ManagedLedger ledgerMock;
    private ManagedCursor cursorMock;
    final String successTopicName = "persistent://prop/use/ns-abc/successTopic";
    final String successSubName = "successSub";
    private static final Logger log = LoggerFactory.getLogger(PersistentTopicTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeMethod
    public void setup(Method m) throws Exception {
        super.setUp(m);
        ServiceConfiguration svcConfig = (ServiceConfiguration)Mockito.spy(ServiceConfiguration.class);
        svcConfig.setBrokerShutdownTimeoutMs(0L);
        PulsarService pulsar = BrokerTestUtil.spyWithClassAndConstructorArgs(PulsarService.class, svcConfig);
        try {
            ((PulsarService)Mockito.doReturn((Object)svcConfig).when((Object)pulsar)).getConfiguration();
            NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
            try {
                this.mlFactoryMock = (ManagedLedgerFactory)Mockito.mock(ManagedLedgerFactory.class);
                ManagedLedgerFactoryImpl factory = new ManagedLedgerFactoryImpl((MetadataStoreExtended)this.metadataStore, (BookKeeper)this.bkc);
                ManagedLedger ledger = factory.open("my_test_ledger", new ManagedLedgerConfig().setMaxEntriesPerLedger(2));
                this.cursorMock = ledger.openCursor("c1");
                this.ledgerMock = ledger;
                this.mlFactoryMock = factory;
                ((PulsarService)Mockito.doReturn((Object)this.mlFactoryMock).when((Object)pulsar)).getManagedLedgerFactory();
                this.brokerService = BrokerTestUtil.spyWithClassAndConstructorArgs(BrokerService.class, pulsar, eventLoopGroup);
                ((PulsarService)Mockito.doReturn((Object)this.brokerService).when((Object)pulsar)).getBrokerService();
                this.serverCnx = BrokerTestUtil.spyWithClassAndConstructorArgs(ServerCnx.class, pulsar);
                ((ServerCnx)Mockito.doReturn((Object)true).when((Object)this.serverCnx)).isActive();
                NamespaceService nsSvc = (NamespaceService)Mockito.mock(NamespaceService.class);
                ((PulsarService)Mockito.doReturn((Object)nsSvc).when((Object)pulsar)).getNamespaceService();
                ((NamespaceService)Mockito.doReturn((Object)true).when((Object)nsSvc)).isServiceUnitOwned((ServiceUnitId)Mockito.any(NamespaceBundle.class));
                ((NamespaceService)Mockito.doReturn((Object)true).when((Object)nsSvc)).isServiceUnitActive((TopicName)Mockito.any(TopicName.class));
                ((NamespaceService)Mockito.doReturn(CompletableFuture.completedFuture(true)).when((Object)nsSvc)).checkTopicOwnership((TopicName)Mockito.any(TopicName.class));
                ArrayList addedEntries = Lists.newArrayList();
                for (int i = 0; i < 100; ++i) {
                    Position pos = ledger.addEntry("entry".getBytes());
                    addedEntries.add(pos);
                }
            }
            finally {
                if (Collections.singletonList(eventLoopGroup).get(0) != null) {
                    eventLoopGroup.shutdownGracefully();
                }
            }
        }
        finally {
            if (Collections.singletonList(pulsar).get(0) != null) {
                pulsar.close();
            }
        }
    }

    @Test(enabled=false)
    public void testConcurrentTopicAndSubscriptionDelete() throws Exception {
        final PersistentTopic topic = (PersistentTopic)this.brokerService.getOrCreateTopic("persistent://prop/use/ns-abc/successTopic").get();
        CommandSubscribe cmd = new CommandSubscribe().setConsumerId(1L).setTopic("persistent://prop/use/ns-abc/successTopic").setSubscription("successSub").setRequestId(1L).setSubType(CommandSubscribe.SubType.Exclusive);
        CompletableFuture f1 = topic.subscribe((TransportCnx)this.serverCnx, cmd.getSubscription(), cmd.getConsumerId(), cmd.getSubType(), 0, cmd.getConsumerName(), cmd.isDurable(), null, Collections.emptyMap(), cmd.isReadCompacted(), CommandSubscribe.InitialPosition.Latest, 0L, false, null);
        f1.get();
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final CountDownLatch counter = new CountDownLatch(2);
        final AtomicBoolean gotException = new AtomicBoolean(false);
        Thread deleter = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    Thread.sleep(5L, 0);
                    log.info("deleter outcome is {}", topic.delete().get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    gotException.set(true);
                }
                finally {
                    counter.countDown();
                }
            }
        };
        Thread unsubscriber = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    ConcurrentOpenHashMap subscriptions = topic.getSubscriptions();
                    PersistentSubscription ps = (PersistentSubscription)subscriptions.get((Object)"successSub");
                    log.info("unsubscriber outcome is {}", ps.doUnsubscribe((Consumer)ps.getConsumers().get(0)).get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    gotException.set(true);
                }
                finally {
                    counter.countDown();
                }
            }
        };
        deleter.start();
        unsubscriber.start();
        counter.await();
        Assert.assertFalse((boolean)gotException.get());
    }

    @Test(enabled=false)
    public void testConcurrentTopicGCAndSubscriptionDelete() throws Exception {
        final PersistentTopic topic = (PersistentTopic)this.brokerService.getOrCreateTopic("persistent://prop/use/ns-abc/successTopic").get();
        CommandSubscribe cmd = new CommandSubscribe().setConsumerId(1L).setTopic("persistent://prop/use/ns-abc/successTopic").setSubscription("successSub").setRequestId(1L).setSubType(CommandSubscribe.SubType.Exclusive);
        CompletableFuture f1 = topic.subscribe((TransportCnx)this.serverCnx, cmd.getSubscription(), cmd.getConsumerId(), cmd.getSubType(), 0, cmd.getConsumerName(), cmd.isDurable(), null, Collections.emptyMap(), cmd.isReadCompacted(), CommandSubscribe.InitialPosition.Latest, 0L, false, null);
        f1.get();
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final CountDownLatch counter = new CountDownLatch(2);
        final AtomicBoolean gotException = new AtomicBoolean(false);
        Thread deleter = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    log.info("{} forcing topic GC ", (Object)Thread.currentThread());
                    for (int i = 0; i < 2000; ++i) {
                        topic.getInactiveTopicPolicies().setMaxInactiveDurationSeconds(0);
                        topic.getInactiveTopicPolicies().setInactiveTopicDeleteMode(InactiveTopicDeleteMode.delete_when_no_subscriptions);
                        topic.checkGC();
                    }
                    log.info("GC done..");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    gotException.set(true);
                }
                finally {
                    counter.countDown();
                }
            }
        };
        Thread unsubscriber = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    ConcurrentOpenHashMap subscriptions = topic.getSubscriptions();
                    PersistentSubscription ps = (PersistentSubscription)subscriptions.get((Object)"successSub");
                    log.info("unsubscriber outcome is {}", ps.doUnsubscribe((Consumer)ps.getConsumers().get(0)).get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    gotException.set(true);
                }
                finally {
                    counter.countDown();
                }
            }
        };
        deleter.start();
        unsubscriber.start();
        counter.await();
        Assert.assertFalse((boolean)gotException.get());
    }

    @Test(enabled=false)
    public void testConcurrentTopicDeleteAndUnsubscribe() throws Exception {
        final PersistentTopic topic = (PersistentTopic)this.brokerService.getOrCreateTopic("persistent://prop/use/ns-abc/successTopic").get();
        CommandSubscribe cmd = new CommandSubscribe().setConsumerId(1L).setTopic("persistent://prop/use/ns-abc/successTopic").setSubscription("successSub").setRequestId(1L).setSubType(CommandSubscribe.SubType.Exclusive);
        CompletableFuture f1 = topic.subscribe((TransportCnx)this.serverCnx, cmd.getSubscription(), cmd.getConsumerId(), cmd.getSubType(), 0, cmd.getConsumerName(), cmd.isDurable(), null, Collections.emptyMap(), cmd.isReadCompacted(), CommandSubscribe.InitialPosition.Latest, 0L, false, null);
        f1.get();
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final CountDownLatch counter = new CountDownLatch(2);
        final AtomicBoolean gotException = new AtomicBoolean(false);
        Thread deleter = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    Thread.sleep(4L, 700);
                    log.info("deleter outcome is {}", topic.delete().get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    gotException.set(true);
                }
                finally {
                    counter.countDown();
                }
            }
        };
        Thread unsubscriber = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    ConcurrentOpenHashMap subscriptions = topic.getSubscriptions();
                    PersistentSubscription ps = (PersistentSubscription)subscriptions.get((Object)"successSub");
                    log.info("unsubscribe result : {}", topic.unsubscribe("successSub").get());
                    log.info("closing consumer..");
                    ((Consumer)ps.getConsumers().get(0)).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    gotException.set(true);
                }
                finally {
                    counter.countDown();
                }
            }
        };
        deleter.start();
        unsubscriber.start();
        counter.await();
        Assert.assertFalse((boolean)gotException.get());
    }

    @Test(enabled=false)
    public void testConcurrentTopicDeleteAndSubsUnsubscribe() throws Exception {
        final PersistentTopic topic = (PersistentTopic)this.brokerService.getOrCreateTopic("persistent://prop/use/ns-abc/successTopic").get();
        CommandSubscribe cmd = new CommandSubscribe().setConsumerId(1L).setTopic("persistent://prop/use/ns-abc/successTopic").setSubscription("successSub").setRequestId(1L).setSubType(CommandSubscribe.SubType.Exclusive);
        CompletableFuture f1 = topic.subscribe((TransportCnx)this.serverCnx, cmd.getSubscription(), cmd.getConsumerId(), cmd.getSubType(), 0, cmd.getConsumerName(), cmd.isDurable(), null, Collections.emptyMap(), cmd.isReadCompacted(), CommandSubscribe.InitialPosition.Latest, 0L, false, null);
        f1.get();
        final CyclicBarrier barrier = new CyclicBarrier(2);
        final CountDownLatch counter = new CountDownLatch(2);
        final AtomicBoolean gotException = new AtomicBoolean(false);
        Thread deleter = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    Thread.sleep(4L, 730);
                    log.info("@@@@@@@@ DELETER TH");
                    log.info("deleter outcome is " + topic.delete().get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    gotException.set(true);
                }
                finally {
                    counter.countDown();
                }
            }
        };
        Thread unsubscriber = new Thread(){

            @Override
            public void run() {
                try {
                    barrier.await();
                    log.info("&&&&&&&&& UNSUBSCRIBER TH");
                    ConcurrentOpenHashMap subscriptions = topic.getSubscriptions();
                    PersistentSubscription ps = (PersistentSubscription)subscriptions.get((Object)"successSub");
                    log.info("unsubscribe result : " + ps.doUnsubscribe((Consumer)ps.getConsumers().get(0)).get());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    gotException.set(true);
                }
                finally {
                    counter.countDown();
                }
            }
        };
        deleter.start();
        unsubscriber.start();
        counter.await();
        Assert.assertFalse((boolean)gotException.get());
    }
}

