/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.service.Replicator;
import org.apache.pulsar.broker.service.ReplicatorTestBase;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.awaitility.Awaitility;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ReplicatorRemoveClusterTest
extends ReplicatorTestBase {
    protected String methodName;

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod(Method m) throws Exception {
        this.methodName = m.getName();
        this.admin1.namespaces().removeBacklogQuota("pulsar/ns");
        this.admin1.namespaces().removeBacklogQuota("pulsar/ns1");
        this.admin1.namespaces().removeBacklogQuota("pulsar/global/ns");
    }

    @Override
    @BeforeClass(alwaysRun=true, timeOut=300000L)
    public void setup() throws Exception {
        super.setup();
    }

    @Override
    @AfterClass(alwaysRun=true, timeOut=300000L)
    public void cleanup() throws Exception {
        super.cleanup();
    }

    @DataProvider(name="partitionedTopic")
    public Object[][] partitionedTopicProvider() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    @Test
    public void testRemoveClusterFromNamespace() throws Exception {
        this.admin1.tenants().createTenant("pulsar1", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet((Object[])new String[]{"appid1", "appid2", "appid3"}), (Set)Sets.newHashSet((Object[])new String[]{"r1", "r2", "r3"})));
        this.admin1.namespaces().createNamespace("pulsar1/ns1", (Set)Sets.newHashSet((Object[])new String[]{"r1", "r2", "r3"}));
        PulsarClient repClient1 = this.pulsar1.getBrokerService().getReplicationClient("r3", this.pulsar1.getBrokerService().pulsar().getPulsarResources().getClusterResources().getCluster("r3"));
        Assert.assertNotNull((Object)repClient1);
        Assert.assertFalse((boolean)repClient1.isClosed());
        PulsarClient client = PulsarClient.builder().serviceUrl(this.url1.toString()).statsInterval(0L, TimeUnit.SECONDS).build();
        String topicName = "persistent://pulsar1/ns1/testRemoveClusterFromNamespace-" + UUID.randomUUID();
        Producer producer = client.newProducer().topic(topicName).create();
        producer.send((Object)"Pulsar".getBytes());
        producer.close();
        client.close();
        Replicator replicator = (Replicator)((Topic)this.pulsar1.getBrokerService().getTopicReference(topicName).get()).getReplicators().get((Object)"r3");
        Awaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)replicator.isConnected()));
        this.admin1.clusters().deleteCluster("r3");
        Awaitility.await().untilAsserted(() -> Assert.assertFalse((boolean)replicator.isConnected()));
        Awaitility.await().untilAsserted(() -> Assert.assertTrue((boolean)repClient1.isClosed()));
        Awaitility.await().untilAsserted(() -> Assert.assertNull((Object)this.pulsar1.getBrokerService().getReplicationClients().get((Object)"r3")));
    }
}

