/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.collect.Sets;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.crypto.SecretKey;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationDataSubscription;
import org.apache.pulsar.broker.authentication.AuthenticationProviderToken;
import org.apache.pulsar.broker.authentication.utils.AuthTokenUtils;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.resources.NamespaceResources;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.broker.resources.TenantResources;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.ServerCnx;
import org.apache.pulsar.broker.service.schema.DefaultSchemaRegistryService;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.common.api.proto.CommandConnect;
import org.apache.pulsar.common.api.proto.CommandLookupTopic;
import org.apache.pulsar.common.api.proto.CommandProducer;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.metadata.impl.ZKMetadataStore;
import org.apache.zookeeper.MockZooKeeper;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ServerCnxAuthorizationTest {
    private final SecretKey SECRET_KEY = AuthTokenUtils.createSecretKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
    private final String CLIENT_PRINCIPAL = "client";
    private final String PROXY_PRINCIPAL = "proxy";
    private final String CLIENT_TOKEN = Jwts.builder().setSubject("client").signWith((Key)this.SECRET_KEY).compact();
    private final String PROXY_TOKEN = Jwts.builder().setSubject("proxy").signWith((Key)this.SECRET_KEY).compact();
    private PulsarService pulsar;
    private PulsarResources pulsarResources;
    private BrokerService brokerService;
    private ServiceConfiguration svcConfig;

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() throws Exception {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
        this.svcConfig = (ServiceConfiguration)Mockito.spy(ServiceConfiguration.class);
        this.svcConfig.setKeepAliveIntervalSeconds(0);
        this.svcConfig.setBrokerShutdownTimeoutMs(0L);
        this.svcConfig.setLoadBalancerOverrideBrokerNicSpeedGbps(Double.valueOf(1.0));
        this.svcConfig.setClusterName("pulsar-cluster");
        this.svcConfig.setSuperUserRoles(Collections.singleton("proxy"));
        this.svcConfig.setAuthenticationEnabled(true);
        this.svcConfig.setAuthenticationProviders((Set)Sets.newHashSet((Object[])new String[]{AuthenticationProviderToken.class.getName()}));
        this.svcConfig.setAuthorizationEnabled(true);
        this.svcConfig.setAuthorizationProvider(PulsarAuthorizationProvider.class.getName());
        Properties properties = new Properties();
        properties.setProperty("tokenSecretKey", "data:;base64," + Base64.getEncoder().encodeToString(this.SECRET_KEY.getEncoded()));
        this.svcConfig.setProperties(properties);
        this.pulsar = BrokerTestUtil.spyWithClassAndConstructorArgs(PulsarService.class, this.svcConfig);
        ((PulsarService)Mockito.doReturn((Object)new DefaultSchemaRegistryService()).when((Object)this.pulsar)).getSchemaRegistryService();
        ((PulsarService)Mockito.doReturn((Object)this.svcConfig).when((Object)this.pulsar)).getConfiguration();
        ((PulsarService)Mockito.doReturn((Object)Mockito.mock(PulsarResources.class)).when((Object)this.pulsar)).getPulsarResources();
        ManagedLedgerFactory mlFactoryMock = (ManagedLedgerFactory)Mockito.mock(ManagedLedgerFactory.class);
        ((PulsarService)Mockito.doReturn((Object)mlFactoryMock).when((Object)this.pulsar)).getManagedLedgerFactory();
        MockZooKeeper mockZk = MockedPulsarServiceBaseTest.createMockZooKeeper();
        OrderedExecutor executor = OrderedExecutor.newBuilder().numThreads(1).build();
        ((PulsarService)Mockito.doReturn((Object)((Object)MockedPulsarServiceBaseTest.createMockBookKeeper(executor))).when((Object)this.pulsar)).getBookKeeperClient();
        ZKMetadataStore store = new ZKMetadataStore((ZooKeeper)mockZk);
        ((PulsarService)Mockito.doReturn((Object)store).when((Object)this.pulsar)).getLocalMetadataStore();
        ((PulsarService)Mockito.doReturn((Object)store).when((Object)this.pulsar)).getConfigurationMetadataStore();
        this.pulsarResources = BrokerTestUtil.spyWithClassAndConstructorArgs(PulsarResources.class, store, store);
        ((PulsarService)Mockito.doReturn((Object)this.pulsarResources).when((Object)this.pulsar)).getPulsarResources();
        NamespaceResources namespaceResources = BrokerTestUtil.spyWithClassAndConstructorArgs(NamespaceResources.class, store, store, 30);
        ((PulsarResources)Mockito.doReturn((Object)namespaceResources).when((Object)this.pulsarResources)).getNamespaceResources();
        TenantResources tenantResources = BrokerTestUtil.spyWithClassAndConstructorArgs(TenantResources.class, store, 30);
        ((PulsarResources)Mockito.doReturn((Object)tenantResources).when((Object)this.pulsarResources)).getTenantResources();
        ((TenantResources)Mockito.doReturn(CompletableFuture.completedFuture(Optional.of(TenantInfo.builder().build()))).when((Object)tenantResources)).getTenantAsync("public");
        this.brokerService = BrokerTestUtil.spyWithClassAndConstructorArgs(BrokerService.class, this.pulsar, eventLoopGroup);
        BrokerInterceptor interceptor = (BrokerInterceptor)Mockito.mock(BrokerInterceptor.class);
        ((BrokerService)Mockito.doReturn((Object)interceptor).when((Object)this.brokerService)).getInterceptor();
        ((PulsarService)Mockito.doReturn((Object)this.brokerService).when((Object)this.pulsar)).getBrokerService();
        ((PulsarService)Mockito.doReturn((Object)executor).when((Object)this.pulsar)).getOrderedExecutor();
    }

    @Test
    public void testVerifyOriginalPrincipalWithAuthDataForwardedFromProxy() throws Exception {
        ((ServiceConfiguration)Mockito.doReturn((Object)true).when((Object)this.svcConfig)).isAuthenticateOriginalAuthData();
        ServerCnx serverCnx = BrokerTestUtil.spyWithClassAndConstructorArgs(ServerCnx.class, this.pulsar);
        ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ChannelPipeline channelPipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);
        ((Channel)Mockito.doReturn((Object)channelPipeline).when((Object)channel)).pipeline();
        ((ChannelPipeline)Mockito.doReturn(null).when((Object)channelPipeline)).get("tls");
        InetSocketAddress socketAddress = new InetSocketAddress(0);
        ((Channel)Mockito.doReturn((Object)socketAddress).when((Object)channel)).remoteAddress();
        ((ChannelHandlerContext)Mockito.doReturn((Object)channel).when((Object)channelHandlerContext)).channel();
        channelHandlerContext.channel().remoteAddress();
        serverCnx.channelActive(channelHandlerContext);
        AuthenticationToken clientAuthenticationToken = new AuthenticationToken(this.CLIENT_TOKEN);
        AuthenticationToken proxyAuthenticationToken = new AuthenticationToken(this.PROXY_TOKEN);
        CommandConnect connect = new CommandConnect();
        connect.setAuthMethodName(proxyAuthenticationToken.getAuthMethodName());
        connect.setAuthData(proxyAuthenticationToken.getAuthData().getCommandData().getBytes(StandardCharsets.UTF_8));
        connect.setClientVersion("test");
        connect.setProtocolVersion(1);
        connect.setOriginalPrincipal("client");
        connect.setOriginalAuthData(clientAuthenticationToken.getAuthData().getCommandData());
        connect.setOriginalAuthMethod(clientAuthenticationToken.getAuthMethodName());
        serverCnx.handleConnect(connect);
        Assert.assertEquals((String)serverCnx.getOriginalAuthData().getCommandData(), (String)clientAuthenticationToken.getAuthData().getCommandData());
        Assert.assertEquals((String)serverCnx.getOriginalAuthState().getAuthRole(), (String)"client");
        Assert.assertEquals((String)serverCnx.getOriginalPrincipal(), (String)"client");
        Assert.assertEquals((String)serverCnx.getAuthData().getCommandData(), (String)proxyAuthenticationToken.getAuthData().getCommandData());
        Assert.assertEquals((String)serverCnx.getAuthRole(), (String)"proxy");
        Assert.assertEquals((String)serverCnx.getAuthState().getAuthRole(), (String)"proxy");
        AuthorizationService authorizationService = BrokerTestUtil.spyWithClassAndConstructorArgs(AuthorizationService.class, this.svcConfig, this.pulsarResources);
        ((BrokerService)Mockito.doReturn((Object)authorizationService).when((Object)this.brokerService)).getAuthorizationService();
        CommandLookupTopic commandLookupTopic = new CommandLookupTopic();
        TopicName topicName = TopicName.get((String)"persistent://public/default/test-topic");
        commandLookupTopic.setTopic(topicName.toString());
        commandLookupTopic.setRequestId(1L);
        serverCnx.handleLookup(commandLookupTopic);
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.LOOKUP, "client", serverCnx.getOriginalAuthData());
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.LOOKUP, "proxy", serverCnx.getAuthData());
        CommandProducer commandProducer = new CommandProducer();
        commandProducer.setRequestId(1L);
        commandProducer.setProducerId(1L);
        commandProducer.setProducerName("test-producer");
        commandProducer.setTopic(topicName.toString());
        serverCnx.handleProducer(commandProducer);
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.PRODUCE, "client", serverCnx.getOriginalAuthData());
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.LOOKUP, "proxy", serverCnx.getAuthData());
        CommandSubscribe commandSubscribe = new CommandSubscribe();
        commandSubscribe.setTopic(topicName.toString());
        commandSubscribe.setRequestId(1L);
        commandSubscribe.setConsumerId(1L);
        String subscriptionName = "test-subscribe";
        commandSubscribe.setSubscription("test-subscribe");
        commandSubscribe.setSubType(CommandSubscribe.SubType.Shared);
        serverCnx.handleSubscribe(commandSubscribe);
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync((TopicName)ArgumentMatchers.eq((Object)topicName), (TopicOperation)ArgumentMatchers.eq((Object)TopicOperation.CONSUME), (String)ArgumentMatchers.eq((Object)"client"), (AuthenticationDataSource)ArgumentMatchers.argThat(arg -> {
            Assert.assertTrue((boolean)(arg instanceof AuthenticationDataSubscription));
            try {
                Assert.assertEquals((String)arg.getCommandData(), (String)clientAuthenticationToken.getAuthData().getCommandData());
            }
            catch (PulsarClientException e) {
                Assert.fail((String)e.getMessage());
            }
            Assert.assertEquals((String)arg.getSubscription(), (String)"test-subscribe");
            return true;
        }));
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync((TopicName)ArgumentMatchers.eq((Object)topicName), (TopicOperation)ArgumentMatchers.eq((Object)TopicOperation.CONSUME), (String)ArgumentMatchers.eq((Object)"proxy"), (AuthenticationDataSource)ArgumentMatchers.argThat(arg -> {
            Assert.assertTrue((boolean)(arg instanceof AuthenticationDataSubscription));
            try {
                Assert.assertEquals((String)arg.getCommandData(), (String)proxyAuthenticationToken.getAuthData().getCommandData());
            }
            catch (PulsarClientException e) {
                Assert.fail((String)e.getMessage());
            }
            Assert.assertEquals((String)arg.getSubscription(), (String)"test-subscribe");
            return true;
        }));
    }

    @Test
    public void testVerifyOriginalPrincipalWithoutAuthDataForwardedFromProxy() throws Exception {
        ((ServiceConfiguration)Mockito.doReturn((Object)false).when((Object)this.svcConfig)).isAuthenticateOriginalAuthData();
        ServerCnx serverCnx = BrokerTestUtil.spyWithClassAndConstructorArgs(ServerCnx.class, this.pulsar);
        ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ChannelPipeline channelPipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);
        ((Channel)Mockito.doReturn((Object)channelPipeline).when((Object)channel)).pipeline();
        ((ChannelPipeline)Mockito.doReturn(null).when((Object)channelPipeline)).get("tls");
        InetSocketAddress socketAddress = new InetSocketAddress(0);
        ((Channel)Mockito.doReturn((Object)socketAddress).when((Object)channel)).remoteAddress();
        ((ChannelHandlerContext)Mockito.doReturn((Object)channel).when((Object)channelHandlerContext)).channel();
        channelHandlerContext.channel().remoteAddress();
        serverCnx.channelActive(channelHandlerContext);
        AuthenticationToken proxyAuthenticationToken = new AuthenticationToken(this.PROXY_TOKEN);
        CommandConnect connect = new CommandConnect();
        connect.setAuthMethodName(proxyAuthenticationToken.getAuthMethodName());
        connect.setAuthData(proxyAuthenticationToken.getAuthData().getCommandData().getBytes(StandardCharsets.UTF_8));
        connect.setClientVersion("test");
        connect.setProtocolVersion(1);
        connect.setOriginalPrincipal("client");
        serverCnx.handleConnect(connect);
        Assert.assertNull((Object)serverCnx.getOriginalAuthData());
        Assert.assertNull((Object)serverCnx.getOriginalAuthState());
        Assert.assertEquals((String)serverCnx.getOriginalPrincipal(), (String)"client");
        Assert.assertEquals((String)serverCnx.getAuthData().getCommandData(), (String)proxyAuthenticationToken.getAuthData().getCommandData());
        Assert.assertEquals((String)serverCnx.getAuthRole(), (String)"proxy");
        Assert.assertEquals((String)serverCnx.getAuthState().getAuthRole(), (String)"proxy");
        AuthorizationService authorizationService = BrokerTestUtil.spyWithClassAndConstructorArgs(AuthorizationService.class, this.svcConfig, this.pulsarResources);
        ((BrokerService)Mockito.doReturn((Object)authorizationService).when((Object)this.brokerService)).getAuthorizationService();
        CommandLookupTopic commandLookupTopic = new CommandLookupTopic();
        TopicName topicName = TopicName.get((String)"persistent://public/default/test-topic");
        commandLookupTopic.setTopic(topicName.toString());
        commandLookupTopic.setRequestId(1L);
        serverCnx.handleLookup(commandLookupTopic);
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.LOOKUP, "client", serverCnx.getAuthData());
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.LOOKUP, "proxy", serverCnx.getAuthData());
        CommandProducer commandProducer = new CommandProducer();
        commandProducer.setRequestId(1L);
        commandProducer.setProducerId(1L);
        commandProducer.setProducerName("test-producer");
        commandProducer.setTopic(topicName.toString());
        serverCnx.handleProducer(commandProducer);
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.PRODUCE, "client", serverCnx.getAuthData());
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.LOOKUP, "proxy", serverCnx.getAuthData());
        CommandSubscribe commandSubscribe = new CommandSubscribe();
        commandSubscribe.setTopic(topicName.toString());
        commandSubscribe.setRequestId(1L);
        commandSubscribe.setConsumerId(1L);
        String subscriptionName = "test-subscribe";
        commandSubscribe.setSubscription("test-subscribe");
        commandSubscribe.setSubType(CommandSubscribe.SubType.Shared);
        serverCnx.handleSubscribe(commandSubscribe);
        ArgumentMatcher authenticationDataSourceArgumentMatcher = arg -> {
            Assert.assertTrue((boolean)(arg instanceof AuthenticationDataSubscription));
            try {
                Assert.assertEquals((String)arg.getCommandData(), (String)proxyAuthenticationToken.getAuthData().getCommandData());
            }
            catch (PulsarClientException e) {
                Assert.fail((String)e.getMessage());
            }
            Assert.assertEquals((String)arg.getSubscription(), (String)"test-subscribe");
            return true;
        };
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync((TopicName)ArgumentMatchers.eq((Object)topicName), (TopicOperation)ArgumentMatchers.eq((Object)TopicOperation.CONSUME), (String)ArgumentMatchers.eq((Object)"client"), (AuthenticationDataSource)ArgumentMatchers.argThat((ArgumentMatcher)authenticationDataSourceArgumentMatcher));
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync((TopicName)ArgumentMatchers.eq((Object)topicName), (TopicOperation)ArgumentMatchers.eq((Object)TopicOperation.CONSUME), (String)ArgumentMatchers.eq((Object)"proxy"), (AuthenticationDataSource)ArgumentMatchers.argThat((ArgumentMatcher)authenticationDataSourceArgumentMatcher));
    }

    @Test
    public void testVerifyAuthRoleAndAuthDataFromDirectConnectionBroker() throws Exception {
        ServerCnx serverCnx = BrokerTestUtil.spyWithClassAndConstructorArgs(ServerCnx.class, this.pulsar);
        ChannelHandlerContext channelHandlerContext = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        ChannelPipeline channelPipeline = (ChannelPipeline)Mockito.mock(ChannelPipeline.class);
        ((Channel)Mockito.doReturn((Object)channelPipeline).when((Object)channel)).pipeline();
        ((ChannelPipeline)Mockito.doReturn(null).when((Object)channelPipeline)).get("tls");
        InetSocketAddress socketAddress = new InetSocketAddress(0);
        ((Channel)Mockito.doReturn((Object)socketAddress).when((Object)channel)).remoteAddress();
        ((ChannelHandlerContext)Mockito.doReturn((Object)channel).when((Object)channelHandlerContext)).channel();
        channelHandlerContext.channel().remoteAddress();
        serverCnx.channelActive(channelHandlerContext);
        AuthenticationToken clientAuthenticationToken = new AuthenticationToken(this.CLIENT_TOKEN);
        CommandConnect connect = new CommandConnect();
        connect.setAuthMethodName(clientAuthenticationToken.getAuthMethodName());
        connect.setAuthData(clientAuthenticationToken.getAuthData().getCommandData().getBytes(StandardCharsets.UTF_8));
        connect.setClientVersion("test");
        connect.setProtocolVersion(1);
        serverCnx.handleConnect(connect);
        Assert.assertNull((Object)serverCnx.getOriginalAuthData());
        Assert.assertNull((Object)serverCnx.getOriginalAuthState());
        Assert.assertNull((Object)serverCnx.getOriginalPrincipal());
        Assert.assertEquals((String)serverCnx.getAuthData().getCommandData(), (String)clientAuthenticationToken.getAuthData().getCommandData());
        Assert.assertEquals((String)serverCnx.getAuthRole(), (String)"client");
        Assert.assertEquals((String)serverCnx.getAuthState().getAuthRole(), (String)"client");
        AuthorizationService authorizationService = BrokerTestUtil.spyWithClassAndConstructorArgs(AuthorizationService.class, this.svcConfig, this.pulsarResources);
        ((BrokerService)Mockito.doReturn((Object)authorizationService).when((Object)this.brokerService)).getAuthorizationService();
        CommandLookupTopic commandLookupTopic = new CommandLookupTopic();
        TopicName topicName = TopicName.get((String)"persistent://public/default/test-topic");
        commandLookupTopic.setTopic(topicName.toString());
        commandLookupTopic.setRequestId(1L);
        serverCnx.handleLookup(commandLookupTopic);
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.LOOKUP, "client", serverCnx.getAuthData());
        CommandProducer commandProducer = new CommandProducer();
        commandProducer.setRequestId(1L);
        commandProducer.setProducerId(1L);
        commandProducer.setProducerName("test-producer");
        commandProducer.setTopic(topicName.toString());
        serverCnx.handleProducer(commandProducer);
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync(topicName, TopicOperation.PRODUCE, "client", serverCnx.getAuthData());
        CommandSubscribe commandSubscribe = new CommandSubscribe();
        commandSubscribe.setTopic(topicName.toString());
        commandSubscribe.setRequestId(1L);
        commandSubscribe.setConsumerId(1L);
        String subscriptionName = "test-subscribe";
        commandSubscribe.setSubscription("test-subscribe");
        commandSubscribe.setSubType(CommandSubscribe.SubType.Shared);
        serverCnx.handleSubscribe(commandSubscribe);
        ((AuthorizationService)Mockito.verify((Object)authorizationService, (VerificationMode)Mockito.times((int)1))).allowTopicOperationAsync((TopicName)ArgumentMatchers.eq((Object)topicName), (TopicOperation)ArgumentMatchers.eq((Object)TopicOperation.CONSUME), (String)ArgumentMatchers.eq((Object)"client"), (AuthenticationDataSource)ArgumentMatchers.argThat(arg -> {
            Assert.assertTrue((boolean)(arg instanceof AuthenticationDataSubscription));
            try {
                Assert.assertEquals((String)arg.getCommandData(), (String)clientAuthenticationToken.getAuthData().getCommandData());
            }
            catch (PulsarClientException e) {
                Assert.fail((String)e.getMessage());
            }
            Assert.assertEquals((String)arg.getSubscription(), (String)"test-subscribe");
            return true;
        }));
    }
}

