/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.pulsar.broker.BrokerTestUtil;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.TransactionTestBase;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.api.transaction.Transaction;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.policies.data.ManagedLedgerInternalStats;
import org.awaitility.Awaitility;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class TransactionMarkerDeleteTest
extends TransactionTestBase {
    private static final int TOPIC_PARTITION = 3;
    private static final String TOPIC_OUTPUT = "tnx/ns1/output";
    private static final int NUM_PARTITIONS = 16;

    @BeforeMethod
    protected void setup() throws Exception {
        this.setUpBase(1, 16, TOPIC_OUTPUT, 3);
    }

    @AfterMethod(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testMarkerDeleteTimes() throws Exception {
        ManagedLedgerImpl managedLedger = (ManagedLedgerImpl)Mockito.spy((Object)((ManagedLedgerImpl)this.getPulsarServiceList().get(0).getManagedLedgerFactory().open("test")));
        PersistentTopic topic = (PersistentTopic)Mockito.mock(PersistentTopic.class);
        BrokerService brokerService = (BrokerService)Mockito.mock(BrokerService.class);
        PulsarService pulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        ServiceConfiguration configuration = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        ((PersistentTopic)Mockito.doReturn((Object)brokerService).when((Object)topic)).getBrokerService();
        ((BrokerService)Mockito.doReturn((Object)pulsarService).when((Object)brokerService)).getPulsar();
        ((PulsarService)Mockito.doReturn((Object)configuration).when((Object)pulsarService)).getConfig();
        ((ServiceConfiguration)Mockito.doReturn((Object)false).when((Object)configuration)).isTransactionCoordinatorEnabled();
        ((PersistentTopic)Mockito.doReturn((Object)managedLedger).when((Object)topic)).getManagedLedger();
        ManagedCursor cursor = managedLedger.openCursor("test");
        PersistentSubscription persistentSubscription = BrokerTestUtil.spyWithClassAndConstructorArgs(PersistentSubscription.class, topic, "test", cursor, false);
        Position position = managedLedger.addEntry("test".getBytes());
        persistentSubscription.acknowledgeMessage(Collections.singletonList(position), CommandAck.AckType.Individual, Collections.emptyMap());
        ((ManagedLedgerImpl)Mockito.verify((Object)managedLedger, (VerificationMode)Mockito.times((int)0))).asyncReadEntry((PositionImpl)ArgumentMatchers.any(), (AsyncCallbacks.ReadEntryCallback)ArgumentMatchers.any(), ArgumentMatchers.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMarkerDelete() throws Exception {
        String subName = "testMarkerDelete";
        String topicName = "tnx/ns1/testMarkerDelete";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"tnx/ns1/testMarkerDelete"}).subscriptionName("testMarkerDelete").isAckReceiptEnabled(true).subscriptionType(SubscriptionType.Shared).subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer().sendTimeout(0, TimeUnit.SECONDS).topic("tnx/ns1/testMarkerDelete").create();
            Transaction txn1 = this.getTxn();
            Transaction txn2 = this.getTxn();
            Transaction txn3 = this.getTxn();
            Transaction txn4 = this.getTxn();
            MessageIdImpl msgId1 = (MessageIdImpl)producer.newMessage(txn1).send();
            MessageIdImpl msgId2 = (MessageIdImpl)producer.newMessage(txn2).send();
            Assert.assertNull((Object)consumer.receive(1, TimeUnit.SECONDS));
            txn1.commit().get();
            consumer.acknowledgeAsync(consumer.receive()).get();
            Assert.assertNull((Object)consumer.receive(1, TimeUnit.SECONDS));
            Assert.assertEquals((String)((ManagedLedgerInternalStats.CursorStats)this.admin.topics().getInternalStats((String)"tnx/ns1/testMarkerDelete").cursors.get((Object)"testMarkerDelete")).markDeletePosition, (String)PositionImpl.get((long)msgId1.getLedgerId(), (long)msgId1.getEntryId()).toString());
            MessageIdImpl msgId3 = (MessageIdImpl)producer.newMessage(txn3).send();
            txn2.commit().get();
            consumer.acknowledgeAsync(consumer.receive()).get();
            Assert.assertNull((Object)consumer.receive(1, TimeUnit.SECONDS));
            Assert.assertEquals((String)((ManagedLedgerInternalStats.CursorStats)this.admin.topics().getInternalStats((String)"tnx/ns1/testMarkerDelete").cursors.get((Object)"testMarkerDelete")).markDeletePosition, (String)PositionImpl.get((long)msgId2.getLedgerId(), (long)(msgId2.getEntryId() + 1L)).toString());
            MessageIdImpl msgId4 = (MessageIdImpl)producer.newMessage(txn4).send();
            txn3.commit().get();
            consumer.acknowledgeAsync(consumer.receive()).get();
            Assert.assertNull((Object)consumer.receive(1, TimeUnit.SECONDS));
            Assert.assertEquals((String)((ManagedLedgerInternalStats.CursorStats)this.admin.topics().getInternalStats((String)"tnx/ns1/testMarkerDelete").cursors.get((Object)"testMarkerDelete")).markDeletePosition, (String)PositionImpl.get((long)msgId3.getLedgerId(), (long)(msgId3.getEntryId() + 1L)).toString());
            txn4.abort().get();
            Awaitility.await().untilAsserted(() -> Assert.assertEquals((String)((ManagedLedgerInternalStats.CursorStats)this.admin.topics().getInternalStats((String)"tnx/ns1/testMarkerDelete").cursors.get((Object)"testMarkerDelete")).markDeletePosition, (String)PositionImpl.get((long)msgId4.getLedgerId(), (long)(msgId4.getEntryId() + 2L)).toString()));
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }

    private Transaction getTxn() throws Exception {
        return (Transaction)this.pulsarClient.newTransaction().withTransactionTimeout(10L, TimeUnit.SECONDS).build().get();
    }
}

