/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import java.nio.ByteBuffer;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.common.schema.LongSchemaVersion;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.zookeeper.ZooKeeper;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class BookkeeperSchemaStorageTest {
    @Test
    public void testBkException() {
        Exception ex = BookkeeperSchemaStorage.bkException((String)"test", (int)-1, (long)1L, (long)-1L);
        Assert.assertEquals((String)"Error while reading ledger -  ledger=1 - operation=test", (String)ex.getMessage());
        ex = BookkeeperSchemaStorage.bkException((String)"test", (int)-1, (long)1L, (long)0L);
        Assert.assertEquals((String)"Error while reading ledger -  ledger=1 - operation=test - entry=0", (String)ex.getMessage());
        ex = BookkeeperSchemaStorage.bkException((String)"test", (int)-2, (long)1L, (long)-1L);
        Assert.assertEquals((String)"Invalid quorum size on ensemble size -  ledger=1 - operation=test", (String)ex.getMessage());
        ex = BookkeeperSchemaStorage.bkException((String)"test", (int)-2, (long)1L, (long)0L);
        Assert.assertEquals((String)"Invalid quorum size on ensemble size -  ledger=1 - operation=test - entry=0", (String)ex.getMessage());
    }

    @Test
    public void testVersionFromBytes() {
        long version = System.currentTimeMillis();
        ByteBuffer bbPre240 = ByteBuffer.allocate(64);
        bbPre240.putLong(version);
        byte[] versionBytesPre240 = bbPre240.array();
        ByteBuffer bbPost240 = ByteBuffer.allocate(8);
        bbPost240.putLong(version);
        byte[] versionBytesPost240 = bbPost240.array();
        PulsarService mockPulsarService = (PulsarService)Mockito.mock(PulsarService.class);
        Mockito.when((Object)mockPulsarService.getLocalMetadataStore()).thenReturn(Mockito.mock(MetadataStoreExtended.class));
        BookkeeperSchemaStorage schemaStorage = new BookkeeperSchemaStorage(mockPulsarService, (ZooKeeper)Mockito.mock(ZooKeeper.class));
        Assert.assertEquals((Object)new LongSchemaVersion(version), (Object)schemaStorage.versionFromBytes(versionBytesPre240));
        Assert.assertEquals((Object)new LongSchemaVersion(version), (Object)schemaStorage.versionFromBytes(versionBytesPost240));
    }
}

