/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.schema;

import com.google.protobuf.Descriptors;
import org.apache.pulsar.broker.service.schema.ProtobufNativeSchemaCompatibilityCheck;
import org.apache.pulsar.client.api.schema.proto.Test;
import org.apache.pulsar.client.impl.schema.ProtobufNativeSchemaUtils;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaType;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class ProtobufNativeSchemaCompatibilityCheckTest {
    private static final SchemaData schemaData1 = ProtobufNativeSchemaCompatibilityCheckTest.getSchemaData(Test.TestMessage.getDescriptor());
    private static final SchemaData schemaData2 = ProtobufNativeSchemaCompatibilityCheckTest.getSchemaData(Test.SubMessage.getDescriptor());

    @Test
    public void testRootMessageChange() {
        ProtobufNativeSchemaCompatibilityCheck compatibilityCheck = new ProtobufNativeSchemaCompatibilityCheck();
        Assert.assertFalse((boolean)compatibilityCheck.isCompatible(schemaData2, schemaData1, SchemaCompatibilityStrategy.FULL), (String)"Protobuf root message isn't allow change");
    }

    private static SchemaData getSchemaData(Descriptors.Descriptor descriptor) {
        return SchemaData.builder().data(ProtobufNativeSchemaUtils.serialize((Descriptors.Descriptor)descriptor)).type(SchemaType.PROTOBUF_NATIVE).build();
    }
}

