/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats;

import java.util.Collections;
import java.util.UUID;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class SubscriptionStatsTest
extends ProducerConsumerBase {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionStatsTest.class);

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testConsumersAfterMarkDelete() throws PulsarClientException, PulsarAdminException {
        String topicName = "persistent://my-property/my-ns/testConsumersAfterMarkDelete-" + UUID.randomUUID().toString();
        String subName = "my-sub";
        Consumer consumer1 = this.pulsarClient.newConsumer().topic(new String[]{topicName}).receiverQueueSize(10).subscriptionName("my-sub").subscriptionType(SubscriptionType.Key_Shared).subscribe();
        Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
        int messages = 100;
        for (int i = 0; i < 100; ++i) {
            producer.send((Object)String.valueOf(i).getBytes());
        }
        consumer1.receive();
        Consumer consumer2 = this.pulsarClient.newConsumer().topic(new String[]{topicName}).receiverQueueSize(10).subscriptionName("my-sub").subscriptionType(SubscriptionType.Key_Shared).subscribe();
        TopicStats stats = this.admin.topics().getStats(topicName);
        Assert.assertEquals((int)stats.getSubscriptions().size(), (int)1);
        Assert.assertEquals((int)((SubscriptionStats)stats.getSubscriptions().entrySet().iterator().next().getValue()).getConsumersAfterMarkDeletePosition().size(), (int)1);
        consumer1.close();
        consumer2.close();
        producer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonContiguousDeletedMessagesRanges() throws Exception {
        String topicName = "persistent://my-property/my-ns/testNonContiguousDeletedMessagesRanges-" + UUID.randomUUID().toString();
        String subName = "my-sub";
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName("my-sub").subscribe();
        try {
            Producer producer = this.pulsarClient.newProducer().topic(topicName).create();
            try {
                int i;
                int messages = 100;
                for (i = 0; i < 100; ++i) {
                    producer.send((Object)String.valueOf(i).getBytes());
                }
                for (i = 0; i < 100; ++i) {
                    Message received = consumer.receive();
                    if (i == 50) continue;
                    consumer.acknowledge(received);
                }
                Awaitility.await().untilAsserted(() -> {
                    TopicStats stats = this.admin.topics().getStats(topicName);
                    Assert.assertEquals((int)stats.getNonContiguousDeletedMessagesRanges(), (int)1);
                    Assert.assertEquals((int)stats.getSubscriptions().size(), (int)1);
                    Assert.assertEquals((int)((SubscriptionStats)stats.getSubscriptions().get("my-sub")).getNonContiguousDeletedMessagesRanges(), (int)1);
                    Assert.assertTrue((stats.getNonContiguousDeletedMessagesRangesSerializedSize() > 0 ? 1 : 0) != 0);
                    Assert.assertTrue((((SubscriptionStats)stats.getSubscriptions().get("my-sub")).getNonContiguousDeletedMessagesRangesSerializedSize() > 0 ? 1 : 0) != 0);
                });
            }
            finally {
                if (Collections.singletonList(producer).get(0) != null) {
                    producer.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(consumer).get(0) != null) {
                consumer.close();
            }
        }
    }
}

