/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.systopic.NamespaceEventsSystemTopicFactory;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.TopicPoliciesSystemTopicClient;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.events.ActionType;
import org.apache.pulsar.common.events.EventType;
import org.apache.pulsar.common.events.PulsarEvent;
import org.apache.pulsar.common.events.TopicPoliciesEvent;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantInfoImpl;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"broker"})
public class NamespaceEventsSystemTopicServiceTest
extends MockedPulsarServiceBaseTest {
    private static final Logger log = LoggerFactory.getLogger(NamespaceEventsSystemTopicServiceTest.class);
    private static final String NAMESPACE1 = "system-topic/namespace-1";
    private static final String NAMESPACE2 = "system-topic/namespace-2";
    private static final String NAMESPACE3 = "system-topic/namespace-3";
    private NamespaceEventsSystemTopicFactory systemTopicFactory;

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        super.internalSetup();
        this.prepareData();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaCompatibility() throws Exception {
        TopicPoliciesSystemTopicClient systemTopicClientForNamespace1 = this.systemTopicFactory.createTopicPoliciesSystemTopicClient(NamespaceName.get((String)NAMESPACE1));
        String topicName = systemTopicClientForNamespace1.getTopicName().toString();
        Reader reader = this.pulsarClient.newReader(Schema.BYTES).topic(topicName).startMessageId(MessageId.earliest).create();
        try {
            PersistentTopic topic = (PersistentTopic)((Optional)this.pulsar.getBrokerService().getTopic(topicName, false).join()).get();
            Assert.assertEquals((Object)SchemaCompatibilityStrategy.ALWAYS_COMPATIBLE, (Object)topic.getSchemaCompatibilityStrategy());
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testSendAndReceiveNamespaceEvents() throws Exception {
        TopicPoliciesSystemTopicClient systemTopicClientForNamespace1 = this.systemTopicFactory.createTopicPoliciesSystemTopicClient(NamespaceName.get((String)NAMESPACE1));
        TopicPolicies policies = TopicPolicies.builder().maxProducerPerTopic(Integer.valueOf(10)).build();
        PulsarEvent event = PulsarEvent.builder().eventType(EventType.TOPIC_POLICY).actionType(ActionType.INSERT).topicPoliciesEvent(TopicPoliciesEvent.builder().domain("persistent").tenant("system-topic").namespace(NamespaceName.get((String)NAMESPACE1).getLocalName()).topic("my-topic").policies(policies).build()).build();
        systemTopicClientForNamespace1.newWriter().write((Object)event);
        SystemTopicClient.Reader reader = systemTopicClientForNamespace1.newReader();
        Message received = reader.readNext();
        log.info("Receive pulsar event from system topic : {}", received.getValue());
        Assert.assertEquals((Object)received.getValue(), (Object)event);
        Assert.assertEquals((int)systemTopicClientForNamespace1.getWriters().size(), (int)1);
        Assert.assertEquals((int)systemTopicClientForNamespace1.getReaders().size(), (int)1);
        SystemTopicClient.Reader reader1 = systemTopicClientForNamespace1.newReader();
        Message received1 = reader1.readNext();
        log.info("Receive pulsar event from system topic : {}", received1.getValue());
        Assert.assertEquals((Object)received1.getValue(), (Object)event);
        Assert.assertEquals((int)systemTopicClientForNamespace1.getReaders().size(), (int)2);
        SystemTopicClient.Writer writer = systemTopicClientForNamespace1.newWriter();
        Assert.assertEquals((int)systemTopicClientForNamespace1.getWriters().size(), (int)2);
        writer.close();
        reader.close();
        Assert.assertEquals((int)systemTopicClientForNamespace1.getWriters().size(), (int)1);
        Assert.assertEquals((int)systemTopicClientForNamespace1.getReaders().size(), (int)1);
        systemTopicClientForNamespace1.close();
        Assert.assertEquals((int)systemTopicClientForNamespace1.getWriters().size(), (int)0);
        Assert.assertEquals((int)systemTopicClientForNamespace1.getReaders().size(), (int)0);
    }

    @Test(timeOut=30000L)
    public void checkSystemTopic() throws PulsarAdminException {
        String systemTopic = "persistent://system-topic/namespace-1/__change_events";
        String normalTopic = "persistent://system-topic/namespace-1/normal_topic";
        this.admin.topics().createPartitionedTopic("persistent://system-topic/namespace-1/normal_topic", 3);
        TopicName systemTopicName = TopicName.get((String)"persistent://system-topic/namespace-1/__change_events");
        TopicName normalTopicName = TopicName.get((String)"persistent://system-topic/namespace-1/normal_topic");
        BrokerService brokerService = this.pulsar.getBrokerService();
        Assert.assertEquals((boolean)brokerService.isSystemTopic(systemTopicName), (boolean)true);
        Assert.assertEquals((boolean)brokerService.isSystemTopic(normalTopicName), (boolean)false);
    }

    private void prepareData() throws PulsarAdminException {
        this.admin.clusters().createCluster("test", ClusterData.builder().serviceUrl(this.pulsar.getWebServiceAddress()).build());
        this.admin.tenants().createTenant("system-topic", (TenantInfo)new TenantInfoImpl((Set)Sets.newHashSet(), (Set)Sets.newHashSet((Object[])new String[]{"test"})));
        this.admin.namespaces().createNamespace(NAMESPACE1);
        this.admin.namespaces().createNamespace(NAMESPACE2);
        this.admin.namespaces().createNamespace(NAMESPACE3);
        this.systemTopicFactory = new NamespaceEventsSystemTopicFactory(this.pulsarClient);
    }
}

